// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/securitycentermanagement/v1/security_center_management.proto

#include "google/cloud/securitycentermanagement/v1/internal/security_center_management_option_defaults.h"
#include "google/cloud/securitycentermanagement/v1/security_center_management_connection.h"
#include "google/cloud/securitycentermanagement/v1/security_center_management_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace securitycentermanagement_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options SecurityCenterManagementDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options),
      "GOOGLE_CLOUD_CPP_SECURITY_CENTER_MANAGEMENT_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_SECURITY_CENTER_MANAGEMENT_AUTHORITY",
      "securitycentermanagement.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<securitycentermanagement_v1::
                       SecurityCenterManagementRetryPolicyOption>()) {
    options.set<
        securitycentermanagement_v1::SecurityCenterManagementRetryPolicyOption>(
        securitycentermanagement_v1::
            SecurityCenterManagementLimitedTimeRetryPolicy(
                std::chrono::minutes(30))
                .clone());
  }
  if (!options.has<securitycentermanagement_v1::
                       SecurityCenterManagementBackoffPolicyOption>()) {
    options.set<securitycentermanagement_v1::
                    SecurityCenterManagementBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<
          securitycentermanagement_v1::
              SecurityCenterManagementConnectionIdempotencyPolicyOption>()) {
    options.set<securitycentermanagement_v1::
                    SecurityCenterManagementConnectionIdempotencyPolicyOption>(
        securitycentermanagement_v1::
            MakeDefaultSecurityCenterManagementConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycentermanagement_v1_internal
}  // namespace cloud
}  // namespace google
