// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/secretmanager/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECRETMANAGER_V1_SECRET_MANAGER_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECRETMANAGER_V1_SECRET_MANAGER_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/secretmanager/v1/service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace secretmanager_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SecretManagerServiceConnectionIdempotencyPolicy {
 public:
  virtual ~SecretManagerServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<SecretManagerServiceConnectionIdempotencyPolicy>
  clone() const;

  virtual google::cloud::Idempotency ListSecrets(
      google::cloud::secretmanager::v1::ListSecretsRequest request);

  virtual google::cloud::Idempotency CreateSecret(
      google::cloud::secretmanager::v1::CreateSecretRequest const& request);

  virtual google::cloud::Idempotency AddSecretVersion(
      google::cloud::secretmanager::v1::AddSecretVersionRequest const& request);

  virtual google::cloud::Idempotency GetSecret(
      google::cloud::secretmanager::v1::GetSecretRequest const& request);

  virtual google::cloud::Idempotency UpdateSecret(
      google::cloud::secretmanager::v1::UpdateSecretRequest const& request);

  virtual google::cloud::Idempotency DeleteSecret(
      google::cloud::secretmanager::v1::DeleteSecretRequest const& request);

  virtual google::cloud::Idempotency ListSecretVersions(
      google::cloud::secretmanager::v1::ListSecretVersionsRequest request);

  virtual google::cloud::Idempotency GetSecretVersion(
      google::cloud::secretmanager::v1::GetSecretVersionRequest const& request);

  virtual google::cloud::Idempotency AccessSecretVersion(
      google::cloud::secretmanager::v1::AccessSecretVersionRequest const&
          request);

  virtual google::cloud::Idempotency DisableSecretVersion(
      google::cloud::secretmanager::v1::DisableSecretVersionRequest const&
          request);

  virtual google::cloud::Idempotency EnableSecretVersion(
      google::cloud::secretmanager::v1::EnableSecretVersionRequest const&
          request);

  virtual google::cloud::Idempotency DestroySecretVersion(
      google::cloud::secretmanager::v1::DestroySecretVersionRequest const&
          request);

  virtual google::cloud::Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request);
};

std::unique_ptr<SecretManagerServiceConnectionIdempotencyPolicy>
MakeDefaultSecretManagerServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace secretmanager_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECRETMANAGER_V1_SECRET_MANAGER_CONNECTION_IDEMPOTENCY_POLICY_H
