// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/folders.proto

#include "google/cloud/resourcemanager/v3/folders_connection.h"
#include "google/cloud/resourcemanager/v3/folders_options.h"
#include "google/cloud/resourcemanager/v3/internal/folders_connection_impl.h"
#include "google/cloud/resourcemanager/v3/internal/folders_option_defaults.h"
#include "google/cloud/resourcemanager/v3/internal/folders_stub_factory.h"
#include "google/cloud/resourcemanager/v3/internal/folders_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace resourcemanager_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FoldersConnection::~FoldersConnection() = default;

StatusOr<google::cloud::resourcemanager::v3::Folder>
FoldersConnection::GetFolder(
    google::cloud::resourcemanager::v3::GetFolderRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::resourcemanager::v3::Folder>
FoldersConnection::ListFolders(
    google::cloud::resourcemanager::v3::
        ListFoldersRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::resourcemanager::v3::Folder>>();
}

StreamRange<google::cloud::resourcemanager::v3::Folder>
FoldersConnection::SearchFolders(
    google::cloud::resourcemanager::v3::
        SearchFoldersRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::resourcemanager::v3::Folder>>();
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersConnection::CreateFolder(
    google::cloud::resourcemanager::v3::CreateFolderRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Folder>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> FoldersConnection::CreateFolder(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::CreateFolderRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersConnection::CreateFolder(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Folder>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersConnection::UpdateFolder(
    google::cloud::resourcemanager::v3::UpdateFolderRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Folder>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> FoldersConnection::UpdateFolder(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::UpdateFolderRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersConnection::UpdateFolder(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Folder>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersConnection::MoveFolder(
    google::cloud::resourcemanager::v3::MoveFolderRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Folder>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> FoldersConnection::MoveFolder(
    NoAwaitTag, google::cloud::resourcemanager::v3::MoveFolderRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersConnection::MoveFolder(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Folder>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersConnection::DeleteFolder(
    google::cloud::resourcemanager::v3::DeleteFolderRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Folder>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> FoldersConnection::DeleteFolder(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::DeleteFolderRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersConnection::DeleteFolder(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Folder>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersConnection::UndeleteFolder(
    google::cloud::resourcemanager::v3::UndeleteFolderRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Folder>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> FoldersConnection::UndeleteFolder(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::UndeleteFolderRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersConnection::UndeleteFolder(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Folder>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::iam::v1::Policy> FoldersConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> FoldersConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
FoldersConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<FoldersConnection> MakeFoldersConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 FoldersPolicyOptionList>(options, __func__);
  options =
      resourcemanager_v3_internal::FoldersDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = resourcemanager_v3_internal::CreateDefaultFoldersStub(
      std::move(auth), options);
  return resourcemanager_v3_internal::MakeFoldersTracingConnection(
      std::make_shared<resourcemanager_v3_internal::FoldersConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3
}  // namespace cloud
}  // namespace google
