// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/recommender/v1/recommender_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RECOMMENDER_V1_RECOMMENDER_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RECOMMENDER_V1_RECOMMENDER_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/recommender/v1/recommender_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace recommender_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class RecommenderConnectionIdempotencyPolicy {
 public:
  virtual ~RecommenderConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<RecommenderConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency ListInsights(
      google::cloud::recommender::v1::ListInsightsRequest request);

  virtual google::cloud::Idempotency GetInsight(
      google::cloud::recommender::v1::GetInsightRequest const& request);

  virtual google::cloud::Idempotency MarkInsightAccepted(
      google::cloud::recommender::v1::MarkInsightAcceptedRequest const&
          request);

  virtual google::cloud::Idempotency ListRecommendations(
      google::cloud::recommender::v1::ListRecommendationsRequest request);

  virtual google::cloud::Idempotency GetRecommendation(
      google::cloud::recommender::v1::GetRecommendationRequest const& request);

  virtual google::cloud::Idempotency MarkRecommendationDismissed(
      google::cloud::recommender::v1::MarkRecommendationDismissedRequest const&
          request);

  virtual google::cloud::Idempotency MarkRecommendationClaimed(
      google::cloud::recommender::v1::MarkRecommendationClaimedRequest const&
          request);

  virtual google::cloud::Idempotency MarkRecommendationSucceeded(
      google::cloud::recommender::v1::MarkRecommendationSucceededRequest const&
          request);

  virtual google::cloud::Idempotency MarkRecommendationFailed(
      google::cloud::recommender::v1::MarkRecommendationFailedRequest const&
          request);

  virtual google::cloud::Idempotency GetRecommenderConfig(
      google::cloud::recommender::v1::GetRecommenderConfigRequest const&
          request);

  virtual google::cloud::Idempotency UpdateRecommenderConfig(
      google::cloud::recommender::v1::UpdateRecommenderConfigRequest const&
          request);

  virtual google::cloud::Idempotency GetInsightTypeConfig(
      google::cloud::recommender::v1::GetInsightTypeConfigRequest const&
          request);

  virtual google::cloud::Idempotency UpdateInsightTypeConfig(
      google::cloud::recommender::v1::UpdateInsightTypeConfigRequest const&
          request);
};

std::unique_ptr<RecommenderConnectionIdempotencyPolicy>
MakeDefaultRecommenderConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace recommender_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RECOMMENDER_V1_RECOMMENDER_CONNECTION_IDEMPOTENCY_POLICY_H
