// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/metastore/v1/metastore.proto

#include "google/cloud/metastore/v1/internal/dataproc_metastore_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/metastore/v1/metastore.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace metastore_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataprocMetastoreStub::~DataprocMetastoreStub() = default;

StatusOr<google::cloud::metastore::v1::ListServicesResponse>
DefaultDataprocMetastoreStub::ListServices(
    grpc::ClientContext& context, Options const&,
    google::cloud::metastore::v1::ListServicesRequest const& request) {
  google::cloud::metastore::v1::ListServicesResponse response;
  auto status = grpc_stub_->ListServices(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::metastore::v1::Service>
DefaultDataprocMetastoreStub::GetService(
    grpc::ClientContext& context, Options const&,
    google::cloud::metastore::v1::GetServiceRequest const& request) {
  google::cloud::metastore::v1::Service response;
  auto status = grpc_stub_->GetService(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDataprocMetastoreStub::AsyncCreateService(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::metastore::v1::CreateServiceRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::metastore::v1::CreateServiceRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::metastore::v1::CreateServiceRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateService(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultDataprocMetastoreStub::CreateService(
    grpc::ClientContext& context, Options,
    google::cloud::metastore::v1::CreateServiceRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->CreateService(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDataprocMetastoreStub::AsyncUpdateService(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::metastore::v1::UpdateServiceRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::metastore::v1::UpdateServiceRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::metastore::v1::UpdateServiceRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateService(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultDataprocMetastoreStub::UpdateService(
    grpc::ClientContext& context, Options,
    google::cloud::metastore::v1::UpdateServiceRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->UpdateService(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDataprocMetastoreStub::AsyncDeleteService(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::metastore::v1::DeleteServiceRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::metastore::v1::DeleteServiceRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::metastore::v1::DeleteServiceRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteService(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultDataprocMetastoreStub::DeleteService(
    grpc::ClientContext& context, Options,
    google::cloud::metastore::v1::DeleteServiceRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DeleteService(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::metastore::v1::ListMetadataImportsResponse>
DefaultDataprocMetastoreStub::ListMetadataImports(
    grpc::ClientContext& context, Options const&,
    google::cloud::metastore::v1::ListMetadataImportsRequest const& request) {
  google::cloud::metastore::v1::ListMetadataImportsResponse response;
  auto status = grpc_stub_->ListMetadataImports(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::metastore::v1::MetadataImport>
DefaultDataprocMetastoreStub::GetMetadataImport(
    grpc::ClientContext& context, Options const&,
    google::cloud::metastore::v1::GetMetadataImportRequest const& request) {
  google::cloud::metastore::v1::MetadataImport response;
  auto status = grpc_stub_->GetMetadataImport(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDataprocMetastoreStub::AsyncCreateMetadataImport(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::metastore::v1::CreateMetadataImportRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::metastore::v1::CreateMetadataImportRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::metastore::v1::CreateMetadataImportRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateMetadataImport(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultDataprocMetastoreStub::CreateMetadataImport(
    grpc::ClientContext& context, Options,
    google::cloud::metastore::v1::CreateMetadataImportRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->CreateMetadataImport(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDataprocMetastoreStub::AsyncUpdateMetadataImport(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::metastore::v1::UpdateMetadataImportRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::metastore::v1::UpdateMetadataImportRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::metastore::v1::UpdateMetadataImportRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateMetadataImport(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultDataprocMetastoreStub::UpdateMetadataImport(
    grpc::ClientContext& context, Options,
    google::cloud::metastore::v1::UpdateMetadataImportRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->UpdateMetadataImport(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDataprocMetastoreStub::AsyncExportMetadata(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::metastore::v1::ExportMetadataRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::metastore::v1::ExportMetadataRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::metastore::v1::ExportMetadataRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncExportMetadata(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultDataprocMetastoreStub::ExportMetadata(
    grpc::ClientContext& context, Options,
    google::cloud::metastore::v1::ExportMetadataRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->ExportMetadata(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDataprocMetastoreStub::AsyncRestoreService(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::metastore::v1::RestoreServiceRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::metastore::v1::RestoreServiceRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::metastore::v1::RestoreServiceRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncRestoreService(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultDataprocMetastoreStub::RestoreService(
    grpc::ClientContext& context, Options,
    google::cloud::metastore::v1::RestoreServiceRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->RestoreService(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::metastore::v1::ListBackupsResponse>
DefaultDataprocMetastoreStub::ListBackups(
    grpc::ClientContext& context, Options const&,
    google::cloud::metastore::v1::ListBackupsRequest const& request) {
  google::cloud::metastore::v1::ListBackupsResponse response;
  auto status = grpc_stub_->ListBackups(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::metastore::v1::Backup>
DefaultDataprocMetastoreStub::GetBackup(
    grpc::ClientContext& context, Options const&,
    google::cloud::metastore::v1::GetBackupRequest const& request) {
  google::cloud::metastore::v1::Backup response;
  auto status = grpc_stub_->GetBackup(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDataprocMetastoreStub::AsyncCreateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::metastore::v1::CreateBackupRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::metastore::v1::CreateBackupRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::metastore::v1::CreateBackupRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateBackup(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultDataprocMetastoreStub::CreateBackup(
    grpc::ClientContext& context, Options,
    google::cloud::metastore::v1::CreateBackupRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->CreateBackup(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDataprocMetastoreStub::AsyncDeleteBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::metastore::v1::DeleteBackupRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::metastore::v1::DeleteBackupRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::metastore::v1::DeleteBackupRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteBackup(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultDataprocMetastoreStub::DeleteBackup(
    grpc::ClientContext& context, Options,
    google::cloud::metastore::v1::DeleteBackupRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DeleteBackup(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDataprocMetastoreStub::AsyncQueryMetadata(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::metastore::v1::QueryMetadataRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::metastore::v1::QueryMetadataRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::metastore::v1::QueryMetadataRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncQueryMetadata(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultDataprocMetastoreStub::QueryMetadata(
    grpc::ClientContext& context, Options,
    google::cloud::metastore::v1::QueryMetadataRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->QueryMetadata(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDataprocMetastoreStub::AsyncMoveTableToDatabase(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::metastore::v1::MoveTableToDatabaseRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::metastore::v1::MoveTableToDatabaseRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::metastore::v1::MoveTableToDatabaseRequest const&
                 request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncMoveTableToDatabase(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultDataprocMetastoreStub::MoveTableToDatabase(
    grpc::ClientContext& context, Options,
    google::cloud::metastore::v1::MoveTableToDatabaseRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->MoveTableToDatabase(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDataprocMetastoreStub::AsyncAlterMetadataResourceLocation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::metastore::v1::AlterMetadataResourceLocationRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::metastore::v1::AlterMetadataResourceLocationRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::metastore::v1::
                 AlterMetadataResourceLocationRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncAlterMetadataResourceLocation(context, request,
                                                              cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultDataprocMetastoreStub::AlterMetadataResourceLocation(
    grpc::ClientContext& context, Options,
    google::cloud::metastore::v1::AlterMetadataResourceLocationRequest const&
        request) {
  google::longrunning::Operation response;
  auto status =
      grpc_stub_->AlterMetadataResourceLocation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultDataprocMetastoreStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::GetOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::GetOperationRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::longrunning::GetOperationRequest const& request,
             grpc::CompletionQueue* cq) {
        return operations_->AsyncGetOperation(context, request, cq);
      },
      request, std::move(context));
}

future<Status> DefaultDataprocMetastoreStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::CancelOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::CancelOperationRequest,
                                    google::protobuf::Empty>(
             cq,
             [this](grpc::ClientContext* context,
                    google::longrunning::CancelOperationRequest const& request,
                    grpc::CompletionQueue* cq) {
               return operations_->AsyncCancelOperation(context, request, cq);
             },
             request, std::move(context))
      .then([](future<StatusOr<google::protobuf::Empty>> f) {
        return f.get().status();
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace metastore_v1_internal
}  // namespace cloud
}  // namespace google
