// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/autokey_admin.proto

#include "google/cloud/kms/v1/autokey_admin_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace kms_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AutokeyAdminClient::AutokeyAdminClient(
    std::shared_ptr<AutokeyAdminConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
AutokeyAdminClient::~AutokeyAdminClient() = default;

StatusOr<google::cloud::kms::v1::AutokeyConfig>
AutokeyAdminClient::UpdateAutokeyConfig(
    google::cloud::kms::v1::AutokeyConfig const& autokey_config,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::kms::v1::UpdateAutokeyConfigRequest request;
  *request.mutable_autokey_config() = autokey_config;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateAutokeyConfig(request);
}

StatusOr<google::cloud::kms::v1::AutokeyConfig>
AutokeyAdminClient::UpdateAutokeyConfig(
    google::cloud::kms::v1::UpdateAutokeyConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateAutokeyConfig(request);
}

StatusOr<google::cloud::kms::v1::AutokeyConfig>
AutokeyAdminClient::GetAutokeyConfig(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::kms::v1::GetAutokeyConfigRequest request;
  request.set_name(name);
  return connection_->GetAutokeyConfig(request);
}

StatusOr<google::cloud::kms::v1::AutokeyConfig>
AutokeyAdminClient::GetAutokeyConfig(
    google::cloud::kms::v1::GetAutokeyConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAutokeyConfig(request);
}

StatusOr<google::cloud::kms::v1::ShowEffectiveAutokeyConfigResponse>
AutokeyAdminClient::ShowEffectiveAutokeyConfig(std::string const& parent,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::kms::v1::ShowEffectiveAutokeyConfigRequest request;
  request.set_parent(parent);
  return connection_->ShowEffectiveAutokeyConfig(request);
}

StatusOr<google::cloud::kms::v1::ShowEffectiveAutokeyConfigResponse>
AutokeyAdminClient::ShowEffectiveAutokeyConfig(
    google::cloud::kms::v1::ShowEffectiveAutokeyConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ShowEffectiveAutokeyConfig(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_v1
}  // namespace cloud
}  // namespace google
