// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/inventory/v1/key_tracking_service.proto

#include "google/cloud/kms/inventory/v1/internal/key_tracking_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace kms_inventory_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

KeyTrackingServiceTracingConnection::KeyTrackingServiceTracingConnection(
    std::shared_ptr<kms_inventory_v1::KeyTrackingServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::kms::inventory::v1::ProtectedResourcesSummary>
KeyTrackingServiceTracingConnection::GetProtectedResourcesSummary(
    google::cloud::kms::inventory::v1::
        GetProtectedResourcesSummaryRequest const& request) {
  auto span = internal::MakeSpan(
      "kms_inventory_v1::KeyTrackingServiceConnection::"
      "GetProtectedResourcesSummary");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->GetProtectedResourcesSummary(request));
}

StreamRange<google::cloud::kms::inventory::v1::ProtectedResource>
KeyTrackingServiceTracingConnection::SearchProtectedResources(
    google::cloud::kms::inventory::v1::SearchProtectedResourcesRequest
        request) {
  auto span = internal::MakeSpan(
      "kms_inventory_v1::KeyTrackingServiceConnection::"
      "SearchProtectedResources");
  internal::OTelScope scope(span);
  auto sr = child_->SearchProtectedResources(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::kms::inventory::v1::ProtectedResource>(std::move(span),
                                                            std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<kms_inventory_v1::KeyTrackingServiceConnection>
MakeKeyTrackingServiceTracingConnection(
    std::shared_ptr<kms_inventory_v1::KeyTrackingServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<KeyTrackingServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_inventory_v1_internal
}  // namespace cloud
}  // namespace google
