// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkebackup/v1/gkebackup.proto

#include "google/cloud/gkebackup/v1/internal/backup_for_gke_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/gkebackup/v1/gkebackup.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace gkebackup_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BackupForGKELogging::BackupForGKELogging(
    std::shared_ptr<BackupForGKEStub> child, TracingOptions tracing_options,
    std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncCreateBackupPlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::CreateBackupPlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::gkebackup::v1::CreateBackupPlanRequest const&
                 request) {
        return child_->AsyncCreateBackupPlan(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> BackupForGKELogging::CreateBackupPlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::CreateBackupPlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::CreateBackupPlanRequest const&
                 request) {
        return child_->CreateBackupPlan(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::ListBackupPlansResponse>
BackupForGKELogging::ListBackupPlans(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListBackupPlansRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::gkebackup::v1::ListBackupPlansRequest const& request) {
        return child_->ListBackupPlans(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::BackupPlan>
BackupForGKELogging::GetBackupPlan(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetBackupPlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::gkebackup::v1::GetBackupPlanRequest const& request) {
        return child_->GetBackupPlan(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncUpdateBackupPlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::UpdateBackupPlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::gkebackup::v1::UpdateBackupPlanRequest const&
                 request) {
        return child_->AsyncUpdateBackupPlan(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> BackupForGKELogging::UpdateBackupPlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::UpdateBackupPlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::UpdateBackupPlanRequest const&
                 request) {
        return child_->UpdateBackupPlan(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncDeleteBackupPlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::DeleteBackupPlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::gkebackup::v1::DeleteBackupPlanRequest const&
                 request) {
        return child_->AsyncDeleteBackupPlan(cq, std::move(context),
                                             std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> BackupForGKELogging::DeleteBackupPlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::DeleteBackupPlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::DeleteBackupPlanRequest const&
                 request) {
        return child_->DeleteBackupPlan(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncCreateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::CreateBackupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::gkebackup::v1::CreateBackupRequest const& request) {
        return child_->AsyncCreateBackup(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> BackupForGKELogging::CreateBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::CreateBackupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::CreateBackupRequest const& request) {
        return child_->CreateBackup(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::ListBackupsResponse>
BackupForGKELogging::ListBackups(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListBackupsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::ListBackupsRequest const& request) {
        return child_->ListBackups(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::Backup> BackupForGKELogging::GetBackup(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetBackupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::GetBackupRequest const& request) {
        return child_->GetBackup(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncUpdateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::UpdateBackupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::gkebackup::v1::UpdateBackupRequest const& request) {
        return child_->AsyncUpdateBackup(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> BackupForGKELogging::UpdateBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::UpdateBackupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::UpdateBackupRequest const& request) {
        return child_->UpdateBackup(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncDeleteBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::DeleteBackupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::gkebackup::v1::DeleteBackupRequest const& request) {
        return child_->AsyncDeleteBackup(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> BackupForGKELogging::DeleteBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::DeleteBackupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::DeleteBackupRequest const& request) {
        return child_->DeleteBackup(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::ListVolumeBackupsResponse>
BackupForGKELogging::ListVolumeBackups(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListVolumeBackupsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::ListVolumeBackupsRequest const&
                 request) {
        return child_->ListVolumeBackups(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::VolumeBackup>
BackupForGKELogging::GetVolumeBackup(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetVolumeBackupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::gkebackup::v1::GetVolumeBackupRequest const& request) {
        return child_->GetVolumeBackup(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncCreateRestorePlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::CreateRestorePlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::gkebackup::v1::CreateRestorePlanRequest const&
                 request) {
        return child_->AsyncCreateRestorePlan(cq, std::move(context),
                                              std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> BackupForGKELogging::CreateRestorePlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::CreateRestorePlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::CreateRestorePlanRequest const&
                 request) {
        return child_->CreateRestorePlan(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::ListRestorePlansResponse>
BackupForGKELogging::ListRestorePlans(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListRestorePlansRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::ListRestorePlansRequest const&
                 request) {
        return child_->ListRestorePlans(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::RestorePlan>
BackupForGKELogging::GetRestorePlan(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetRestorePlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::gkebackup::v1::GetRestorePlanRequest const& request) {
        return child_->GetRestorePlan(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncUpdateRestorePlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::UpdateRestorePlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::gkebackup::v1::UpdateRestorePlanRequest const&
                 request) {
        return child_->AsyncUpdateRestorePlan(cq, std::move(context),
                                              std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> BackupForGKELogging::UpdateRestorePlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::UpdateRestorePlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::UpdateRestorePlanRequest const&
                 request) {
        return child_->UpdateRestorePlan(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncDeleteRestorePlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::DeleteRestorePlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::gkebackup::v1::DeleteRestorePlanRequest const&
                 request) {
        return child_->AsyncDeleteRestorePlan(cq, std::move(context),
                                              std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> BackupForGKELogging::DeleteRestorePlan(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::DeleteRestorePlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::DeleteRestorePlanRequest const&
                 request) {
        return child_->DeleteRestorePlan(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncCreateRestore(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::CreateRestoreRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::gkebackup::v1::CreateRestoreRequest const& request) {
        return child_->AsyncCreateRestore(cq, std::move(context),
                                          std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> BackupForGKELogging::CreateRestore(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::CreateRestoreRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::gkebackup::v1::CreateRestoreRequest const& request) {
        return child_->CreateRestore(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::ListRestoresResponse>
BackupForGKELogging::ListRestores(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListRestoresRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::ListRestoresRequest const& request) {
        return child_->ListRestores(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::Restore> BackupForGKELogging::GetRestore(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetRestoreRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::GetRestoreRequest const& request) {
        return child_->GetRestore(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncUpdateRestore(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::UpdateRestoreRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::gkebackup::v1::UpdateRestoreRequest const& request) {
        return child_->AsyncUpdateRestore(cq, std::move(context),
                                          std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> BackupForGKELogging::UpdateRestore(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::UpdateRestoreRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::gkebackup::v1::UpdateRestoreRequest const& request) {
        return child_->UpdateRestore(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncDeleteRestore(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkebackup::v1::DeleteRestoreRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::gkebackup::v1::DeleteRestoreRequest const& request) {
        return child_->AsyncDeleteRestore(cq, std::move(context),
                                          std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation> BackupForGKELogging::DeleteRestore(
    grpc::ClientContext& context, Options options,
    google::cloud::gkebackup::v1::DeleteRestoreRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::gkebackup::v1::DeleteRestoreRequest const& request) {
        return child_->DeleteRestore(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::ListVolumeRestoresResponse>
BackupForGKELogging::ListVolumeRestores(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::ListVolumeRestoresRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::ListVolumeRestoresRequest const&
                 request) {
        return child_->ListVolumeRestores(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::VolumeRestore>
BackupForGKELogging::GetVolumeRestore(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetVolumeRestoreRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkebackup::v1::GetVolumeRestoreRequest const&
                 request) {
        return child_->GetVolumeRestore(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::GetBackupIndexDownloadUrlResponse>
BackupForGKELogging::GetBackupIndexDownloadUrl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkebackup::v1::GetBackupIndexDownloadUrlRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::gkebackup::v1::GetBackupIndexDownloadUrlRequest const&
              request) {
        return child_->GetBackupIndexDownloadUrl(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

future<Status> BackupForGKELogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkebackup_v1_internal
}  // namespace cloud
}  // namespace google
