// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/entity_type.proto

#include "google/cloud/dialogflow_es/entity_types_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

EntityTypesConnectionIdempotencyPolicy::
    ~EntityTypesConnectionIdempotencyPolicy() = default;

std::unique_ptr<EntityTypesConnectionIdempotencyPolicy>
EntityTypesConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<EntityTypesConnectionIdempotencyPolicy>(*this);
}

Idempotency EntityTypesConnectionIdempotencyPolicy::ListEntityTypes(
    google::cloud::dialogflow::v2::ListEntityTypesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EntityTypesConnectionIdempotencyPolicy::GetEntityType(
    google::cloud::dialogflow::v2::GetEntityTypeRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EntityTypesConnectionIdempotencyPolicy::CreateEntityType(
    google::cloud::dialogflow::v2::CreateEntityTypeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EntityTypesConnectionIdempotencyPolicy::UpdateEntityType(
    google::cloud::dialogflow::v2::UpdateEntityTypeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EntityTypesConnectionIdempotencyPolicy::DeleteEntityType(
    google::cloud::dialogflow::v2::DeleteEntityTypeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EntityTypesConnectionIdempotencyPolicy::BatchUpdateEntityTypes(
    google::cloud::dialogflow::v2::BatchUpdateEntityTypesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EntityTypesConnectionIdempotencyPolicy::BatchDeleteEntityTypes(
    google::cloud::dialogflow::v2::BatchDeleteEntityTypesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EntityTypesConnectionIdempotencyPolicy::BatchCreateEntities(
    google::cloud::dialogflow::v2::BatchCreateEntitiesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EntityTypesConnectionIdempotencyPolicy::BatchUpdateEntities(
    google::cloud::dialogflow::v2::BatchUpdateEntitiesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EntityTypesConnectionIdempotencyPolicy::BatchDeleteEntities(
    google::cloud::dialogflow::v2::BatchDeleteEntitiesRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<EntityTypesConnectionIdempotencyPolicy>
MakeDefaultEntityTypesConnectionIdempotencyPolicy() {
  return std::make_unique<EntityTypesConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
