// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/metadata.proto

#include "google/cloud/dataplex/v1/internal/metadata_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dataplex/v1/metadata.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetadataServiceMetadata::MetadataServiceMetadata(
    std::shared_ptr<MetadataServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::dataplex::v1::Entity>
MetadataServiceMetadata::CreateEntity(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::CreateEntityRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateEntity(context, options, request);
}

StatusOr<google::cloud::dataplex::v1::Entity>
MetadataServiceMetadata::UpdateEntity(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::UpdateEntityRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("entity.name=",
                           internal::UrlEncode(request.entity().name())));
  return child_->UpdateEntity(context, options, request);
}

Status MetadataServiceMetadata::DeleteEntity(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::DeleteEntityRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteEntity(context, options, request);
}

StatusOr<google::cloud::dataplex::v1::Entity>
MetadataServiceMetadata::GetEntity(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::GetEntityRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetEntity(context, options, request);
}

StatusOr<google::cloud::dataplex::v1::ListEntitiesResponse>
MetadataServiceMetadata::ListEntities(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::ListEntitiesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListEntities(context, options, request);
}

StatusOr<google::cloud::dataplex::v1::Partition>
MetadataServiceMetadata::CreatePartition(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::CreatePartitionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreatePartition(context, options, request);
}

Status MetadataServiceMetadata::DeletePartition(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::DeletePartitionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeletePartition(context, options, request);
}

StatusOr<google::cloud::dataplex::v1::Partition>
MetadataServiceMetadata::GetPartition(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::GetPartitionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetPartition(context, options, request);
}

StatusOr<google::cloud::dataplex::v1::ListPartitionsResponse>
MetadataServiceMetadata::ListPartitions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::ListPartitionsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListPartitions(context, options, request);
}

void MetadataServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                          Options const& options,
                                          std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void MetadataServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                          Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google
