// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/data_taxonomy.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_DATA_TAXONOMY_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_DATA_TAXONOMY_CONNECTION_H

#include "google/cloud/dataplex/v1/data_taxonomy_connection_idempotency_policy.h"
#include "google/cloud/dataplex/v1/internal/data_taxonomy_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/dataplex/v1/data_taxonomy.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `DataTaxonomyServiceConnection`.
class DataTaxonomyServiceRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<DataTaxonomyServiceRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `DataTaxonomyServiceConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class DataTaxonomyServiceLimitedErrorCountRetryPolicy
    : public DataTaxonomyServiceRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit DataTaxonomyServiceLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  DataTaxonomyServiceLimitedErrorCountRetryPolicy(
      DataTaxonomyServiceLimitedErrorCountRetryPolicy&& rhs) noexcept
      : DataTaxonomyServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}
  DataTaxonomyServiceLimitedErrorCountRetryPolicy(
      DataTaxonomyServiceLimitedErrorCountRetryPolicy const& rhs) noexcept
      : DataTaxonomyServiceLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<DataTaxonomyServiceRetryPolicy> clone() const override {
    return std::make_unique<DataTaxonomyServiceLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = DataTaxonomyServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      dataplex_v1_internal::DataTaxonomyServiceRetryTraits>
      impl_;
};

/**
 * A retry policy for `DataTaxonomyServiceConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class DataTaxonomyServiceLimitedTimeRetryPolicy
    : public DataTaxonomyServiceRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit DataTaxonomyServiceLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  DataTaxonomyServiceLimitedTimeRetryPolicy(
      DataTaxonomyServiceLimitedTimeRetryPolicy&& rhs) noexcept
      : DataTaxonomyServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  DataTaxonomyServiceLimitedTimeRetryPolicy(
      DataTaxonomyServiceLimitedTimeRetryPolicy const& rhs) noexcept
      : DataTaxonomyServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<DataTaxonomyServiceRetryPolicy> clone() const override {
    return std::make_unique<DataTaxonomyServiceLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = DataTaxonomyServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      dataplex_v1_internal::DataTaxonomyServiceRetryTraits>
      impl_;
};

/**
 * The `DataTaxonomyServiceConnection` object for `DataTaxonomyServiceClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `DataTaxonomyServiceClient`. This allows users to inject custom
 * behavior (e.g., with a Google Mock object) when writing tests that use
 * objects of type `DataTaxonomyServiceClient`.
 *
 * To create a concrete instance, see `MakeDataTaxonomyServiceConnection()`.
 *
 * For mocking, see `dataplex_v1_mocks::MockDataTaxonomyServiceConnection`.
 */
class DataTaxonomyServiceConnection {
 public:
  virtual ~DataTaxonomyServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
  CreateDataTaxonomy(
      google::cloud::dataplex::v1::CreateDataTaxonomyRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateDataTaxonomy(
      NoAwaitTag,
      google::cloud::dataplex::v1::CreateDataTaxonomyRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
  CreateDataTaxonomy(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
  UpdateDataTaxonomy(
      google::cloud::dataplex::v1::UpdateDataTaxonomyRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateDataTaxonomy(
      NoAwaitTag,
      google::cloud::dataplex::v1::UpdateDataTaxonomyRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
  UpdateDataTaxonomy(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
  DeleteDataTaxonomy(
      google::cloud::dataplex::v1::DeleteDataTaxonomyRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteDataTaxonomy(
      NoAwaitTag,
      google::cloud::dataplex::v1::DeleteDataTaxonomyRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
  DeleteDataTaxonomy(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::dataplex::v1::DataTaxonomy>
  ListDataTaxonomies(
      google::cloud::dataplex::v1::ListDataTaxonomiesRequest request);

  virtual StatusOr<google::cloud::dataplex::v1::DataTaxonomy> GetDataTaxonomy(
      google::cloud::dataplex::v1::GetDataTaxonomyRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
  CreateDataAttributeBinding(
      google::cloud::dataplex::v1::CreateDataAttributeBindingRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateDataAttributeBinding(
      NoAwaitTag,
      google::cloud::dataplex::v1::CreateDataAttributeBindingRequest const&
          request);

  virtual future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
  CreateDataAttributeBinding(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
  UpdateDataAttributeBinding(
      google::cloud::dataplex::v1::UpdateDataAttributeBindingRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> UpdateDataAttributeBinding(
      NoAwaitTag,
      google::cloud::dataplex::v1::UpdateDataAttributeBindingRequest const&
          request);

  virtual future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
  UpdateDataAttributeBinding(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
  DeleteDataAttributeBinding(
      google::cloud::dataplex::v1::DeleteDataAttributeBindingRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> DeleteDataAttributeBinding(
      NoAwaitTag,
      google::cloud::dataplex::v1::DeleteDataAttributeBindingRequest const&
          request);

  virtual future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
  DeleteDataAttributeBinding(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::dataplex::v1::DataAttributeBinding>
  ListDataAttributeBindings(
      google::cloud::dataplex::v1::ListDataAttributeBindingsRequest request);

  virtual StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>
  GetDataAttributeBinding(
      google::cloud::dataplex::v1::GetDataAttributeBindingRequest const&
          request);

  virtual future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
  CreateDataAttribute(
      google::cloud::dataplex::v1::CreateDataAttributeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateDataAttribute(
      NoAwaitTag,
      google::cloud::dataplex::v1::CreateDataAttributeRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
  CreateDataAttribute(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
  UpdateDataAttribute(
      google::cloud::dataplex::v1::UpdateDataAttributeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateDataAttribute(
      NoAwaitTag,
      google::cloud::dataplex::v1::UpdateDataAttributeRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
  UpdateDataAttribute(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
  DeleteDataAttribute(
      google::cloud::dataplex::v1::DeleteDataAttributeRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteDataAttribute(
      NoAwaitTag,
      google::cloud::dataplex::v1::DeleteDataAttributeRequest const& request);

  virtual future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
  DeleteDataAttribute(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::dataplex::v1::DataAttribute>
  ListDataAttributes(
      google::cloud::dataplex::v1::ListDataAttributesRequest request);

  virtual StatusOr<google::cloud::dataplex::v1::DataAttribute> GetDataAttribute(
      google::cloud::dataplex::v1::GetDataAttributeRequest const& request);
};

/**
 * A factory function to construct an object of type
 * `DataTaxonomyServiceConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of
 * DataTaxonomyServiceClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `DataTaxonomyServiceConnection`. Expected options are any of the
 * types in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::dataplex_v1::DataTaxonomyServicePolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `DataTaxonomyServiceConnection`
 * created by this function.
 */
std::shared_ptr<DataTaxonomyServiceConnection>
MakeDataTaxonomyServiceConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_DATA_TAXONOMY_CONNECTION_H
