// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/storage_pools/v1/storage_pools.proto

#include "google/cloud/compute/storage_pools/v1/storage_pools_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_storage_pools_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

StoragePoolsClient::StoragePoolsClient(
    std::shared_ptr<StoragePoolsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
StoragePoolsClient::~StoragePoolsClient() = default;

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::StoragePoolsScopedList>>
StoragePoolsClient::AggregatedListStoragePools(std::string const& project,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pools::v1::
      AggregatedListStoragePoolsRequest request;
  request.set_project(project);
  return connection_->AggregatedListStoragePools(request);
}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::StoragePoolsScopedList>>
StoragePoolsClient::AggregatedListStoragePools(
    google::cloud::cpp::compute::storage_pools::v1::
        AggregatedListStoragePoolsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListStoragePools(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
StoragePoolsClient::DeleteStoragePool(std::string const& project,
                                      std::string const& zone,
                                      std::string const& storage_pool,
                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pools::v1::DeleteStoragePoolRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_storage_pool(storage_pool);
  return connection_->DeleteStoragePool(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
StoragePoolsClient::DeleteStoragePool(NoAwaitTag, std::string const& project,
                                      std::string const& zone,
                                      std::string const& storage_pool,
                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pools::v1::DeleteStoragePoolRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_storage_pool(storage_pool);
  return connection_->DeleteStoragePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
StoragePoolsClient::DeleteStoragePool(
    google::cloud::cpp::compute::storage_pools::v1::
        DeleteStoragePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteStoragePool(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
StoragePoolsClient::DeleteStoragePool(
    NoAwaitTag,
    google::cloud::cpp::compute::storage_pools::v1::
        DeleteStoragePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteStoragePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
StoragePoolsClient::DeleteStoragePool(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteStoragePool(operation);
}

StatusOr<google::cloud::cpp::compute::v1::StoragePool>
StoragePoolsClient::GetStoragePool(std::string const& project,
                                   std::string const& zone,
                                   std::string const& storage_pool,
                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pools::v1::GetStoragePoolRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_storage_pool(storage_pool);
  return connection_->GetStoragePool(request);
}

StatusOr<google::cloud::cpp::compute::v1::StoragePool>
StoragePoolsClient::GetStoragePool(
    google::cloud::cpp::compute::storage_pools::v1::GetStoragePoolRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetStoragePool(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
StoragePoolsClient::GetIamPolicy(std::string const& project,
                                 std::string const& zone,
                                 std::string const& resource, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pools::v1::GetIamPolicyRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_resource(resource);
  return connection_->GetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
StoragePoolsClient::GetIamPolicy(
    google::cloud::cpp::compute::storage_pools::v1::GetIamPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
StoragePoolsClient::InsertStoragePool(
    std::string const& project, std::string const& zone,
    google::cloud::cpp::compute::v1::StoragePool const& storage_pool_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pools::v1::InsertStoragePoolRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  *request.mutable_storage_pool_resource() = storage_pool_resource;
  return connection_->InsertStoragePool(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
StoragePoolsClient::InsertStoragePool(
    NoAwaitTag, std::string const& project, std::string const& zone,
    google::cloud::cpp::compute::v1::StoragePool const& storage_pool_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pools::v1::InsertStoragePoolRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  *request.mutable_storage_pool_resource() = storage_pool_resource;
  return connection_->InsertStoragePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
StoragePoolsClient::InsertStoragePool(
    google::cloud::cpp::compute::storage_pools::v1::
        InsertStoragePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertStoragePool(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
StoragePoolsClient::InsertStoragePool(
    NoAwaitTag,
    google::cloud::cpp::compute::storage_pools::v1::
        InsertStoragePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertStoragePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
StoragePoolsClient::InsertStoragePool(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertStoragePool(operation);
}

StreamRange<google::cloud::cpp::compute::v1::StoragePool>
StoragePoolsClient::ListStoragePools(std::string const& project,
                                     std::string const& zone, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pools::v1::ListStoragePoolsRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  return connection_->ListStoragePools(request);
}

StreamRange<google::cloud::cpp::compute::v1::StoragePool>
StoragePoolsClient::ListStoragePools(
    google::cloud::cpp::compute::storage_pools::v1::ListStoragePoolsRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListStoragePools(std::move(request));
}

StreamRange<google::cloud::cpp::compute::v1::StoragePoolDisk>
StoragePoolsClient::ListDisks(std::string const& project,
                              std::string const& zone,
                              std::string const& storage_pool, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pools::v1::ListDisksRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_storage_pool(storage_pool);
  return connection_->ListDisks(request);
}

StreamRange<google::cloud::cpp::compute::v1::StoragePoolDisk>
StoragePoolsClient::ListDisks(
    google::cloud::cpp::compute::storage_pools::v1::ListDisksRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDisks(std::move(request));
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
StoragePoolsClient::SetIamPolicy(
    std::string const& project, std::string const& zone,
    std::string const& resource,
    google::cloud::cpp::compute::v1::ZoneSetPolicyRequest const&
        zone_set_policy_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pools::v1::SetIamPolicyRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_resource(resource);
  *request.mutable_zone_set_policy_request_resource() =
      zone_set_policy_request_resource;
  return connection_->SetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
StoragePoolsClient::SetIamPolicy(
    google::cloud::cpp::compute::storage_pools::v1::SetIamPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
StoragePoolsClient::TestIamPermissions(
    std::string const& project, std::string const& zone,
    std::string const& resource,
    google::cloud::cpp::compute::v1::TestPermissionsRequest const&
        test_permissions_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pools::v1::TestIamPermissionsRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_resource(resource);
  *request.mutable_test_permissions_request_resource() =
      test_permissions_request_resource;
  return connection_->TestIamPermissions(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
StoragePoolsClient::TestIamPermissions(
    google::cloud::cpp::compute::storage_pools::v1::
        TestIamPermissionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
StoragePoolsClient::UpdateStoragePool(
    std::string const& project, std::string const& zone,
    std::string const& storage_pool, std::string const& update_mask,
    google::cloud::cpp::compute::v1::StoragePool const& storage_pool_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pools::v1::UpdateStoragePoolRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_storage_pool(storage_pool);
  request.set_update_mask(update_mask);
  *request.mutable_storage_pool_resource() = storage_pool_resource;
  return connection_->UpdateStoragePool(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
StoragePoolsClient::UpdateStoragePool(
    NoAwaitTag, std::string const& project, std::string const& zone,
    std::string const& storage_pool, std::string const& update_mask,
    google::cloud::cpp::compute::v1::StoragePool const& storage_pool_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::storage_pools::v1::UpdateStoragePoolRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_storage_pool(storage_pool);
  request.set_update_mask(update_mask);
  *request.mutable_storage_pool_resource() = storage_pool_resource;
  return connection_->UpdateStoragePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
StoragePoolsClient::UpdateStoragePool(
    google::cloud::cpp::compute::storage_pools::v1::
        UpdateStoragePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateStoragePool(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
StoragePoolsClient::UpdateStoragePool(
    NoAwaitTag,
    google::cloud::cpp::compute::storage_pools::v1::
        UpdateStoragePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateStoragePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
StoragePoolsClient::UpdateStoragePool(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateStoragePool(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_storage_pools_v1
}  // namespace cloud
}  // namespace google
