// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/resource_policies/v1/resource_policies.proto

#include "google/cloud/compute/resource_policies/v1/resource_policies_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_resource_policies_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ResourcePoliciesClient::ResourcePoliciesClient(
    std::shared_ptr<ResourcePoliciesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ResourcePoliciesClient::~ResourcePoliciesClient() = default;

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::ResourcePoliciesScopedList>>
ResourcePoliciesClient::AggregatedListResourcePolicies(
    std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::resource_policies::v1::
      AggregatedListResourcePoliciesRequest request;
  request.set_project(project);
  return connection_->AggregatedListResourcePolicies(request);
}

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::ResourcePoliciesScopedList>>
ResourcePoliciesClient::AggregatedListResourcePolicies(
    google::cloud::cpp::compute::resource_policies::v1::
        AggregatedListResourcePoliciesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListResourcePolicies(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesClient::DeleteResourcePolicy(std::string const& project,
                                             std::string const& region,
                                             std::string const& resource_policy,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::resource_policies::v1::
      DeleteResourcePolicyRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource_policy(resource_policy);
  return connection_->DeleteResourcePolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
ResourcePoliciesClient::DeleteResourcePolicy(NoAwaitTag,
                                             std::string const& project,
                                             std::string const& region,
                                             std::string const& resource_policy,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::resource_policies::v1::
      DeleteResourcePolicyRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource_policy(resource_policy);
  return connection_->DeleteResourcePolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesClient::DeleteResourcePolicy(
    google::cloud::cpp::compute::resource_policies::v1::
        DeleteResourcePolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteResourcePolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
ResourcePoliciesClient::DeleteResourcePolicy(
    NoAwaitTag,
    google::cloud::cpp::compute::resource_policies::v1::
        DeleteResourcePolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteResourcePolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesClient::DeleteResourcePolicy(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteResourcePolicy(operation);
}

StatusOr<google::cloud::cpp::compute::v1::ResourcePolicy>
ResourcePoliciesClient::GetResourcePolicy(std::string const& project,
                                          std::string const& region,
                                          std::string const& resource_policy,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::resource_policies::v1::GetResourcePolicyRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource_policy(resource_policy);
  return connection_->GetResourcePolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::ResourcePolicy>
ResourcePoliciesClient::GetResourcePolicy(
    google::cloud::cpp::compute::resource_policies::v1::
        GetResourcePolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetResourcePolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
ResourcePoliciesClient::GetIamPolicy(std::string const& project,
                                     std::string const& region,
                                     std::string const& resource,
                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::resource_policies::v1::GetIamPolicyRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  return connection_->GetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
ResourcePoliciesClient::GetIamPolicy(
    google::cloud::cpp::compute::resource_policies::v1::
        GetIamPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesClient::InsertResourcePolicy(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::ResourcePolicy const&
        resource_policy_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::resource_policies::v1::
      InsertResourcePolicyRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_resource_policy_resource() = resource_policy_resource;
  return connection_->InsertResourcePolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
ResourcePoliciesClient::InsertResourcePolicy(
    NoAwaitTag, std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::ResourcePolicy const&
        resource_policy_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::resource_policies::v1::
      InsertResourcePolicyRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_resource_policy_resource() = resource_policy_resource;
  return connection_->InsertResourcePolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesClient::InsertResourcePolicy(
    google::cloud::cpp::compute::resource_policies::v1::
        InsertResourcePolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertResourcePolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
ResourcePoliciesClient::InsertResourcePolicy(
    NoAwaitTag,
    google::cloud::cpp::compute::resource_policies::v1::
        InsertResourcePolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertResourcePolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesClient::InsertResourcePolicy(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertResourcePolicy(operation);
}

StreamRange<google::cloud::cpp::compute::v1::ResourcePolicy>
ResourcePoliciesClient::ListResourcePolicies(std::string const& project,
                                             std::string const& region,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::resource_policies::v1::
      ListResourcePoliciesRequest request;
  request.set_project(project);
  request.set_region(region);
  return connection_->ListResourcePolicies(request);
}

StreamRange<google::cloud::cpp::compute::v1::ResourcePolicy>
ResourcePoliciesClient::ListResourcePolicies(
    google::cloud::cpp::compute::resource_policies::v1::
        ListResourcePoliciesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListResourcePolicies(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesClient::PatchResourcePolicy(
    std::string const& project, std::string const& region,
    std::string const& resource_policy, std::string const& update_mask,
    google::cloud::cpp::compute::v1::ResourcePolicy const&
        resource_policy_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::resource_policies::v1::PatchResourcePolicyRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource_policy(resource_policy);
  request.set_update_mask(update_mask);
  *request.mutable_resource_policy_resource() = resource_policy_resource;
  return connection_->PatchResourcePolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
ResourcePoliciesClient::PatchResourcePolicy(
    NoAwaitTag, std::string const& project, std::string const& region,
    std::string const& resource_policy, std::string const& update_mask,
    google::cloud::cpp::compute::v1::ResourcePolicy const&
        resource_policy_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::resource_policies::v1::PatchResourcePolicyRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource_policy(resource_policy);
  request.set_update_mask(update_mask);
  *request.mutable_resource_policy_resource() = resource_policy_resource;
  return connection_->PatchResourcePolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesClient::PatchResourcePolicy(
    google::cloud::cpp::compute::resource_policies::v1::
        PatchResourcePolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchResourcePolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
ResourcePoliciesClient::PatchResourcePolicy(
    NoAwaitTag,
    google::cloud::cpp::compute::resource_policies::v1::
        PatchResourcePolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchResourcePolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
ResourcePoliciesClient::PatchResourcePolicy(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchResourcePolicy(operation);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
ResourcePoliciesClient::SetIamPolicy(
    std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::RegionSetPolicyRequest const&
        region_set_policy_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::resource_policies::v1::SetIamPolicyRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_region_set_policy_request_resource() =
      region_set_policy_request_resource;
  return connection_->SetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
ResourcePoliciesClient::SetIamPolicy(
    google::cloud::cpp::compute::resource_policies::v1::
        SetIamPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
ResourcePoliciesClient::TestIamPermissions(
    std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::TestPermissionsRequest const&
        test_permissions_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::resource_policies::v1::TestIamPermissionsRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_test_permissions_request_resource() =
      test_permissions_request_resource;
  return connection_->TestIamPermissions(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
ResourcePoliciesClient::TestIamPermissions(
    google::cloud::cpp::compute::resource_policies::v1::
        TestIamPermissionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_resource_policies_v1
}  // namespace cloud
}  // namespace google
