// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/cloudquotas/v1/cloudquotas.proto

#include "google/cloud/cloudquotas/v1/cloud_quotas_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace cloudquotas_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CloudQuotasConnectionIdempotencyPolicy::
    ~CloudQuotasConnectionIdempotencyPolicy() = default;

std::unique_ptr<CloudQuotasConnectionIdempotencyPolicy>
CloudQuotasConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<CloudQuotasConnectionIdempotencyPolicy>(*this);
}

Idempotency CloudQuotasConnectionIdempotencyPolicy::ListQuotaInfos(
    google::api::cloudquotas::v1::ListQuotaInfosRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CloudQuotasConnectionIdempotencyPolicy::GetQuotaInfo(
    google::api::cloudquotas::v1::GetQuotaInfoRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CloudQuotasConnectionIdempotencyPolicy::ListQuotaPreferences(
    google::api::cloudquotas::v1::ListQuotaPreferencesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CloudQuotasConnectionIdempotencyPolicy::GetQuotaPreference(
    google::api::cloudquotas::v1::GetQuotaPreferenceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CloudQuotasConnectionIdempotencyPolicy::CreateQuotaPreference(
    google::api::cloudquotas::v1::CreateQuotaPreferenceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudQuotasConnectionIdempotencyPolicy::UpdateQuotaPreference(
    google::api::cloudquotas::v1::UpdateQuotaPreferenceRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<CloudQuotasConnectionIdempotencyPolicy>
MakeDefaultCloudQuotasConnectionIdempotencyPolicy() {
  return std::make_unique<CloudQuotasConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudquotas_v1
}  // namespace cloud
}  // namespace google
