// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/bigtable/admin/v2/bigtable_table_admin.proto

#include "google/cloud/bigtable/admin/internal/bigtable_table_admin_auth_decorator.h"
#include <google/bigtable/admin/v2/bigtable_table_admin.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigtable_admin_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BigtableTableAdminAuth::BigtableTableAdminAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<BigtableTableAdminStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::bigtable::admin::v2::Table>
BigtableTableAdminAuth::CreateTable(
    grpc::ClientContext& context, Options const& options,
    google::bigtable::admin::v2::CreateTableRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateTable(context, options, request);
}

StatusOr<google::bigtable::admin::v2::ListTablesResponse>
BigtableTableAdminAuth::ListTables(
    grpc::ClientContext& context, Options const& options,
    google::bigtable::admin::v2::ListTablesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListTables(context, options, request);
}

StatusOr<google::bigtable::admin::v2::Table> BigtableTableAdminAuth::GetTable(
    grpc::ClientContext& context, Options const& options,
    google::bigtable::admin::v2::GetTableRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetTable(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BigtableTableAdminAuth::AsyncUpdateTable(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::bigtable::admin::v2::UpdateTableRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncUpdateTable(cq, *std::move(context),
                                       std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> BigtableTableAdminAuth::UpdateTable(
    grpc::ClientContext& context, Options options,
    google::bigtable::admin::v2::UpdateTableRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateTable(context, options, request);
}

Status BigtableTableAdminAuth::DeleteTable(
    grpc::ClientContext& context, Options const& options,
    google::bigtable::admin::v2::DeleteTableRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteTable(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BigtableTableAdminAuth::AsyncUndeleteTable(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::bigtable::admin::v2::UndeleteTableRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncUndeleteTable(cq, *std::move(context),
                                         std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> BigtableTableAdminAuth::UndeleteTable(
    grpc::ClientContext& context, Options options,
    google::bigtable::admin::v2::UndeleteTableRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UndeleteTable(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BigtableTableAdminAuth::AsyncCreateAuthorizedView(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::bigtable::admin::v2::CreateAuthorizedViewRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateAuthorizedView(cq, *std::move(context),
                                                std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
BigtableTableAdminAuth::CreateAuthorizedView(
    grpc::ClientContext& context, Options options,
    google::bigtable::admin::v2::CreateAuthorizedViewRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateAuthorizedView(context, options, request);
}

StatusOr<google::bigtable::admin::v2::ListAuthorizedViewsResponse>
BigtableTableAdminAuth::ListAuthorizedViews(
    grpc::ClientContext& context, Options const& options,
    google::bigtable::admin::v2::ListAuthorizedViewsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListAuthorizedViews(context, options, request);
}

StatusOr<google::bigtable::admin::v2::AuthorizedView>
BigtableTableAdminAuth::GetAuthorizedView(
    grpc::ClientContext& context, Options const& options,
    google::bigtable::admin::v2::GetAuthorizedViewRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetAuthorizedView(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BigtableTableAdminAuth::AsyncUpdateAuthorizedView(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::bigtable::admin::v2::UpdateAuthorizedViewRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncUpdateAuthorizedView(cq, *std::move(context),
                                                std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation>
BigtableTableAdminAuth::UpdateAuthorizedView(
    grpc::ClientContext& context, Options options,
    google::bigtable::admin::v2::UpdateAuthorizedViewRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateAuthorizedView(context, options, request);
}

Status BigtableTableAdminAuth::DeleteAuthorizedView(
    grpc::ClientContext& context, Options const& options,
    google::bigtable::admin::v2::DeleteAuthorizedViewRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteAuthorizedView(context, options, request);
}

StatusOr<google::bigtable::admin::v2::Table>
BigtableTableAdminAuth::ModifyColumnFamilies(
    grpc::ClientContext& context, Options const& options,
    google::bigtable::admin::v2::ModifyColumnFamiliesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ModifyColumnFamilies(context, options, request);
}

Status BigtableTableAdminAuth::DropRowRange(
    grpc::ClientContext& context, Options const& options,
    google::bigtable::admin::v2::DropRowRangeRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DropRowRange(context, options, request);
}

StatusOr<google::bigtable::admin::v2::GenerateConsistencyTokenResponse>
BigtableTableAdminAuth::GenerateConsistencyToken(
    grpc::ClientContext& context, Options const& options,
    google::bigtable::admin::v2::GenerateConsistencyTokenRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GenerateConsistencyToken(context, options, request);
}

StatusOr<google::bigtable::admin::v2::CheckConsistencyResponse>
BigtableTableAdminAuth::CheckConsistency(
    grpc::ClientContext& context, Options const& options,
    google::bigtable::admin::v2::CheckConsistencyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CheckConsistency(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BigtableTableAdminAuth::AsyncCreateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::bigtable::admin::v2::CreateBackupRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCreateBackup(cq, *std::move(context),
                                        std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> BigtableTableAdminAuth::CreateBackup(
    grpc::ClientContext& context, Options options,
    google::bigtable::admin::v2::CreateBackupRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateBackup(context, options, request);
}

StatusOr<google::bigtable::admin::v2::Backup> BigtableTableAdminAuth::GetBackup(
    grpc::ClientContext& context, Options const& options,
    google::bigtable::admin::v2::GetBackupRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetBackup(context, options, request);
}

StatusOr<google::bigtable::admin::v2::Backup>
BigtableTableAdminAuth::UpdateBackup(
    grpc::ClientContext& context, Options const& options,
    google::bigtable::admin::v2::UpdateBackupRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateBackup(context, options, request);
}

Status BigtableTableAdminAuth::DeleteBackup(
    grpc::ClientContext& context, Options const& options,
    google::bigtable::admin::v2::DeleteBackupRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteBackup(context, options, request);
}

StatusOr<google::bigtable::admin::v2::ListBackupsResponse>
BigtableTableAdminAuth::ListBackups(
    grpc::ClientContext& context, Options const& options,
    google::bigtable::admin::v2::ListBackupsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListBackups(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BigtableTableAdminAuth::AsyncRestoreTable(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::bigtable::admin::v2::RestoreTableRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncRestoreTable(cq, *std::move(context),
                                        std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> BigtableTableAdminAuth::RestoreTable(
    grpc::ClientContext& context, Options options,
    google::bigtable::admin::v2::RestoreTableRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->RestoreTable(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
BigtableTableAdminAuth::AsyncCopyBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::bigtable::admin::v2::CopyBackupRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncCopyBackup(cq, *std::move(context),
                                      std::move(options), request);
      });
}

StatusOr<google::longrunning::Operation> BigtableTableAdminAuth::CopyBackup(
    grpc::ClientContext& context, Options options,
    google::bigtable::admin::v2::CopyBackupRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CopyBackup(context, options, request);
}

StatusOr<google::iam::v1::Policy> BigtableTableAdminAuth::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::Policy> BigtableTableAdminAuth::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
BigtableTableAdminAuth::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->TestIamPermissions(context, options, request);
}

future<StatusOr<google::bigtable::admin::v2::CheckConsistencyResponse>>
BigtableTableAdminAuth::AsyncCheckConsistency(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::bigtable::admin::v2::CheckConsistencyRequest const& request) {
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(
              StatusOr<google::bigtable::admin::v2::CheckConsistencyResponse>(
                  std::move(context).status()));
        }
        return child->AsyncCheckConsistency(cq, *std::move(context),
                                            std::move(options), request);
      });
}

future<StatusOr<google::longrunning::Operation>>
BigtableTableAdminAuth::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  using ReturnType = StatusOr<google::longrunning::Operation>;
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) {
          return make_ready_future(ReturnType(std::move(context).status()));
        }
        return child->AsyncGetOperation(cq, *std::move(context),
                                        std::move(options), request);
      });
}

future<Status> BigtableTableAdminAuth::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return auth_->AsyncConfigureContext(std::move(context))
      .then([cq, child = child_, options = std::move(options),
             request](future<StatusOr<std::shared_ptr<grpc::ClientContext>>>
                          f) mutable {
        auto context = f.get();
        if (!context) return make_ready_future(std::move(context).status());
        return child->AsyncCancelOperation(cq, *std::move(context),
                                           std::move(options), request);
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigtable_admin_internal
}  // namespace cloud
}  // namespace google
