// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/storage/v1/storage.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_STORAGE_V1_BIGQUERY_WRITE_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_STORAGE_V1_BIGQUERY_WRITE_CLIENT_H

#include "google/cloud/bigquery/storage/v1/bigquery_write_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace bigquery_storage_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// BigQuery Write API.
///
/// The Write API can be used to write data to BigQuery.
///
/// For supplementary information about the Write API, see:
/// https://cloud.google.com/bigquery/docs/write-api
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class BigQueryWriteClient {
 public:
  explicit BigQueryWriteClient(
      std::shared_ptr<BigQueryWriteConnection> connection, Options opts = {});
  ~BigQueryWriteClient();

  ///@{
  /// @name Copy and move support
  BigQueryWriteClient(BigQueryWriteClient const&) = default;
  BigQueryWriteClient& operator=(BigQueryWriteClient const&) = default;
  BigQueryWriteClient(BigQueryWriteClient&&) = default;
  BigQueryWriteClient& operator=(BigQueryWriteClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(BigQueryWriteClient const& a,
                         BigQueryWriteClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(BigQueryWriteClient const& a,
                         BigQueryWriteClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a write stream to the given table.
  /// Additionally, every table has a special stream named '_default'
  /// to which data can be written. This stream doesn't need to be created using
  /// CreateWriteStream. It is a stream that can be used simultaneously by any
  /// number of clients. Data written to this stream is considered committed as
  /// soon as an acknowledgement is received.
  ///
  /// @param parent  Required. Reference to the table to which the stream belongs, in the format
  ///  of `projects/{project}/datasets/{dataset}/tables/{table}`.
  /// @param write_stream  Required. Stream to be created.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.storage.v1.WriteStream])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.storage.v1.CreateWriteStreamRequest]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L403}
  /// [google.cloud.bigquery.storage.v1.WriteStream]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/stream.proto#L271}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::storage::v1::WriteStream> CreateWriteStream(
      std::string const& parent,
      google::cloud::bigquery::storage::v1::WriteStream const& write_stream,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a write stream to the given table.
  /// Additionally, every table has a special stream named '_default'
  /// to which data can be written. This stream doesn't need to be created using
  /// CreateWriteStream. It is a stream that can be used simultaneously by any
  /// number of clients. Data written to this stream is considered committed as
  /// soon as an acknowledgement is received.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.storage.v1.CreateWriteStreamRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.storage.v1.WriteStream])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.storage.v1.CreateWriteStreamRequest]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L403}
  /// [google.cloud.bigquery.storage.v1.WriteStream]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/stream.proto#L271}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::storage::v1::WriteStream> CreateWriteStream(
      google::cloud::bigquery::storage::v1::CreateWriteStreamRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Appends data to the given stream.
  ///
  /// If `offset` is specified, the `offset` is checked against the end of
  /// stream. The server returns `OUT_OF_RANGE` in `AppendRowsResponse` if an
  /// attempt is made to append to an offset beyond the current end of the stream
  /// or `ALREADY_EXISTS` if user provides an `offset` that has already been
  /// written to. User can retry with adjusted offset within the same RPC
  /// connection. If `offset` is not specified, append happens at the end of the
  /// stream.
  ///
  /// The response contains an optional offset at which the append
  /// happened.  No offset information will be returned for appends to a
  /// default stream.
  ///
  /// Responses are received in the same order in which requests are sent.
  /// There will be one response for each successful inserted request.  Responses
  /// may optionally embed error information if the originating AppendRequest was
  /// not successfully processed.
  ///
  /// The specifics of when successfully appended data is made visible to the
  /// table are governed by the type of stream:
  ///
  /// * For COMMITTED streams (which includes the default stream), data is
  /// visible immediately upon successful append.
  ///
  /// * For BUFFERED streams, data is made visible via a subsequent `FlushRows`
  /// rpc which advances a cursor to a newer offset in the stream.
  ///
  /// * For PENDING streams, data is not made visible until the stream itself is
  /// finalized (via the `FinalizeWriteStream` rpc), and the stream is explicitly
  /// committed via the `BatchCommitWriteStreams` rpc.
  ///
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return An object representing the bidirectional streaming
  ///     RPC. Applications can send multiple request messages and receive
  ///     multiple response messages through this API. Bidirectional streaming
  ///     RPCs can impose restrictions on the sequence of request and response
  ///     messages. Please consult the service documentation for details.
  ///     The request message type ([google.cloud.bigquery.storage.v1.AppendRowsRequest]) and response messages
  ///     ([google.cloud.bigquery.storage.v1.AppendRowsResponse]) are mapped to C++ classes using the
  ///     [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.storage.v1.AppendRowsRequest]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L424}
  /// [google.cloud.bigquery.storage.v1.AppendRowsResponse]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L553}
  ///
  // clang-format on
  std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
      google::cloud::bigquery::storage::v1::AppendRowsRequest,
      google::cloud::bigquery::storage::v1::AppendRowsResponse>>
  AsyncAppendRows(Options opts = {});

  // clang-format off
  ///
  /// Gets information about a write stream.
  ///
  /// @param name  Required. Name of the stream to get, in the form of
  ///  `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.storage.v1.WriteStream])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.storage.v1.GetWriteStreamRequest]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L604}
  /// [google.cloud.bigquery.storage.v1.WriteStream]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/stream.proto#L271}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::storage::v1::WriteStream> GetWriteStream(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets information about a write stream.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.storage.v1.GetWriteStreamRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.storage.v1.WriteStream])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.storage.v1.GetWriteStreamRequest]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L604}
  /// [google.cloud.bigquery.storage.v1.WriteStream]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/stream.proto#L271}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::storage::v1::WriteStream> GetWriteStream(
      google::cloud::bigquery::storage::v1::GetWriteStreamRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Finalize a write stream so that no new data can be appended to the
  /// stream. Finalize is not supported on the '_default' stream.
  ///
  /// @param name  Required. Name of the stream to finalize, in the form of
  ///  `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.storage.v1.FinalizeWriteStreamRequest]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L648}
  /// [google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L660}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>
  FinalizeWriteStream(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Finalize a write stream so that no new data can be appended to the
  /// stream. Finalize is not supported on the '_default' stream.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.storage.v1.FinalizeWriteStreamRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.storage.v1.FinalizeWriteStreamRequest]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L648}
  /// [google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L660}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>
  FinalizeWriteStream(
      google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Atomically commits a group of `PENDING` streams that belong to the same
  /// `parent` table.
  ///
  /// Streams must be finalized before commit and cannot be committed multiple
  /// times. Once a stream is committed, data in the stream becomes available
  /// for read operations.
  ///
  /// @param parent  Required. Parent table that all the streams should belong to, in the form
  ///  of `projects/{project}/datasets/{dataset}/tables/{table}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsRequest]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L620}
  /// [google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsResponse]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L633}
  ///
  // clang-format on
  StatusOr<
      google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>
  BatchCommitWriteStreams(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Atomically commits a group of `PENDING` streams that belong to the same
  /// `parent` table.
  ///
  /// Streams must be finalized before commit and cannot be committed multiple
  /// times. Once a stream is committed, data in the stream becomes available
  /// for read operations.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsRequest]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L620}
  /// [google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsResponse]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L633}
  ///
  // clang-format on
  StatusOr<
      google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>
  BatchCommitWriteStreams(google::cloud::bigquery::storage::v1::
                              BatchCommitWriteStreamsRequest const& request,
                          Options opts = {});

  // clang-format off
  ///
  /// Flushes rows to a BUFFERED stream.
  ///
  /// If users are appending rows to BUFFERED stream, flush operation is
  /// required in order for the rows to become available for reading. A
  /// Flush operation flushes up to any previously flushed offset in a BUFFERED
  /// stream, to the offset specified in the request.
  ///
  /// Flush is not supported on the _default stream, since it is not BUFFERED.
  ///
  /// @param write_stream  Required. The stream that is the target of the flush operation.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.storage.v1.FlushRowsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.storage.v1.FlushRowsRequest]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L666}
  /// [google.cloud.bigquery.storage.v1.FlushRowsResponse]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L681}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::storage::v1::FlushRowsResponse> FlushRows(
      std::string const& write_stream, Options opts = {});

  // clang-format off
  ///
  /// Flushes rows to a BUFFERED stream.
  ///
  /// If users are appending rows to BUFFERED stream, flush operation is
  /// required in order for the rows to become available for reading. A
  /// Flush operation flushes up to any previously flushed offset in a BUFFERED
  /// stream, to the offset specified in the request.
  ///
  /// Flush is not supported on the _default stream, since it is not BUFFERED.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.storage.v1.FlushRowsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.storage.v1.FlushRowsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.storage.v1.FlushRowsRequest]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L666}
  /// [google.cloud.bigquery.storage.v1.FlushRowsResponse]: @googleapis_reference_link{google/cloud/bigquery/storage/v1/storage.proto#L681}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::storage::v1::FlushRowsResponse> FlushRows(
      google::cloud::bigquery::storage::v1::FlushRowsRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<BigQueryWriteConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_storage_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_STORAGE_V1_BIGQUERY_WRITE_CLIENT_H
