// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/datapolicies/v1/datapolicy.proto

#include "google/cloud/bigquery/datapolicies/v1/internal/data_policy_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquery_datapolicies_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DataPolicyServiceTracingConnection::DataPolicyServiceTracingConnection(
    std::shared_ptr<bigquery_datapolicies_v1::DataPolicyServiceConnection>
        child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
DataPolicyServiceTracingConnection::CreateDataPolicy(
    google::cloud::bigquery::datapolicies::v1::CreateDataPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datapolicies_v1::DataPolicyServiceConnection::"
      "CreateDataPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateDataPolicy(request));
}

StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
DataPolicyServiceTracingConnection::UpdateDataPolicy(
    google::cloud::bigquery::datapolicies::v1::UpdateDataPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datapolicies_v1::DataPolicyServiceConnection::"
      "UpdateDataPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateDataPolicy(request));
}

StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
DataPolicyServiceTracingConnection::RenameDataPolicy(
    google::cloud::bigquery::datapolicies::v1::RenameDataPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datapolicies_v1::DataPolicyServiceConnection::"
      "RenameDataPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->RenameDataPolicy(request));
}

Status DataPolicyServiceTracingConnection::DeleteDataPolicy(
    google::cloud::bigquery::datapolicies::v1::DeleteDataPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datapolicies_v1::DataPolicyServiceConnection::"
      "DeleteDataPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteDataPolicy(request));
}

StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
DataPolicyServiceTracingConnection::GetDataPolicy(
    google::cloud::bigquery::datapolicies::v1::GetDataPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datapolicies_v1::DataPolicyServiceConnection::GetDataPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDataPolicy(request));
}

StreamRange<google::cloud::bigquery::datapolicies::v1::DataPolicy>
DataPolicyServiceTracingConnection::ListDataPolicies(
    google::cloud::bigquery::datapolicies::v1::ListDataPoliciesRequest
        request) {
  auto span = internal::MakeSpan(
      "bigquery_datapolicies_v1::DataPolicyServiceConnection::"
      "ListDataPolicies");
  internal::OTelScope scope(span);
  auto sr = child_->ListDataPolicies(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::bigquery::datapolicies::v1::DataPolicy>(std::move(span),
                                                             std::move(sr));
}

StatusOr<google::iam::v1::Policy>
DataPolicyServiceTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquery_datapolicies_v1::DataPolicyServiceConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy>
DataPolicyServiceTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquery_datapolicies_v1::DataPolicyServiceConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DataPolicyServiceTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquery_datapolicies_v1::DataPolicyServiceConnection::"
      "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<bigquery_datapolicies_v1::DataPolicyServiceConnection>
MakeDataPolicyServiceTracingConnection(
    std::shared_ptr<bigquery_datapolicies_v1::DataPolicyServiceConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<DataPolicyServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_datapolicies_v1_internal
}  // namespace cloud
}  // namespace google
