// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#include "google/cloud/appengine/v1/internal/authorized_certificates_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace appengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AuthorizedCertificatesTracingConnection::
    AuthorizedCertificatesTracingConnection(
        std::shared_ptr<appengine_v1::AuthorizedCertificatesConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::appengine::v1::AuthorizedCertificate>
AuthorizedCertificatesTracingConnection::ListAuthorizedCertificates(
    google::appengine::v1::ListAuthorizedCertificatesRequest request) {
  auto span = internal::MakeSpan(
      "appengine_v1::AuthorizedCertificatesConnection::"
      "ListAuthorizedCertificates");
  internal::OTelScope scope(span);
  auto sr = child_->ListAuthorizedCertificates(std::move(request));
  return internal::MakeTracedStreamRange<
      google::appengine::v1::AuthorizedCertificate>(std::move(span),
                                                    std::move(sr));
}

StatusOr<google::appengine::v1::AuthorizedCertificate>
AuthorizedCertificatesTracingConnection::GetAuthorizedCertificate(
    google::appengine::v1::GetAuthorizedCertificateRequest const& request) {
  auto span = internal::MakeSpan(
      "appengine_v1::AuthorizedCertificatesConnection::"
      "GetAuthorizedCertificate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetAuthorizedCertificate(request));
}

StatusOr<google::appengine::v1::AuthorizedCertificate>
AuthorizedCertificatesTracingConnection::CreateAuthorizedCertificate(
    google::appengine::v1::CreateAuthorizedCertificateRequest const& request) {
  auto span = internal::MakeSpan(
      "appengine_v1::AuthorizedCertificatesConnection::"
      "CreateAuthorizedCertificate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateAuthorizedCertificate(request));
}

StatusOr<google::appengine::v1::AuthorizedCertificate>
AuthorizedCertificatesTracingConnection::UpdateAuthorizedCertificate(
    google::appengine::v1::UpdateAuthorizedCertificateRequest const& request) {
  auto span = internal::MakeSpan(
      "appengine_v1::AuthorizedCertificatesConnection::"
      "UpdateAuthorizedCertificate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateAuthorizedCertificate(request));
}

Status AuthorizedCertificatesTracingConnection::DeleteAuthorizedCertificate(
    google::appengine::v1::DeleteAuthorizedCertificateRequest const& request) {
  auto span = internal::MakeSpan(
      "appengine_v1::AuthorizedCertificatesConnection::"
      "DeleteAuthorizedCertificate");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteAuthorizedCertificate(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<appengine_v1::AuthorizedCertificatesConnection>
MakeAuthorizedCertificatesTracingConnection(
    std::shared_ptr<appengine_v1::AuthorizedCertificatesConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<AuthorizedCertificatesTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine_v1_internal
}  // namespace cloud
}  // namespace google
