/***********************************************************************
 * Software License Agreement (BSD License)
 *
 * Copyright 2008-2009  Marius Muja (mariusm@cs.ubc.ca). All rights reserved.
 * Copyright 2008-2009  David G. Lowe (lowe@cs.ubc.ca). All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *************************************************************************/


#ifndef RTABMAP_FLANN_SAMPLING_H_
#define RTABMAP_FLANN_SAMPLING_H_

#include "rtflann/util/matrix.h"
#include "rtflann/util/random.h"

namespace rtflann
{

template<typename T>
Matrix<T> random_sample(Matrix<T>& srcMatrix, size_t size, bool remove = false)
{
	UniqueRandom rand_unique(srcMatrix.rows);
    Matrix<T> newSet(new T[size * srcMatrix.cols], size,srcMatrix.cols);

    T* src,* dest;
    for (size_t i=0; i<size; ++i) {
    	size_t r;
    	if (remove) {
            r = static_cast<size_t>(rand_int(srcMatrix.rows-i));
    	}
    	else {
    		r = static_cast<size_t>(rand_unique.next());
    	}
        dest = newSet[i];
        src = srcMatrix[r];
        std::copy(src, src+srcMatrix.cols, dest);
        if (remove) {
            src = srcMatrix[srcMatrix.rows-i-1];
            dest = srcMatrix[r];
            std::copy(src, src+srcMatrix.cols, dest);
        }
    }
    if (remove) {
        srcMatrix.rows -= size;
    }
    return newSet;
}

} // namespace


#endif /* FLANN_SAMPLING_H_ */
