---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, caractères, écrire en français, guillemets, 
              quotes, quote marks, apostrophes, guillemets simples, citation
---

# Comment obtenir les guillemets ?

## Les guillemets français

Pour écrire en français, vous utilisez normalement l'extension <ctanpkg:babel>
avec l'option `french` (qu’il vaut mieux donner au chargement de la classe du document).
La [documentation de babel-french](texdoc:frenchb-doc) est en français, 
et mentionne les guillemets à la page 6.

Dans ce cas, 
- la commande `\og` ouvre les guillemets ;
- la commande `\fg` ferme les guillemets. 

La commande `\frquote{⟨texte⟩}` est aussi disponible. Elle ajuste les espaces
autour des guillemets, gère les imbrications et permet des citations sur
plusieurs lignes : 

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page

\begin{document}
Qu'entendez-vous par \og{}des guillemets\fg{} ?

Elle répondit : \frquote{Je ne parle pas des \frquote{chiures de 
mouches}, mais des vrais guillemets.}

\bigskip
Jan \bsc{Tschichold} a écrit :

\frquote{Une typographie personnelle est une typographie défectueuse.
Seuls les débutants et les imbéciles peuvent l'exiger.

La typographie de la plupart des journaux est résolument arriérée.
}
\end{document}
```

Une autre façon de saisir des guillements français est d'utiliser `<<` et `>>`. 
C'est notamment la façon recommandée par l'extension <ctanpkg:e-french>. 
Mais il vous faudra insérer vous-mêmes des espaces insécables avec `~` 
(certains préfèrent des espaces fines avec `\,`) :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  % \usepackage{babel}      % Pour l'exemple, on retranche ici babel.
  \usepackage{frenchle}     % ... mais on utilise frenchle
  \pagestyle{empty}         % N'affiche pas de numéro de page

\begin{document}
Car, qu'entendez-vous par <<\,des guillemets\,>> ?

Oui, qu'entendez-vous par <<~des guillemets~>> ?
\end{document}
```


## Les guillemets dans d'autres langues

L'extension <ctanpkg:csquotes> permet de gérer des guillemets dans différentes langues
en mettant à disposition de nombreuses commandes. 

Pour simplifier, en utilisant l'option d'extension `autostyle=true`, 
la gestion du choix des caractères des guillemets se fait en fonction des choix de langues
(avec la commande `\enquote{⟨texte⟩}`), par exemple avec les indications 
`\selectlanguage{⟨langue⟩}` données pour l'extension <ctanpkg:babel>. 
Si les guillemets d'une autre langue sont nécessaires, la commande 
`\foreigntextquote{⟨langue⟩}{⟨texte⟩}` permet de les sélectionner spécifiquement.

L'exemple ci-dessous illustre ces différents cas. Vous pourrez d'ailleurs noter 
qu'en français les guillemets placés dans des guillemets sont des guillemets anglais. 
En anglais, l'usage est tout autre.

```
\documentclass[french,english]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage[autostyle=true]{csquotes}

\begin{document}
\selectlanguage{english} % On passe en anglais pour babel
What do you mean by \enquote{guillemets} ?

She answered : \enquote{I'm not talking about \enquote{fly droppings}, 
but real inverted commas}. 

In other words, \foreigntextquote{french}{Je ne parle pas des 
\enquote{chiures de mouches}, mais des vrais 
guillemets.}

\selectlanguage{french} % On passe en français pour babel
Il s'indigna : \enquote{Des \enquote{chiures de mouches} ? Vous êtes 
sérieuse ?}
\end{document}
```

:::{seealso}
Pour des informations plus poussées sur les guillemets et leur histoire, vous pouvez consulter 
*[Les guillemets](<http://listetypo.free.fr/meron/new/Guilles.pdf>)* de Jean Méron (1999) 
:::

:::{sources}
- [Guillemets in LaTeX («  »)](https://tex.stackexchange.com/q/2681) 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/) ;
- [French quotation marks in titles](https://tex.stackexchange.com/q/201995), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/).
:::
