---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, résumé, abstract
---

# Comment mettre un résumé et un abstract dans un document ?

## Avec l'extension <ctanpkg:babel>

L'extension <ctanpkg:babel> peut être utilisée, comme le montre l'exemple.

```
\documentclass[english,french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{babel}          % Réglages linguistiques
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\selectlanguage{francais}
\begin{abstract}
Je parle français
\end{abstract}

\selectlanguage{english}
\begin{abstract}
I speak english
\end{abstract}
\end{document}
```


## Avec l'extension <ctanpkg:e-french>

L'extension <ctanpkg:e-french> a hérité de [French Pro](ctanpkg:frenchpro)
(qu'il remplace) les environnements `resume` et `abstract`.


## Avec les commandes de base

Autre solution qui ne permet toutefois pas d'avoir les deux textes 
sur la même page :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\renewcommand{\abstractname}{Résumé}
\begin{abstract} résumé en français \end{abstract}
\renewcommand{\abstractname}{Abstract}
\begin{abstract} the same in english \end{abstract}
\end{document}
```