/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.actions.HandleAction;
import org.asamk.signal.manager.actions.RefreshPreKeysAction;
import org.asamk.signal.manager.actions.RenewSessionAction;
import org.asamk.signal.manager.actions.ResendMessageAction;
import org.asamk.signal.manager.actions.RetrieveProfileAction;
import org.asamk.signal.manager.actions.SendGroupInfoAction;
import org.asamk.signal.manager.actions.SendGroupInfoRequestAction;
import org.asamk.signal.manager.actions.SendProfileKeyAction;
import org.asamk.signal.manager.actions.SendReceiptAction;
import org.asamk.signal.manager.actions.SendRetryMessageRequestAction;
import org.asamk.signal.manager.actions.SendSyncBlockedListAction;
import org.asamk.signal.manager.actions.SendSyncConfigurationAction;
import org.asamk.signal.manager.actions.SendSyncContactsAction;
import org.asamk.signal.manager.actions.SendSyncGroupsAction;
import org.asamk.signal.manager.actions.SendSyncKeysAction;
import org.asamk.signal.manager.actions.SyncStorageDataAction;
import org.asamk.signal.manager.actions.UpdateAccountAttributesAction;
import org.asamk.signal.manager.api.Contact;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupIdV1;
import org.asamk.signal.manager.api.GroupNotFoundException;
import org.asamk.signal.manager.api.MessageEnvelope;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.ReceiveConfig;
import org.asamk.signal.manager.api.StickerPackId;
import org.asamk.signal.manager.api.TrustLevel;
import org.asamk.signal.manager.api.UntrustedIdentityException;
import org.asamk.signal.manager.groups.GroupUtils;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.jobs.RetrieveStickerPackJob;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.configuration.ConfigurationStore;
import org.asamk.signal.manager.storage.groups.GroupInfo;
import org.asamk.signal.manager.storage.groups.GroupInfoV1;
import org.asamk.signal.manager.storage.identities.IdentityInfo;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.recipients.RecipientResolver;
import org.asamk.signal.manager.storage.sendLog.MessageSendLogEntry;
import org.asamk.signal.manager.storage.sessions.SessionStore;
import org.asamk.signal.manager.storage.stickers.StickerPack;
import org.signal.libsignal.metadata.ProtocolException;
import org.signal.libsignal.metadata.ProtocolInvalidKeyException;
import org.signal.libsignal.metadata.ProtocolInvalidKeyIdException;
import org.signal.libsignal.metadata.ProtocolInvalidMessageException;
import org.signal.libsignal.metadata.ProtocolNoSessionException;
import org.signal.libsignal.metadata.ProtocolUntrustedIdentityException;
import org.signal.libsignal.metadata.SelfSendException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.UsePqRatchet;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.groups.GroupSessionBuilder;
import org.signal.libsignal.protocol.groups.state.SenderKeyStore;
import org.signal.libsignal.protocol.message.DecryptionErrorMessage;
import org.signal.libsignal.protocol.message.SenderKeyDistributionMessage;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.AccountEntropyPool;
import org.whispersystems.signalservice.api.InvalidMessageStructureException;
import org.whispersystems.signalservice.api.backup.MediaRootBackupKey;
import org.whispersystems.signalservice.api.crypto.EnvelopeMetadata;
import org.whispersystems.signalservice.api.crypto.SignalGroupSessionBuilder;
import org.whispersystems.signalservice.api.crypto.SignalServiceCipherResult;
import org.whispersystems.signalservice.api.kbs.MasterKey;
import org.whispersystems.signalservice.api.messages.EnvelopeContentValidator;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceContent;
import org.whispersystems.signalservice.api.messages.SignalServiceDataMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceEditMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceEnvelope;
import org.whispersystems.signalservice.api.messages.SignalServiceGroup;
import org.whispersystems.signalservice.api.messages.SignalServiceGroupContext;
import org.whispersystems.signalservice.api.messages.SignalServiceGroupV2;
import org.whispersystems.signalservice.api.messages.SignalServicePniSignatureMessage;
import org.whispersystems.signalservice.api.messages.SignalServicePreview;
import org.whispersystems.signalservice.api.messages.SignalServiceReceiptMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceStoryMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceTextAttachment;
import org.whispersystems.signalservice.api.messages.multidevice.BlockedListMessage;
import org.whispersystems.signalservice.api.messages.multidevice.ConfigurationMessage;
import org.whispersystems.signalservice.api.messages.multidevice.ContactsMessage;
import org.whispersystems.signalservice.api.messages.multidevice.KeysMessage;
import org.whispersystems.signalservice.api.messages.multidevice.RequestMessage;
import org.whispersystems.signalservice.api.messages.multidevice.SentTranscriptMessage;
import org.whispersystems.signalservice.api.messages.multidevice.SignalServiceSyncMessage;
import org.whispersystems.signalservice.api.messages.multidevice.StickerPackOperationMessage;
import org.whispersystems.signalservice.api.messages.multidevice.VerifiedMessage;
import org.whispersystems.signalservice.api.messages.shared.SharedContact;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.ServiceIdType;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.storage.StorageKey;
import org.whispersystems.signalservice.internal.push.Content;
import org.whispersystems.signalservice.internal.push.Envelope;
import org.whispersystems.signalservice.internal.push.SyncMessage;
import org.whispersystems.signalservice.internal.push.UnsupportedDataMessageException;

public final class IncomingMessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(IncomingMessageHandler.class);
    private final SignalAccount account;
    private final SignalDependencies dependencies;
    private final Context context;

    public IncomingMessageHandler(Context context) {
        this.account = context.getAccount();
        this.dependencies = context.getDependencies();
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<List<HandleAction>, Exception> handleRetryEnvelope(SignalServiceEnvelope envelope, ReceiveConfig receiveConfig, Manager.ReceiveMessageHandler handler) {
        ArrayList<HandleAction> actions = new ArrayList<HandleAction>();
        if (envelope.isPreKeySignalMessage()) {
            actions.add(RefreshPreKeysAction.create());
        }
        SignalServiceContent content = null;
        if (!envelope.isReceipt()) {
            this.account.getIdentityKeyStore().setRetryingDecryption(true);
            ServiceId destination = this.getDestination(envelope).serviceId();
            try {
                SignalServiceCipherResult cipherResult = this.dependencies.getCipher(destination == null || destination.equals(this.account.getAci()) ? ServiceIdType.ACI : ServiceIdType.PNI).decrypt(envelope.getProto(), envelope.getServerDeliveredTimestamp(), UsePqRatchet.NO);
                content = this.validate(envelope.getProto(), cipherResult, envelope.getServerDeliveredTimestamp());
                if (content == null) {
                    Pair pair = new Pair(List.of(), null);
                    return pair;
                }
            }
            catch (ProtocolUntrustedIdentityException e) {
                RecipientId recipientId = this.account.getRecipientResolver().resolveRecipient(e.getSender());
                UntrustedIdentityException exception = new UntrustedIdentityException(this.account.getRecipientAddressResolver().resolveRecipientAddress(recipientId).toApiRecipientAddress(), e.getSenderDevice());
                Pair<List<HandleAction>, Exception> pair = new Pair<List<HandleAction>, Exception>(List.of(), exception);
                return pair;
            }
            catch (Exception e) {
                Pair<List<HandleAction>, Exception> pair = new Pair<List<HandleAction>, Exception>(List.of(), e);
                return pair;
            }
            finally {
                this.account.getIdentityKeyStore().setRetryingDecryption(false);
            }
        }
        actions.addAll(this.checkAndHandleMessage(envelope, content, receiveConfig, handler, null));
        return new Pair(actions, null);
    }

    public Pair<List<HandleAction>, Exception> handleEnvelope(SignalServiceEnvelope envelope, ReceiveConfig receiveConfig, Manager.ReceiveMessageHandler handler) {
        ArrayList<HandleAction> actions = new ArrayList<HandleAction>();
        SignalServiceContent content = null;
        Throwable exception = null;
        envelope.getSourceServiceId().map(ServiceId::parseOrNull).ifPresent(serviceId -> this.account.getRecipientResolver().resolveRecipient((ServiceId)serviceId));
        if (!envelope.isReceipt()) {
            ServiceId destination = this.getDestination(envelope).serviceId();
            try {
                SignalServiceCipherResult cipherResult = this.dependencies.getCipher(destination == null || destination.equals(this.account.getAci()) ? ServiceIdType.ACI : ServiceIdType.PNI).decrypt(envelope.getProto(), envelope.getServerDeliveredTimestamp(), UsePqRatchet.NO);
                content = this.validate(envelope.getProto(), cipherResult, envelope.getServerDeliveredTimestamp());
                if (content == null) {
                    return new Pair(List.of(), null);
                }
            }
            catch (ProtocolUntrustedIdentityException e) {
                RecipientId recipientId = this.account.getRecipientResolver().resolveRecipient(e.getSender());
                actions.add(new RetrieveProfileAction(recipientId));
                exception = new UntrustedIdentityException(this.account.getRecipientAddressResolver().resolveRecipientAddress(recipientId).toApiRecipientAddress(), e.getSenderDevice());
            }
            catch (ProtocolInvalidKeyException | ProtocolInvalidKeyIdException | ProtocolInvalidMessageException | ProtocolNoSessionException e) {
                logger.debug("Failed to decrypt incoming message", e);
                if (e instanceof ProtocolInvalidKeyIdException) {
                    actions.add(RefreshPreKeysAction.create());
                }
                RecipientId sender = this.account.getRecipientResolver().resolveRecipient(e.getSender());
                if (this.context.getContactHelper().isContactBlocked(sender)) {
                    logger.debug("Received invalid message from blocked contact, ignoring.");
                } else {
                    ServiceId serviceId2 = ServiceId.parseOrNull((String)e.getSender());
                    if (serviceId2 != null) {
                        boolean isSelf = sender.equals(this.account.getSelfRecipientId()) && e.getSenderDevice() == this.account.getDeviceId();
                        logger.debug("Received invalid message, queuing renew session action.");
                        actions.add(new RenewSessionAction(sender, serviceId2, destination));
                        if (!isSelf) {
                            logger.debug("Received invalid message, requesting message resend.");
                            actions.add(new SendRetryMessageRequestAction(sender, (ProtocolException)e, envelope));
                        }
                    } else {
                        logger.debug("Received invalid message from invalid sender: {}", (Object)e.getSender());
                    }
                }
                exception = e;
            }
            catch (SelfSendException e) {
                logger.debug("Dropping unidentified message from self.");
                return new Pair(List.of(), null);
            }
            catch (Exception e) {
                logger.debug("Failed to handle incoming message", (Throwable)e);
                exception = e;
            }
        }
        actions.addAll(this.checkAndHandleMessage(envelope, content, receiveConfig, handler, (Exception)exception));
        return new Pair<List<HandleAction>, Exception>((List<HandleAction>)actions, (Exception)exception);
    }

    private SignalServiceContent validate(Envelope envelope, SignalServiceCipherResult cipherResult, long serverDeliveredTimestamp) throws ProtocolInvalidKeyException, ProtocolInvalidMessageException, UnsupportedDataMessageException, InvalidMessageStructureException {
        Content content = cipherResult.getContent();
        EnvelopeMetadata envelopeMetadata = cipherResult.getMetadata();
        EnvelopeContentValidator.Result validationResult = EnvelopeContentValidator.INSTANCE.validate(envelope, content, this.account.getAci());
        if (validationResult instanceof EnvelopeContentValidator.Result.Invalid) {
            EnvelopeContentValidator.Result.Invalid v = (EnvelopeContentValidator.Result.Invalid)validationResult;
            logger.warn("Invalid content! {}", (Object)v.getReason(), (Object)v.getThrowable());
            return null;
        }
        if (validationResult instanceof EnvelopeContentValidator.Result.UnsupportedDataMessage) {
            EnvelopeContentValidator.Result.UnsupportedDataMessage v = (EnvelopeContentValidator.Result.UnsupportedDataMessage)validationResult;
            logger.warn("Unsupported DataMessage! Our version: {}, their version: {}", (Object)v.getOurVersion(), (Object)v.getTheirVersion());
            return null;
        }
        return SignalServiceContent.Companion.createFrom(this.account.getNumber(), envelope, envelopeMetadata, content, serverDeliveredTimestamp);
    }

    private List<HandleAction> checkAndHandleMessage(SignalServiceEnvelope envelope, SignalServiceContent content, ReceiveConfig receiveConfig, Manager.ReceiveMessageHandler handler, Exception exception) {
        SignalServiceAddress senderAddress;
        if (content != null) {
            boolean handledPniSignature = false;
            if (content.getPniSignatureMessage().isPresent()) {
                SignalServicePniSignatureMessage message = (SignalServicePniSignatureMessage)content.getPniSignatureMessage().get();
                senderAddress = this.getSenderAddress(envelope, content);
                if (senderAddress != null) {
                    handledPniSignature = this.handlePniSignatureMessage(message, senderAddress);
                }
            }
            if (!handledPniSignature) {
                this.account.getRecipientTrustedResolver().resolveRecipientTrusted(content.getSender());
            }
        }
        if (envelope.isReceipt()) {
            DeviceAddress senderDeviceAddress = this.getSender(envelope, content);
            ServiceId sender = senderDeviceAddress.serviceId();
            int senderDeviceId = senderDeviceAddress.deviceId();
            this.account.getMessageSendLogStore().deleteEntryForRecipient(envelope.getTimestamp(), sender, senderDeviceId);
        }
        boolean notAllowedToSendToGroup = this.isNotAllowedToSendToGroup(envelope, content);
        SignalServiceGroupContext groupContext = this.getGroupContext(content);
        if (groupContext != null && groupContext.getGroupV2().isPresent()) {
            this.handleGroupV2Context((SignalServiceGroupV2)groupContext.getGroupV2().get());
        }
        boolean bl = notAllowedToSendToGroup = notAllowedToSendToGroup && this.isNotAllowedToSendToGroup(envelope, content);
        if (this.isMessageBlocked(envelope, content)) {
            logger.info("Ignoring a message from blocked user/group: {}", (Object)envelope.getTimestamp());
            return List.of();
        }
        if (notAllowedToSendToGroup) {
            senderAddress = this.getSenderAddress(envelope, content);
            logger.info("Ignoring a group message from an unauthorized sender (no member or admin): {} {}", (Object)(senderAddress == null ? null : senderAddress.getIdentifier()), (Object)envelope.getTimestamp());
            return List.of();
        }
        List<HandleAction> actions = content != null ? this.handleMessage(envelope, content, receiveConfig) : List.of();
        handler.handleMessage(MessageEnvelope.from(envelope, content, this.account.getRecipientResolver(), this.account.getRecipientAddressResolver(), this.context.getAttachmentHelper()::getAttachmentFile, exception), exception);
        return actions;
    }

    public List<HandleAction> handleMessage(SignalServiceEnvelope envelope, SignalServiceContent content, ReceiveConfig receiveConfig) {
        SignalServiceReceiptMessage message;
        ArrayList<HandleAction> actions = new ArrayList<HandleAction>();
        DeviceAddress senderDeviceAddress = this.getSender(envelope, content);
        RecipientId sender = senderDeviceAddress.recipientId();
        ServiceId senderServiceId = senderDeviceAddress.serviceId();
        int senderDeviceId = senderDeviceAddress.deviceId();
        DeviceAddress destination = this.getDestination(envelope);
        if (this.account.getPni().equals((Object)destination.serviceId)) {
            this.account.getRecipientStore().markNeedsPniSignature(destination.recipientId, true);
        } else if (this.account.getAci().equals((Object)destination.serviceId)) {
            this.account.getRecipientStore().markNeedsPniSignature(destination.recipientId, false);
        }
        if (content.getReceiptMessage().isPresent() && (message = (SignalServiceReceiptMessage)content.getReceiptMessage().get()).isDeliveryReceipt()) {
            this.account.getMessageSendLogStore().deleteEntriesForRecipient(message.getTimestamps(), senderServiceId, senderDeviceId);
        }
        if (content.getSenderKeyDistributionMessage().isPresent()) {
            message = (SenderKeyDistributionMessage)content.getSenderKeyDistributionMessage().get();
            SignalProtocolAddress protocolAddress = senderServiceId.toProtocolAddress(senderDeviceId);
            logger.debug("Received a sender key distribution message for distributionId {} from {}", (Object)message.getDistributionId(), (Object)protocolAddress);
            new SignalGroupSessionBuilder(this.dependencies.getSessionLock(), new GroupSessionBuilder((SenderKeyStore)this.account.getSenderKeyStore())).process(protocolAddress, (SenderKeyDistributionMessage)message);
        }
        if (content.getDecryptionErrorMessage().isPresent()) {
            message = (DecryptionErrorMessage)content.getDecryptionErrorMessage().get();
            logger.debug("Received a decryption error message from {}.{} (resend request for {})", new Object[]{sender, senderDeviceId, message.getTimestamp()});
            if (message.getDeviceId() == this.account.getDeviceId()) {
                this.handleDecryptionErrorMessage(actions, sender, senderServiceId, senderDeviceId, (DecryptionErrorMessage)message, destination.serviceId());
            } else {
                logger.debug("Request is for another one of our devices");
            }
        }
        if (content.getDataMessage().isPresent() || content.getEditMessage().isPresent()) {
            SignalServiceDataMessage signalServiceDataMessage = message = content.getDataMessage().isPresent() ? (SignalServiceDataMessage)content.getDataMessage().get() : ((SignalServiceEditMessage)content.getEditMessage().get()).getDataMessage();
            if (content.isNeedsReceipt()) {
                actions.add(new SendReceiptAction(sender, SignalServiceReceiptMessage.Type.DELIVERY, message.getTimestamp()));
            } else {
                Contact contact = this.context.getAccount().getContactStore().getContact(sender);
                if (this.account.isPrimaryDevice() && contact != null && !contact.isBlocked() && contact.isProfileSharingEnabled()) {
                    actions.add(UpdateAccountAttributesAction.create());
                    actions.add(new SendProfileKeyAction(sender));
                }
            }
            if (receiveConfig.sendReadReceipts()) {
                actions.add(new SendReceiptAction(sender, SignalServiceReceiptMessage.Type.READ, message.getTimestamp()));
            }
            actions.addAll(this.handleSignalServiceDataMessage((SignalServiceDataMessage)message, false, senderDeviceAddress, destination, receiveConfig.ignoreAttachments()));
        }
        if (content.getStoryMessage().isPresent()) {
            message = (SignalServiceStoryMessage)content.getStoryMessage().get();
            actions.addAll(this.handleSignalServiceStoryMessage((SignalServiceStoryMessage)message, sender, receiveConfig.ignoreAttachments()));
        }
        if (content.getSyncMessage().isPresent()) {
            SignalServiceSyncMessage syncMessage = (SignalServiceSyncMessage)content.getSyncMessage().get();
            actions.addAll(this.handleSyncMessage(envelope, syncMessage, senderDeviceAddress, receiveConfig.ignoreAttachments()));
        }
        return actions;
    }

    private boolean handlePniSignatureMessage(SignalServicePniSignatureMessage message, SignalServiceAddress senderAddress) {
        ServiceId aci = senderAddress.getServiceId();
        IdentityInfo aciIdentity = this.account.getIdentityKeyStore().getIdentityInfo(aci);
        ServiceId.PNI pni = message.getPni();
        IdentityInfo pniIdentity = this.account.getIdentityKeyStore().getIdentityInfo((ServiceId)pni);
        if (aciIdentity == null || pniIdentity == null || aci.equals(pni)) {
            return false;
        }
        boolean verified = pniIdentity.getIdentityKey().verifyAlternateIdentity(aciIdentity.getIdentityKey(), message.getSignature());
        if (!verified) {
            logger.debug("Invalid PNI signature of ACI {} with PNI {}", (Object)aci, (Object)pni);
            return false;
        }
        logger.debug("Verified association of ACI {} with PNI {}", (Object)aci, (Object)pni);
        this.account.getRecipientTrustedResolver().resolveRecipientTrusted(Optional.of(ServiceId.ACI.from((UUID)aci.getRawUuid())), Optional.of(pni), senderAddress.getNumber());
        return true;
    }

    private void handleDecryptionErrorMessage(List<HandleAction> actions, RecipientId sender, ServiceId senderServiceId, int senderDeviceId, DecryptionErrorMessage message, ServiceId destination) {
        List<MessageSendLogEntry> logEntries = this.account.getMessageSendLogStore().findMessages(senderServiceId, senderDeviceId, message.getTimestamp(), message.getRatchetKey().isEmpty());
        for (MessageSendLogEntry logEntry : logEntries) {
            actions.add(new ResendMessageAction(sender, message.getTimestamp(), logEntry));
        }
        if (message.getRatchetKey().isPresent()) {
            SessionStore sessionStore = this.account.getAccountData(destination).getSessionStore();
            if (sessionStore.isCurrentRatchetKey(senderServiceId, senderDeviceId, (ECPublicKey)message.getRatchetKey().get())) {
                if (logEntries.isEmpty()) {
                    logger.debug("Renewing the session with sender");
                    actions.add(new RenewSessionAction(sender, senderServiceId, destination));
                } else {
                    logger.trace("Archiving the session with sender, a resend message has already been queued");
                    sessionStore.archiveSessions(senderServiceId);
                }
            }
            return;
        }
        boolean found = false;
        for (MessageSendLogEntry logEntry : logEntries) {
            GroupInfo group;
            if (logEntry.groupId().isEmpty() || (group = this.account.getGroupStore().getGroup(logEntry.groupId().get())) == null) continue;
            found = true;
            logger.trace("Deleting shared sender key with {} ({}): {}", new Object[]{sender, senderDeviceId, group.getDistributionId()});
            this.account.getSenderKeyStore().deleteSharedWith(senderServiceId, senderDeviceId, group.getDistributionId());
        }
        if (!found) {
            logger.debug("Reset all shared sender keys with this recipient, no related message found in send log");
            this.account.getSenderKeyStore().deleteSharedWith(senderServiceId);
        }
    }

    private List<HandleAction> handleSyncMessage(SignalServiceEnvelope envelope, SignalServiceSyncMessage syncMessage, DeviceAddress sender, boolean ignoreAttachments) {
        ArrayList<HandleAction> actions = new ArrayList<HandleAction>();
        this.account.setMultiDevice(true);
        if (syncMessage.getSent().isPresent()) {
            SentTranscriptMessage message = (SentTranscriptMessage)syncMessage.getSent().get();
            SignalServiceAddress destination = message.getDestination().orElse(null);
            if (message.getDataMessage().isPresent()) {
                actions.addAll(this.handleSignalServiceDataMessage((SignalServiceDataMessage)message.getDataMessage().get(), true, sender, destination == null ? null : new DeviceAddress(this.account.getRecipientResolver().resolveRecipient(destination), destination.getServiceId(), 0), ignoreAttachments));
            }
            if (message.getStoryMessage().isPresent()) {
                actions.addAll(this.handleSignalServiceStoryMessage((SignalServiceStoryMessage)message.getStoryMessage().get(), sender.recipientId(), ignoreAttachments));
            }
        }
        if (syncMessage.getRequest().isPresent() && this.account.isPrimaryDevice()) {
            RequestMessage rm = (RequestMessage)syncMessage.getRequest().get();
            if (rm.isContactsRequest()) {
                actions.add(SendSyncContactsAction.create());
            }
            if (rm.isGroupsRequest()) {
                actions.add(SendSyncGroupsAction.create());
            }
            if (rm.isBlockedListRequest()) {
                actions.add(SendSyncBlockedListAction.create());
            }
            if (rm.isKeysRequest()) {
                actions.add(SendSyncKeysAction.create());
            }
            if (rm.isConfigurationRequest()) {
                actions.add(SendSyncConfigurationAction.create());
            }
            actions.add(SyncStorageDataAction.create());
        }
        if (syncMessage.getGroups().isPresent()) {
            try {
                SignalServiceAttachment groupsMessage = (SignalServiceAttachment)syncMessage.getGroups().get();
                this.context.getAttachmentHelper().retrieveAttachment(groupsMessage, this.context.getSyncHelper()::handleSyncDeviceGroups);
            }
            catch (Exception e) {
                logger.warn("Failed to handle received sync groups, ignoring: {}", (Object)e.getMessage());
            }
        }
        if (syncMessage.getBlockedList().isPresent()) {
            BlockedListMessage blockedListMessage = (BlockedListMessage)syncMessage.getBlockedList().get();
            for (BlockedListMessage.Individual individual : blockedListMessage.individuals) {
                RecipientAddress address = new RecipientAddress(individual.getAci(), individual.getE164());
                RecipientId recipientId = this.account.getRecipientResolver().resolveRecipient(address);
                this.context.getContactHelper().setContactBlocked(recipientId, true);
            }
            for (GroupId groupId : blockedListMessage.groupIds.stream().map(GroupId::unknownVersion).collect(Collectors.toSet())) {
                try {
                    this.context.getGroupHelper().setGroupBlocked(groupId, true);
                }
                catch (GroupNotFoundException e) {
                    logger.warn("BlockedListMessage contained groupID that was not found in GroupStore: {}", (Object)groupId.toBase64());
                }
            }
        }
        if (syncMessage.getContacts().isPresent()) {
            try {
                ContactsMessage contactsMessage = (ContactsMessage)syncMessage.getContacts().get();
                this.context.getAttachmentHelper().retrieveAttachment(contactsMessage.getContactsStream(), this.context.getSyncHelper()::handleSyncDeviceContacts);
            }
            catch (Exception e) {
                logger.warn("Failed to handle received sync contacts, ignoring: {}", (Object)e.getMessage());
            }
        }
        if (syncMessage.getVerified().isPresent()) {
            VerifiedMessage verifiedMessage = (VerifiedMessage)syncMessage.getVerified().get();
            this.account.getIdentityKeyStore().setIdentityTrustLevel(verifiedMessage.getDestination().getServiceId(), verifiedMessage.getIdentityKey(), TrustLevel.fromVerifiedState(verifiedMessage.getVerified()));
        }
        if (syncMessage.getStickerPackOperations().isPresent()) {
            List stickerPackOperationMessages = (List)syncMessage.getStickerPackOperations().get();
            for (StickerPackOperationMessage m : stickerPackOperationMessages) {
                boolean installed;
                if (m.getPackId().isEmpty()) continue;
                StickerPackId stickerPackId = StickerPackId.deserialize((byte[])m.getPackId().get());
                byte[] stickerPackKey = m.getPackKey().orElse(null);
                boolean bl = installed = m.getType().isEmpty() || m.getType().get() == StickerPackOperationMessage.Type.INSTALL;
                StickerPack sticker = this.context.getStickerHelper().addOrUpdateStickerPack(stickerPackId, stickerPackKey, installed);
                if (sticker == null || !installed) continue;
                this.context.getJobExecutor().enqueueJob(new RetrieveStickerPackJob(stickerPackId, sticker.packKey()));
            }
        }
        if (syncMessage.getFetchType().isPresent()) {
            switch ((SignalServiceSyncMessage.FetchType)syncMessage.getFetchType().get()) {
                case LOCAL_PROFILE: {
                    actions.add(new RetrieveProfileAction(this.account.getSelfRecipientId()));
                    break;
                }
                case STORAGE_MANIFEST: {
                    actions.add(SyncStorageDataAction.create());
                }
            }
        }
        if (syncMessage.getKeys().isPresent()) {
            KeysMessage keysMessage = (KeysMessage)syncMessage.getKeys().get();
            if (keysMessage.getAccountEntropyPool() != null) {
                AccountEntropyPool aep = keysMessage.getAccountEntropyPool();
                this.account.setAccountEntropyPool(aep);
                actions.add(SyncStorageDataAction.create());
            } else if (keysMessage.getMaster() != null) {
                MasterKey masterKey = keysMessage.getMaster();
                this.account.setMasterKey(masterKey);
                actions.add(SyncStorageDataAction.create());
            } else if (keysMessage.getStorageService() != null) {
                StorageKey storageKey = keysMessage.getStorageService();
                this.account.setStorageKey(storageKey);
                actions.add(SyncStorageDataAction.create());
            }
            if (keysMessage.getMediaRootBackupKey() != null) {
                MediaRootBackupKey mrb = keysMessage.getMediaRootBackupKey();
                this.account.setMediaRootBackupKey(mrb);
                actions.add(SyncStorageDataAction.create());
            }
        }
        if (syncMessage.getConfiguration().isPresent()) {
            ConfigurationMessage configurationMessage = (ConfigurationMessage)syncMessage.getConfiguration().get();
            ConfigurationStore configurationStore = this.account.getConfigurationStore();
            if (configurationMessage.getReadReceipts().isPresent()) {
                configurationStore.setReadReceipts((Boolean)configurationMessage.getReadReceipts().get());
            }
            if (configurationMessage.getLinkPreviews().isPresent()) {
                configurationStore.setLinkPreviews((Boolean)configurationMessage.getLinkPreviews().get());
            }
            if (configurationMessage.getTypingIndicators().isPresent()) {
                configurationStore.setTypingIndicators((Boolean)configurationMessage.getTypingIndicators().get());
            }
            if (configurationMessage.getUnidentifiedDeliveryIndicators().isPresent()) {
                configurationStore.setUnidentifiedDeliveryIndicators((Boolean)configurationMessage.getUnidentifiedDeliveryIndicators().get());
            }
        }
        if (syncMessage.getPniChangeNumber().isPresent()) {
            SyncMessage.PniChangeNumber pniChangeNumber = (SyncMessage.PniChangeNumber)syncMessage.getPniChangeNumber().get();
            logger.debug("Received PNI change number sync message, applying.");
            String updatedPniString = envelope.getUpdatedPni();
            if (updatedPniString != null && !updatedPniString.isEmpty()) {
                ServiceId.PNI updatedPni = ServiceId.PNI.parseOrThrow((String)updatedPniString);
                this.context.getAccountHelper().handlePniChangeNumberMessage(pniChangeNumber, updatedPni);
            }
        }
        return actions;
    }

    private SignalServiceGroupContext getGroupContext(SignalServiceContent content) {
        SignalServiceDataMessage message;
        if (content == null) {
            return null;
        }
        if (content.getDataMessage().isPresent() && (message = (SignalServiceDataMessage)content.getDataMessage().get()).getGroupContext().isPresent()) {
            return (SignalServiceGroupContext)message.getGroupContext().get();
        }
        if (content.getStoryMessage().isPresent() && (message = (SignalServiceStoryMessage)content.getStoryMessage().get()).getGroupContext().isPresent()) {
            try {
                return SignalServiceGroupContext.create(null, (SignalServiceGroupV2)((SignalServiceGroupV2)message.getGroupContext().get()));
            }
            catch (InvalidMessageException e) {
                throw new AssertionError((Object)e);
            }
        }
        return null;
    }

    private boolean isMessageBlocked(SignalServiceEnvelope envelope, SignalServiceContent content) {
        SignalServiceAddress source = this.getSenderAddress(envelope, content);
        if (source == null) {
            return false;
        }
        RecipientId recipientId = this.account.getRecipientResolver().resolveRecipient(source);
        if (this.context.getContactHelper().isContactBlocked(recipientId)) {
            return true;
        }
        SignalServiceGroupContext groupContext = this.getGroupContext(content);
        if (groupContext != null) {
            GroupId groupId = GroupUtils.getGroupId(groupContext);
            return this.context.getGroupHelper().isGroupBlocked(groupId);
        }
        return false;
    }

    private boolean isNotAllowedToSendToGroup(SignalServiceEnvelope envelope, SignalServiceContent content) {
        SignalServiceGroup groupInfo;
        SignalServiceAddress source = this.getSenderAddress(envelope, content);
        if (source == null) {
            return false;
        }
        SignalServiceGroupContext groupContext = this.getGroupContext(content);
        if (groupContext == null) {
            return false;
        }
        if (groupContext.getGroupV1().isPresent() && (groupInfo = (SignalServiceGroup)groupContext.getGroupV1().get()).getType() == SignalServiceGroup.Type.QUIT) {
            return false;
        }
        GroupId groupId = GroupUtils.getGroupId(groupContext);
        GroupInfo group = this.context.getGroupHelper().getGroup(groupId);
        if (group == null) {
            return false;
        }
        SignalServiceDataMessage message = content.getDataMessage().orElse(null);
        RecipientId recipientId = this.account.getRecipientResolver().resolveRecipient(source);
        if (!(group.isMember(recipientId) || group.isPendingMember(recipientId) && message != null && message.isGroupV2Update())) {
            return true;
        }
        if (group.isAnnouncementGroup() && !group.isAdmin(recipientId)) {
            return message == null || message.getBody().isPresent() || message.getAttachments().isPresent() || message.getQuote().isPresent() || message.getPreviews().isPresent() || message.getMentions().isPresent() || message.getSticker().isPresent();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<HandleAction> handleSignalServiceDataMessage(SignalServiceDataMessage message, boolean isSync, DeviceAddress source, DeviceAddress destination, boolean ignoreAttachments) {
        ArrayList<HandleAction> actions;
        block33: {
            DeviceAddress conversationPartnerAddress;
            block34: {
                actions = new ArrayList<HandleAction>();
                if (message.getGroupContext().isPresent()) {
                    SignalServiceGroupContext groupContext = (SignalServiceGroupContext)message.getGroupContext().get();
                    if (groupContext.getGroupV1().isPresent()) {
                        SignalServiceGroup groupInfo = (SignalServiceGroup)groupContext.getGroupV1().get();
                        GroupIdV1 groupId = GroupId.v1(groupInfo.getGroupId());
                        GroupInfo group = this.context.getGroupHelper().getGroup(groupId);
                        if (group == null || group instanceof GroupInfoV1) {
                            GroupInfoV1 groupV1 = (GroupInfoV1)group;
                            switch (groupInfo.getType()) {
                                case UPDATE: {
                                    if (groupV1 == null) {
                                        groupV1 = new GroupInfoV1(groupId);
                                    }
                                    if (groupInfo.getAvatar().isPresent()) {
                                        SignalServiceAttachment avatar = (SignalServiceAttachment)groupInfo.getAvatar().get();
                                        this.context.getGroupHelper().downloadGroupAvatar(groupV1.getGroupId(), avatar);
                                    }
                                    if (groupInfo.getName().isPresent()) {
                                        groupV1.name = (String)groupInfo.getName().get();
                                    }
                                    if (groupInfo.getMembers().isPresent()) {
                                        RecipientResolver recipientResolver = this.account.getRecipientResolver();
                                        groupV1.addMembers(((List)groupInfo.getMembers().get()).stream().map(recipientResolver::resolveRecipient).collect(Collectors.toSet()));
                                    }
                                    this.account.getGroupStore().updateGroup(groupV1);
                                    break;
                                }
                                case DELIVER: {
                                    if (groupV1 != null || isSync) break;
                                    actions.add(new SendGroupInfoRequestAction(source.recipientId(), groupId));
                                    break;
                                }
                                case QUIT: {
                                    if (groupV1 == null) break;
                                    groupV1.removeMember(source.recipientId());
                                    this.account.getGroupStore().updateGroup(groupV1);
                                    break;
                                }
                                case REQUEST_INFO: {
                                    if (groupV1 == null || isSync) break;
                                    actions.add(new SendGroupInfoAction(source.recipientId(), groupV1.getGroupId()));
                                    break;
                                }
                            }
                        }
                    }
                    if (groupContext.getGroupV2().isPresent()) {
                        this.handleGroupV2Context((SignalServiceGroupV2)groupContext.getGroupV2().get());
                    }
                }
                DeviceAddress selfAddress = isSync ? source : destination;
                DeviceAddress deviceAddress = conversationPartnerAddress = isSync ? destination : source;
                if (conversationPartnerAddress != null && message.isEndSession()) {
                    this.account.getAccountData(selfAddress.serviceId()).getSessionStore().deleteAllSessions(conversationPartnerAddress.serviceId());
                }
                if (!message.isExpirationUpdate() && !message.getBody().isPresent()) break block33;
                if (!message.getGroupContext().isPresent()) break block34;
                SignalServiceGroupContext groupContext = (SignalServiceGroupContext)message.getGroupContext().get();
                if (groupContext.getGroupV1().isPresent()) {
                    SignalServiceGroup groupInfo = (SignalServiceGroup)groupContext.getGroupV1().get();
                    GroupInfoV1 group = this.account.getGroupStore().getOrCreateGroupV1(GroupId.v1(groupInfo.getGroupId()));
                    if (group != null && group.messageExpirationTime != message.getExpiresInSeconds()) {
                        group.messageExpirationTime = message.getExpiresInSeconds();
                        this.account.getGroupStore().updateGroup(group);
                    }
                    break block33;
                } else if (!groupContext.getGroupV2().isPresent()) {
                    // empty if block
                }
                break block33;
            }
            if (conversationPartnerAddress != null) {
                this.context.getContactHelper().setExpirationTimer(conversationPartnerAddress.recipientId(), message.getExpiresInSeconds(), message.getExpireTimerVersion());
            }
        }
        if (!ignoreAttachments) {
            SignalServiceDataMessage.Quote quote;
            if (message.getAttachments().isPresent()) {
                for (SignalServiceAttachment attachment : (List)message.getAttachments().get()) {
                    this.context.getAttachmentHelper().downloadAttachment(attachment);
                }
            }
            if (message.getSharedContacts().isPresent()) {
                for (Object contact : (List)message.getSharedContacts().get()) {
                    if (!contact.getAvatar().isPresent()) continue;
                    this.context.getAttachmentHelper().downloadAttachment(((SharedContact.Avatar)contact.getAvatar().get()).getAttachment());
                }
            }
            if (message.getPreviews().isPresent()) {
                List previews = (List)message.getPreviews().get();
                for (SignalServicePreview preview : previews) {
                    if (!preview.getImage().isPresent()) continue;
                    this.context.getAttachmentHelper().downloadAttachment((SignalServiceAttachment)preview.getImage().get());
                }
            }
            if (message.getQuote().isPresent() && (quote = (SignalServiceDataMessage.Quote)message.getQuote().get()).getAttachments() != null) {
                for (SignalServiceDataMessage.Quote.QuotedAttachment quotedAttachment : quote.getAttachments()) {
                    SignalServiceAttachment thumbnail = quotedAttachment.getThumbnail();
                    if (thumbnail == null) continue;
                    this.context.getAttachmentHelper().downloadAttachment(thumbnail);
                }
            }
        }
        if (message.getGiftBadge().isPresent()) {
            this.handleIncomingGiftBadge((SignalServiceDataMessage.GiftBadge)message.getGiftBadge().get());
        }
        if (message.getProfileKey().isPresent()) {
            this.handleIncomingProfileKey((byte[])message.getProfileKey().get(), source.recipientId());
        }
        if (message.getSticker().isPresent()) {
            SignalServiceDataMessage.Sticker messageSticker = (SignalServiceDataMessage.Sticker)message.getSticker().get();
            StickerPackId stickerPackId = StickerPackId.deserialize(messageSticker.getPackId());
            StickerPack sticker = this.account.getStickerStore().getStickerPack(stickerPackId);
            if (sticker == null) {
                sticker = new StickerPack(stickerPackId, messageSticker.getPackKey());
                this.account.getStickerStore().addStickerPack(sticker);
            }
            this.context.getJobExecutor().enqueueJob(new RetrieveStickerPackJob(stickerPackId, messageSticker.getPackKey()));
        }
        return actions;
    }

    private void handleIncomingGiftBadge(SignalServiceDataMessage.GiftBadge giftBadge) {
    }

    private List<HandleAction> handleSignalServiceStoryMessage(SignalServiceStoryMessage message, RecipientId source, boolean ignoreAttachments) {
        ArrayList<HandleAction> actions = new ArrayList<HandleAction>();
        if (message.getGroupContext().isPresent()) {
            this.handleGroupV2Context((SignalServiceGroupV2)message.getGroupContext().get());
        }
        if (!ignoreAttachments) {
            SignalServicePreview preview;
            SignalServiceTextAttachment textAttachment;
            if (message.getFileAttachment().isPresent()) {
                this.context.getAttachmentHelper().downloadAttachment((SignalServiceAttachment)message.getFileAttachment().get());
            }
            if (message.getTextAttachment().isPresent() && (textAttachment = (SignalServiceTextAttachment)message.getTextAttachment().get()).getPreview().isPresent() && (preview = (SignalServicePreview)textAttachment.getPreview().get()).getImage().isPresent()) {
                this.context.getAttachmentHelper().downloadAttachment((SignalServiceAttachment)preview.getImage().get());
            }
        }
        if (message.getProfileKey().isPresent()) {
            this.handleIncomingProfileKey((byte[])message.getProfileKey().get(), source);
        }
        return actions;
    }

    private void handleGroupV2Context(SignalServiceGroupV2 groupContext) {
        GroupMasterKey groupMasterKey = groupContext.getMasterKey();
        this.context.getGroupHelper().getOrMigrateGroup(groupMasterKey, groupContext.getRevision(), groupContext.hasSignedGroupChange() ? groupContext.getSignedGroupChange() : null);
    }

    private void handleIncomingProfileKey(byte[] profileKeyBytes, RecipientId source) {
        ProfileKey profileKey;
        if (profileKeyBytes.length != 32) {
            logger.debug("Received invalid profile key of length {}", (Object)profileKeyBytes.length);
            return;
        }
        try {
            profileKey = new ProfileKey(profileKeyBytes);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
        if (this.account.getSelfRecipientId().equals(source)) {
            this.account.setProfileKey(profileKey);
        }
        this.account.getProfileStore().storeProfileKey(source, profileKey);
    }

    private SignalServiceAddress getSenderAddress(SignalServiceEnvelope envelope, SignalServiceContent content) {
        ServiceId serviceId = envelope.getSourceServiceId().map(ServiceId::parseOrNull).orElse(null);
        if (!envelope.isUnidentifiedSender() && serviceId != null) {
            return new SignalServiceAddress(serviceId);
        }
        if (content != null) {
            return content.getSender();
        }
        return null;
    }

    private DeviceAddress getSender(SignalServiceEnvelope envelope, SignalServiceContent content) {
        ServiceId serviceId = envelope.getSourceServiceId().map(ServiceId::parseOrNull).orElse(null);
        if (!envelope.isUnidentifiedSender() && serviceId != null) {
            return new DeviceAddress(this.account.getRecipientResolver().resolveRecipient(serviceId), serviceId, envelope.getSourceDevice());
        }
        return new DeviceAddress(this.account.getRecipientResolver().resolveRecipient(content.getSender()), content.getSender().getServiceId(), content.getSenderDevice());
    }

    private DeviceAddress getDestination(SignalServiceEnvelope envelope) {
        ServiceId destination = envelope.getDestinationServiceId();
        if (destination == null || destination.isUnknown()) {
            return new DeviceAddress(this.account.getSelfRecipientId(), (ServiceId)this.account.getAci(), this.account.getDeviceId());
        }
        return new DeviceAddress(this.account.getRecipientResolver().resolveRecipient(destination), destination, this.account.getDeviceId());
    }

    private record DeviceAddress(RecipientId recipientId, ServiceId serviceId, int deviceId) {
    }
}

