/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.link;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.Base64;
import org.signal.core.util.StringExtensionsKt;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.whispersystems.signalservice.api.AccountEntropyPool;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.backup.MediaRootBackupKey;
import org.whispersystems.signalservice.api.backup.MessageBackupKey;
import org.whispersystems.signalservice.api.kbs.MasterKey;
import org.whispersystems.signalservice.api.link.LinkedDeviceVerificationCodeResponse;
import org.whispersystems.signalservice.api.link.SetDeviceNameRequest;
import org.whispersystems.signalservice.api.link.SetLinkedDeviceTransferArchiveRequest;
import org.whispersystems.signalservice.api.link.TransferArchiveError;
import org.whispersystems.signalservice.api.link.TransferArchiveResponse;
import org.whispersystems.signalservice.api.link.WaitForLinkedDeviceResponse;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceInfo;
import org.whispersystems.signalservice.api.provisioning.ProvisioningMessage;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.crypto.PrimaryProvisioningCipher;
import org.whispersystems.signalservice.internal.push.DeviceInfoList;
import org.whispersystems.signalservice.internal.push.ProvisionMessage;
import org.whispersystems.signalservice.internal.push.ProvisioningVersion;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007Jv\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00122\b\u0010&\u001a\u0004\u0018\u00010'J%\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00072\u0006\u0010*\u001a\u00020\u00122\b\b\u0002\u0010+\u001a\u00020,\u00a2\u0006\u0004\b-\u0010.J,\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0006\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020\u0012J$\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0006\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020\r2\u0006\u00105\u001a\u000206J\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0006\u00108\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rJ\u001d\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u00072\b\b\u0002\u0010+\u001a\u00020,\u00a2\u0006\u0004\b;\u0010<R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/whispersystems/signalservice/api/link/LinkDeviceApi;", "", "authWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;)V", "getDevices", "Lorg/whispersystems/signalservice/api/NetworkResult;", "", "Lorg/whispersystems/signalservice/api/messages/multidevice/DeviceInfo;", "removeDevice", "", "deviceId", "", "getDeviceVerificationCode", "Lorg/whispersystems/signalservice/api/link/LinkedDeviceVerificationCodeResponse;", "linkDevice", "e164", "", "aci", "Lorg/whispersystems/signalservice/api/push/ServiceId$ACI;", "pni", "Lorg/whispersystems/signalservice/api/push/ServiceId$PNI;", "deviceIdentifier", "deviceKey", "Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "aciIdentityKeyPair", "Lorg/signal/libsignal/protocol/IdentityKeyPair;", "pniIdentityKeyPair", "profileKey", "Lorg/signal/libsignal/zkgroup/profiles/ProfileKey;", "accountEntropyPool", "Lorg/whispersystems/signalservice/api/AccountEntropyPool;", "masterKey", "Lorg/whispersystems/signalservice/api/kbs/MasterKey;", "mediaRootBackupKey", "Lorg/whispersystems/signalservice/api/backup/MediaRootBackupKey;", "code", "ephemeralMessageBackupKey", "Lorg/whispersystems/signalservice/api/backup/MessageBackupKey;", "waitForLinkedDevice", "Lorg/whispersystems/signalservice/api/link/WaitForLinkedDeviceResponse;", "token", "timeout", "Lkotlin/time/Duration;", "waitForLinkedDevice-HG0u8IE", "(Ljava/lang/String;J)Lorg/whispersystems/signalservice/api/NetworkResult;", "setTransferArchive", "destinationDeviceId", "destinationDeviceRegistrationId", "cdn", "cdnKey", "setTransferArchiveError", "error", "Lorg/whispersystems/signalservice/api/link/TransferArchiveError;", "setDeviceName", "encryptedDeviceName", "waitForPrimaryDevice", "Lorg/whispersystems/signalservice/api/link/TransferArchiveResponse;", "waitForPrimaryDevice-LRDsOJo", "(J)Lorg/whispersystems/signalservice/api/NetworkResult;", "signal-service-java"})
public final class LinkDeviceApi {
    @NotNull
    private final SignalWebSocket.AuthenticatedWebSocket authWebSocket;

    public LinkDeviceApi(@NotNull SignalWebSocket.AuthenticatedWebSocket authWebSocket) {
        Intrinsics.checkNotNullParameter((Object)authWebSocket, (String)"authWebSocket");
        this.authWebSocket = authWebSocket;
    }

    @NotNull
    public final NetworkResult<List<DeviceInfo>> getDevices() {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/devices", null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.authWebSocket, request2, Reflection.getOrCreateKotlinClass(DeviceInfoList.class), 0L, 8, null).map(LinkDeviceApi::getDevices$lambda$0);
    }

    @NotNull
    public final NetworkResult<Unit> removeDevice(int deviceId) {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.delete$default(WebSocketRequestMessage.Companion, "/v1/devices/" + deviceId, null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<LinkedDeviceVerificationCodeResponse> getDeviceVerificationCode() {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/devices/provisioning/code", null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.authWebSocket, request2, Reflection.getOrCreateKotlinClass(LinkedDeviceVerificationCodeResponse.class), 0L, 8, null);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final NetworkResult<Unit> linkDevice(@NotNull String e164, @NotNull ServiceId.ACI aci, @NotNull ServiceId.PNI pni, @NotNull String deviceIdentifier, @NotNull ECPublicKey deviceKey, @NotNull IdentityKeyPair aciIdentityKeyPair, @NotNull IdentityKeyPair pniIdentityKeyPair, @NotNull ProfileKey profileKey, @NotNull AccountEntropyPool accountEntropyPool, @NotNull MasterKey masterKey, @NotNull MediaRootBackupKey mediaRootBackupKey, @NotNull String code, @Nullable MessageBackupKey ephemeralMessageBackupKey) {
        Intrinsics.checkNotNullParameter((Object)e164, (String)"e164");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)pni, (String)"pni");
        Intrinsics.checkNotNullParameter((Object)deviceIdentifier, (String)"deviceIdentifier");
        Intrinsics.checkNotNullParameter((Object)deviceKey, (String)"deviceKey");
        Intrinsics.checkNotNullParameter((Object)aciIdentityKeyPair, (String)"aciIdentityKeyPair");
        Intrinsics.checkNotNullParameter((Object)pniIdentityKeyPair, (String)"pniIdentityKeyPair");
        Intrinsics.checkNotNullParameter((Object)profileKey, (String)"profileKey");
        Intrinsics.checkNotNullParameter((Object)accountEntropyPool, (String)"accountEntropyPool");
        Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
        Intrinsics.checkNotNullParameter((Object)mediaRootBackupKey, (String)"mediaRootBackupKey");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        cipher = new PrimaryProvisioningCipher(deviceKey);
        v0 = aciIdentityKeyPair.getPublicKey().serialize();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"serialize(...)");
        v1 = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])v0, (int)0, (int)0, (int)3, null);
        v2 = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])aciIdentityKeyPair.getPrivateKey().serialize(), (int)0, (int)0, (int)3, null);
        v3 = pniIdentityKeyPair.getPublicKey().serialize();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"serialize(...)");
        v4 = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])v3, (int)0, (int)0, (int)3, null);
        v5 = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])pniIdentityKeyPair.getPrivateKey().serialize(), (int)0, (int)0, (int)3, null);
        v6 = aci.toString();
        v7 = pni.toStringWithoutPrefix();
        v8 = profileKey.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"serialize(...)");
        v9 = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])v8, (int)0, (int)0, (int)3, null);
        v10 = ProvisioningVersion.CURRENT.getValue();
        v11 = masterKey.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"serialize(...)");
        v12 = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])v11, (int)0, (int)0, (int)3, null);
        v13 = ephemeralMessageBackupKey;
        if (v13 == null) ** GOTO lbl-1000
        v14 = v13.getValue();
        v13 = v14;
        if (v14 != null) {
            v15 = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])v13, (int)0, (int)0, (int)3, null);
        } else lbl-1000:
        // 2 sources

        {
            v15 = null;
        }
        message = new ProvisionMessage(v1, v2, v4, v5, v6, v7, e164, code, null, v9, null, v10, v12, v15, accountEntropyPool.getValue(), ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])mediaRootBackupKey.getValue(), (int)0, (int)0, (int)3, null), aci.toByteString(), pni.toByteStringWithoutPrefix(), null, 263168, null);
        v16 = cipher.encrypt(message);
        Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"encrypt(...)");
        ciphertext = v16;
        body = new ProvisioningMessage(Base64.encodeWithPadding$default((byte[])ciphertext, (int)0, (int)0, (int)6, null));
        request = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v1/provisioning/" + StringExtensionsKt.urlEncode((String)deviceIdentifier), body, null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<WaitForLinkedDeviceResponse> waitForLinkedDevice-HG0u8IE(@NotNull String token, long timeout) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/devices/wait_for_linked_device/" + StringExtensionsKt.urlEncode((String)token) + "?timeout=" + Duration.getInWholeSeconds-impl((long)timeout), null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-exY8QGI(this.authWebSocket, request2, timeout, new NetworkResult.LongPollingWebSocketConverter(Reflection.getOrCreateKotlinClass(WaitForLinkedDeviceResponse.class)));
    }

    public static /* synthetic */ NetworkResult waitForLinkedDevice-HG0u8IE$default(LinkDeviceApi linkDeviceApi, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
        }
        return linkDeviceApi.waitForLinkedDevice-HG0u8IE(string, l);
    }

    @NotNull
    public final NetworkResult<Unit> setTransferArchive(int destinationDeviceId, int destinationDeviceRegistrationId, int cdn, @NotNull String cdnKey) {
        Intrinsics.checkNotNullParameter((Object)cdnKey, (String)"cdnKey");
        SetLinkedDeviceTransferArchiveRequest body = new SetLinkedDeviceTransferArchiveRequest(destinationDeviceId, destinationDeviceRegistrationId, new SetLinkedDeviceTransferArchiveRequest.TransferArchive.CdnInfo(cdn, cdnKey));
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v1/devices/transfer_archive", body, null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<Unit> setTransferArchiveError(int destinationDeviceId, int destinationDeviceRegistrationId, @NotNull TransferArchiveError error) {
        Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
        SetLinkedDeviceTransferArchiveRequest body = new SetLinkedDeviceTransferArchiveRequest(destinationDeviceId, destinationDeviceRegistrationId, new SetLinkedDeviceTransferArchiveRequest.TransferArchive.Error(error));
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v1/devices/transfer_archive", body, null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<Unit> setDeviceName(@NotNull String encryptedDeviceName, int deviceId) {
        Intrinsics.checkNotNullParameter((Object)encryptedDeviceName, (String)"encryptedDeviceName");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v1/accounts/name?deviceId=" + deviceId, new SetDeviceNameRequest(encryptedDeviceName), null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<TransferArchiveResponse> waitForPrimaryDevice-LRDsOJo(long timeout) {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/devices/transfer_archive?timeout=" + Duration.getInWholeSeconds-impl((long)timeout), null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-exY8QGI(this.authWebSocket, request2, timeout, new NetworkResult.LongPollingWebSocketConverter(Reflection.getOrCreateKotlinClass(TransferArchiveResponse.class)));
    }

    public static /* synthetic */ NetworkResult waitForPrimaryDevice-LRDsOJo$default(LinkDeviceApi linkDeviceApi, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
        }
        return linkDeviceApi.waitForPrimaryDevice-LRDsOJo(l);
    }

    private static final List getDevices$lambda$0(DeviceInfoList it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List<DeviceInfo> list = it.getDevices();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDevices(...)");
        return list;
    }
}

