/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public final class SetUtil {
    private SetUtil() {
    }

    public static <E> Set<E> intersection(Collection<E> a, Collection<E> b) {
        LinkedHashSet<E> intersection = new LinkedHashSet<E>(a);
        intersection.retainAll(b);
        return intersection;
    }

    public static <E> Set<E> difference(Collection<E> a, Collection<E> b) {
        LinkedHashSet<E> difference = new LinkedHashSet<E>(a);
        difference.removeAll(b);
        return difference;
    }

    public static <E> Set<E> union(Set<E> a, Set<E> b) {
        LinkedHashSet<E> result = new LinkedHashSet<E>(a);
        result.addAll(b);
        return result;
    }

    @SafeVarargs
    public static <E> HashSet<E> newHashSet(E ... elements) {
        return new HashSet<E>(Arrays.asList(elements));
    }
}

