/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.asamk.signal.json.JsonContactAddress;
import org.asamk.signal.json.JsonContactAvatar;
import org.asamk.signal.json.JsonContactEmail;
import org.asamk.signal.json.JsonContactName;
import org.asamk.signal.json.JsonContactPhone;
import org.asamk.signal.manager.api.MessageEnvelope;

public record JsonSharedContact(JsonContactName name, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonContactAvatar avatar, @JsonInclude(value=JsonInclude.Include.NON_NULL) List<JsonContactPhone> phone, @JsonInclude(value=JsonInclude.Include.NON_NULL) List<JsonContactEmail> email, @JsonInclude(value=JsonInclude.Include.NON_NULL) List<JsonContactAddress> address, String organization) {
    static JsonSharedContact from(MessageEnvelope.Data.SharedContact contact) {
        JsonContactName name = JsonContactName.from(contact.name());
        JsonContactAvatar avatar = contact.avatar().isPresent() ? JsonContactAvatar.from((MessageEnvelope.Data.SharedContact.Avatar)contact.avatar().get()) : null;
        List<JsonContactPhone> phone = !contact.phone().isEmpty() ? contact.phone().stream().map(JsonContactPhone::from).toList() : null;
        List<JsonContactEmail> email = !contact.email().isEmpty() ? contact.email().stream().map(JsonContactEmail::from).toList() : null;
        List<JsonContactAddress> address = !contact.address().isEmpty() ? contact.address().stream().map(JsonContactAddress::from).toList() : null;
        String organization = contact.organization().orElse(null);
        return new JsonSharedContact(name, avatar, phone, email, address, organization);
    }
}

