#ifndef WAVSPLIT_H
#define WAVSPLIT_H

#include <stdio.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

#include <stdlib.h>
#include <errno.h>
#include <getopt.h>
#include <math.h>
#include <string.h>
#include <assert.h>

#define VERSION "1.2.1"
#define MAX_PATH 255
#define BUFFERSIZE 65536
#define PCM_WAVE_FORMAT  1
#define DEFAULT_VERBOSE 1
#define DEFAULT_TEST 0
#define DEFAULT_HOURS 0
#define DEFAULT_FRAMES 0
#define DEFAULT_FPS 25
#define DEFAULT_SECONDS 0
#define DEFAULT_TRACK 0
#define OPF_QUIET 'q'
#define OPF_HELP 'h'
#define OPF_HOURS 'H'
#define OPF_FRAMES 'f'
#define OPF_SECONDS 's'
#define OPF_TRACK 't'
#define OPF_QUIET_LONG "quiet"
#define OPF_HELP_LONG "help"
#define OPF_HOURS_LONG "Hours"
#define OPF_FRAMES_LONG "frames"
#define OPF_SECONDS_LONG "seconds"
#define OPF_TRACK_LONG "tracktimes"

typedef enum {
  USE_HOURS,
  USE_FRAMES,
  USE_SECONDS
} TIMEFORMAT;

typedef struct {
  u_long dwSize;
  u_short wFormatTag;
  u_short wChannels;
  u_long dwSamplesPerSec;
  u_long dwAvgBytesPerSec;
  u_short wBlockAlign;
  u_short wBitsPerSample;
} WAVEFORMAT;

typedef struct {
  char RiffID[4];
  u_long RiffSize;
  char WaveID[4];
  char FmtID[4];
  u_long FmtSize;
  u_short wFormatTag;
  u_short nChannels;
  u_long nSamplesPerSec;
  u_long nAvgBytesPerSec;
  u_short nBlockAlign;
  u_short wBitsPerSample;
  char DataID[4];
  u_long nDataBytes;
} WAVE_HEADER;

typedef struct {
  int hr;
  int min;
  double sek;                   /* APF allow decimal point in seconds */
  int seki;                     /* integer seconds for use with frames */
  double frames;                /* specify in frames - default 25fps */
} timepos;


static WAVE_HEADER waveheader = {
  {'R', 'I', 'F', 'F'},
  0,
  {'W', 'A', 'V', 'E'},
  {'f', 'm', 't', ' '},
  16,
/* FmtSize*/
  PCM_WAVE_FORMAT,
/* wFormatTag*/
  0,
/* nChannels*/
  0,
  0,
  0,
  0,
  {'d', 'a', 't', 'a'},
  0
};                              /* waveheader */

#ifdef __powerpc__

static __inline__ long _LE_long (unsigned char *lp)
{
  return (lp[3] << 24 | lp[2] << 16 | lp[1] << 8 | lp[0]);
}

static __inline__ short _LE_short (unsigned char *lp)
{
  return (lp[1] << 8 | lp[0]);
}

#endif

static char *findchunk ();
static int readheader ();
static void Report (const char *Message, const char *Severity, int Verbose);
static int TokenOK (const char *Message, char **strPtr);
static unsigned int checkfps (unsigned int fps);
static int split (unsigned int UseHours, unsigned int UseFrames,
                  unsigned int fps, unsigned int UseTrackLens,
                  int splits, timepos * splitpos);
static long calcsplit (unsigned int UseHours, unsigned int UseFrames,
                       unsigned int fps, unsigned int UseTrackLens,
                       int splitnr, timepos * split);
static int createout ();
int closeout ();
void display (unsigned char avgleft, unsigned char avgright,
              unsigned char avgloud);
static void usage ();
static long stdread (char *buf, long nchars);
#ifdef __powerpc__
static _ConvertHeaderFromNative (WAVE_HEADER * hdr);
static _ConvertHeaderToNative (WAVE_HEADER * hdr);
#endif

static char *ptr;
static WAVEFORMAT waveformat;
static u_long databytes, b;
static int ifd, ofd;
static int verbose;
static char basename[MAX_PATH + 1], ifile[MAX_PATH + 1];

#endif
