# Contributing to JobSchedulerNg

We welcome contribution from everyone. Here are the guidelines if you are
thinking of helping us:

## Contributions

Contributions to JobScheduler should be made in the form of GitHub pull
requests. Each pull request will be reviewed and either landed in the main
tree or given feedback for changes that would be required. All contributions
should follow this format.

Should you wish to work on an issue, please claim it first by commenting on
the GitHub issue that you want to work on it. This is to prevent duplicated
efforts from contributors on the same issue.

Unless you explicitly state otherwise, any contribution intentionally
submitted for inclusion in JobScheduler by you, as defined in the Apache-2.0
license, shall be dual licensed as MIT/Apache-2.0, without any additional
terms or conditions.

## Pull Request Checklist

- Branch from the master branch and, if needed, rebase to the current master
  branch before submitting your pull request. If it doesn't merge cleanly with
  master you may be asked to rebase your changes.

- Commits should be as small as possible, while ensuring that each commit is
  correct independently (i.e., each commit should compile and pass tests).

- If your patch is not getting reviewed or you need a specific person to review
  it, you can @-reply a reviewer asking for a review in the pull request or a
  comment.

- Add tests relevant to the fixed bug or new feature.

## Conduct

We follow the [Rust Code of Conduct](https://www.rust-lang.org/conduct.html).
For escalation or moderation issues, please contact BlackDex via an issue instead of the Rust moderation team.

## Communication

Beyond opening tickets on the
[job_scheduler_ng](https://github.com/BlackDex/job_scheduler) project, I can be
found as `BlackDex` on Matrix and IRC and I frequent the `#rust` channel.
