# This code is licensed under the Apache License, Version 2.0. You may
# obtain a copy of this license in the LICENSE.txt file in the root directory
# of this source tree or at http://www.apache.org/licenses/LICENSE-2.0.
#
# Any modifications or derivative works of this code must retain this
# copyright notice, and modified files need to carry a notice indicating
# that they have been altered from the originals.

# This file contains only type annotations for PyO3 functions and classes
# For implementation details, see visit.py

from typing import Any, Generic

import sys

if sys.version_info >= (3, 13):
    from typing import TypeVar
else:
    from typing_extensions import TypeVar

class StopSearch(Exception): ...
class PruneSearch(Exception): ...

_T = TypeVar("_T", default=Any)

class BFSVisitor(Generic[_T]):
    def discover_vertex(self, v: int) -> Any: ...
    def finish_vertex(self, v: int) -> Any: ...
    def tree_edge(self, e: tuple[int, int, _T]) -> Any: ...
    def non_tree_edge(self, e: tuple[int, int, _T]) -> Any: ...
    def gray_target_edge(self, e: tuple[int, int, _T]) -> Any: ...
    def black_target_edge(self, e: tuple[int, int, _T]) -> Any: ...

class DFSVisitor(Generic[_T]):
    def discover_vertex(self, v: int, t: int) -> Any: ...
    def finish_vertex(self, v: int, t: int) -> Any: ...
    def tree_edge(self, e: tuple[int, int, _T]) -> Any: ...
    def back_edge(self, e: tuple[int, int, _T]) -> Any: ...
    def forward_or_cross_edge(self, e: tuple[int, int, _T]) -> Any: ...

class DijkstraVisitor(Generic[_T]):
    def discover_vertex(self, v: int, score: float) -> Any: ...
    def finish_vertex(self, v: int) -> Any: ...
    def examine_edge(self, edge: tuple[int, int, _T]) -> Any: ...
    def edge_relaxed(self, edge: tuple[int, int, _T]) -> Any: ...
    def edge_not_relaxed(self, edge: tuple[int, int, _T]) -> Any: ...
