/*
 * Decompiled with CFR 0.152.
 */
package org.rogach.scallop.tokenize;

import java.io.Serializable;
import org.rogach.scallop.tokenize.EOF;
import org.rogach.scallop.tokenize.EOF$;
import org.rogach.scallop.tokenize.Failed$;
import org.rogach.scallop.tokenize.Matched;
import org.rogach.scallop.tokenize.Matched$;
import org.rogach.scallop.tokenize.StringView;
import org.rogach.scallop.tokenize.TokenizationResult;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ArgumentTokenizer$
implements Serializable {
    private static final Function1 argumentsParser;
    public static final ArgumentTokenizer$ MODULE$;

    private ArgumentTokenizer$() {
    }

    static {
        MODULE$ = new ArgumentTokenizer$();
        Function1<StringView, TokenizationResult> & Serializable inputEnd = (Function1<StringView, TokenizationResult> & Serializable)input -> input.length() == 0 ? Matched$.MODULE$.apply(package$.MODULE$.Nil(), (StringView)input) : Failed$.MODULE$;
        Function1<StringView, TokenizationResult> & Serializable whitespace = (Function1<StringView, TokenizationResult> & Serializable)input -> {
            int i;
            int l = input.length();
            for (i = 0; i < l && Character.isWhitespace(input.charAt(i)); ++i) {
            }
            return i == 0 ? Failed$.MODULE$ : Matched$.MODULE$.apply(package$.MODULE$.Nil(), input.substring(i));
        };
        Function1<StringView, TokenizationResult> & Serializable singleQuotedString = (Function1<StringView, TokenizationResult> & Serializable)input -> {
            int stringEnd;
            return input.length() == 0 || input.charAt(0) != '\'' ? Failed$.MODULE$ : (TokenizationResult)((stringEnd = input.indexOf(39, 1)) == -1 ? EOF$.MODULE$.apply("'") : Matched$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{input.extract(1, stringEnd)})), input.substring(stringEnd + 1)));
        };
        Function1<StringView, TokenizationResult> & Serializable doubleQuotedString = (Function1<StringView, TokenizationResult> & Serializable)input -> {
            TokenizationResult tokenizationResult;
            if (input.length() == 0 || input.charAt(0) != '\"') {
                tokenizationResult = Failed$.MODULE$;
            } else {
                int i = 1;
                int s = 1;
                int l = input.length();
                StringBuilder b = new StringBuilder();
                boolean bl = false;
                boolean eofEscaped = false;
                boolean stringClosed = false;
                while (!bl && i < l) {
                    while (i < l && input.charAt(i) != '\\' && input.charAt(i) != '\"') {
                        ++i;
                    }
                    b.append(input.extract(s, i));
                    s = i;
                    if (i >= l) continue;
                    if (input.charAt(i) == '\\') {
                        if (i + 1 < l) {
                            StringBuilder stringBuilder = input.charAt(i + 1) == '\\' || input.charAt(i + 1) == '\"' ? b.append(input.charAt(i + 1)) : b.append(input.extract(i, i + 2));
                            s = i += 2;
                            continue;
                        }
                        eofEscaped = true;
                        bl = true;
                        continue;
                    }
                    if (input.charAt(i) == '\"') {
                        stringClosed = true;
                        bl = true;
                        continue;
                    }
                    b.append(input.charAt(i));
                    s = ++i;
                }
                tokenizationResult = eofEscaped ? EOF$.MODULE$.apply("escaped char") : (TokenizationResult)(!stringClosed ? EOF$.MODULE$.apply("\"") : Matched$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{b.toString()})), input.substring(i + 1)));
            }
            return tokenizationResult;
        };
        Function1<StringView, TokenizationResult> & Serializable plainArgument = (Function1<StringView, TokenizationResult> & Serializable)input -> {
            int i = 0;
            int s = 0;
            int l = input.length();
            StringBuilder b = new StringBuilder();
            boolean bl = false;
            boolean eofEscaped = false;
            while (!bl && i < l) {
                while (i < l && !Character.isWhitespace(input.charAt(i)) && input.charAt(i) != '\\' && input.charAt(i) != '\"' && input.charAt(i) != '\'') {
                    ++i;
                }
                b.append(input.extract(s, i));
                s = i;
                if (i >= l) continue;
                if (Character.isWhitespace(input.charAt(i))) {
                    bl = true;
                    continue;
                }
                if (input.charAt(i) == '\\') {
                    if (i + 1 < l) {
                        b.append(input.charAt(i + 1));
                        s = i += 2;
                        continue;
                    }
                    eofEscaped = true;
                    bl = true;
                    continue;
                }
                bl = true;
            }
            return eofEscaped ? EOF$.MODULE$.apply("escaped char") : (TokenizationResult)(b.length() == 0 ? Failed$.MODULE$ : Matched$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{b.toString()})), input.substring(i)));
        };
        Function1<StringView, TokenizationResult> token = MODULE$.mapResult(MODULE$.repeat(MODULE$.alternatives((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Function1[]{singleQuotedString, doubleQuotedString, plainArgument})))), (Function1<Seq<String>, Seq<String>>)(Function1<Seq, Seq> & Serializable)tokens -> (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{tokens.mkString("")})));
        argumentsParser = MODULE$.alternatives((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Function1[]{MODULE$.seq(MODULE$.seq(MODULE$.repeat(MODULE$.seq(MODULE$.optional(whitespace), token)), MODULE$.optional(whitespace)), inputEnd), MODULE$.seq(MODULE$.optional(whitespace), inputEnd)})));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ArgumentTokenizer$.class);
    }

    public TokenizationResult tokenize(String input) {
        return (TokenizationResult)argumentsParser.apply(new StringView(input, 0));
    }

    private Function1 optional(Function1 parser) {
        return (Function1<StringView, TokenizationResult> & Serializable)input -> {
            TokenizationResult other;
            TokenizationResult tokenizationResult = (TokenizationResult)parser.apply(input);
            TokenizationResult tokenizationResult2 = Failed$.MODULE$.equals(tokenizationResult) ? Matched$.MODULE$.apply(package$.MODULE$.Nil(), (StringView)input) : (other = tokenizationResult);
            return tokenizationResult2;
        };
    }

    private Function1 seq(Function1 parser1, Function1 parser2) {
        return (Function1<StringView, TokenizationResult> & Serializable)input -> {
            TokenizationResult tokenizationResult;
            TokenizationResult tokenizationResult2 = (TokenizationResult)parser1.apply(input);
            if (tokenizationResult2 instanceof EOF) {
                EOF eof;
                tokenizationResult = eof = (EOF)tokenizationResult2;
            } else if (Failed$.MODULE$.equals(tokenizationResult2)) {
                tokenizationResult = Failed$.MODULE$;
            } else if (tokenizationResult2 instanceof Matched) {
                Matched matched = Matched$.MODULE$.unapply((Matched)tokenizationResult2);
                Seq<String> seq = matched._1();
                StringView stringView = matched._2();
                Seq<String> tokens1 = seq;
                StringView rest1 = stringView;
                TokenizationResult tokenizationResult3 = (TokenizationResult)parser2.apply(rest1);
                if (tokenizationResult3 instanceof Matched) {
                    Matched matched2 = Matched$.MODULE$.unapply((Matched)tokenizationResult3);
                    Seq<String> seq2 = matched2._1();
                    StringView stringView2 = matched2._2();
                    Seq<String> tokens2 = seq2;
                    StringView rest2 = stringView2;
                    tokenizationResult = Matched$.MODULE$.apply((Seq)tokens1.$plus$plus(tokens2), rest2);
                } else {
                    TokenizationResult other = tokenizationResult3;
                    tokenizationResult = other;
                }
            } else {
                throw new MatchError(tokenizationResult2);
            }
            return tokenizationResult;
        };
    }

    private Function1 repeat(Function1 parser) {
        return (Function1<StringView, TokenizationResult> & Serializable)input -> this.repeatImpl(parser, (StringView)input, package$.MODULE$.Nil());
    }

    private TokenizationResult repeatImpl(Function1<StringView, TokenizationResult> parser, StringView input, List<Seq<String>> acc) {
        TokenizationResult tokenizationResult;
        block3: {
            TokenizationResult tokenizationResult2;
            List<Seq<String>> list2 = acc;
            StringView stringView = input;
            while (true) {
                StringView remainingInput;
                if ((tokenizationResult2 = parser.apply(stringView)) instanceof EOF) {
                    EOF eof;
                    tokenizationResult = eof = (EOF)tokenizationResult2;
                    break block3;
                }
                if (Failed$.MODULE$.equals(tokenizationResult2)) {
                    tokenizationResult = list2.isEmpty() ? Failed$.MODULE$ : Matched$.MODULE$.apply((Seq)((List)list2.reverse()).flatten(Predef$.MODULE$.$conforms()), stringView);
                    break block3;
                }
                if (!(tokenizationResult2 instanceof Matched)) break;
                Matched matched = Matched$.MODULE$.unapply((Matched)tokenizationResult2);
                Seq<String> seq = matched._1();
                StringView stringView2 = matched._2();
                Seq<String> tokens = seq;
                StringView stringView3 = remainingInput = stringView2;
                List<Seq<String>> list3 = list2.$colon$colon(tokens);
                stringView = stringView3;
                list2 = list3;
            }
            throw new MatchError(tokenizationResult2);
        }
        return tokenizationResult;
    }

    private Function1<StringView, TokenizationResult> alternatives(List<Function1<StringView, TokenizationResult>> parsers) {
        return (Function1<StringView, TokenizationResult> & Serializable)input -> this.alternativesImpl(parsers, (StringView)input);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TokenizationResult alternativesImpl(List<Function1<StringView, TokenizationResult>> parsers, StringView input) {
        TokenizationResult tokenizationResult;
        TokenizationResult tokenizationResult2;
        List<Function1<StringView, TokenizationResult>> list2 = parsers;
        while (true) {
            void var3_4;
            void var4_6 = var3_4;
            Nil$ nil$ = package$.MODULE$.Nil();
            void var5_7 = var4_6;
            if (!(nil$ != null ? !((Object)nil$).equals(var5_7) : var5_7 != null)) {
                tokenizationResult2 = Failed$.MODULE$;
                return tokenizationResult2;
            }
            if (!(var4_6 instanceof $colon$colon)) throw new MatchError(var4_6);
            $colon$colon $colon$colon = ($colon$colon)var4_6;
            List list3 = $colon$colon.next$access$1();
            Function1 parser = (Function1)$colon$colon.head();
            List remainingParsers = list3;
            tokenizationResult = (TokenizationResult)parser.apply(input);
            if (tokenizationResult instanceof EOF) {
                EOF eof = (EOF)tokenizationResult;
                tokenizationResult2 = eof;
                return tokenizationResult2;
            }
            if (!Failed$.MODULE$.equals(tokenizationResult)) break;
            List list4 = remainingParsers;
        }
        if (!(tokenizationResult instanceof Matched)) throw new MatchError(tokenizationResult);
        Matched matched = (Matched)tokenizationResult;
        tokenizationResult2 = matched;
        return tokenizationResult2;
    }

    private Function1<StringView, TokenizationResult> mapResult(Function1<StringView, TokenizationResult> parser, Function1<Seq<String>, Seq<String>> fn) {
        return (Function1<StringView, TokenizationResult> & Serializable)input -> {
            TokenizationResult tokenizationResult;
            TokenizationResult tokenizationResult2 = (TokenizationResult)parser.apply((StringView)input);
            if (tokenizationResult2 instanceof Matched) {
                Matched matched = Matched$.MODULE$.unapply((Matched)tokenizationResult2);
                Seq<String> seq = matched._1();
                StringView stringView = matched._2();
                Seq<String> tokens = seq;
                StringView rest = stringView;
                tokenizationResult = Matched$.MODULE$.apply((Seq)fn.apply(tokens), rest);
            } else {
                TokenizationResult other;
                tokenizationResult = other = tokenizationResult2;
            }
            return tokenizationResult;
        };
    }
}

