/*
 * Decompiled with CFR 0.152.
 */
package eu.geekplace.scala.jnr.time;

import eu.geekplace.scala.jnr.time.Timespec$;
import java.time.Instant;
import java.time.OffsetDateTime;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;

public final class Timespec
extends Struct {
    private final Runtime runtime;
    private final Struct.time_t seconds;
    private final Struct.SignedLong nanoseconds;

    public static Timespec apply() {
        return Timespec$.MODULE$.apply();
    }

    public static Timespec apply(Instant instant) {
        return Timespec$.MODULE$.apply(instant);
    }

    public static Timespec apply(long l, long l2, Runtime runtime) {
        return Timespec$.MODULE$.apply(l, l2, runtime);
    }

    public static Timespec apply(OffsetDateTime offsetDateTime) {
        return Timespec$.MODULE$.apply(offsetDateTime);
    }

    public static Timespec zero() {
        return Timespec$.MODULE$.zero();
    }

    public static long apply$default$2() {
        return Timespec$.MODULE$.apply$default$2();
    }

    public static Runtime apply$default$3() {
        return Timespec$.MODULE$.apply$default$3();
    }

    public Timespec(Runtime runtime) {
        this.runtime = runtime;
        super(runtime);
        this.seconds = new Struct.time_t();
        this.nanoseconds = new Struct.SignedLong();
    }

    public Runtime runtime() {
        return this.runtime;
    }

    public Struct.time_t seconds() {
        return this.seconds;
    }

    public Struct.SignedLong nanoseconds() {
        return this.nanoseconds;
    }

    public Instant instant() {
        return Instant.ofEpochSecond(this.seconds().get(), this.nanoseconds().get());
    }

    public void set(Timespec other) {
        this.seconds().set(other.seconds().get());
        this.nanoseconds().set(other.nanoseconds().get());
    }

    @Override
    public String toString() {
        return new StringBuilder(43).append("Timespec(seconds=").append(this.seconds()).append(", nanoseconds=").append(this.nanoseconds()).append(" [instant=").append(this.instant()).append("])").toString();
    }
}

