# Contributing Guidelines

We love getting feedback from our users. Bugs and code contributions are great forms of feedback and we thank you for any bugs you report or code you contribute.

## Reporting Issues

Before reporting a new bug, please check first to see if a similar bug [exists](https://bugs.mysql.com/search.php).

Bug reports should be as complete as possible.  Please try and include the following:

* complete steps to reproduce the issue
* any information about platform and environment that could be specific to
  the bug
* Specific version of the product you are using
* Specific version of the server being used
* C++ code to help reproduce the issue if possible

Please do NOT raise a GitHub Issue to report a security vulnerability.
See SECURITY.md for additional information.

## Contributing Code

You need to follow these steps.

* Make sure you have a user account at bugs.mysql.com. You'll need to reference
  this user account when you submit your OCA (Oracle Contributor Agreement).
* Sign the Oracle Contributor Agreement. You can find instructions for doing
  that at [OCA Page](https://oca.opensource.oracle.com/)
* Develop your pull request
* Make sure you are aware of the requirements for the project (i.e. don't
  require C++20 if we are supporting C++17 and higher)
* Validate your pull request by including tests that sufficiently cover
  the functionality
* Submit your pull request
* It is also possible to upload your changes using the 'contribution' tab to
  a bug record in https://bugs.mysql.com.

Only pull requests from committers that can be verified as having signed the OCA
can be accepted.
