/* tracker-backend.c generated by valac 0.41.90.2-8c9f4-dirty, the Vala compiler
 * generated from tracker-backend.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-common/tracker-domain-ontology.h"
#include "libtracker-sparql/tracker-sparql.h"
#include <gio/gio.h>
#include "libtracker-direct/tracker-direct.h"
#include "libtracker-bus/tracker-bus.h"
#include "libtracker-remote/tracker-remote.h"


#define TRACKER_SPARQL_TYPE_BACKEND (tracker_sparql_backend_get_type ())
#define TRACKER_SPARQL_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackend))
#define TRACKER_SPARQL_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))
#define TRACKER_SPARQL_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))

typedef struct _TrackerSparqlBackend TrackerSparqlBackend;
typedef struct _TrackerSparqlBackendClass TrackerSparqlBackendClass;
typedef struct _TrackerSparqlBackendPrivate TrackerSparqlBackendPrivate;
enum  {
	TRACKER_SPARQL_BACKEND_0_PROPERTY,
	TRACKER_SPARQL_BACKEND_NUM_PROPERTIES
};
static GParamSpec* tracker_sparql_backend_properties[TRACKER_SPARQL_BACKEND_NUM_PROPERTIES];

#define TRACKER_SPARQL_BACKEND_TYPE_BACKEND (tracker_sparql_backend_backend_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerSparqlBackendQueryAsyncData TrackerSparqlBackendQueryAsyncData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerSparqlBackendUpdateAsyncData TrackerSparqlBackendUpdateAsyncData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _TrackerSparqlBackendUpdateArrayAsyncData TrackerSparqlBackendUpdateArrayAsyncData;
typedef struct _TrackerSparqlBackendUpdateBlankAsyncData TrackerSparqlBackendUpdateBlankAsyncData;
typedef struct _TrackerSparqlBackendLoadAsyncData TrackerSparqlBackendLoadAsyncData;
typedef struct _TrackerSparqlBackendStatisticsAsyncData TrackerSparqlBackendStatisticsAsyncData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
typedef struct _TrackerSparqlBackendGetInternalAsyncData TrackerSparqlBackendGetInternalAsyncData;
typedef struct _TrackerSparqlConnectionGetAsyncData TrackerSparqlConnectionGetAsyncData;
typedef struct _TrackerSparqlConnectionLocalNewAsyncData TrackerSparqlConnectionLocalNewAsyncData;

struct _TrackerSparqlBackend {
	TrackerSparqlConnection parent_instance;
	TrackerSparqlBackendPrivate * priv;
};

struct _TrackerSparqlBackendClass {
	TrackerSparqlConnectionClass parent_class;
};

struct _TrackerSparqlBackendPrivate {
	gboolean initialized;
	TrackerSparqlConnection* direct;
	TrackerSparqlConnection* bus;
};

typedef enum  {
	TRACKER_SPARQL_BACKEND_BACKEND_AUTO,
	TRACKER_SPARQL_BACKEND_BACKEND_DIRECT,
	TRACKER_SPARQL_BACKEND_BACKEND_BUS
} TrackerSparqlBackendBackend;

struct _TrackerSparqlBackendQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	TrackerSparqlCursor* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	TrackerSparqlCursor* _tmp5_;
	TrackerSparqlConnection* _tmp6_;
	TrackerSparqlCursor* _tmp7_;
	TrackerSparqlCursor* _tmp8_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	TrackerSparqlConnection* _tmp0_;
	GError* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateArrayAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	gchar** sparql;
	gint sparql_length1;
	gint priority;
	GCancellable* cancellable;
	GPtrArray* result;
	TrackerSparqlConnection* _tmp0_;
	GError* _tmp1_;
	GPtrArray* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	GPtrArray* _tmp4_;
	GPtrArray* _tmp5_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateBlankAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
	TrackerSparqlConnection* _tmp0_;
	GError* _tmp1_;
	GVariant* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	GFile* file;
	GCancellable* cancellable;
	gchar* uri;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError* _tmp3_;
	TrackerSparqlConnection* _tmp4_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendStatisticsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlBackend* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlConnection* _tmp0_;
	GError* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	TrackerSparqlCursor* _tmp5_;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	GAsyncResult* async_result;
};

struct _Block2Data {
	int _ref_count_;
	GError* sparql_error;
	GError* io_error;
	GError* dbus_error;
	GError* spawn_error;
	TrackerSparqlConnection* _result_;
	GMainContext* context;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _TrackerSparqlBackendGetInternalAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	Block2Data* _data2_;
	TrackerSparqlConnection* _result_;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GMainContext* _tmp3_;
	GMainContext* _tmp4_;
	GError* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	TrackerSparqlConnection* _tmp17_;
	TrackerSparqlConnection* _tmp18_;
	GError * _inner_error_;
};

struct _TrackerSparqlConnectionGetAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError * _inner_error_;
};

struct _TrackerSparqlConnectionLocalNewAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlConnectionFlags flags;
	GFile* store;
	GFile* journal;
	GFile* ontology;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	TrackerDirectConnection* conn;
	TrackerDirectConnection* _tmp0_;
	GError * _inner_error_;
};


extern gchar* domain_name;
gchar* domain_name = NULL;
extern TrackerDomainOntology* domain_ontology;
TrackerDomainOntology* domain_ontology = NULL;
static gint TrackerSparqlBackend_private_offset;
static gpointer tracker_sparql_backend_parent_class = NULL;
static TrackerSparqlConnection* tracker_sparql_backend_singleton;
static TrackerSparqlConnection* tracker_sparql_backend_singleton = NULL;
static GMutex tracker_sparql_backend_door;
static GMutex tracker_sparql_backend_door = {0};

GType tracker_sparql_backend_get_type (void) G_GNUC_CONST;
static GType tracker_sparql_backend_backend_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
TrackerSparqlBackend* tracker_sparql_backend_new (GError** error);
TrackerSparqlBackend* tracker_sparql_backend_construct (GType object_type,
                                                        GError** error);
static void tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self,
                                          GError** error);
static void tracker_sparql_backend_real_dispose (GObject* base);
static TrackerSparqlCursor* tracker_sparql_backend_real_query (TrackerSparqlConnection* base,
                                                        const gchar* sparql,
                                                        GCancellable* cancellable,
                                                        GError** error);
static void tracker_sparql_backend_real_query_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base,
                                              const gchar* sparql,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* _data_);
static void tracker_sparql_backend_query_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void tracker_sparql_backend_real_update (TrackerSparqlConnection* base,
                                         const gchar* sparql,
                                         gint priority,
                                         GCancellable* cancellable,
                                         GError** error);
static GVariant* tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base,
                                                    const gchar* sparql,
                                                    gint priority,
                                                    GCancellable* cancellable,
                                                    GError** error);
static void tracker_sparql_backend_real_update_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base,
                                               const gchar* sparql,
                                               gint priority,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* _data_);
static void tracker_sparql_backend_update_async_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void tracker_sparql_backend_real_update_array_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base,
                                                     gchar** sparql,
                                                     int sparql_length1,
                                                     gint priority,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* _data_);
static void tracker_sparql_backend_update_array_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base,
                                                     const gchar* sparql,
                                                     gint priority,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* _data_);
static void tracker_sparql_backend_update_blank_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void tracker_sparql_backend_real_load (TrackerSparqlConnection* base,
                                       GFile* file,
                                       GCancellable* cancellable,
                                       GError** error);
static void tracker_sparql_backend_real_load_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base,
                                             GFile* file,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* _data_);
static void tracker_sparql_backend_load_async_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static TrackerSparqlCursor* tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base,
                                                             GCancellable* cancellable,
                                                             GError** error);
static void tracker_sparql_backend_real_statistics_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* _data_);
static void tracker_sparql_backend_statistics_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static TrackerNamespaceManager* tracker_sparql_backend_real_get_namespace_manager (TrackerSparqlConnection* base);
static TrackerSparqlConnection* tracker_sparql_backend_create_readonly_direct (TrackerSparqlBackend* self,
                                                                        GError** error);
static TrackerSparqlConnection* tracker_sparql_backend_get (GCancellable* cancellable,
                                                     GError** error);
TrackerSparqlConnection* tracker_sparql_backend_get_internal (GCancellable* cancellable,
                                                              GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void tracker_sparql_backend_get_internal_async (GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_backend_get_internal_finish (GAsyncResult* _res_,
                                                                     GError** error);
static void __lambda6_ (Block1Data* _data1_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_sparql_backend_get_internal_async_data_free (gpointer _data);
static gboolean tracker_sparql_backend_get_internal_async_co (TrackerSparqlBackendGetInternalAsyncData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda4_ (Block2Data* _data2_,
                     GIOSchedulerJob* job);
static gboolean __lambda5_ (Block2Data* _data2_);
static gboolean ___lambda5__gsource_func (gpointer self);
static gboolean ___lambda4__gio_scheduler_job_func (GIOSchedulerJob* job,
                                             GCancellable* cancellable,
                                             gpointer self);
static void tracker_sparql_backend_finalize (GObject * obj);
static void tracker_sparql_connection_get_async_data_free (gpointer _data);
void tracker_sparql_connection_get_async (GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get_finish (GAsyncResult* _res_,
                                                               GError** error);
static gboolean tracker_sparql_connection_get_async_co (TrackerSparqlConnectionGetAsyncData* _data_);
static void tracker_sparql_connection_get_async_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get (GCancellable* cancellable,
                                                        GError** error);
TrackerSparqlConnection* tracker_sparql_connection_remote_new (const gchar* url_base);
TrackerSparqlConnection* tracker_sparql_connection_local_new (TrackerSparqlConnectionFlags flags,
                                                              GFile* store,
                                                              GFile* journal,
                                                              GFile* ontology,
                                                              GCancellable* cancellable,
                                                              GError** error);
static void tracker_sparql_connection_local_new_async_data_free (gpointer _data);
void tracker_sparql_connection_local_new_async (TrackerSparqlConnectionFlags flags,
                                                GFile* store,
                                                GFile* journal,
                                                GFile* ontology,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_local_new_finish (GAsyncResult* _res_,
                                                                     GError** error);
static gboolean tracker_sparql_connection_local_new_async_co (TrackerSparqlConnectionLocalNewAsyncData* _data_);
void tracker_sparql_connection_set_domain (const gchar* domain);
gchar* tracker_sparql_connection_get_domain (void);


static inline gpointer
tracker_sparql_backend_get_instance_private (TrackerSparqlBackend* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerSparqlBackend_private_offset);
}


static GType
tracker_sparql_backend_backend_get_type (void)
{
	static volatile gsize tracker_sparql_backend_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_backend_backend_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_BACKEND_BACKEND_AUTO, "TRACKER_SPARQL_BACKEND_BACKEND_AUTO", "auto"}, {TRACKER_SPARQL_BACKEND_BACKEND_DIRECT, "TRACKER_SPARQL_BACKEND_BACKEND_DIRECT", "direct"}, {TRACKER_SPARQL_BACKEND_BACKEND_BUS, "TRACKER_SPARQL_BACKEND_BACKEND_BUS", "bus"}, {0, NULL, NULL}};
		GType tracker_sparql_backend_backend_type_id;
		tracker_sparql_backend_backend_type_id = g_enum_register_static ("TrackerSparqlBackendBackend", values);
		g_once_init_leave (&tracker_sparql_backend_backend_type_id__volatile, tracker_sparql_backend_backend_type_id);
	}
	return tracker_sparql_backend_backend_type_id__volatile;
}


TrackerSparqlBackend*
tracker_sparql_backend_construct (GType object_type,
                                  GError** error)
{
	TrackerSparqlBackend * self = NULL;
	GError * _inner_error_ = NULL;
#line 33 "tracker-backend.vala"
	self = (TrackerSparqlBackend*) tracker_sparql_connection_construct (object_type);
#line 481 "tracker-backend.c"
	{
		TrackerDomainOntology* _tmp0_ = NULL;
		const gchar* _tmp1_;
		TrackerDomainOntology* _tmp2_;
		TrackerDomainOntology* _tmp3_;
#line 35 "tracker-backend.vala"
		_tmp1_ = domain_name;
#line 35 "tracker-backend.vala"
		_tmp2_ = tracker_domain_ontology_new (_tmp1_, NULL, &_inner_error_);
#line 35 "tracker-backend.vala"
		_tmp0_ = _tmp2_;
#line 35 "tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 495 "tracker-backend.c"
			goto __catch0_g_error;
		}
#line 35 "tracker-backend.vala"
		_tmp3_ = _tmp0_;
#line 35 "tracker-backend.vala"
		_tmp0_ = NULL;
#line 35 "tracker-backend.vala"
		_g_object_unref0 (domain_ontology);
#line 35 "tracker-backend.vala"
		domain_ontology = _tmp3_;
#line 36 "tracker-backend.vala"
		tracker_sparql_backend_load_plugins (self, &_inner_error_);
#line 36 "tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 36 "tracker-backend.vala"
			_g_object_unref0 (_tmp0_);
#line 512 "tracker-backend.c"
			goto __catch0_g_error;
		}
#line 34 "tracker-backend.vala"
		_g_object_unref0 (_tmp0_);
#line 517 "tracker-backend.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
#line 34 "tracker-backend.vala"
		e = _inner_error_;
#line 34 "tracker-backend.vala"
		_inner_error_ = NULL;
#line 38 "tracker-backend.vala"
		_tmp4_ = e;
#line 38 "tracker-backend.vala"
		_tmp5_ = _tmp4_->message;
#line 38 "tracker-backend.vala"
		_tmp6_ = g_strconcat ("Failed to load SPARQL backend: ", _tmp5_, NULL);
#line 38 "tracker-backend.vala"
		_tmp7_ = _tmp6_;
#line 38 "tracker-backend.vala"
		_tmp8_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp7_);
#line 38 "tracker-backend.vala"
		_tmp9_ = _tmp8_;
#line 38 "tracker-backend.vala"
		_g_free0 (_tmp7_);
#line 38 "tracker-backend.vala"
		_inner_error_ = _tmp9_;
#line 38 "tracker-backend.vala"
		_g_error_free0 (e);
#line 551 "tracker-backend.c"
		goto __finally0;
	}
	__finally0:
#line 34 "tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 34 "tracker-backend.vala"
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 34 "tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 34 "tracker-backend.vala"
			_g_object_unref0 (self);
#line 34 "tracker-backend.vala"
			return NULL;
#line 565 "tracker-backend.c"
		} else {
#line 34 "tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 34 "tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 34 "tracker-backend.vala"
			return NULL;
#line 573 "tracker-backend.c"
		}
	}
#line 41 "tracker-backend.vala"
	self->priv->initialized = TRUE;
#line 33 "tracker-backend.vala"
	return self;
#line 580 "tracker-backend.c"
}


TrackerSparqlBackend*
tracker_sparql_backend_new (GError** error)
{
#line 33 "tracker-backend.vala"
	return tracker_sparql_backend_construct (TRACKER_SPARQL_TYPE_BACKEND, error);
#line 589 "tracker-backend.c"
}


static void
tracker_sparql_backend_real_dispose (GObject* base)
{
	TrackerSparqlBackend * self;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
#line 44 "tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 46 "tracker-backend.vala"
	_tmp0_ = self->priv->initialized;
#line 46 "tracker-backend.vala"
	if (_tmp0_) {
#line 47 "tracker-backend.vala"
		g_mutex_lock (&tracker_sparql_backend_door);
#line 607 "tracker-backend.c"
		{
			TrackerSparqlConnection* _tmp1_;
#line 54 "tracker-backend.vala"
			_tmp1_ = tracker_sparql_backend_singleton;
#line 54 "tracker-backend.vala"
			if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (self, TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection)) {
#line 55 "tracker-backend.vala"
				tracker_sparql_backend_singleton = NULL;
#line 616 "tracker-backend.c"
			}
		}
		__finally1:
		{
#line 58 "tracker-backend.vala"
			g_mutex_unlock (&tracker_sparql_backend_door);
#line 623 "tracker-backend.c"
		}
#line 49 "tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 49 "tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 49 "tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 49 "tracker-backend.vala"
			return;
#line 633 "tracker-backend.c"
		}
	}
#line 62 "tracker-backend.vala"
	G_OBJECT_CLASS (tracker_sparql_backend_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection));
#line 638 "tracker-backend.c"
}


static TrackerSparqlCursor*
tracker_sparql_backend_real_query (TrackerSparqlConnection* base,
                                   const gchar* sparql,
                                   GCancellable* cancellable,
                                   GError** error)
{
	TrackerSparqlBackend * self;
	TrackerSparqlCursor* result = NULL;
	TrackerSparqlConnection* _tmp0_;
	GError * _inner_error_ = NULL;
#line 65 "tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 65 "tracker-backend.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 66 "tracker-backend.vala"
	g_debug ("%s(): '%s'", "Tracker.Sparql.Backend.query", sparql);
#line 67 "tracker-backend.vala"
	_tmp0_ = self->priv->direct;
#line 67 "tracker-backend.vala"
	if (_tmp0_ != NULL) {
#line 662 "tracker-backend.c"
		TrackerSparqlCursor* _tmp1_ = NULL;
		TrackerSparqlConnection* _tmp2_;
		TrackerSparqlCursor* _tmp3_;
		TrackerSparqlCursor* _tmp4_;
#line 68 "tracker-backend.vala"
		_tmp2_ = self->priv->direct;
#line 68 "tracker-backend.vala"
		_tmp3_ = tracker_sparql_connection_query (_tmp2_, sparql, cancellable, &_inner_error_);
#line 68 "tracker-backend.vala"
		_tmp1_ = _tmp3_;
#line 68 "tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 68 "tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 68 "tracker-backend.vala"
			return NULL;
#line 679 "tracker-backend.c"
		}
#line 68 "tracker-backend.vala"
		_tmp4_ = _tmp1_;
#line 68 "tracker-backend.vala"
		_tmp1_ = NULL;
#line 68 "tracker-backend.vala"
		result = _tmp4_;
#line 68 "tracker-backend.vala"
		_g_object_unref0 (_tmp1_);
#line 68 "tracker-backend.vala"
		return result;
#line 691 "tracker-backend.c"
	} else {
		TrackerSparqlCursor* _tmp5_ = NULL;
		TrackerSparqlConnection* _tmp6_;
		TrackerSparqlCursor* _tmp7_;
		TrackerSparqlCursor* _tmp8_;
#line 70 "tracker-backend.vala"
		_tmp6_ = self->priv->bus;
#line 70 "tracker-backend.vala"
		_tmp7_ = tracker_sparql_connection_query (_tmp6_, sparql, cancellable, &_inner_error_);
#line 70 "tracker-backend.vala"
		_tmp5_ = _tmp7_;
#line 70 "tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 70 "tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 70 "tracker-backend.vala"
			return NULL;
#line 709 "tracker-backend.c"
		}
#line 70 "tracker-backend.vala"
		_tmp8_ = _tmp5_;
#line 70 "tracker-backend.vala"
		_tmp5_ = NULL;
#line 70 "tracker-backend.vala"
		result = _tmp8_;
#line 70 "tracker-backend.vala"
		_g_object_unref0 (_tmp5_);
#line 70 "tracker-backend.vala"
		return result;
#line 721 "tracker-backend.c"
	}
}


static void
tracker_sparql_backend_real_query_async_data_free (gpointer _data)
{
	TrackerSparqlBackendQueryAsyncData* _data_;
	_data_ = _data;
#line 23 "tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->result);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 23 "tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendQueryAsyncData, _data_);
#line 741 "tracker-backend.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 23 "tracker-backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 750 "tracker-backend.c"
}


static void
tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base,
                                         const gchar* sparql,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	TrackerSparqlBackend * self;
	TrackerSparqlBackendQueryAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 23 "tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 23 "tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendQueryAsyncData);
#line 23 "tracker-backend.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 23 "tracker-backend.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_query_async_data_free);
#line 23 "tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "tracker-backend.vala"
	_data_->self = _tmp0_;
#line 23 "tracker-backend.vala"
	_tmp1_ = g_strdup (sparql);
#line 23 "tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 23 "tracker-backend.vala"
	_data_->sparql = _tmp1_;
#line 23 "tracker-backend.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "tracker-backend.vala"
	_data_->cancellable = _tmp2_;
#line 23 "tracker-backend.vala"
	tracker_sparql_backend_real_query_async_co (_data_);
#line 792 "tracker-backend.c"
}


static TrackerSparqlCursor*
tracker_sparql_backend_real_query_finish (TrackerSparqlConnection* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	TrackerSparqlCursor* result;
	TrackerSparqlBackendQueryAsyncData* _data_;
#line 23 "tracker-backend.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 23 "tracker-backend.vala"
	if (NULL == _data_) {
#line 23 "tracker-backend.vala"
		return NULL;
#line 809 "tracker-backend.c"
	}
#line 23 "tracker-backend.vala"
	result = _data_->result;
#line 23 "tracker-backend.vala"
	_data_->result = NULL;
#line 23 "tracker-backend.vala"
	return result;
#line 817 "tracker-backend.c"
}


static void
tracker_sparql_backend_query_async_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	TrackerSparqlBackendQueryAsyncData* _data_;
#line 77 "tracker-backend.vala"
	_data_ = _user_data_;
#line 77 "tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 77 "tracker-backend.vala"
	_data_->_res_ = _res_;
#line 77 "tracker-backend.vala"
	tracker_sparql_backend_real_query_async_co (_data_);
#line 835 "tracker-backend.c"
}


static gboolean
tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* _data_)
{
#line 74 "tracker-backend.vala"
	switch (_data_->_state_) {
#line 74 "tracker-backend.vala"
		case 0:
#line 846 "tracker-backend.c"
		goto _state_0;
#line 74 "tracker-backend.vala"
		case 1:
#line 850 "tracker-backend.c"
		goto _state_1;
#line 74 "tracker-backend.vala"
		case 2:
#line 854 "tracker-backend.c"
		goto _state_2;
		default:
#line 74 "tracker-backend.vala"
		g_assert_not_reached ();
#line 859 "tracker-backend.c"
	}
	_state_0:
#line 75 "tracker-backend.vala"
	g_debug ("%s(): '%s'", "Tracker.Sparql.Backend.query_async", _data_->sparql);
#line 76 "tracker-backend.vala"
	_data_->_tmp0_ = _data_->self->priv->direct;
#line 76 "tracker-backend.vala"
	if (_data_->_tmp0_ != NULL) {
#line 77 "tracker-backend.vala"
		_data_->_tmp2_ = _data_->self->priv->direct;
#line 77 "tracker-backend.vala"
		_data_->_state_ = 1;
#line 77 "tracker-backend.vala"
		tracker_sparql_connection_query_async (_data_->_tmp2_, _data_->sparql, _data_->cancellable, tracker_sparql_backend_query_async_ready, _data_);
#line 77 "tracker-backend.vala"
		return FALSE;
#line 876 "tracker-backend.c"
		_state_1:
#line 77 "tracker-backend.vala"
		_data_->_tmp3_ = tracker_sparql_connection_query_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
#line 77 "tracker-backend.vala"
		_data_->_tmp1_ = _data_->_tmp3_;
#line 77 "tracker-backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 77 "tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 77 "tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 77 "tracker-backend.vala"
			return FALSE;
#line 890 "tracker-backend.c"
		}
#line 77 "tracker-backend.vala"
		_data_->_tmp4_ = _data_->_tmp1_;
#line 77 "tracker-backend.vala"
		_data_->_tmp1_ = NULL;
#line 77 "tracker-backend.vala"
		_data_->result = _data_->_tmp4_;
#line 77 "tracker-backend.vala"
		_g_object_unref0 (_data_->_tmp1_);
#line 77 "tracker-backend.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 77 "tracker-backend.vala"
		if (_data_->_state_ != 0) {
#line 77 "tracker-backend.vala"
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 77 "tracker-backend.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 908 "tracker-backend.c"
			}
		}
#line 77 "tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 77 "tracker-backend.vala"
		return FALSE;
#line 915 "tracker-backend.c"
	} else {
#line 79 "tracker-backend.vala"
		_data_->_tmp6_ = _data_->self->priv->bus;
#line 79 "tracker-backend.vala"
		_data_->_state_ = 2;
#line 79 "tracker-backend.vala"
		tracker_sparql_connection_query_async (_data_->_tmp6_, _data_->sparql, _data_->cancellable, tracker_sparql_backend_query_async_ready, _data_);
#line 79 "tracker-backend.vala"
		return FALSE;
#line 925 "tracker-backend.c"
		_state_2:
#line 79 "tracker-backend.vala"
		_data_->_tmp7_ = tracker_sparql_connection_query_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
#line 79 "tracker-backend.vala"
		_data_->_tmp5_ = _data_->_tmp7_;
#line 79 "tracker-backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 79 "tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 79 "tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 79 "tracker-backend.vala"
			return FALSE;
#line 939 "tracker-backend.c"
		}
#line 79 "tracker-backend.vala"
		_data_->_tmp8_ = _data_->_tmp5_;
#line 79 "tracker-backend.vala"
		_data_->_tmp5_ = NULL;
#line 79 "tracker-backend.vala"
		_data_->result = _data_->_tmp8_;
#line 79 "tracker-backend.vala"
		_g_object_unref0 (_data_->_tmp5_);
#line 79 "tracker-backend.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 79 "tracker-backend.vala"
		if (_data_->_state_ != 0) {
#line 79 "tracker-backend.vala"
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 79 "tracker-backend.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 957 "tracker-backend.c"
			}
		}
#line 79 "tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 79 "tracker-backend.vala"
		return FALSE;
#line 964 "tracker-backend.c"
	}
}


static void
tracker_sparql_backend_real_update (TrackerSparqlConnection* base,
                                    const gchar* sparql,
                                    gint priority,
                                    GCancellable* cancellable,
                                    GError** error)
{
	TrackerSparqlBackend * self;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlConnection* _tmp2_;
	GError * _inner_error_ = NULL;
#line 83 "tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 83 "tracker-backend.vala"
	g_return_if_fail (sparql != NULL);
#line 84 "tracker-backend.vala"
	g_debug ("%s(priority:%d): '%s'", "Tracker.Sparql.Backend.update", priority, sparql);
#line 85 "tracker-backend.vala"
	_tmp0_ = self->priv->bus;
#line 85 "tracker-backend.vala"
	if (_tmp0_ == NULL) {
#line 990 "tracker-backend.c"
		GError* _tmp1_;
#line 86 "tracker-backend.vala"
		_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 86 "tracker-backend.vala"
		_inner_error_ = _tmp1_;
#line 86 "tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 86 "tracker-backend.vala"
		return;
#line 1000 "tracker-backend.c"
	}
#line 88 "tracker-backend.vala"
	_tmp2_ = self->priv->bus;
#line 88 "tracker-backend.vala"
	tracker_sparql_connection_update (_tmp2_, sparql, priority, cancellable, &_inner_error_);
#line 88 "tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 88 "tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 88 "tracker-backend.vala"
		return;
#line 1012 "tracker-backend.c"
	}
}


static GVariant*
tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base,
                                          const gchar* sparql,
                                          gint priority,
                                          GCancellable* cancellable,
                                          GError** error)
{
	TrackerSparqlBackend * self;
	GVariant* result = NULL;
	TrackerSparqlConnection* _tmp0_;
	GVariant* _tmp2_ = NULL;
	TrackerSparqlConnection* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GError * _inner_error_ = NULL;
#line 91 "tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 91 "tracker-backend.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 92 "tracker-backend.vala"
	g_debug ("%s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank", priority, sparql);
#line 93 "tracker-backend.vala"
	_tmp0_ = self->priv->bus;
#line 93 "tracker-backend.vala"
	if (_tmp0_ == NULL) {
#line 1042 "tracker-backend.c"
		GError* _tmp1_;
#line 94 "tracker-backend.vala"
		_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 94 "tracker-backend.vala"
		_inner_error_ = _tmp1_;
#line 94 "tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 94 "tracker-backend.vala"
		return NULL;
#line 1052 "tracker-backend.c"
	}
#line 96 "tracker-backend.vala"
	_tmp3_ = self->priv->bus;
#line 96 "tracker-backend.vala"
	_tmp4_ = tracker_sparql_connection_update_blank (_tmp3_, sparql, priority, cancellable, &_inner_error_);
#line 96 "tracker-backend.vala"
	_tmp2_ = _tmp4_;
#line 96 "tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 96 "tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 96 "tracker-backend.vala"
		return NULL;
#line 1066 "tracker-backend.c"
	}
#line 96 "tracker-backend.vala"
	_tmp5_ = _tmp2_;
#line 96 "tracker-backend.vala"
	_tmp2_ = NULL;
#line 96 "tracker-backend.vala"
	result = _tmp5_;
#line 96 "tracker-backend.vala"
	_g_variant_unref0 (_tmp2_);
#line 96 "tracker-backend.vala"
	return result;
#line 1078 "tracker-backend.c"
}


static void
tracker_sparql_backend_real_update_async_data_free (gpointer _data)
{
	TrackerSparqlBackendUpdateAsyncData* _data_;
	_data_ = _data;
#line 23 "tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 23 "tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendUpdateAsyncData, _data_);
#line 1095 "tracker-backend.c"
}


static void
tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base,
                                          const gchar* sparql,
                                          gint priority,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 23 "tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 23 "tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateAsyncData);
#line 23 "tracker-backend.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 23 "tracker-backend.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_update_async_data_free);
#line 23 "tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "tracker-backend.vala"
	_data_->self = _tmp0_;
#line 23 "tracker-backend.vala"
	_tmp1_ = g_strdup (sparql);
#line 23 "tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 23 "tracker-backend.vala"
	_data_->sparql = _tmp1_;
#line 23 "tracker-backend.vala"
	_data_->priority = priority;
#line 23 "tracker-backend.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "tracker-backend.vala"
	_data_->cancellable = _tmp2_;
#line 23 "tracker-backend.vala"
	tracker_sparql_backend_real_update_async_co (_data_);
#line 1140 "tracker-backend.c"
}


static void
tracker_sparql_backend_real_update_finish (TrackerSparqlConnection* base,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	TrackerSparqlBackendUpdateAsyncData* _data_;
#line 23 "tracker-backend.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 23 "tracker-backend.vala"
	if (NULL == _data_) {
#line 23 "tracker-backend.vala"
		return;
#line 1156 "tracker-backend.c"
	}
}


static void
tracker_sparql_backend_update_async_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	TrackerSparqlBackendUpdateAsyncData* _data_;
#line 104 "tracker-backend.vala"
	_data_ = _user_data_;
#line 104 "tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 104 "tracker-backend.vala"
	_data_->_res_ = _res_;
#line 104 "tracker-backend.vala"
	tracker_sparql_backend_real_update_async_co (_data_);
#line 1175 "tracker-backend.c"
}


static gboolean
tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* _data_)
{
#line 99 "tracker-backend.vala"
	switch (_data_->_state_) {
#line 99 "tracker-backend.vala"
		case 0:
#line 1186 "tracker-backend.c"
		goto _state_0;
#line 99 "tracker-backend.vala"
		case 1:
#line 1190 "tracker-backend.c"
		goto _state_1;
		default:
#line 99 "tracker-backend.vala"
		g_assert_not_reached ();
#line 1195 "tracker-backend.c"
	}
	_state_0:
#line 100 "tracker-backend.vala"
	g_debug ("%s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_async", _data_->priority, _data_->sparql);
#line 101 "tracker-backend.vala"
	_data_->_tmp0_ = _data_->self->priv->bus;
#line 101 "tracker-backend.vala"
	if (_data_->_tmp0_ == NULL) {
#line 102 "tracker-backend.vala"
		_data_->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 102 "tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp1_;
#line 102 "tracker-backend.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 102 "tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 102 "tracker-backend.vala"
		return FALSE;
#line 1214 "tracker-backend.c"
	}
#line 104 "tracker-backend.vala"
	_data_->_tmp2_ = _data_->self->priv->bus;
#line 104 "tracker-backend.vala"
	_data_->_state_ = 1;
#line 104 "tracker-backend.vala"
	tracker_sparql_connection_update_async (_data_->_tmp2_, _data_->sparql, _data_->priority, _data_->cancellable, tracker_sparql_backend_update_async_ready, _data_);
#line 104 "tracker-backend.vala"
	return FALSE;
#line 1224 "tracker-backend.c"
	_state_1:
#line 104 "tracker-backend.vala"
	tracker_sparql_connection_update_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
#line 104 "tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 104 "tracker-backend.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 104 "tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 104 "tracker-backend.vala"
		return FALSE;
#line 1236 "tracker-backend.c"
	}
#line 99 "tracker-backend.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 99 "tracker-backend.vala"
	if (_data_->_state_ != 0) {
#line 99 "tracker-backend.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 99 "tracker-backend.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1246 "tracker-backend.c"
		}
	}
#line 99 "tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 99 "tracker-backend.vala"
	return FALSE;
#line 1253 "tracker-backend.c"
}


static void
tracker_sparql_backend_real_update_array_async_data_free (gpointer _data)
{
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	_data_ = _data;
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "tracker-backend.vala"
	_g_ptr_array_unref0 (_data_->result);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 23 "tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendUpdateArrayAsyncData, _data_);
#line 1270 "tracker-backend.c"
}


static void
tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base,
                                                gchar** sparql,
                                                int sparql_length1,
                                                gint priority,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	GCancellable* _tmp1_;
#line 23 "tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 23 "tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateArrayAsyncData);
#line 23 "tracker-backend.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 23 "tracker-backend.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_update_array_async_data_free);
#line 23 "tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "tracker-backend.vala"
	_data_->self = _tmp0_;
#line 23 "tracker-backend.vala"
	_data_->sparql = sparql;
#line 23 "tracker-backend.vala"
	_data_->sparql_length1 = sparql_length1;
#line 23 "tracker-backend.vala"
	_data_->priority = priority;
#line 23 "tracker-backend.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "tracker-backend.vala"
	_data_->cancellable = _tmp1_;
#line 23 "tracker-backend.vala"
	tracker_sparql_backend_real_update_array_async_co (_data_);
#line 1313 "tracker-backend.c"
}


static GPtrArray*
tracker_sparql_backend_real_update_array_finish (TrackerSparqlConnection* base,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GPtrArray* result;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
#line 23 "tracker-backend.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 23 "tracker-backend.vala"
	if (NULL == _data_) {
#line 23 "tracker-backend.vala"
		return NULL;
#line 1330 "tracker-backend.c"
	}
#line 23 "tracker-backend.vala"
	result = _data_->result;
#line 23 "tracker-backend.vala"
	_data_->result = NULL;
#line 23 "tracker-backend.vala"
	return result;
#line 1338 "tracker-backend.c"
}


static void
tracker_sparql_backend_update_array_async_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
#line 111 "tracker-backend.vala"
	_data_ = _user_data_;
#line 111 "tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 111 "tracker-backend.vala"
	_data_->_res_ = _res_;
#line 111 "tracker-backend.vala"
	tracker_sparql_backend_real_update_array_async_co (_data_);
#line 1356 "tracker-backend.c"
}


static gboolean
tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* _data_)
{
#line 107 "tracker-backend.vala"
	switch (_data_->_state_) {
#line 107 "tracker-backend.vala"
		case 0:
#line 1367 "tracker-backend.c"
		goto _state_0;
#line 107 "tracker-backend.vala"
		case 1:
#line 1371 "tracker-backend.c"
		goto _state_1;
		default:
#line 107 "tracker-backend.vala"
		g_assert_not_reached ();
#line 1376 "tracker-backend.c"
	}
	_state_0:
#line 108 "tracker-backend.vala"
	_data_->_tmp0_ = _data_->self->priv->bus;
#line 108 "tracker-backend.vala"
	if (_data_->_tmp0_ == NULL) {
#line 109 "tracker-backend.vala"
		_data_->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 109 "tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp1_;
#line 109 "tracker-backend.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 109 "tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 109 "tracker-backend.vala"
		return FALSE;
#line 1393 "tracker-backend.c"
	}
#line 111 "tracker-backend.vala"
	_data_->_tmp3_ = _data_->self->priv->bus;
#line 111 "tracker-backend.vala"
	_data_->_state_ = 1;
#line 111 "tracker-backend.vala"
	tracker_sparql_connection_update_array_async (_data_->_tmp3_, _data_->sparql, _data_->sparql_length1, _data_->priority, _data_->cancellable, tracker_sparql_backend_update_array_async_ready, _data_);
#line 111 "tracker-backend.vala"
	return FALSE;
#line 1403 "tracker-backend.c"
	_state_1:
#line 111 "tracker-backend.vala"
	_data_->_tmp4_ = tracker_sparql_connection_update_array_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 111 "tracker-backend.vala"
	_data_->_tmp2_ = _data_->_tmp4_;
#line 111 "tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 111 "tracker-backend.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 111 "tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 111 "tracker-backend.vala"
		return FALSE;
#line 1417 "tracker-backend.c"
	}
#line 111 "tracker-backend.vala"
	_data_->_tmp5_ = _data_->_tmp2_;
#line 111 "tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 111 "tracker-backend.vala"
	_data_->result = _data_->_tmp5_;
#line 111 "tracker-backend.vala"
	_g_ptr_array_unref0 (_data_->_tmp2_);
#line 111 "tracker-backend.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 111 "tracker-backend.vala"
	if (_data_->_state_ != 0) {
#line 111 "tracker-backend.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 111 "tracker-backend.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1435 "tracker-backend.c"
		}
	}
#line 111 "tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 111 "tracker-backend.vala"
	return FALSE;
#line 1442 "tracker-backend.c"
}


static void
tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data)
{
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	_data_ = _data;
#line 23 "tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "tracker-backend.vala"
	_g_variant_unref0 (_data_->result);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 23 "tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendUpdateBlankAsyncData, _data_);
#line 1461 "tracker-backend.c"
}


static void
tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base,
                                                const gchar* sparql,
                                                gint priority,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 23 "tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 23 "tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateBlankAsyncData);
#line 23 "tracker-backend.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 23 "tracker-backend.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_update_blank_async_data_free);
#line 23 "tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "tracker-backend.vala"
	_data_->self = _tmp0_;
#line 23 "tracker-backend.vala"
	_tmp1_ = g_strdup (sparql);
#line 23 "tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 23 "tracker-backend.vala"
	_data_->sparql = _tmp1_;
#line 23 "tracker-backend.vala"
	_data_->priority = priority;
#line 23 "tracker-backend.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "tracker-backend.vala"
	_data_->cancellable = _tmp2_;
#line 23 "tracker-backend.vala"
	tracker_sparql_backend_real_update_blank_async_co (_data_);
#line 1506 "tracker-backend.c"
}


static GVariant*
tracker_sparql_backend_real_update_blank_finish (TrackerSparqlConnection* base,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GVariant* result;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
#line 23 "tracker-backend.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 23 "tracker-backend.vala"
	if (NULL == _data_) {
#line 23 "tracker-backend.vala"
		return NULL;
#line 1523 "tracker-backend.c"
	}
#line 23 "tracker-backend.vala"
	result = _data_->result;
#line 23 "tracker-backend.vala"
	_data_->result = NULL;
#line 23 "tracker-backend.vala"
	return result;
#line 1531 "tracker-backend.c"
}


static void
tracker_sparql_backend_update_blank_async_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
#line 119 "tracker-backend.vala"
	_data_ = _user_data_;
#line 119 "tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 119 "tracker-backend.vala"
	_data_->_res_ = _res_;
#line 119 "tracker-backend.vala"
	tracker_sparql_backend_real_update_blank_async_co (_data_);
#line 1549 "tracker-backend.c"
}


static gboolean
tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* _data_)
{
#line 114 "tracker-backend.vala"
	switch (_data_->_state_) {
#line 114 "tracker-backend.vala"
		case 0:
#line 1560 "tracker-backend.c"
		goto _state_0;
#line 114 "tracker-backend.vala"
		case 1:
#line 1564 "tracker-backend.c"
		goto _state_1;
		default:
#line 114 "tracker-backend.vala"
		g_assert_not_reached ();
#line 1569 "tracker-backend.c"
	}
	_state_0:
#line 115 "tracker-backend.vala"
	g_debug ("%s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank_async", _data_->priority, _data_->sparql);
#line 116 "tracker-backend.vala"
	_data_->_tmp0_ = _data_->self->priv->bus;
#line 116 "tracker-backend.vala"
	if (_data_->_tmp0_ == NULL) {
#line 117 "tracker-backend.vala"
		_data_->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 117 "tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp1_;
#line 117 "tracker-backend.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 117 "tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 117 "tracker-backend.vala"
		return FALSE;
#line 1588 "tracker-backend.c"
	}
#line 119 "tracker-backend.vala"
	_data_->_tmp3_ = _data_->self->priv->bus;
#line 119 "tracker-backend.vala"
	_data_->_state_ = 1;
#line 119 "tracker-backend.vala"
	tracker_sparql_connection_update_blank_async (_data_->_tmp3_, _data_->sparql, _data_->priority, _data_->cancellable, tracker_sparql_backend_update_blank_async_ready, _data_);
#line 119 "tracker-backend.vala"
	return FALSE;
#line 1598 "tracker-backend.c"
	_state_1:
#line 119 "tracker-backend.vala"
	_data_->_tmp4_ = tracker_sparql_connection_update_blank_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 119 "tracker-backend.vala"
	_data_->_tmp2_ = _data_->_tmp4_;
#line 119 "tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 119 "tracker-backend.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 119 "tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 119 "tracker-backend.vala"
		return FALSE;
#line 1612 "tracker-backend.c"
	}
#line 119 "tracker-backend.vala"
	_data_->_tmp5_ = _data_->_tmp2_;
#line 119 "tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 119 "tracker-backend.vala"
	_data_->result = _data_->_tmp5_;
#line 119 "tracker-backend.vala"
	_g_variant_unref0 (_data_->_tmp2_);
#line 119 "tracker-backend.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 119 "tracker-backend.vala"
	if (_data_->_state_ != 0) {
#line 119 "tracker-backend.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 119 "tracker-backend.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1630 "tracker-backend.c"
		}
	}
#line 119 "tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 119 "tracker-backend.vala"
	return FALSE;
#line 1637 "tracker-backend.c"
}


static void
tracker_sparql_backend_real_load (TrackerSparqlConnection* base,
                                  GFile* file,
                                  GCancellable* cancellable,
                                  GError** error)
{
	TrackerSparqlBackend * self;
	gchar* uri = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	TrackerSparqlConnection* _tmp4_;
	GError * _inner_error_ = NULL;
#line 122 "tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 122 "tracker-backend.vala"
	g_return_if_fail (file != NULL);
#line 123 "tracker-backend.vala"
	_tmp0_ = g_file_get_uri (file);
#line 123 "tracker-backend.vala"
	uri = _tmp0_;
#line 124 "tracker-backend.vala"
	_tmp1_ = uri;
#line 124 "tracker-backend.vala"
	g_debug ("%s(): '%s'", "Tracker.Sparql.Backend.load", _tmp1_);
#line 125 "tracker-backend.vala"
	_tmp2_ = self->priv->bus;
#line 125 "tracker-backend.vala"
	if (_tmp2_ == NULL) {
#line 1670 "tracker-backend.c"
		GError* _tmp3_;
#line 126 "tracker-backend.vala"
		_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 126 "tracker-backend.vala"
		_inner_error_ = _tmp3_;
#line 126 "tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 126 "tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 126 "tracker-backend.vala"
			_g_free0 (uri);
#line 126 "tracker-backend.vala"
			return;
#line 1684 "tracker-backend.c"
		} else {
#line 126 "tracker-backend.vala"
			_g_free0 (uri);
#line 126 "tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 126 "tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 126 "tracker-backend.vala"
			return;
#line 1694 "tracker-backend.c"
		}
	}
#line 128 "tracker-backend.vala"
	_tmp4_ = self->priv->bus;
#line 128 "tracker-backend.vala"
	tracker_sparql_connection_load (_tmp4_, file, cancellable, &_inner_error_);
#line 128 "tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 128 "tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 128 "tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 128 "tracker-backend.vala"
			_g_free0 (uri);
#line 128 "tracker-backend.vala"
			return;
#line 1711 "tracker-backend.c"
		} else {
#line 128 "tracker-backend.vala"
			_g_free0 (uri);
#line 128 "tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 128 "tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 128 "tracker-backend.vala"
			return;
#line 1721 "tracker-backend.c"
		}
	}
#line 122 "tracker-backend.vala"
	_g_free0 (uri);
#line 1726 "tracker-backend.c"
}


static void
tracker_sparql_backend_real_load_async_data_free (gpointer _data)
{
	TrackerSparqlBackendLoadAsyncData* _data_;
	_data_ = _data;
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->file);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 23 "tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendLoadAsyncData, _data_);
#line 1743 "tracker-backend.c"
}


static void
tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base,
                                        GFile* file,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	TrackerSparqlBackend * self;
	TrackerSparqlBackendLoadAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
#line 23 "tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 23 "tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendLoadAsyncData);
#line 23 "tracker-backend.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 23 "tracker-backend.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_load_async_data_free);
#line 23 "tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "tracker-backend.vala"
	_data_->self = _tmp0_;
#line 23 "tracker-backend.vala"
	_tmp1_ = _g_object_ref0 (file);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->file);
#line 23 "tracker-backend.vala"
	_data_->file = _tmp1_;
#line 23 "tracker-backend.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "tracker-backend.vala"
	_data_->cancellable = _tmp2_;
#line 23 "tracker-backend.vala"
	tracker_sparql_backend_real_load_async_co (_data_);
#line 1785 "tracker-backend.c"
}


static void
tracker_sparql_backend_real_load_finish (TrackerSparqlConnection* base,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	TrackerSparqlBackendLoadAsyncData* _data_;
#line 23 "tracker-backend.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 23 "tracker-backend.vala"
	if (NULL == _data_) {
#line 23 "tracker-backend.vala"
		return;
#line 1801 "tracker-backend.c"
	}
}


static void
tracker_sparql_backend_load_async_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	TrackerSparqlBackendLoadAsyncData* _data_;
#line 137 "tracker-backend.vala"
	_data_ = _user_data_;
#line 137 "tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 137 "tracker-backend.vala"
	_data_->_res_ = _res_;
#line 137 "tracker-backend.vala"
	tracker_sparql_backend_real_load_async_co (_data_);
#line 1820 "tracker-backend.c"
}


static gboolean
tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* _data_)
{
#line 131 "tracker-backend.vala"
	switch (_data_->_state_) {
#line 131 "tracker-backend.vala"
		case 0:
#line 1831 "tracker-backend.c"
		goto _state_0;
#line 131 "tracker-backend.vala"
		case 1:
#line 1835 "tracker-backend.c"
		goto _state_1;
		default:
#line 131 "tracker-backend.vala"
		g_assert_not_reached ();
#line 1840 "tracker-backend.c"
	}
	_state_0:
#line 132 "tracker-backend.vala"
	_data_->_tmp0_ = g_file_get_uri (_data_->file);
#line 132 "tracker-backend.vala"
	_data_->uri = _data_->_tmp0_;
#line 133 "tracker-backend.vala"
	_data_->_tmp1_ = _data_->uri;
#line 133 "tracker-backend.vala"
	g_debug ("%s(): '%s'", "Tracker.Sparql.Backend.load_async", _data_->_tmp1_);
#line 134 "tracker-backend.vala"
	_data_->_tmp2_ = _data_->self->priv->bus;
#line 134 "tracker-backend.vala"
	if (_data_->_tmp2_ == NULL) {
#line 135 "tracker-backend.vala"
		_data_->_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 135 "tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp3_;
#line 135 "tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 135 "tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 135 "tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 135 "tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 135 "tracker-backend.vala"
			return FALSE;
#line 1869 "tracker-backend.c"
		} else {
#line 135 "tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 135 "tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 135 "tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 135 "tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 135 "tracker-backend.vala"
			return FALSE;
#line 1881 "tracker-backend.c"
		}
	}
#line 137 "tracker-backend.vala"
	_data_->_tmp4_ = _data_->self->priv->bus;
#line 137 "tracker-backend.vala"
	_data_->_state_ = 1;
#line 137 "tracker-backend.vala"
	tracker_sparql_connection_load_async (_data_->_tmp4_, _data_->file, _data_->cancellable, tracker_sparql_backend_load_async_ready, _data_);
#line 137 "tracker-backend.vala"
	return FALSE;
#line 1892 "tracker-backend.c"
	_state_1:
#line 137 "tracker-backend.vala"
	tracker_sparql_connection_load_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
#line 137 "tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 137 "tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 137 "tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 137 "tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 137 "tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 137 "tracker-backend.vala"
			return FALSE;
#line 1908 "tracker-backend.c"
		} else {
#line 137 "tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 137 "tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 137 "tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 137 "tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 137 "tracker-backend.vala"
			return FALSE;
#line 1920 "tracker-backend.c"
		}
	}
#line 131 "tracker-backend.vala"
	_g_free0 (_data_->uri);
#line 131 "tracker-backend.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 131 "tracker-backend.vala"
	if (_data_->_state_ != 0) {
#line 131 "tracker-backend.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 131 "tracker-backend.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1933 "tracker-backend.c"
		}
	}
#line 131 "tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 131 "tracker-backend.vala"
	return FALSE;
#line 1940 "tracker-backend.c"
}


static TrackerSparqlCursor*
tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base,
                                        GCancellable* cancellable,
                                        GError** error)
{
	TrackerSparqlBackend * self;
	TrackerSparqlCursor* result = NULL;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlCursor* _tmp2_ = NULL;
	TrackerSparqlConnection* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	TrackerSparqlCursor* _tmp5_;
	GError * _inner_error_ = NULL;
#line 140 "tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 141 "tracker-backend.vala"
	g_debug ("%s()", "Tracker.Sparql.Backend.statistics");
#line 142 "tracker-backend.vala"
	_tmp0_ = self->priv->bus;
#line 142 "tracker-backend.vala"
	if (_tmp0_ == NULL) {
#line 1965 "tracker-backend.c"
		GError* _tmp1_;
#line 143 "tracker-backend.vala"
		_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Statistics support not available for direct-only connection");
#line 143 "tracker-backend.vala"
		_inner_error_ = _tmp1_;
#line 143 "tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 143 "tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 143 "tracker-backend.vala"
			return NULL;
#line 1977 "tracker-backend.c"
		} else {
#line 143 "tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 143 "tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 143 "tracker-backend.vala"
			return NULL;
#line 1985 "tracker-backend.c"
		}
	}
#line 145 "tracker-backend.vala"
	_tmp3_ = self->priv->bus;
#line 145 "tracker-backend.vala"
	_tmp4_ = tracker_sparql_connection_statistics (_tmp3_, cancellable, &_inner_error_);
#line 145 "tracker-backend.vala"
	_tmp2_ = _tmp4_;
#line 145 "tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 145 "tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 145 "tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 145 "tracker-backend.vala"
			return NULL;
#line 2002 "tracker-backend.c"
		} else {
#line 145 "tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 145 "tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 145 "tracker-backend.vala"
			return NULL;
#line 2010 "tracker-backend.c"
		}
	}
#line 145 "tracker-backend.vala"
	_tmp5_ = _tmp2_;
#line 145 "tracker-backend.vala"
	_tmp2_ = NULL;
#line 145 "tracker-backend.vala"
	result = _tmp5_;
#line 145 "tracker-backend.vala"
	_g_object_unref0 (_tmp2_);
#line 145 "tracker-backend.vala"
	return result;
#line 2023 "tracker-backend.c"
}


static void
tracker_sparql_backend_real_statistics_async_data_free (gpointer _data)
{
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	_data_ = _data;
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->result);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 23 "tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendStatisticsAsyncData, _data_);
#line 2040 "tracker-backend.c"
}


static void
tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	TrackerSparqlBackend * self;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_;
	GCancellable* _tmp1_;
#line 23 "tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 23 "tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendStatisticsAsyncData);
#line 23 "tracker-backend.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 23 "tracker-backend.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_real_statistics_async_data_free);
#line 23 "tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "tracker-backend.vala"
	_data_->self = _tmp0_;
#line 23 "tracker-backend.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "tracker-backend.vala"
	_data_->cancellable = _tmp1_;
#line 23 "tracker-backend.vala"
	tracker_sparql_backend_real_statistics_async_co (_data_);
#line 2074 "tracker-backend.c"
}


static TrackerSparqlCursor*
tracker_sparql_backend_real_statistics_finish (TrackerSparqlConnection* base,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	TrackerSparqlCursor* result;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
#line 23 "tracker-backend.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 23 "tracker-backend.vala"
	if (NULL == _data_) {
#line 23 "tracker-backend.vala"
		return NULL;
#line 2091 "tracker-backend.c"
	}
#line 23 "tracker-backend.vala"
	result = _data_->result;
#line 23 "tracker-backend.vala"
	_data_->result = NULL;
#line 23 "tracker-backend.vala"
	return result;
#line 2099 "tracker-backend.c"
}


static void
tracker_sparql_backend_statistics_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	TrackerSparqlBackendStatisticsAsyncData* _data_;
#line 153 "tracker-backend.vala"
	_data_ = _user_data_;
#line 153 "tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 153 "tracker-backend.vala"
	_data_->_res_ = _res_;
#line 153 "tracker-backend.vala"
	tracker_sparql_backend_real_statistics_async_co (_data_);
#line 2117 "tracker-backend.c"
}


static gboolean
tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* _data_)
{
#line 148 "tracker-backend.vala"
	switch (_data_->_state_) {
#line 148 "tracker-backend.vala"
		case 0:
#line 2128 "tracker-backend.c"
		goto _state_0;
#line 148 "tracker-backend.vala"
		case 1:
#line 2132 "tracker-backend.c"
		goto _state_1;
		default:
#line 148 "tracker-backend.vala"
		g_assert_not_reached ();
#line 2137 "tracker-backend.c"
	}
	_state_0:
#line 149 "tracker-backend.vala"
	g_debug ("%s()", "Tracker.Sparql.Backend.statistics_async");
#line 150 "tracker-backend.vala"
	_data_->_tmp0_ = _data_->self->priv->bus;
#line 150 "tracker-backend.vala"
	if (_data_->_tmp0_ == NULL) {
#line 151 "tracker-backend.vala"
		_data_->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Statistics support not available for direct-only connection");
#line 151 "tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp1_;
#line 151 "tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 151 "tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 151 "tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 151 "tracker-backend.vala"
			return FALSE;
#line 2158 "tracker-backend.c"
		} else {
#line 151 "tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 151 "tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 151 "tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 151 "tracker-backend.vala"
			return FALSE;
#line 2168 "tracker-backend.c"
		}
	}
#line 153 "tracker-backend.vala"
	_data_->_tmp3_ = _data_->self->priv->bus;
#line 153 "tracker-backend.vala"
	_data_->_state_ = 1;
#line 153 "tracker-backend.vala"
	tracker_sparql_connection_statistics_async (_data_->_tmp3_, _data_->cancellable, tracker_sparql_backend_statistics_async_ready, _data_);
#line 153 "tracker-backend.vala"
	return FALSE;
#line 2179 "tracker-backend.c"
	_state_1:
#line 153 "tracker-backend.vala"
	_data_->_tmp4_ = tracker_sparql_connection_statistics_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 153 "tracker-backend.vala"
	_data_->_tmp2_ = _data_->_tmp4_;
#line 153 "tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 153 "tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 153 "tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 153 "tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 153 "tracker-backend.vala"
			return FALSE;
#line 2195 "tracker-backend.c"
		} else {
#line 153 "tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 153 "tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 153 "tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 153 "tracker-backend.vala"
			return FALSE;
#line 2205 "tracker-backend.c"
		}
	}
#line 153 "tracker-backend.vala"
	_data_->_tmp5_ = _data_->_tmp2_;
#line 153 "tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 153 "tracker-backend.vala"
	_data_->result = _data_->_tmp5_;
#line 153 "tracker-backend.vala"
	_g_object_unref0 (_data_->_tmp2_);
#line 153 "tracker-backend.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 153 "tracker-backend.vala"
	if (_data_->_state_ != 0) {
#line 153 "tracker-backend.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 153 "tracker-backend.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2224 "tracker-backend.c"
		}
	}
#line 153 "tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 153 "tracker-backend.vala"
	return FALSE;
#line 2231 "tracker-backend.c"
}


static TrackerNamespaceManager*
tracker_sparql_backend_real_get_namespace_manager (TrackerSparqlConnection* base)
{
	TrackerSparqlBackend * self;
	TrackerNamespaceManager* result = NULL;
	TrackerSparqlConnection* _tmp0_;
#line 156 "tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 157 "tracker-backend.vala"
	_tmp0_ = self->priv->direct;
#line 157 "tracker-backend.vala"
	if (_tmp0_ != NULL) {
#line 2247 "tracker-backend.c"
		TrackerSparqlConnection* _tmp1_;
		TrackerNamespaceManager* _tmp2_;
#line 158 "tracker-backend.vala"
		_tmp1_ = self->priv->direct;
#line 158 "tracker-backend.vala"
		_tmp2_ = tracker_sparql_connection_get_namespace_manager (_tmp1_);
#line 158 "tracker-backend.vala"
		result = _tmp2_;
#line 158 "tracker-backend.vala"
		return result;
#line 2258 "tracker-backend.c"
	} else {
		TrackerNamespaceManager* _tmp3_;
#line 160 "tracker-backend.vala"
		_tmp3_ = tracker_namespace_manager_get_default ();
#line 160 "tracker-backend.vala"
		result = _tmp3_;
#line 160 "tracker-backend.vala"
		return result;
#line 2267 "tracker-backend.c"
	}
}


static TrackerSparqlConnection*
tracker_sparql_backend_create_readonly_direct (TrackerSparqlBackend* self,
                                               GError** error)
{
	TrackerSparqlConnection* result = NULL;
	TrackerDirectConnection* conn = NULL;
	TrackerDomainOntology* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	TrackerDomainOntology* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	TrackerDomainOntology* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	TrackerDirectConnection* _tmp9_;
	TrackerDirectConnection* _tmp10_;
	TrackerDirectConnection* _tmp11_;
	GError * _inner_error_ = NULL;
#line 163 "tracker-backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 164 "tracker-backend.vala"
	_tmp0_ = domain_ontology;
#line 164 "tracker-backend.vala"
	_tmp1_ = tracker_domain_ontology_get_cache (_tmp0_);
#line 164 "tracker-backend.vala"
	_tmp2_ = _tmp1_;
#line 164 "tracker-backend.vala"
	_tmp3_ = domain_ontology;
#line 164 "tracker-backend.vala"
	_tmp4_ = tracker_domain_ontology_get_journal (_tmp3_);
#line 164 "tracker-backend.vala"
	_tmp5_ = _tmp4_;
#line 164 "tracker-backend.vala"
	_tmp6_ = domain_ontology;
#line 164 "tracker-backend.vala"
	_tmp7_ = tracker_domain_ontology_get_ontology (_tmp6_);
#line 164 "tracker-backend.vala"
	_tmp8_ = _tmp7_;
#line 164 "tracker-backend.vala"
	_tmp9_ = tracker_direct_connection_new (TRACKER_SPARQL_CONNECTION_FLAGS_READONLY, _tmp2_, _tmp5_, _tmp8_, &_inner_error_);
#line 164 "tracker-backend.vala"
	_tmp10_ = _tmp9_;
#line 164 "tracker-backend.vala"
	_g_object_unref0 (_tmp8_);
#line 164 "tracker-backend.vala"
	_g_object_unref0 (_tmp5_);
#line 164 "tracker-backend.vala"
	_g_object_unref0 (_tmp2_);
#line 164 "tracker-backend.vala"
	conn = _tmp10_;
#line 164 "tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 164 "tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 164 "tracker-backend.vala"
		return NULL;
#line 2329 "tracker-backend.c"
	}
#line 168 "tracker-backend.vala"
	_tmp11_ = conn;
#line 168 "tracker-backend.vala"
	g_initable_init ((GInitable*) _tmp11_, NULL, &_inner_error_);
#line 168 "tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 168 "tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 168 "tracker-backend.vala"
		_g_object_unref0 (conn);
#line 168 "tracker-backend.vala"
		return NULL;
#line 2343 "tracker-backend.c"
	}
#line 169 "tracker-backend.vala"
	result = (TrackerSparqlConnection*) conn;
#line 169 "tracker-backend.vala"
	return result;
#line 2349 "tracker-backend.c"
}


static void
tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self,
                                     GError** error)
{
	gchar* env_backend = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	TrackerSparqlBackendBackend backend = 0;
	const gchar* _tmp2_;
	TrackerSparqlBackendBackend _tmp6_;
	TrackerSparqlBackendBackend _tmp7_;
	GError * _inner_error_ = NULL;
#line 173 "tracker-backend.vala"
	g_return_if_fail (self != NULL);
#line 174 "tracker-backend.vala"
	_tmp0_ = g_getenv ("TRACKER_SPARQL_BACKEND");
#line 174 "tracker-backend.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 174 "tracker-backend.vala"
	env_backend = _tmp1_;
#line 175 "tracker-backend.vala"
	backend = TRACKER_SPARQL_BACKEND_BACKEND_AUTO;
#line 177 "tracker-backend.vala"
	_tmp2_ = env_backend;
#line 177 "tracker-backend.vala"
	if (_tmp2_ != NULL) {
#line 2379 "tracker-backend.c"
		const gchar* _tmp3_;
#line 178 "tracker-backend.vala"
		_tmp3_ = env_backend;
#line 178 "tracker-backend.vala"
		if (g_ascii_strcasecmp (_tmp3_, "direct") == 0) {
#line 179 "tracker-backend.vala"
			backend = TRACKER_SPARQL_BACKEND_BACKEND_DIRECT;
#line 180 "tracker-backend.vala"
			g_debug ("Using backend = 'DIRECT'");
#line 2389 "tracker-backend.c"
		} else {
			const gchar* _tmp4_;
#line 181 "tracker-backend.vala"
			_tmp4_ = env_backend;
#line 181 "tracker-backend.vala"
			if (g_ascii_strcasecmp (_tmp4_, "bus") == 0) {
#line 182 "tracker-backend.vala"
				backend = TRACKER_SPARQL_BACKEND_BACKEND_BUS;
#line 183 "tracker-backend.vala"
				g_debug ("Using backend = 'BUS'");
#line 2400 "tracker-backend.c"
			} else {
				const gchar* _tmp5_;
#line 185 "tracker-backend.vala"
				_tmp5_ = env_backend;
#line 185 "tracker-backend.vala"
				g_warning ("Environment variable TRACKER_SPARQL_BACKEND set to unknown value '%s'", _tmp5_);
#line 2407 "tracker-backend.c"
			}
		}
	}
#line 189 "tracker-backend.vala"
	_tmp6_ = backend;
#line 189 "tracker-backend.vala"
	if (_tmp6_ == TRACKER_SPARQL_BACKEND_BACKEND_AUTO) {
#line 190 "tracker-backend.vala"
		g_debug ("Using backend = 'AUTO'");
#line 2417 "tracker-backend.c"
	}
#line 193 "tracker-backend.vala"
	_tmp7_ = backend;
#line 193 "tracker-backend.vala"
	switch (_tmp7_) {
#line 193 "tracker-backend.vala"
		case TRACKER_SPARQL_BACKEND_BACKEND_AUTO:
#line 2425 "tracker-backend.c"
		{
			TrackerBusConnection* _tmp8_ = NULL;
			TrackerDomainOntology* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			TrackerBusConnection* _tmp12_;
			TrackerBusConnection* _tmp13_;
			TrackerBusConnection* _tmp14_;
#line 195 "tracker-backend.vala"
			_tmp9_ = domain_ontology;
#line 195 "tracker-backend.vala"
			_tmp10_ = tracker_domain_ontology_get_domain (_tmp9_, "Tracker1");
#line 195 "tracker-backend.vala"
			_tmp11_ = _tmp10_;
#line 195 "tracker-backend.vala"
			_tmp12_ = tracker_bus_connection_new (_tmp11_, &_inner_error_);
#line 195 "tracker-backend.vala"
			_tmp13_ = _tmp12_;
#line 195 "tracker-backend.vala"
			_g_free0 (_tmp11_);
#line 195 "tracker-backend.vala"
			_tmp8_ = _tmp13_;
#line 195 "tracker-backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 195 "tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 195 "tracker-backend.vala"
				_g_free0 (env_backend);
#line 195 "tracker-backend.vala"
				return;
#line 2456 "tracker-backend.c"
			}
#line 195 "tracker-backend.vala"
			_tmp14_ = _tmp8_;
#line 195 "tracker-backend.vala"
			_tmp8_ = NULL;
#line 195 "tracker-backend.vala"
			_g_object_unref0 (self->priv->bus);
#line 195 "tracker-backend.vala"
			self->priv->bus = (TrackerSparqlConnection*) _tmp14_;
#line 2466 "tracker-backend.c"
			{
				TrackerSparqlConnection* _tmp15_ = NULL;
				TrackerSparqlConnection* _tmp16_;
				TrackerSparqlConnection* _tmp17_;
#line 198 "tracker-backend.vala"
				_tmp16_ = tracker_sparql_backend_create_readonly_direct (self, &_inner_error_);
#line 198 "tracker-backend.vala"
				_tmp15_ = _tmp16_;
#line 198 "tracker-backend.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2477 "tracker-backend.c"
					goto __catch2_g_error;
				}
#line 198 "tracker-backend.vala"
				_tmp17_ = _tmp15_;
#line 198 "tracker-backend.vala"
				_tmp15_ = NULL;
#line 198 "tracker-backend.vala"
				_g_object_unref0 (self->priv->direct);
#line 198 "tracker-backend.vala"
				self->priv->direct = _tmp17_;
#line 197 "tracker-backend.vala"
				_g_object_unref0 (_tmp15_);
#line 2490 "tracker-backend.c"
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				GError* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
#line 197 "tracker-backend.vala"
				e = _inner_error_;
#line 197 "tracker-backend.vala"
				_inner_error_ = NULL;
#line 200 "tracker-backend.vala"
				_tmp18_ = e;
#line 200 "tracker-backend.vala"
				_tmp19_ = _tmp18_->message;
#line 200 "tracker-backend.vala"
				_tmp20_ = g_strconcat ("Falling back to bus backend, the direct backend failed to initialize: ", _tmp19_, NULL);
#line 200 "tracker-backend.vala"
				_tmp21_ = _tmp20_;
#line 200 "tracker-backend.vala"
				g_warning ("%s", _tmp21_);
#line 200 "tracker-backend.vala"
				_g_free0 (_tmp21_);
#line 197 "tracker-backend.vala"
				_g_error_free0 (e);
#line 2518 "tracker-backend.c"
			}
			__finally2:
#line 197 "tracker-backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 197 "tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 197 "tracker-backend.vala"
				_g_object_unref0 (_tmp8_);
#line 197 "tracker-backend.vala"
				_g_free0 (env_backend);
#line 197 "tracker-backend.vala"
				return;
#line 2531 "tracker-backend.c"
			}
#line 203 "tracker-backend.vala"
			_g_object_unref0 (_tmp8_);
#line 203 "tracker-backend.vala"
			break;
#line 2537 "tracker-backend.c"
		}
#line 193 "tracker-backend.vala"
		case TRACKER_SPARQL_BACKEND_BACKEND_DIRECT:
#line 2541 "tracker-backend.c"
		{
			TrackerSparqlConnection* _tmp22_ = NULL;
			TrackerSparqlConnection* _tmp23_;
			TrackerSparqlConnection* _tmp24_;
#line 206 "tracker-backend.vala"
			_tmp23_ = tracker_sparql_backend_create_readonly_direct (self, &_inner_error_);
#line 206 "tracker-backend.vala"
			_tmp22_ = _tmp23_;
#line 206 "tracker-backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 206 "tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 206 "tracker-backend.vala"
				_g_free0 (env_backend);
#line 206 "tracker-backend.vala"
				return;
#line 2558 "tracker-backend.c"
			}
#line 206 "tracker-backend.vala"
			_tmp24_ = _tmp22_;
#line 206 "tracker-backend.vala"
			_tmp22_ = NULL;
#line 206 "tracker-backend.vala"
			_g_object_unref0 (self->priv->direct);
#line 206 "tracker-backend.vala"
			self->priv->direct = _tmp24_;
#line 207 "tracker-backend.vala"
			_g_object_unref0 (_tmp22_);
#line 207 "tracker-backend.vala"
			break;
#line 2572 "tracker-backend.c"
		}
#line 193 "tracker-backend.vala"
		case TRACKER_SPARQL_BACKEND_BACKEND_BUS:
#line 2576 "tracker-backend.c"
		{
			TrackerBusConnection* _tmp25_ = NULL;
			TrackerDomainOntology* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			TrackerBusConnection* _tmp29_;
			TrackerBusConnection* _tmp30_;
			TrackerBusConnection* _tmp31_;
#line 210 "tracker-backend.vala"
			_tmp26_ = domain_ontology;
#line 210 "tracker-backend.vala"
			_tmp27_ = tracker_domain_ontology_get_domain (_tmp26_, "Tracker1");
#line 210 "tracker-backend.vala"
			_tmp28_ = _tmp27_;
#line 210 "tracker-backend.vala"
			_tmp29_ = tracker_bus_connection_new (_tmp28_, &_inner_error_);
#line 210 "tracker-backend.vala"
			_tmp30_ = _tmp29_;
#line 210 "tracker-backend.vala"
			_g_free0 (_tmp28_);
#line 210 "tracker-backend.vala"
			_tmp25_ = _tmp30_;
#line 210 "tracker-backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 210 "tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 210 "tracker-backend.vala"
				_g_free0 (env_backend);
#line 210 "tracker-backend.vala"
				return;
#line 2607 "tracker-backend.c"
			}
#line 210 "tracker-backend.vala"
			_tmp31_ = _tmp25_;
#line 210 "tracker-backend.vala"
			_tmp25_ = NULL;
#line 210 "tracker-backend.vala"
			_g_object_unref0 (self->priv->bus);
#line 210 "tracker-backend.vala"
			self->priv->bus = (TrackerSparqlConnection*) _tmp31_;
#line 211 "tracker-backend.vala"
			_g_object_unref0 (_tmp25_);
#line 211 "tracker-backend.vala"
			break;
#line 2621 "tracker-backend.c"
		}
		default:
		{
#line 214 "tracker-backend.vala"
			g_assert_not_reached ();
#line 2627 "tracker-backend.c"
		}
	}
#line 173 "tracker-backend.vala"
	_g_free0 (env_backend);
#line 2632 "tracker-backend.c"
}


static TrackerSparqlConnection*
tracker_sparql_backend_get (GCancellable* cancellable,
                            GError** error)
{
	TrackerSparqlConnection* result = NULL;
	GError * _inner_error_ = NULL;
#line 222 "tracker-backend.vala"
	g_mutex_lock (&tracker_sparql_backend_door);
#line 2644 "tracker-backend.c"
	{
		TrackerSparqlConnection* _result_ = NULL;
		TrackerSparqlConnection* _tmp0_;
		TrackerSparqlConnection* _tmp1_;
		TrackerSparqlConnection* _tmp2_;
#line 226 "tracker-backend.vala"
		_tmp0_ = tracker_sparql_backend_singleton;
#line 226 "tracker-backend.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 226 "tracker-backend.vala"
		_result_ = _tmp1_;
#line 228 "tracker-backend.vala"
		_tmp2_ = _result_;
#line 228 "tracker-backend.vala"
		if (_tmp2_ == NULL) {
#line 2660 "tracker-backend.c"
			TrackerSparqlBackend* _tmp3_ = NULL;
			TrackerSparqlBackend* _tmp4_;
			TrackerSparqlBackend* _tmp5_;
			gboolean _tmp6_ = FALSE;
			TrackerSparqlConnection* _tmp8_;
#line 229 "tracker-backend.vala"
			_tmp4_ = tracker_sparql_backend_new (&_inner_error_);
#line 229 "tracker-backend.vala"
			_tmp3_ = _tmp4_;
#line 229 "tracker-backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 229 "tracker-backend.vala"
				_g_object_unref0 (_result_);
#line 2674 "tracker-backend.c"
				goto __finally3;
			}
#line 229 "tracker-backend.vala"
			_tmp5_ = _tmp3_;
#line 229 "tracker-backend.vala"
			_tmp3_ = NULL;
#line 229 "tracker-backend.vala"
			_g_object_unref0 (_result_);
#line 229 "tracker-backend.vala"
			_result_ = (TrackerSparqlConnection*) _tmp5_;
#line 231 "tracker-backend.vala"
			if (cancellable != NULL) {
#line 231 "tracker-backend.vala"
				_tmp6_ = g_cancellable_is_cancelled (cancellable);
#line 2689 "tracker-backend.c"
			} else {
#line 231 "tracker-backend.vala"
				_tmp6_ = FALSE;
#line 2693 "tracker-backend.c"
			}
#line 231 "tracker-backend.vala"
			if (_tmp6_) {
#line 2697 "tracker-backend.c"
				GError* _tmp7_;
#line 232 "tracker-backend.vala"
				_tmp7_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 232 "tracker-backend.vala"
				_inner_error_ = _tmp7_;
#line 232 "tracker-backend.vala"
				_g_object_unref0 (_tmp3_);
#line 232 "tracker-backend.vala"
				_g_object_unref0 (_result_);
#line 2707 "tracker-backend.c"
				goto __finally3;
			}
#line 235 "tracker-backend.vala"
			_tmp8_ = _result_;
#line 235 "tracker-backend.vala"
			tracker_sparql_backend_singleton = _tmp8_;
#line 228 "tracker-backend.vala"
			_g_object_unref0 (_tmp3_);
#line 2716 "tracker-backend.c"
		}
#line 238 "tracker-backend.vala"
		result = _result_;
#line 2720 "tracker-backend.c"
		{
#line 240 "tracker-backend.vala"
			g_mutex_unlock (&tracker_sparql_backend_door);
#line 2724 "tracker-backend.c"
		}
#line 238 "tracker-backend.vala"
		return result;
#line 2728 "tracker-backend.c"
	}
	__finally3:
	{
#line 240 "tracker-backend.vala"
		g_mutex_unlock (&tracker_sparql_backend_door);
#line 2734 "tracker-backend.c"
	}
#line 224 "tracker-backend.vala"
	if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 224 "tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 224 "tracker-backend.vala"
		return NULL;
#line 2742 "tracker-backend.c"
	} else {
#line 224 "tracker-backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 224 "tracker-backend.vala"
		g_clear_error (&_inner_error_);
#line 224 "tracker-backend.vala"
		return NULL;
#line 2750 "tracker-backend.c"
	}
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 244 "tracker-backend.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 244 "tracker-backend.vala"
	return _data1_;
#line 2762 "tracker-backend.c"
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 244 "tracker-backend.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 244 "tracker-backend.vala"
		_g_object_unref0 (_data1_->async_result);
#line 244 "tracker-backend.vala"
		_g_main_loop_unref0 (_data1_->loop);
#line 244 "tracker-backend.vala"
		g_slice_free (Block1Data, _data1_);
#line 2779 "tracker-backend.c"
	}
}


static void
__lambda6_ (Block1Data* _data1_,
            GObject* obj,
            GAsyncResult* res)
{
	GAsyncResult* _tmp0_;
	GMainLoop* _tmp1_;
#line 257 "tracker-backend.vala"
	g_return_if_fail (res != NULL);
#line 258 "tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 258 "tracker-backend.vala"
	_g_object_unref0 (_data1_->async_result);
#line 258 "tracker-backend.vala"
	_data1_->async_result = _tmp0_;
#line 259 "tracker-backend.vala"
	_tmp1_ = _data1_->loop;
#line 259 "tracker-backend.vala"
	g_main_loop_quit (_tmp1_);
#line 2803 "tracker-backend.c"
}


static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 257 "tracker-backend.vala"
	__lambda6_ (self, source_object, res);
#line 257 "tracker-backend.vala"
	block1_data_unref (self);
#line 2816 "tracker-backend.c"
}


TrackerSparqlConnection*
tracker_sparql_backend_get_internal (GCancellable* cancellable,
                                     GError** error)
{
	TrackerSparqlConnection* result = NULL;
	Block1Data* _data1_;
	GMainContext* _tmp0_;
	GMainContext* context = NULL;
	GMainContext* _tmp4_;
	GMainContext* _tmp5_;
	GMainLoop* _tmp6_;
	GMainContext* _tmp7_;
	GMainLoop* _tmp8_;
	GMainContext* _tmp9_;
	TrackerSparqlConnection* _tmp10_ = NULL;
	GAsyncResult* _tmp11_;
	TrackerSparqlConnection* _tmp12_;
	TrackerSparqlConnection* _tmp13_;
	GError * _inner_error_ = NULL;
#line 244 "tracker-backend.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 244 "tracker-backend.vala"
	_data1_->_ref_count_ = 1;
#line 245 "tracker-backend.vala"
	_tmp0_ = g_main_context_get_thread_default ();
#line 245 "tracker-backend.vala"
	if (_tmp0_ == NULL) {
#line 2847 "tracker-backend.c"
		TrackerSparqlConnection* _tmp1_ = NULL;
		TrackerSparqlConnection* _tmp2_;
		TrackerSparqlConnection* _tmp3_;
#line 247 "tracker-backend.vala"
		_tmp2_ = tracker_sparql_backend_get (cancellable, &_inner_error_);
#line 247 "tracker-backend.vala"
		_tmp1_ = _tmp2_;
#line 247 "tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 247 "tracker-backend.vala"
			if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 247 "tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 247 "tracker-backend.vala"
				block1_data_unref (_data1_);
#line 247 "tracker-backend.vala"
				_data1_ = NULL;
#line 247 "tracker-backend.vala"
				return NULL;
#line 2867 "tracker-backend.c"
			} else {
#line 247 "tracker-backend.vala"
				block1_data_unref (_data1_);
#line 247 "tracker-backend.vala"
				_data1_ = NULL;
#line 247 "tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 247 "tracker-backend.vala"
				g_clear_error (&_inner_error_);
#line 247 "tracker-backend.vala"
				return NULL;
#line 2879 "tracker-backend.c"
			}
		}
#line 247 "tracker-backend.vala"
		_tmp3_ = _tmp1_;
#line 247 "tracker-backend.vala"
		_tmp1_ = NULL;
#line 247 "tracker-backend.vala"
		result = _tmp3_;
#line 247 "tracker-backend.vala"
		_g_object_unref0 (_tmp1_);
#line 247 "tracker-backend.vala"
		block1_data_unref (_data1_);
#line 247 "tracker-backend.vala"
		_data1_ = NULL;
#line 247 "tracker-backend.vala"
		return result;
#line 2896 "tracker-backend.c"
	}
#line 251 "tracker-backend.vala"
	_tmp4_ = g_main_context_new ();
#line 251 "tracker-backend.vala"
	context = _tmp4_;
#line 252 "tracker-backend.vala"
	_tmp5_ = context;
#line 252 "tracker-backend.vala"
	_tmp6_ = g_main_loop_new (_tmp5_, FALSE);
#line 252 "tracker-backend.vala"
	_data1_->loop = _tmp6_;
#line 253 "tracker-backend.vala"
	_data1_->async_result = NULL;
#line 255 "tracker-backend.vala"
	_tmp7_ = context;
#line 255 "tracker-backend.vala"
	g_main_context_push_thread_default (_tmp7_);
#line 257 "tracker-backend.vala"
	tracker_sparql_backend_get_internal_async (cancellable, ___lambda6__gasync_ready_callback, block1_data_ref (_data1_));
#line 262 "tracker-backend.vala"
	_tmp8_ = _data1_->loop;
#line 262 "tracker-backend.vala"
	g_main_loop_run (_tmp8_);
#line 264 "tracker-backend.vala"
	_tmp9_ = context;
#line 264 "tracker-backend.vala"
	g_main_context_pop_thread_default (_tmp9_);
#line 266 "tracker-backend.vala"
	_tmp11_ = _data1_->async_result;
#line 266 "tracker-backend.vala"
	_tmp12_ = tracker_sparql_backend_get_internal_finish (_tmp11_, &_inner_error_);
#line 266 "tracker-backend.vala"
	_tmp10_ = _tmp12_;
#line 266 "tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 266 "tracker-backend.vala"
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 266 "tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 266 "tracker-backend.vala"
			_g_main_context_unref0 (context);
#line 266 "tracker-backend.vala"
			block1_data_unref (_data1_);
#line 266 "tracker-backend.vala"
			_data1_ = NULL;
#line 266 "tracker-backend.vala"
			return NULL;
#line 2944 "tracker-backend.c"
		} else {
#line 266 "tracker-backend.vala"
			_g_main_context_unref0 (context);
#line 266 "tracker-backend.vala"
			block1_data_unref (_data1_);
#line 266 "tracker-backend.vala"
			_data1_ = NULL;
#line 266 "tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 266 "tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 266 "tracker-backend.vala"
			return NULL;
#line 2958 "tracker-backend.c"
		}
	}
#line 266 "tracker-backend.vala"
	_tmp13_ = _tmp10_;
#line 266 "tracker-backend.vala"
	_tmp10_ = NULL;
#line 266 "tracker-backend.vala"
	result = _tmp13_;
#line 266 "tracker-backend.vala"
	_g_object_unref0 (_tmp10_);
#line 266 "tracker-backend.vala"
	_g_main_context_unref0 (context);
#line 266 "tracker-backend.vala"
	block1_data_unref (_data1_);
#line 266 "tracker-backend.vala"
	_data1_ = NULL;
#line 266 "tracker-backend.vala"
	return result;
#line 2977 "tracker-backend.c"
}


static void
tracker_sparql_backend_get_internal_async_data_free (gpointer _data)
{
	TrackerSparqlBackendGetInternalAsyncData* _data_;
	_data_ = _data;
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->result);
#line 23 "tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendGetInternalAsyncData, _data_);
#line 2990 "tracker-backend.c"
}


void
tracker_sparql_backend_get_internal_async (GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	TrackerSparqlBackendGetInternalAsyncData* _data_;
	GCancellable* _tmp0_;
#line 23 "tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendGetInternalAsyncData);
#line 23 "tracker-backend.vala"
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
#line 23 "tracker-backend.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_backend_get_internal_async_data_free);
#line 23 "tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (cancellable);
#line 23 "tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 23 "tracker-backend.vala"
	_data_->cancellable = _tmp0_;
#line 23 "tracker-backend.vala"
	tracker_sparql_backend_get_internal_async_co (_data_);
#line 3015 "tracker-backend.c"
}


TrackerSparqlConnection*
tracker_sparql_backend_get_internal_finish (GAsyncResult* _res_,
                                            GError** error)
{
	TrackerSparqlConnection* result;
	TrackerSparqlBackendGetInternalAsyncData* _data_;
#line 23 "tracker-backend.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 23 "tracker-backend.vala"
	if (NULL == _data_) {
#line 23 "tracker-backend.vala"
		return NULL;
#line 3031 "tracker-backend.c"
	}
#line 23 "tracker-backend.vala"
	result = _data_->result;
#line 23 "tracker-backend.vala"
	_data_->result = NULL;
#line 23 "tracker-backend.vala"
	return result;
#line 3039 "tracker-backend.c"
}


static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 269 "tracker-backend.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 269 "tracker-backend.vala"
	return _data2_;
#line 3050 "tracker-backend.c"
}


static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 269 "tracker-backend.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 269 "tracker-backend.vala"
		_g_main_context_unref0 (_data2_->context);
#line 269 "tracker-backend.vala"
		_g_object_unref0 (_data2_->_result_);
#line 269 "tracker-backend.vala"
		_g_error_free0 (_data2_->spawn_error);
#line 269 "tracker-backend.vala"
		_g_error_free0 (_data2_->dbus_error);
#line 269 "tracker-backend.vala"
		_g_error_free0 (_data2_->io_error);
#line 269 "tracker-backend.vala"
		_g_error_free0 (_data2_->sparql_error);
#line 269 "tracker-backend.vala"
		_g_object_unref0 (_data2_->cancellable);
#line 269 "tracker-backend.vala"
		g_slice_free (Block2Data, _data2_);
#line 3077 "tracker-backend.c"
	}
}


static gpointer
_g_main_context_ref0 (gpointer self)
{
#line 288 "tracker-backend.vala"
	return self ? g_main_context_ref (self) : NULL;
#line 3087 "tracker-backend.c"
}


static gpointer
_g_error_copy0 (gpointer self)
{
#line 294 "tracker-backend.vala"
	return self ? g_error_copy (self) : NULL;
#line 3096 "tracker-backend.c"
}


static gboolean
__lambda5_ (Block2Data* _data2_)
{
	gboolean result = FALSE;
#line 305 "tracker-backend.vala"
	tracker_sparql_backend_get_internal_async_co (_data2_->_async_data_);
#line 306 "tracker-backend.vala"
	result = FALSE;
#line 306 "tracker-backend.vala"
	return result;
#line 3110 "tracker-backend.c"
}


static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ (self);
#line 304 "tracker-backend.vala"
	return result;
#line 3121 "tracker-backend.c"
}


static gboolean
__lambda4_ (Block2Data* _data2_,
            GIOSchedulerJob* job)
{
	gboolean result = FALSE;
	GSource* source = NULL;
	GSource* _tmp13_;
	GMainContext* _tmp14_;
	GError * _inner_error_ = NULL;
#line 290 "tracker-backend.vala"
	g_return_val_if_fail (job != NULL, FALSE);
#line 3136 "tracker-backend.c"
	{
		TrackerSparqlConnection* _tmp0_ = NULL;
		TrackerSparqlConnection* _tmp1_;
		TrackerSparqlConnection* _tmp3_;
#line 292 "tracker-backend.vala"
		_tmp1_ = tracker_sparql_backend_get (_data2_->cancellable, &_inner_error_);
#line 292 "tracker-backend.vala"
		_tmp0_ = _tmp1_;
#line 292 "tracker-backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3147 "tracker-backend.c"
			gboolean _tmp2_ = FALSE;
#line 292 "tracker-backend.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 3151 "tracker-backend.c"
				goto __catch4_g_io_error;
			}
#line 292 "tracker-backend.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3156 "tracker-backend.c"
				goto __catch4_tracker_sparql_error;
			}
#line 292 "tracker-backend.vala"
			if (_inner_error_->domain == G_DBUS_ERROR) {
#line 3161 "tracker-backend.c"
				goto __catch4_g_dbus_error;
			}
#line 292 "tracker-backend.vala"
			if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 3166 "tracker-backend.c"
				goto __catch4_g_spawn_error;
			}
#line 292 "tracker-backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 292 "tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 292 "tracker-backend.vala"
			return _tmp2_;
#line 3175 "tracker-backend.c"
		}
#line 292 "tracker-backend.vala"
		_tmp3_ = _tmp0_;
#line 292 "tracker-backend.vala"
		_tmp0_ = NULL;
#line 292 "tracker-backend.vala"
		_g_object_unref0 (_data2_->_result_);
#line 292 "tracker-backend.vala"
		_data2_->_result_ = _tmp3_;
#line 291 "tracker-backend.vala"
		_g_object_unref0 (_tmp0_);
#line 3187 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_g_io_error:
	{
		GError* e_io = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
#line 291 "tracker-backend.vala"
		e_io = _inner_error_;
#line 291 "tracker-backend.vala"
		_inner_error_ = NULL;
#line 294 "tracker-backend.vala"
		_tmp4_ = e_io;
#line 294 "tracker-backend.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 294 "tracker-backend.vala"
		_g_error_free0 (_data2_->io_error);
#line 294 "tracker-backend.vala"
		_data2_->io_error = _tmp5_;
#line 291 "tracker-backend.vala"
		_g_error_free0 (e_io);
#line 3209 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_tracker_sparql_error:
	{
		GError* e_spql = NULL;
		GError* _tmp6_;
		GError* _tmp7_;
#line 291 "tracker-backend.vala"
		e_spql = _inner_error_;
#line 291 "tracker-backend.vala"
		_inner_error_ = NULL;
#line 296 "tracker-backend.vala"
		_tmp6_ = e_spql;
#line 296 "tracker-backend.vala"
		_tmp7_ = _g_error_copy0 (_tmp6_);
#line 296 "tracker-backend.vala"
		_g_error_free0 (_data2_->sparql_error);
#line 296 "tracker-backend.vala"
		_data2_->sparql_error = _tmp7_;
#line 291 "tracker-backend.vala"
		_g_error_free0 (e_spql);
#line 3231 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_g_dbus_error:
	{
		GError* e_dbus = NULL;
		GError* _tmp8_;
		GError* _tmp9_;
#line 291 "tracker-backend.vala"
		e_dbus = _inner_error_;
#line 291 "tracker-backend.vala"
		_inner_error_ = NULL;
#line 298 "tracker-backend.vala"
		_tmp8_ = e_dbus;
#line 298 "tracker-backend.vala"
		_tmp9_ = _g_error_copy0 (_tmp8_);
#line 298 "tracker-backend.vala"
		_g_error_free0 (_data2_->dbus_error);
#line 298 "tracker-backend.vala"
		_data2_->dbus_error = _tmp9_;
#line 291 "tracker-backend.vala"
		_g_error_free0 (e_dbus);
#line 3253 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_g_spawn_error:
	{
		GError* e_spawn = NULL;
		GError* _tmp10_;
		GError* _tmp11_;
#line 291 "tracker-backend.vala"
		e_spawn = _inner_error_;
#line 291 "tracker-backend.vala"
		_inner_error_ = NULL;
#line 300 "tracker-backend.vala"
		_tmp10_ = e_spawn;
#line 300 "tracker-backend.vala"
		_tmp11_ = _g_error_copy0 (_tmp10_);
#line 300 "tracker-backend.vala"
		_g_error_free0 (_data2_->spawn_error);
#line 300 "tracker-backend.vala"
		_data2_->spawn_error = _tmp11_;
#line 291 "tracker-backend.vala"
		_g_error_free0 (e_spawn);
#line 3275 "tracker-backend.c"
	}
	__finally4:
#line 291 "tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3280 "tracker-backend.c"
		gboolean _tmp12_ = FALSE;
#line 291 "tracker-backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 291 "tracker-backend.vala"
		g_clear_error (&_inner_error_);
#line 291 "tracker-backend.vala"
		return _tmp12_;
#line 3288 "tracker-backend.c"
	}
#line 303 "tracker-backend.vala"
	_tmp13_ = g_idle_source_new ();
#line 303 "tracker-backend.vala"
	source = _tmp13_;
#line 304 "tracker-backend.vala"
	g_source_set_callback (source, ___lambda5__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 308 "tracker-backend.vala"
	_tmp14_ = _data2_->context;
#line 308 "tracker-backend.vala"
	g_source_attach (source, _tmp14_);
#line 310 "tracker-backend.vala"
	result = FALSE;
#line 310 "tracker-backend.vala"
	_g_source_unref0 (source);
#line 310 "tracker-backend.vala"
	return result;
#line 3306 "tracker-backend.c"
}


static gboolean
___lambda4__gio_scheduler_job_func (GIOSchedulerJob* job,
                                    GCancellable* cancellable,
                                    gpointer self)
{
	gboolean result;
	result = __lambda4_ (self, job);
#line 290 "tracker-backend.vala"
	return result;
#line 3319 "tracker-backend.c"
}


static gboolean
tracker_sparql_backend_get_internal_async_co (TrackerSparqlBackendGetInternalAsyncData* _data_)
{
#line 269 "tracker-backend.vala"
	switch (_data_->_state_) {
#line 269 "tracker-backend.vala"
		case 0:
#line 3330 "tracker-backend.c"
		goto _state_0;
#line 269 "tracker-backend.vala"
		case 1:
#line 3334 "tracker-backend.c"
		goto _state_1;
		default:
#line 269 "tracker-backend.vala"
		g_assert_not_reached ();
#line 3339 "tracker-backend.c"
	}
	_state_0:
#line 269 "tracker-backend.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 269 "tracker-backend.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 269 "tracker-backend.vala"
	_g_object_unref0 (_data_->_data2_->cancellable);
#line 269 "tracker-backend.vala"
	_data_->_data2_->cancellable = _data_->cancellable;
#line 269 "tracker-backend.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 271 "tracker-backend.vala"
	if (g_mutex_trylock (&tracker_sparql_backend_door)) {
#line 273 "tracker-backend.vala"
		_data_->_tmp0_ = tracker_sparql_backend_singleton;
#line 273 "tracker-backend.vala"
		_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
#line 273 "tracker-backend.vala"
		_data_->_result_ = _data_->_tmp1_;
#line 275 "tracker-backend.vala"
		g_mutex_unlock (&tracker_sparql_backend_door);
#line 277 "tracker-backend.vala"
		_data_->_tmp2_ = _data_->_result_;
#line 277 "tracker-backend.vala"
		if (_data_->_tmp2_ != NULL) {
#line 278 "tracker-backend.vala"
			_data_->result = _data_->_result_;
#line 278 "tracker-backend.vala"
			block2_data_unref (_data_->_data2_);
#line 278 "tracker-backend.vala"
			_data_->_data2_ = NULL;
#line 278 "tracker-backend.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 278 "tracker-backend.vala"
			if (_data_->_state_ != 0) {
#line 278 "tracker-backend.vala"
				while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 278 "tracker-backend.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3380 "tracker-backend.c"
				}
			}
#line 278 "tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 278 "tracker-backend.vala"
			return FALSE;
#line 3387 "tracker-backend.c"
		}
#line 271 "tracker-backend.vala"
		_g_object_unref0 (_data_->_result_);
#line 3391 "tracker-backend.c"
	}
#line 283 "tracker-backend.vala"
	_data_->_data2_->sparql_error = NULL;
#line 284 "tracker-backend.vala"
	_data_->_data2_->io_error = NULL;
#line 285 "tracker-backend.vala"
	_data_->_data2_->dbus_error = NULL;
#line 286 "tracker-backend.vala"
	_data_->_data2_->spawn_error = NULL;
#line 287 "tracker-backend.vala"
	_data_->_data2_->_result_ = NULL;
#line 288 "tracker-backend.vala"
	_data_->_tmp3_ = g_main_context_get_thread_default ();
#line 288 "tracker-backend.vala"
	_data_->_tmp4_ = _g_main_context_ref0 (_data_->_tmp3_);
#line 288 "tracker-backend.vala"
	_data_->_data2_->context = _data_->_tmp4_;
#line 290 "tracker-backend.vala"
	g_io_scheduler_push_job (___lambda4__gio_scheduler_job_func, block2_data_ref (_data_->_data2_), block2_data_unref, G_PRIORITY_DEFAULT, NULL);
#line 312 "tracker-backend.vala"
	_data_->_state_ = 1;
#line 312 "tracker-backend.vala"
	return FALSE;
#line 3415 "tracker-backend.c"
	_state_1:
	;
#line 314 "tracker-backend.vala"
	_data_->_tmp5_ = _data_->_data2_->sparql_error;
#line 314 "tracker-backend.vala"
	if (_data_->_tmp5_ != NULL) {
#line 315 "tracker-backend.vala"
		_data_->_tmp6_ = _data_->_data2_->sparql_error;
#line 315 "tracker-backend.vala"
		_data_->_tmp7_ = _g_error_copy0 (_data_->_tmp6_);
#line 315 "tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp7_;
#line 315 "tracker-backend.vala"
		if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 315 "tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 315 "tracker-backend.vala"
			block2_data_unref (_data_->_data2_);
#line 315 "tracker-backend.vala"
			_data_->_data2_ = NULL;
#line 315 "tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 315 "tracker-backend.vala"
			return FALSE;
#line 3440 "tracker-backend.c"
		} else {
#line 315 "tracker-backend.vala"
			block2_data_unref (_data_->_data2_);
#line 315 "tracker-backend.vala"
			_data_->_data2_ = NULL;
#line 315 "tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 315 "tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 315 "tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 315 "tracker-backend.vala"
			return FALSE;
#line 3454 "tracker-backend.c"
		}
	} else {
#line 316 "tracker-backend.vala"
		_data_->_tmp8_ = _data_->_data2_->io_error;
#line 316 "tracker-backend.vala"
		if (_data_->_tmp8_ != NULL) {
#line 317 "tracker-backend.vala"
			_data_->_tmp9_ = _data_->_data2_->io_error;
#line 317 "tracker-backend.vala"
			_data_->_tmp10_ = _g_error_copy0 (_data_->_tmp9_);
#line 317 "tracker-backend.vala"
			_data_->_inner_error_ = _data_->_tmp10_;
#line 317 "tracker-backend.vala"
			if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 317 "tracker-backend.vala"
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 317 "tracker-backend.vala"
				block2_data_unref (_data_->_data2_);
#line 317 "tracker-backend.vala"
				_data_->_data2_ = NULL;
#line 317 "tracker-backend.vala"
				g_object_unref (_data_->_async_result);
#line 317 "tracker-backend.vala"
				return FALSE;
#line 3479 "tracker-backend.c"
			} else {
#line 317 "tracker-backend.vala"
				block2_data_unref (_data_->_data2_);
#line 317 "tracker-backend.vala"
				_data_->_data2_ = NULL;
#line 317 "tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 317 "tracker-backend.vala"
				g_clear_error (&_data_->_inner_error_);
#line 317 "tracker-backend.vala"
				g_object_unref (_data_->_async_result);
#line 317 "tracker-backend.vala"
				return FALSE;
#line 3493 "tracker-backend.c"
			}
		} else {
#line 318 "tracker-backend.vala"
			_data_->_tmp11_ = _data_->_data2_->dbus_error;
#line 318 "tracker-backend.vala"
			if (_data_->_tmp11_ != NULL) {
#line 319 "tracker-backend.vala"
				_data_->_tmp12_ = _data_->_data2_->dbus_error;
#line 319 "tracker-backend.vala"
				_data_->_tmp13_ = _g_error_copy0 (_data_->_tmp12_);
#line 319 "tracker-backend.vala"
				_data_->_inner_error_ = _data_->_tmp13_;
#line 319 "tracker-backend.vala"
				if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 319 "tracker-backend.vala"
					g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 319 "tracker-backend.vala"
					block2_data_unref (_data_->_data2_);
#line 319 "tracker-backend.vala"
					_data_->_data2_ = NULL;
#line 319 "tracker-backend.vala"
					g_object_unref (_data_->_async_result);
#line 319 "tracker-backend.vala"
					return FALSE;
#line 3518 "tracker-backend.c"
				} else {
#line 319 "tracker-backend.vala"
					block2_data_unref (_data_->_data2_);
#line 319 "tracker-backend.vala"
					_data_->_data2_ = NULL;
#line 319 "tracker-backend.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 319 "tracker-backend.vala"
					g_clear_error (&_data_->_inner_error_);
#line 319 "tracker-backend.vala"
					g_object_unref (_data_->_async_result);
#line 319 "tracker-backend.vala"
					return FALSE;
#line 3532 "tracker-backend.c"
				}
			} else {
#line 320 "tracker-backend.vala"
				_data_->_tmp14_ = _data_->_data2_->spawn_error;
#line 320 "tracker-backend.vala"
				if (_data_->_tmp14_ != NULL) {
#line 321 "tracker-backend.vala"
					_data_->_tmp15_ = _data_->_data2_->spawn_error;
#line 321 "tracker-backend.vala"
					_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
#line 321 "tracker-backend.vala"
					_data_->_inner_error_ = _data_->_tmp16_;
#line 321 "tracker-backend.vala"
					if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 321 "tracker-backend.vala"
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 321 "tracker-backend.vala"
						block2_data_unref (_data_->_data2_);
#line 321 "tracker-backend.vala"
						_data_->_data2_ = NULL;
#line 321 "tracker-backend.vala"
						g_object_unref (_data_->_async_result);
#line 321 "tracker-backend.vala"
						return FALSE;
#line 3557 "tracker-backend.c"
					} else {
#line 321 "tracker-backend.vala"
						block2_data_unref (_data_->_data2_);
#line 321 "tracker-backend.vala"
						_data_->_data2_ = NULL;
#line 321 "tracker-backend.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 321 "tracker-backend.vala"
						g_clear_error (&_data_->_inner_error_);
#line 321 "tracker-backend.vala"
						g_object_unref (_data_->_async_result);
#line 321 "tracker-backend.vala"
						return FALSE;
#line 3571 "tracker-backend.c"
					}
				} else {
#line 323 "tracker-backend.vala"
					_data_->_tmp17_ = _data_->_data2_->_result_;
#line 323 "tracker-backend.vala"
					_data_->_tmp18_ = _g_object_ref0 (_data_->_tmp17_);
#line 323 "tracker-backend.vala"
					_data_->result = _data_->_tmp18_;
#line 323 "tracker-backend.vala"
					block2_data_unref (_data_->_data2_);
#line 323 "tracker-backend.vala"
					_data_->_data2_ = NULL;
#line 323 "tracker-backend.vala"
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 323 "tracker-backend.vala"
					if (_data_->_state_ != 0) {
#line 323 "tracker-backend.vala"
						while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 323 "tracker-backend.vala"
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3592 "tracker-backend.c"
						}
					}
#line 323 "tracker-backend.vala"
					g_object_unref (_data_->_async_result);
#line 323 "tracker-backend.vala"
					return FALSE;
#line 3599 "tracker-backend.c"
				}
			}
		}
	}
#line 269 "tracker-backend.vala"
	block2_data_unref (_data_->_data2_);
#line 269 "tracker-backend.vala"
	_data_->_data2_ = NULL;
#line 3608 "tracker-backend.c"
}


static void
tracker_sparql_backend_class_init (TrackerSparqlBackendClass * klass)
{
#line 23 "tracker-backend.vala"
	tracker_sparql_backend_parent_class = g_type_class_peek_parent (klass);
#line 23 "tracker-backend.vala"
	g_type_class_adjust_private_offset (klass, &TrackerSparqlBackend_private_offset);
#line 23 "tracker-backend.vala"
	((GObjectClass *) klass)->dispose = (void (*) (GObject *)) tracker_sparql_backend_real_dispose;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->query = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, const gchar*, GCancellable*, GError**)) tracker_sparql_backend_real_query;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->query_async = (void (*) (TrackerSparqlConnection *, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_query_async;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->query_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_backend_real_query_finish;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update = (void (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GError**)) tracker_sparql_backend_real_update;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank = (GVariant* (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GError**)) tracker_sparql_backend_real_update_blank;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_async = (void (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_update_async;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_finish = (void (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_backend_real_update_finish;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_async = (void (*) (TrackerSparqlConnection *, gchar**, int, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_update_array_async;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_finish = (GPtrArray* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_backend_real_update_array_finish;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_async = (void (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_update_blank_async;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_finish = (GVariant* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_backend_real_update_blank_finish;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->load = (void (*) (TrackerSparqlConnection *, GFile*, GCancellable*, GError**)) tracker_sparql_backend_real_load;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->load_async = (void (*) (TrackerSparqlConnection *, GFile*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_load_async;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->load_finish = (void (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_backend_real_load_finish;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, GCancellable*, GError**)) tracker_sparql_backend_real_statistics;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics_async = (void (*) (TrackerSparqlConnection *, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_backend_real_statistics_async;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_backend_real_statistics_finish;
#line 23 "tracker-backend.vala"
	((TrackerSparqlConnectionClass *) klass)->get_namespace_manager = (TrackerNamespaceManager* (*) (TrackerSparqlConnection *)) tracker_sparql_backend_real_get_namespace_manager;
#line 23 "tracker-backend.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_backend_finalize;
#line 3659 "tracker-backend.c"
}


static void
tracker_sparql_backend_instance_init (TrackerSparqlBackend * self)
{
#line 23 "tracker-backend.vala"
	self->priv = tracker_sparql_backend_get_instance_private (self);
#line 25 "tracker-backend.vala"
	self->priv->direct = NULL;
#line 26 "tracker-backend.vala"
	self->priv->bus = NULL;
#line 3672 "tracker-backend.c"
}


static void
tracker_sparql_backend_finalize (GObject * obj)
{
	TrackerSparqlBackend * self;
#line 23 "tracker-backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackend);
#line 25 "tracker-backend.vala"
	_g_object_unref0 (self->priv->direct);
#line 26 "tracker-backend.vala"
	_g_object_unref0 (self->priv->bus);
#line 23 "tracker-backend.vala"
	G_OBJECT_CLASS (tracker_sparql_backend_parent_class)->finalize (obj);
#line 3688 "tracker-backend.c"
}


GType
tracker_sparql_backend_get_type (void)
{
	static volatile gsize tracker_sparql_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlBackend), 0, (GInstanceInitFunc) tracker_sparql_backend_instance_init, NULL };
		GType tracker_sparql_backend_type_id;
		tracker_sparql_backend_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerSparqlBackend", &g_define_type_info, 0);
		TrackerSparqlBackend_private_offset = g_type_add_instance_private (tracker_sparql_backend_type_id, sizeof (TrackerSparqlBackendPrivate));
		g_once_init_leave (&tracker_sparql_backend_type_id__volatile, tracker_sparql_backend_type_id);
	}
	return tracker_sparql_backend_type_id__volatile;
}


static void
tracker_sparql_connection_get_async_data_free (gpointer _data)
{
	TrackerSparqlConnectionGetAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (TrackerSparqlConnectionGetAsyncData, _data_);
}


void
tracker_sparql_connection_get_async (GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	TrackerSparqlConnectionGetAsyncData* _data_;
	GCancellable* _tmp0_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionGetAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_get_async_data_free);
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp0_;
	tracker_sparql_connection_get_async_co (_data_);
}


TrackerSparqlConnection*
tracker_sparql_connection_get_finish (GAsyncResult* _res_,
                                      GError** error)
{
	TrackerSparqlConnection* result;
	TrackerSparqlConnectionGetAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void
tracker_sparql_connection_get_async_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	TrackerSparqlConnectionGetAsyncData* _data_;
#line 329 "tracker-backend.vala"
	_data_ = _user_data_;
#line 329 "tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 329 "tracker-backend.vala"
	_data_->_res_ = _res_;
#line 329 "tracker-backend.vala"
	tracker_sparql_connection_get_async_co (_data_);
#line 3765 "tracker-backend.c"
}


static gboolean
tracker_sparql_connection_get_async_co (TrackerSparqlConnectionGetAsyncData* _data_)
{
#line 328 "tracker-backend.vala"
	switch (_data_->_state_) {
#line 328 "tracker-backend.vala"
		case 0:
#line 3776 "tracker-backend.c"
		goto _state_0;
#line 328 "tracker-backend.vala"
		case 1:
#line 3780 "tracker-backend.c"
		goto _state_1;
		default:
#line 328 "tracker-backend.vala"
		g_assert_not_reached ();
#line 3785 "tracker-backend.c"
	}
	_state_0:
#line 329 "tracker-backend.vala"
	_data_->_state_ = 1;
#line 329 "tracker-backend.vala"
	tracker_sparql_backend_get_internal_async (_data_->cancellable, tracker_sparql_connection_get_async_ready, _data_);
#line 329 "tracker-backend.vala"
	return FALSE;
#line 3794 "tracker-backend.c"
	_state_1:
#line 329 "tracker-backend.vala"
	_data_->_tmp1_ = tracker_sparql_backend_get_internal_finish (_data_->_res_, &_data_->_inner_error_);
#line 329 "tracker-backend.vala"
	_data_->_tmp0_ = _data_->_tmp1_;
#line 329 "tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 329 "tracker-backend.vala"
		if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 329 "tracker-backend.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 329 "tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 329 "tracker-backend.vala"
			return FALSE;
#line 3810 "tracker-backend.c"
		} else {
#line 329 "tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 329 "tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 329 "tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 329 "tracker-backend.vala"
			return FALSE;
#line 3820 "tracker-backend.c"
		}
	}
#line 329 "tracker-backend.vala"
	_data_->_tmp2_ = _data_->_tmp0_;
#line 329 "tracker-backend.vala"
	_data_->_tmp0_ = NULL;
#line 329 "tracker-backend.vala"
	_data_->result = _data_->_tmp2_;
#line 329 "tracker-backend.vala"
	_g_object_unref0 (_data_->_tmp0_);
#line 329 "tracker-backend.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 329 "tracker-backend.vala"
	if (_data_->_state_ != 0) {
#line 329 "tracker-backend.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 329 "tracker-backend.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3839 "tracker-backend.c"
		}
	}
#line 329 "tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 329 "tracker-backend.vala"
	return FALSE;
#line 3846 "tracker-backend.c"
}


TrackerSparqlConnection*
tracker_sparql_connection_get (GCancellable* cancellable,
                               GError** error)
{
	TrackerSparqlConnection* result = NULL;
	TrackerSparqlConnection* _tmp0_ = NULL;
	TrackerSparqlConnection* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError * _inner_error_ = NULL;
#line 333 "tracker-backend.vala"
	_tmp1_ = tracker_sparql_backend_get_internal (cancellable, &_inner_error_);
#line 333 "tracker-backend.vala"
	_tmp0_ = _tmp1_;
#line 333 "tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 333 "tracker-backend.vala"
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 333 "tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 333 "tracker-backend.vala"
			return NULL;
#line 3871 "tracker-backend.c"
		} else {
#line 333 "tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 333 "tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 333 "tracker-backend.vala"
			return NULL;
#line 3879 "tracker-backend.c"
		}
	}
#line 333 "tracker-backend.vala"
	_tmp2_ = _tmp0_;
#line 333 "tracker-backend.vala"
	_tmp0_ = NULL;
#line 333 "tracker-backend.vala"
	result = _tmp2_;
#line 333 "tracker-backend.vala"
	_g_object_unref0 (_tmp0_);
#line 333 "tracker-backend.vala"
	return result;
#line 3892 "tracker-backend.c"
}


TrackerSparqlConnection*
tracker_sparql_connection_remote_new (const gchar* url_base)
{
	TrackerSparqlConnection* result = NULL;
	TrackerRemoteConnection* _tmp0_;
#line 336 "tracker-backend.vala"
	g_return_val_if_fail (url_base != NULL, NULL);
#line 337 "tracker-backend.vala"
	_tmp0_ = tracker_remote_connection_new (url_base);
#line 337 "tracker-backend.vala"
	result = (TrackerSparqlConnection*) _tmp0_;
#line 337 "tracker-backend.vala"
	return result;
#line 3909 "tracker-backend.c"
}


TrackerSparqlConnection*
tracker_sparql_connection_local_new (TrackerSparqlConnectionFlags flags,
                                     GFile* store,
                                     GFile* journal,
                                     GFile* ontology,
                                     GCancellable* cancellable,
                                     GError** error)
{
	TrackerSparqlConnection* result = NULL;
	TrackerDirectConnection* conn = NULL;
	TrackerDirectConnection* _tmp0_;
	TrackerDirectConnection* _tmp1_;
	GError * _inner_error_ = NULL;
#line 340 "tracker-backend.vala"
	g_return_val_if_fail (store != NULL, NULL);
#line 341 "tracker-backend.vala"
	_tmp0_ = tracker_direct_connection_new (flags, store, journal, ontology, &_inner_error_);
#line 341 "tracker-backend.vala"
	conn = _tmp0_;
#line 341 "tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 341 "tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 341 "tracker-backend.vala"
		return NULL;
#line 3938 "tracker-backend.c"
	}
#line 342 "tracker-backend.vala"
	_tmp1_ = conn;
#line 342 "tracker-backend.vala"
	g_initable_init ((GInitable*) _tmp1_, cancellable, &_inner_error_);
#line 342 "tracker-backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 342 "tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 342 "tracker-backend.vala"
		_g_object_unref0 (conn);
#line 342 "tracker-backend.vala"
		return NULL;
#line 3952 "tracker-backend.c"
	}
#line 343 "tracker-backend.vala"
	result = (TrackerSparqlConnection*) conn;
#line 343 "tracker-backend.vala"
	return result;
#line 3958 "tracker-backend.c"
}


static void
tracker_sparql_connection_local_new_async_data_free (gpointer _data)
{
	TrackerSparqlConnectionLocalNewAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->store);
	_g_object_unref0 (_data_->journal);
	_g_object_unref0 (_data_->ontology);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (TrackerSparqlConnectionLocalNewAsyncData, _data_);
}


void
tracker_sparql_connection_local_new_async (TrackerSparqlConnectionFlags flags,
                                           GFile* store,
                                           GFile* journal,
                                           GFile* ontology,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	TrackerSparqlConnectionLocalNewAsyncData* _data_;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GCancellable* _tmp3_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionLocalNewAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_local_new_async_data_free);
	_data_->flags = flags;
	_tmp0_ = _g_object_ref0 (store);
	_g_object_unref0 (_data_->store);
	_data_->store = _tmp0_;
	_tmp1_ = _g_object_ref0 (journal);
	_g_object_unref0 (_data_->journal);
	_data_->journal = _tmp1_;
	_tmp2_ = _g_object_ref0 (ontology);
	_g_object_unref0 (_data_->ontology);
	_data_->ontology = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	tracker_sparql_connection_local_new_async_co (_data_);
}


TrackerSparqlConnection*
tracker_sparql_connection_local_new_finish (GAsyncResult* _res_,
                                            GError** error)
{
	TrackerSparqlConnection* result;
	TrackerSparqlConnectionLocalNewAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean
tracker_sparql_connection_local_new_async_co (TrackerSparqlConnectionLocalNewAsyncData* _data_)
{
#line 346 "tracker-backend.vala"
	switch (_data_->_state_) {
#line 346 "tracker-backend.vala"
		case 0:
#line 4033 "tracker-backend.c"
		goto _state_0;
#line 346 "tracker-backend.vala"
		case 1:
#line 4037 "tracker-backend.c"
		goto _state_1;
		default:
#line 346 "tracker-backend.vala"
		g_assert_not_reached ();
#line 4042 "tracker-backend.c"
	}
	_state_0:
#line 347 "tracker-backend.vala"
	_data_->_tmp0_ = tracker_direct_connection_new (_data_->flags, _data_->store, _data_->journal, _data_->ontology, &_data_->_inner_error_);
#line 347 "tracker-backend.vala"
	_data_->conn = _data_->_tmp0_;
#line 347 "tracker-backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 347 "tracker-backend.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 347 "tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 347 "tracker-backend.vala"
		return FALSE;
#line 4057 "tracker-backend.c"
	}
#line 348 "tracker-backend.vala"
	g_async_initable_init_async ((GAsyncInitable*) _data_->conn, G_PRIORITY_DEFAULT, _data_->cancellable, NULL, NULL);
#line 349 "tracker-backend.vala"
	_data_->_state_ = 1;
#line 349 "tracker-backend.vala"
	return FALSE;
#line 4065 "tracker-backend.c"
	_state_1:
	;
#line 350 "tracker-backend.vala"
	_data_->result = (TrackerSparqlConnection*) _data_->conn;
#line 350 "tracker-backend.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 350 "tracker-backend.vala"
	if (_data_->_state_ != 0) {
#line 350 "tracker-backend.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 350 "tracker-backend.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4078 "tracker-backend.c"
		}
	}
#line 350 "tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 350 "tracker-backend.vala"
	return FALSE;
#line 4085 "tracker-backend.c"
}


void
tracker_sparql_connection_set_domain (const gchar* domain)
{
	const gchar* _tmp0_;
#line 354 "tracker-backend.vala"
	_tmp0_ = domain_name;
#line 354 "tracker-backend.vala"
	if (_tmp0_ == NULL) {
#line 4097 "tracker-backend.c"
		gchar* _tmp1_;
#line 355 "tracker-backend.vala"
		_tmp1_ = g_strdup (domain);
#line 355 "tracker-backend.vala"
		_g_free0 (domain_name);
#line 355 "tracker-backend.vala"
		domain_name = _tmp1_;
#line 4105 "tracker-backend.c"
	}
}


gchar*
tracker_sparql_connection_get_domain (void)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 359 "tracker-backend.vala"
	_tmp0_ = domain_name;
#line 359 "tracker-backend.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 359 "tracker-backend.vala"
	result = _tmp1_;
#line 359 "tracker-backend.vala"
	return result;
#line 4124 "tracker-backend.c"
}



