# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NodeDeactivationTask(Model):
    """The task representing the deactivation operation on the node.

    :param node_deactivation_task_id: Identity of the task related to
     deactivation operation on the node.
    :type node_deactivation_task_id:
     ~azure.servicefabric.models.NodeDeactivationTaskId
    :param node_deactivation_intent: The intent or the reason for deactivating
     the node. Following are the possible values for it. Possible values
     include: 'Invalid', 'Pause', 'Restart', 'RemoveData', 'RemoveNode'
    :type node_deactivation_intent: str or
     ~azure.servicefabric.models.NodeDeactivationIntent
    """

    _attribute_map = {
        'node_deactivation_task_id': {'key': 'NodeDeactivationTaskId', 'type': 'NodeDeactivationTaskId'},
        'node_deactivation_intent': {'key': 'NodeDeactivationIntent', 'type': 'str'},
    }

    def __init__(self, *, node_deactivation_task_id=None, node_deactivation_intent=None, **kwargs) -> None:
        super(NodeDeactivationTask, self).__init__(**kwargs)
        self.node_deactivation_task_id = node_deactivation_task_id
        self.node_deactivation_intent = node_deactivation_intent
