# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_only_resource import ProxyOnlyResource


class ProcessInfo(ProxyOnlyResource):
    """Process Information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar identifier: ARM Identifier for deployment.
    :vartype identifier: int
    :param deployment_name: Deployment name.
    :type deployment_name: str
    :param href: HRef URI.
    :type href: str
    :param minidump: Minidump URI.
    :type minidump: str
    :param is_profile_running: Is profile running?
    :type is_profile_running: bool
    :param is_iis_profile_running: Is the IIS Profile running?
    :type is_iis_profile_running: bool
    :param iis_profile_timeout_in_seconds: IIS Profile timeout (seconds).
    :type iis_profile_timeout_in_seconds: float
    :param parent: Parent process.
    :type parent: str
    :param children: Child process list.
    :type children: list[str]
    :param threads: Thread list.
    :type threads: list[~azure.mgmt.web.models.ProcessThreadInfo]
    :param open_file_handles: List of open files.
    :type open_file_handles: list[str]
    :param modules: List of modules.
    :type modules: list[~azure.mgmt.web.models.ProcessModuleInfo]
    :param file_name: File name of this process.
    :type file_name: str
    :param command_line: Command line.
    :type command_line: str
    :param user_name: User name.
    :type user_name: str
    :param handle_count: Handle count.
    :type handle_count: int
    :param module_count: Module count.
    :type module_count: int
    :param thread_count: Thread count.
    :type thread_count: int
    :param start_time: Start time.
    :type start_time: datetime
    :param total_cpu_time: Total CPU time.
    :type total_cpu_time: str
    :param user_cpu_time: User CPU time.
    :type user_cpu_time: str
    :param privileged_cpu_time: Privileged CPU time.
    :type privileged_cpu_time: str
    :param working_set: Working set.
    :type working_set: long
    :param peak_working_set: Peak working set.
    :type peak_working_set: long
    :param private_memory: Private memory size.
    :type private_memory: long
    :param virtual_memory: Virtual memory size.
    :type virtual_memory: long
    :param peak_virtual_memory: Peak virtual memory usage.
    :type peak_virtual_memory: long
    :param paged_system_memory: Paged system memory.
    :type paged_system_memory: long
    :param non_paged_system_memory: Non-paged system memory.
    :type non_paged_system_memory: long
    :param paged_memory: Paged memory.
    :type paged_memory: long
    :param peak_paged_memory: Peak paged memory.
    :type peak_paged_memory: long
    :param time_stamp: Time stamp.
    :type time_stamp: datetime
    :param environment_variables: List of environment variables.
    :type environment_variables: dict[str, str]
    :param is_scm_site: Is this the SCM site?
    :type is_scm_site: bool
    :param is_webjob: Is this a Web Job?
    :type is_webjob: bool
    :param description: Description of process.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identifier': {'key': 'properties.identifier', 'type': 'int'},
        'deployment_name': {'key': 'properties.deployment_name', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'minidump': {'key': 'properties.minidump', 'type': 'str'},
        'is_profile_running': {'key': 'properties.is_profile_running', 'type': 'bool'},
        'is_iis_profile_running': {'key': 'properties.is_iis_profile_running', 'type': 'bool'},
        'iis_profile_timeout_in_seconds': {'key': 'properties.iis_profile_timeout_in_seconds', 'type': 'float'},
        'parent': {'key': 'properties.parent', 'type': 'str'},
        'children': {'key': 'properties.children', 'type': '[str]'},
        'threads': {'key': 'properties.threads', 'type': '[ProcessThreadInfo]'},
        'open_file_handles': {'key': 'properties.open_file_handles', 'type': '[str]'},
        'modules': {'key': 'properties.modules', 'type': '[ProcessModuleInfo]'},
        'file_name': {'key': 'properties.file_name', 'type': 'str'},
        'command_line': {'key': 'properties.command_line', 'type': 'str'},
        'user_name': {'key': 'properties.user_name', 'type': 'str'},
        'handle_count': {'key': 'properties.handle_count', 'type': 'int'},
        'module_count': {'key': 'properties.module_count', 'type': 'int'},
        'thread_count': {'key': 'properties.thread_count', 'type': 'int'},
        'start_time': {'key': 'properties.start_time', 'type': 'iso-8601'},
        'total_cpu_time': {'key': 'properties.total_cpu_time', 'type': 'str'},
        'user_cpu_time': {'key': 'properties.user_cpu_time', 'type': 'str'},
        'privileged_cpu_time': {'key': 'properties.privileged_cpu_time', 'type': 'str'},
        'working_set': {'key': 'properties.working_set', 'type': 'long'},
        'peak_working_set': {'key': 'properties.peak_working_set', 'type': 'long'},
        'private_memory': {'key': 'properties.private_memory', 'type': 'long'},
        'virtual_memory': {'key': 'properties.virtual_memory', 'type': 'long'},
        'peak_virtual_memory': {'key': 'properties.peak_virtual_memory', 'type': 'long'},
        'paged_system_memory': {'key': 'properties.paged_system_memory', 'type': 'long'},
        'non_paged_system_memory': {'key': 'properties.non_paged_system_memory', 'type': 'long'},
        'paged_memory': {'key': 'properties.paged_memory', 'type': 'long'},
        'peak_paged_memory': {'key': 'properties.peak_paged_memory', 'type': 'long'},
        'time_stamp': {'key': 'properties.time_stamp', 'type': 'iso-8601'},
        'environment_variables': {'key': 'properties.environment_variables', 'type': '{str}'},
        'is_scm_site': {'key': 'properties.is_scm_site', 'type': 'bool'},
        'is_webjob': {'key': 'properties.is_webjob', 'type': 'bool'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProcessInfo, self).__init__(**kwargs)
        self.identifier = None
        self.deployment_name = kwargs.get('deployment_name', None)
        self.href = kwargs.get('href', None)
        self.minidump = kwargs.get('minidump', None)
        self.is_profile_running = kwargs.get('is_profile_running', None)
        self.is_iis_profile_running = kwargs.get('is_iis_profile_running', None)
        self.iis_profile_timeout_in_seconds = kwargs.get('iis_profile_timeout_in_seconds', None)
        self.parent = kwargs.get('parent', None)
        self.children = kwargs.get('children', None)
        self.threads = kwargs.get('threads', None)
        self.open_file_handles = kwargs.get('open_file_handles', None)
        self.modules = kwargs.get('modules', None)
        self.file_name = kwargs.get('file_name', None)
        self.command_line = kwargs.get('command_line', None)
        self.user_name = kwargs.get('user_name', None)
        self.handle_count = kwargs.get('handle_count', None)
        self.module_count = kwargs.get('module_count', None)
        self.thread_count = kwargs.get('thread_count', None)
        self.start_time = kwargs.get('start_time', None)
        self.total_cpu_time = kwargs.get('total_cpu_time', None)
        self.user_cpu_time = kwargs.get('user_cpu_time', None)
        self.privileged_cpu_time = kwargs.get('privileged_cpu_time', None)
        self.working_set = kwargs.get('working_set', None)
        self.peak_working_set = kwargs.get('peak_working_set', None)
        self.private_memory = kwargs.get('private_memory', None)
        self.virtual_memory = kwargs.get('virtual_memory', None)
        self.peak_virtual_memory = kwargs.get('peak_virtual_memory', None)
        self.paged_system_memory = kwargs.get('paged_system_memory', None)
        self.non_paged_system_memory = kwargs.get('non_paged_system_memory', None)
        self.paged_memory = kwargs.get('paged_memory', None)
        self.peak_paged_memory = kwargs.get('peak_paged_memory', None)
        self.time_stamp = kwargs.get('time_stamp', None)
        self.environment_variables = kwargs.get('environment_variables', None)
        self.is_scm_site = kwargs.get('is_scm_site', None)
        self.is_webjob = kwargs.get('is_webjob', None)
        self.description = kwargs.get('description', None)
