# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class HandlerMapping(Model):
    """The IIS handler mappings used to define which handler processes HTTP
    requests with certain extension.
    For example, it is used to configure php-cgi.exe process to handle all HTTP
    requests with *.php extension.

    :param extension: Requests with this extension will be handled using the
     specified FastCGI application.
    :type extension: str
    :param script_processor: The absolute path to the FastCGI application.
    :type script_processor: str
    :param arguments: Command-line arguments to be passed to the script
     processor.
    :type arguments: str
    """

    _attribute_map = {
        'extension': {'key': 'extension', 'type': 'str'},
        'script_processor': {'key': 'scriptProcessor', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': 'str'},
    }

    def __init__(self, *, extension: str=None, script_processor: str=None, arguments: str=None, **kwargs) -> None:
        super(HandlerMapping, self).__init__(**kwargs)
        self.extension = extension
        self.script_processor = script_processor
        self.arguments = arguments
