# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RunCommandParameterDefinition(Model):
    """Describes the properties of a run command parameter.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The run command parameter name.
    :type name: str
    :param type: Required. The run command parameter type.
    :type type: str
    :param default_value: The run command parameter default value.
    :type default_value: str
    :param required: The run command parameter required. Default value: False
     .
    :type required: bool
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
        'required': {'key': 'required', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(RunCommandParameterDefinition, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)
        self.default_value = kwargs.get('default_value', None)
        self.required = kwargs.get('required', False)
