# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UrlFileExtensionConditionParameters(Model):
    """Defines the parameters for the URL file extension condition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odatatype: Required.  Default value:
     "Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFileExtensionConditionParameters"
     .
    :vartype odatatype: str
    :param extensions: Required. A list of extensions for the condition of the
     delivery rule.
    :type extensions: list[str]
    """

    _validation = {
        'odatatype': {'required': True, 'constant': True},
        'extensions': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'extensions': {'key': 'extensions', 'type': '[str]'},
    }

    odatatype = "Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFileExtensionConditionParameters"

    def __init__(self, *, extensions, **kwargs) -> None:
        super(UrlFileExtensionConditionParameters, self).__init__(**kwargs)
        self.extensions = extensions
