# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CustomMpiSettings(Model):
    """Specifies the settings for a custom MPI job.

    All required parameters must be populated in order to send to Azure.

    :param command_line: Required. The program and program command line
     parameters to be executed by mpi runtime.
    :type command_line: str
    :param process_count: Number of processes parameter that is passed to MPI
     runtime. The default value for this property is equal to nodeCount
     property
    :type process_count: int
    """

    _validation = {
        'command_line': {'required': True},
    }

    _attribute_map = {
        'command_line': {'key': 'commandLine', 'type': 'str'},
        'process_count': {'key': 'processCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(CustomMpiSettings, self).__init__(**kwargs)
        self.command_line = kwargs.get('command_line', None)
        self.process_count = kwargs.get('process_count', None)
