package gdki

// ModifierType is a representation of GDK's GdkModifierType.
type ModifierType uint

var (
	GDK_SHIFT_MASK    ModifierType
	GDK_LOCK_MASK     ModifierType
	GDK_CONTROL_MASK  ModifierType
	GDK_MOD1_MASK     ModifierType
	GDK_MOD2_MASK     ModifierType
	GDK_MOD3_MASK     ModifierType
	GDK_MOD4_MASK     ModifierType
	GDK_MOD5_MASK     ModifierType
	GDK_BUTTON1_MASK  ModifierType
	GDK_BUTTON2_MASK  ModifierType
	GDK_BUTTON3_MASK  ModifierType
	GDK_BUTTON4_MASK  ModifierType
	GDK_BUTTON5_MASK  ModifierType
	GDK_SUPER_MASK    ModifierType
	GDK_HYPER_MASK    ModifierType
	GDK_META_MASK     ModifierType
	GDK_RELEASE_MASK  ModifierType
	GDK_MODIFIER_MASK ModifierType
)

var (
	KEY_VoidSymbol                  uint
	KEY_BackSpace                   uint
	KEY_Tab                         uint
	KEY_Linefeed                    uint
	KEY_Clear                       uint
	KEY_Return                      uint
	KEY_Pause                       uint
	KEY_Scroll_Lock                 uint
	KEY_Sys_Req                     uint
	KEY_Escape                      uint
	KEY_Delete                      uint
	KEY_Multi_key                   uint
	KEY_Codeinput                   uint
	KEY_SingleCandidate             uint
	KEY_MultipleCandidate           uint
	KEY_PreviousCandidate           uint
	KEY_Kanji                       uint
	KEY_Muhenkan                    uint
	KEY_Henkan_Mode                 uint
	KEY_Henkan                      uint
	KEY_Romaji                      uint
	KEY_Hiragana                    uint
	KEY_Katakana                    uint
	KEY_Hiragana_Katakana           uint
	KEY_Zenkaku                     uint
	KEY_Hankaku                     uint
	KEY_Zenkaku_Hankaku             uint
	KEY_Touroku                     uint
	KEY_Massyo                      uint
	KEY_Kana_Lock                   uint
	KEY_Kana_Shift                  uint
	KEY_Eisu_Shift                  uint
	KEY_Eisu_toggle                 uint
	KEY_Kanji_Bangou                uint
	KEY_Zen_Koho                    uint
	KEY_Mae_Koho                    uint
	KEY_Home                        uint
	KEY_Left                        uint
	KEY_Up                          uint
	KEY_Right                       uint
	KEY_Down                        uint
	KEY_Prior                       uint
	KEY_Page_Up                     uint
	KEY_Next                        uint
	KEY_Page_Down                   uint
	KEY_End                         uint
	KEY_Begin                       uint
	KEY_Select                      uint
	KEY_Print                       uint
	KEY_Execute                     uint
	KEY_Insert                      uint
	KEY_Undo                        uint
	KEY_Redo                        uint
	KEY_Menu                        uint
	KEY_Find                        uint
	KEY_Cancel                      uint
	KEY_Help                        uint
	KEY_Break                       uint
	KEY_Mode_switch                 uint
	KEY_script_switch               uint
	KEY_Num_Lock                    uint
	KEY_KP_Space                    uint
	KEY_KP_Tab                      uint
	KEY_KP_Enter                    uint
	KEY_KP_F1                       uint
	KEY_KP_F2                       uint
	KEY_KP_F3                       uint
	KEY_KP_F4                       uint
	KEY_KP_Home                     uint
	KEY_KP_Left                     uint
	KEY_KP_Up                       uint
	KEY_KP_Right                    uint
	KEY_KP_Down                     uint
	KEY_KP_Prior                    uint
	KEY_KP_Page_Up                  uint
	KEY_KP_Next                     uint
	KEY_KP_Page_Down                uint
	KEY_KP_End                      uint
	KEY_KP_Begin                    uint
	KEY_KP_Insert                   uint
	KEY_KP_Delete                   uint
	KEY_KP_Equal                    uint
	KEY_KP_Multiply                 uint
	KEY_KP_Add                      uint
	KEY_KP_Separator                uint
	KEY_KP_Subtract                 uint
	KEY_KP_Decimal                  uint
	KEY_KP_Divide                   uint
	KEY_KP_0                        uint
	KEY_KP_1                        uint
	KEY_KP_2                        uint
	KEY_KP_3                        uint
	KEY_KP_4                        uint
	KEY_KP_5                        uint
	KEY_KP_6                        uint
	KEY_KP_7                        uint
	KEY_KP_8                        uint
	KEY_KP_9                        uint
	KEY_F1                          uint
	KEY_F2                          uint
	KEY_F3                          uint
	KEY_F4                          uint
	KEY_F5                          uint
	KEY_F6                          uint
	KEY_F7                          uint
	KEY_F8                          uint
	KEY_F9                          uint
	KEY_F10                         uint
	KEY_F11                         uint
	KEY_L1                          uint
	KEY_F12                         uint
	KEY_L2                          uint
	KEY_F13                         uint
	KEY_L3                          uint
	KEY_F14                         uint
	KEY_L4                          uint
	KEY_F15                         uint
	KEY_L5                          uint
	KEY_F16                         uint
	KEY_L6                          uint
	KEY_F17                         uint
	KEY_L7                          uint
	KEY_F18                         uint
	KEY_L8                          uint
	KEY_F19                         uint
	KEY_L9                          uint
	KEY_F20                         uint
	KEY_L10                         uint
	KEY_F21                         uint
	KEY_R1                          uint
	KEY_F22                         uint
	KEY_R2                          uint
	KEY_F23                         uint
	KEY_R3                          uint
	KEY_F24                         uint
	KEY_R4                          uint
	KEY_F25                         uint
	KEY_R5                          uint
	KEY_F26                         uint
	KEY_R6                          uint
	KEY_F27                         uint
	KEY_R7                          uint
	KEY_F28                         uint
	KEY_R8                          uint
	KEY_F29                         uint
	KEY_R9                          uint
	KEY_F30                         uint
	KEY_R10                         uint
	KEY_F31                         uint
	KEY_R11                         uint
	KEY_F32                         uint
	KEY_R12                         uint
	KEY_F33                         uint
	KEY_R13                         uint
	KEY_F34                         uint
	KEY_R14                         uint
	KEY_F35                         uint
	KEY_R15                         uint
	KEY_Shift_L                     uint
	KEY_Shift_R                     uint
	KEY_Control_L                   uint
	KEY_Control_R                   uint
	KEY_Caps_Lock                   uint
	KEY_Shift_Lock                  uint
	KEY_Meta_L                      uint
	KEY_Meta_R                      uint
	KEY_Alt_L                       uint
	KEY_Alt_R                       uint
	KEY_Super_L                     uint
	KEY_Super_R                     uint
	KEY_Hyper_L                     uint
	KEY_Hyper_R                     uint
	KEY_ISO_Lock                    uint
	KEY_ISO_Level2_Latch            uint
	KEY_ISO_Level3_Shift            uint
	KEY_ISO_Level3_Latch            uint
	KEY_ISO_Level3_Lock             uint
	KEY_ISO_Level5_Shift            uint
	KEY_ISO_Level5_Latch            uint
	KEY_ISO_Level5_Lock             uint
	KEY_ISO_Group_Shift             uint
	KEY_ISO_Group_Latch             uint
	KEY_ISO_Group_Lock              uint
	KEY_ISO_Next_Group              uint
	KEY_ISO_Next_Group_Lock         uint
	KEY_ISO_Prev_Group              uint
	KEY_ISO_Prev_Group_Lock         uint
	KEY_ISO_First_Group             uint
	KEY_ISO_First_Group_Lock        uint
	KEY_ISO_Last_Group              uint
	KEY_ISO_Last_Group_Lock         uint
	KEY_ISO_Left_Tab                uint
	KEY_ISO_Move_Line_Up            uint
	KEY_ISO_Move_Line_Down          uint
	KEY_ISO_Partial_Line_Up         uint
	KEY_ISO_Partial_Line_Down       uint
	KEY_ISO_Partial_Space_Left      uint
	KEY_ISO_Partial_Space_Right     uint
	KEY_ISO_Set_Margin_Left         uint
	KEY_ISO_Set_Margin_Right        uint
	KEY_ISO_Release_Margin_Left     uint
	KEY_ISO_Release_Margin_Right    uint
	KEY_ISO_Release_Both_Margins    uint
	KEY_ISO_Fast_Cursor_Left        uint
	KEY_ISO_Fast_Cursor_Right       uint
	KEY_ISO_Fast_Cursor_Up          uint
	KEY_ISO_Fast_Cursor_Down        uint
	KEY_ISO_Continuous_Underline    uint
	KEY_ISO_Discontinuous_Underline uint
	KEY_ISO_Emphasize               uint
	KEY_ISO_Center_Object           uint
	KEY_ISO_Enter                   uint
	KEY_First_Virtual_Screen        uint
	KEY_Prev_Virtual_Screen         uint
	KEY_Next_Virtual_Screen         uint
	KEY_Last_Virtual_Screen         uint
	KEY_Terminate_Server            uint
	KEY_AccessX_Enable              uint
	KEY_AccessX_Feedback_Enable     uint
	KEY_RepeatKeys_Enable           uint
	KEY_SlowKeys_Enable             uint
	KEY_BounceKeys_Enable           uint
	KEY_StickyKeys_Enable           uint
	KEY_MouseKeys_Enable            uint
	KEY_MouseKeys_Accel_Enable      uint
	KEY_Overlay1_Enable             uint
	KEY_Overlay2_Enable             uint
	KEY_AudibleBell_Enable          uint
	KEY_Pointer_Left                uint
	KEY_Pointer_Right               uint
	KEY_Pointer_Up                  uint
	KEY_Pointer_Down                uint
	KEY_Pointer_UpLeft              uint
	KEY_Pointer_UpRight             uint
	KEY_Pointer_DownLeft            uint
	KEY_Pointer_DownRight           uint
	KEY_Pointer_Button_Dflt         uint
	KEY_Pointer_Button1             uint
	KEY_Pointer_Button2             uint
	KEY_Pointer_Button3             uint
	KEY_Pointer_Button4             uint
	KEY_Pointer_Button5             uint
	KEY_Pointer_DblClick_Dflt       uint
	KEY_Pointer_DblClick1           uint
	KEY_Pointer_DblClick2           uint
	KEY_Pointer_DblClick3           uint
	KEY_Pointer_DblClick4           uint
	KEY_Pointer_DblClick5           uint
	KEY_Pointer_Drag_Dflt           uint
	KEY_Pointer_Drag1               uint
	KEY_Pointer_Drag2               uint
	KEY_Pointer_Drag3               uint
	KEY_Pointer_Drag4               uint
	KEY_Pointer_Drag5               uint
	KEY_Pointer_EnableKeys          uint
	KEY_Pointer_Accelerate          uint
	KEY_Pointer_DfltBtnNext         uint
	KEY_Pointer_DfltBtnPrev         uint
	KEY_space                       uint
	KEY_exclam                      uint
	KEY_quotedbl                    uint
	KEY_numbersign                  uint
	KEY_dollar                      uint
	KEY_percent                     uint
	KEY_ampersand                   uint
	KEY_apostrophe                  uint
	KEY_quoteright                  uint
	KEY_parenleft                   uint
	KEY_parenright                  uint
	KEY_asterisk                    uint
	KEY_plus                        uint
	KEY_comma                       uint
	KEY_minus                       uint
	KEY_period                      uint
	KEY_slash                       uint
	KEY_0                           uint
	KEY_1                           uint
	KEY_2                           uint
	KEY_3                           uint
	KEY_4                           uint
	KEY_5                           uint
	KEY_6                           uint
	KEY_7                           uint
	KEY_8                           uint
	KEY_9                           uint
	KEY_colon                       uint
	KEY_semicolon                   uint
	KEY_less                        uint
	KEY_equal                       uint
	KEY_greater                     uint
	KEY_question                    uint
	KEY_at                          uint
	KEY_A                           uint
	KEY_B                           uint
	KEY_C                           uint
	KEY_D                           uint
	KEY_E                           uint
	KEY_F                           uint
	KEY_G                           uint
	KEY_H                           uint
	KEY_I                           uint
	KEY_J                           uint
	KEY_K                           uint
	KEY_L                           uint
	KEY_M                           uint
	KEY_N                           uint
	KEY_O                           uint
	KEY_P                           uint
	KEY_Q                           uint
	KEY_R                           uint
	KEY_S                           uint
	KEY_T                           uint
	KEY_U                           uint
	KEY_V                           uint
	KEY_W                           uint
	KEY_X                           uint
	KEY_Y                           uint
	KEY_Z                           uint
	KEY_bracketleft                 uint
	KEY_backslash                   uint
	KEY_bracketright                uint
	KEY_asciicircum                 uint
	KEY_underscore                  uint
	KEY_grave                       uint
	KEY_quoteleft                   uint
	KEY_a                           uint
	KEY_b                           uint
	KEY_c                           uint
	KEY_d                           uint
	KEY_e                           uint
	KEY_f                           uint
	KEY_g                           uint
	KEY_h                           uint
	KEY_i                           uint
	KEY_j                           uint
	KEY_k                           uint
	KEY_l                           uint
	KEY_m                           uint
	KEY_n                           uint
	KEY_o                           uint
	KEY_p                           uint
	KEY_q                           uint
	KEY_r                           uint
	KEY_s                           uint
	KEY_t                           uint
	KEY_u                           uint
	KEY_v                           uint
	KEY_w                           uint
	KEY_x                           uint
	KEY_y                           uint
	KEY_z                           uint
	KEY_braceleft                   uint
	KEY_bar                         uint
	KEY_braceright                  uint
	KEY_asciitilde                  uint
	KEY_nobreakspace                uint
	KEY_exclamdown                  uint
	KEY_cent                        uint
	KEY_sterling                    uint
	KEY_currency                    uint
	KEY_yen                         uint
	KEY_brokenbar                   uint
	KEY_section                     uint
	KEY_diaeresis                   uint
	KEY_copyright                   uint
	KEY_ordfeminine                 uint
	KEY_guillemotleft               uint
	KEY_notsign                     uint
	KEY_hyphen                      uint
	KEY_registered                  uint
	KEY_macron                      uint
	KEY_degree                      uint
	KEY_plusminus                   uint
	KEY_twosuperior                 uint
	KEY_threesuperior               uint
	KEY_acute                       uint
	KEY_mu                          uint
	KEY_paragraph                   uint
	KEY_periodcentered              uint
	KEY_cedilla                     uint
	KEY_onesuperior                 uint
	KEY_masculine                   uint
	KEY_guillemotright              uint
	KEY_onequarter                  uint
	KEY_onehalf                     uint
	KEY_threequarters               uint
	KEY_questiondown                uint
	KEY_Agrave                      uint
	KEY_Aacute                      uint
	KEY_Acircumflex                 uint
	KEY_Atilde                      uint
	KEY_Adiaeresis                  uint
	KEY_Aring                       uint
	KEY_AE                          uint
	KEY_Ccedilla                    uint
	KEY_Egrave                      uint
	KEY_Eacute                      uint
	KEY_Ecircumflex                 uint
	KEY_Ediaeresis                  uint
	KEY_Igrave                      uint
	KEY_Iacute                      uint
	KEY_Icircumflex                 uint
	KEY_Idiaeresis                  uint
	KEY_ETH                         uint
	KEY_Eth                         uint
	KEY_Ntilde                      uint
	KEY_Ograve                      uint
	KEY_Oacute                      uint
	KEY_Ocircumflex                 uint
	KEY_Otilde                      uint
	KEY_Odiaeresis                  uint
	KEY_multiply                    uint
	KEY_Oslash                      uint
	KEY_Ooblique                    uint
	KEY_Ugrave                      uint
	KEY_Uacute                      uint
	KEY_Ucircumflex                 uint
	KEY_Udiaeresis                  uint
	KEY_Yacute                      uint
	KEY_THORN                       uint
	KEY_Thorn                       uint
	KEY_ssharp                      uint
	KEY_agrave                      uint
	KEY_aacute                      uint
	KEY_acircumflex                 uint
	KEY_atilde                      uint
	KEY_adiaeresis                  uint
	KEY_aring                       uint
	KEY_ae                          uint
	KEY_ccedilla                    uint
	KEY_egrave                      uint
	KEY_eacute                      uint
	KEY_ecircumflex                 uint
	KEY_ediaeresis                  uint
	KEY_igrave                      uint
	KEY_iacute                      uint
	KEY_icircumflex                 uint
	KEY_idiaeresis                  uint
	KEY_eth                         uint
	KEY_ntilde                      uint
	KEY_ograve                      uint
	KEY_oacute                      uint
	KEY_ocircumflex                 uint
	KEY_otilde                      uint
	KEY_odiaeresis                  uint
	KEY_division                    uint
	KEY_oslash                      uint
	KEY_ooblique                    uint
	KEY_ugrave                      uint
	KEY_uacute                      uint
	KEY_ucircumflex                 uint
	KEY_udiaeresis                  uint
	KEY_yacute                      uint
	KEY_thorn                       uint
	KEY_ydiaeresis                  uint
	KEY_Aogonek                     uint
	KEY_breve                       uint
	KEY_Lstroke                     uint
	KEY_Lcaron                      uint
	KEY_Sacute                      uint
	KEY_Scaron                      uint
	KEY_Scedilla                    uint
	KEY_Tcaron                      uint
	KEY_Zacute                      uint
	KEY_Zcaron                      uint
	KEY_Zabovedot                   uint
	KEY_aogonek                     uint
	KEY_ogonek                      uint
	KEY_lstroke                     uint
	KEY_lcaron                      uint
	KEY_sacute                      uint
	KEY_caron                       uint
	KEY_scaron                      uint
	KEY_scedilla                    uint
	KEY_tcaron                      uint
	KEY_zacute                      uint
	KEY_doubleacute                 uint
	KEY_zcaron                      uint
	KEY_zabovedot                   uint
	KEY_Racute                      uint
	KEY_Abreve                      uint
	KEY_Lacute                      uint
	KEY_Cacute                      uint
	KEY_Ccaron                      uint
	KEY_Eogonek                     uint
	KEY_Ecaron                      uint
	KEY_Dcaron                      uint
	KEY_Dstroke                     uint
	KEY_Nacute                      uint
	KEY_Ncaron                      uint
	KEY_Odoubleacute                uint
	KEY_Rcaron                      uint
	KEY_Uring                       uint
	KEY_Udoubleacute                uint
	KEY_Tcedilla                    uint
	KEY_racute                      uint
	KEY_abreve                      uint
	KEY_lacute                      uint
	KEY_cacute                      uint
	KEY_ccaron                      uint
	KEY_eogonek                     uint
	KEY_ecaron                      uint
	KEY_dcaron                      uint
	KEY_dstroke                     uint
	KEY_nacute                      uint
	KEY_ncaron                      uint
	KEY_odoubleacute                uint
	KEY_rcaron                      uint
	KEY_uring                       uint
	KEY_udoubleacute                uint
	KEY_tcedilla                    uint
	KEY_abovedot                    uint
	KEY_Hstroke                     uint
	KEY_Hcircumflex                 uint
	KEY_Iabovedot                   uint
	KEY_Gbreve                      uint
	KEY_Jcircumflex                 uint
	KEY_hstroke                     uint
	KEY_hcircumflex                 uint
	KEY_idotless                    uint
	KEY_gbreve                      uint
	KEY_jcircumflex                 uint
	KEY_Cabovedot                   uint
	KEY_Ccircumflex                 uint
	KEY_Gabovedot                   uint
	KEY_Gcircumflex                 uint
	KEY_Ubreve                      uint
	KEY_Scircumflex                 uint
	KEY_cabovedot                   uint
	KEY_ccircumflex                 uint
	KEY_gabovedot                   uint
	KEY_gcircumflex                 uint
	KEY_ubreve                      uint
	KEY_scircumflex                 uint
	KEY_kra                         uint
	KEY_kappa                       uint
	KEY_Rcedilla                    uint
	KEY_Itilde                      uint
	KEY_Lcedilla                    uint
	KEY_Emacron                     uint
	KEY_Gcedilla                    uint
	KEY_Tslash                      uint
	KEY_rcedilla                    uint
	KEY_itilde                      uint
	KEY_lcedilla                    uint
	KEY_emacron                     uint
	KEY_gcedilla                    uint
	KEY_tslash                      uint
	KEY_ENG                         uint
	KEY_eng                         uint
	KEY_Amacron                     uint
	KEY_Iogonek                     uint
	KEY_Eabovedot                   uint
	KEY_Imacron                     uint
	KEY_Ncedilla                    uint
	KEY_Omacron                     uint
	KEY_Kcedilla                    uint
	KEY_Uogonek                     uint
	KEY_Utilde                      uint
	KEY_Umacron                     uint
	KEY_amacron                     uint
	KEY_iogonek                     uint
	KEY_eabovedot                   uint
	KEY_imacron                     uint
	KEY_ncedilla                    uint
	KEY_omacron                     uint
	KEY_kcedilla                    uint
	KEY_uogonek                     uint
	KEY_utilde                      uint
	KEY_umacron                     uint
	KEY_Wcircumflex                 uint
	KEY_wcircumflex                 uint
	KEY_Ycircumflex                 uint
	KEY_ycircumflex                 uint
	KEY_Babovedot                   uint
	KEY_babovedot                   uint
	KEY_Dabovedot                   uint
	KEY_dabovedot                   uint
	KEY_Fabovedot                   uint
	KEY_fabovedot                   uint
	KEY_Mabovedot                   uint
	KEY_mabovedot                   uint
	KEY_Pabovedot                   uint
	KEY_pabovedot                   uint
	KEY_Sabovedot                   uint
	KEY_sabovedot                   uint
	KEY_Tabovedot                   uint
	KEY_tabovedot                   uint
	KEY_Wgrave                      uint
	KEY_wgrave                      uint
	KEY_Wacute                      uint
	KEY_wacute                      uint
	KEY_Wdiaeresis                  uint
	KEY_wdiaeresis                  uint
	KEY_Ygrave                      uint
	KEY_ygrave                      uint
	KEY_OE                          uint
	KEY_oe                          uint
	KEY_Ydiaeresis                  uint
	KEY_overline                    uint
)
