// Code generated by "./generator ./org.freedesktop.udisks2"; DO NOT EDIT.

package udisks2

import (
	"errors"
	"unsafe"

	"github.com/godbus/dbus"
	"github.com/linuxdeepin/go-dbus-factory/object_manager"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type UDisks interface {
	object_manager.ObjectManager // interface org.freedesktop.DBus.ObjectManager
	proxy.Object
}

type objectUDisks struct {
	object_manager.InterfaceObjectManager // interface org.freedesktop.DBus.ObjectManager
	proxy.ImplObject
}

func NewUDisks(conn *dbus.Conn) UDisks {
	obj := new(objectUDisks)
	obj.ImplObject.Init_(conn, "org.freedesktop.UDisks2", "/org/freedesktop/UDisks2")
	return obj
}

type Manager interface {
	manager // interface org.freedesktop.UDisks2.Manager
	proxy.Object
}

type objectManager struct {
	interfaceManager // interface org.freedesktop.UDisks2.Manager
	proxy.ImplObject
}

func NewManager(conn *dbus.Conn) Manager {
	obj := new(objectManager)
	obj.ImplObject.Init_(conn, "org.freedesktop.UDisks2", "/org/freedesktop/UDisks2/Manager")
	return obj
}

type manager interface {
	GoLoopSetup(flags dbus.Flags, ch chan *dbus.Call, fd dbus.UnixFD, options map[string]dbus.Variant) *dbus.Call
	LoopSetup(flags dbus.Flags, fd dbus.UnixFD, options map[string]dbus.Variant) (dbus.ObjectPath, error)
	GoMDRaidCreate(flags dbus.Flags, ch chan *dbus.Call, blocks []dbus.ObjectPath, level string, name string, chunk uint64, options map[string]dbus.Variant) *dbus.Call
	MDRaidCreate(flags dbus.Flags, blocks []dbus.ObjectPath, level string, name string, chunk uint64, options map[string]dbus.Variant) (dbus.ObjectPath, error)
	Version() proxy.PropString
}

type interfaceManager struct{}

func (v *interfaceManager) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceManager) GetInterfaceName_() string {
	return "org.freedesktop.UDisks2.Manager"
}

// method LoopSetup

func (v *interfaceManager) GoLoopSetup(flags dbus.Flags, ch chan *dbus.Call, fd dbus.UnixFD, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".LoopSetup", flags, ch, fd, options)
}

func (*interfaceManager) StoreLoopSetup(call *dbus.Call) (resulting_device dbus.ObjectPath, err error) {
	err = call.Store(&resulting_device)
	return
}

func (v *interfaceManager) LoopSetup(flags dbus.Flags, fd dbus.UnixFD, options map[string]dbus.Variant) (dbus.ObjectPath, error) {
	return v.StoreLoopSetup(
		<-v.GoLoopSetup(flags, make(chan *dbus.Call, 1), fd, options).Done)
}

// method MDRaidCreate

func (v *interfaceManager) GoMDRaidCreate(flags dbus.Flags, ch chan *dbus.Call, blocks []dbus.ObjectPath, level string, name string, chunk uint64, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".MDRaidCreate", flags, ch, blocks, level, name, chunk, options)
}

func (*interfaceManager) StoreMDRaidCreate(call *dbus.Call) (resulting_array dbus.ObjectPath, err error) {
	err = call.Store(&resulting_array)
	return
}

func (v *interfaceManager) MDRaidCreate(flags dbus.Flags, blocks []dbus.ObjectPath, level string, name string, chunk uint64, options map[string]dbus.Variant) (dbus.ObjectPath, error) {
	return v.StoreMDRaidCreate(
		<-v.GoMDRaidCreate(flags, make(chan *dbus.Call, 1), blocks, level, name, chunk, options).Done)
}

// property Version s

func (v *interfaceManager) Version() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Version",
	}
}

type Drive interface {
	Drive() drive       // interface org.freedesktop.UDisks2.Drive
	DriveAta() driveAta // interface org.freedesktop.UDisks2.Drive.Ata
	proxy.Object
}

type objectDrive struct {
	interfaceDrive    // interface org.freedesktop.UDisks2.Drive
	interfaceDriveAta // interface org.freedesktop.UDisks2.Drive.Ata
	proxy.ImplObject
}

func NewDrive(conn *dbus.Conn, path dbus.ObjectPath) (Drive, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectDrive)
	obj.ImplObject.Init_(conn, "org.freedesktop.UDisks2", path)
	return obj, nil
}

func (obj *objectDrive) Drive() drive {
	return &obj.interfaceDrive
}

type drive interface {
	GoEject(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	Eject(flags dbus.Flags, options map[string]dbus.Variant) error
	GoSetConfiguration(flags dbus.Flags, ch chan *dbus.Call, value map[string]dbus.Variant, options map[string]dbus.Variant) *dbus.Call
	SetConfiguration(flags dbus.Flags, value map[string]dbus.Variant, options map[string]dbus.Variant) error
	GoPowerOff(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	PowerOff(flags dbus.Flags, options map[string]dbus.Variant) error
	Vendor() proxy.PropString
	Model() proxy.PropString
	Revision() proxy.PropString
	Serial() proxy.PropString
	WWN() proxy.PropString
	Id() proxy.PropString
	Configuration() PropDriveConfiguration
	Media() proxy.PropString
	MediaCompatibility() proxy.PropStringArray
	MediaRemovable() proxy.PropBool
	MediaAvailable() proxy.PropBool
	MediaChangeDetected() proxy.PropBool
	Size() proxy.PropUint64
	TimeDetected() proxy.PropUint64
	TimeMediaDetected() proxy.PropUint64
	Optical() proxy.PropBool
	OpticalBlank() proxy.PropBool
	OpticalNumTracks() proxy.PropUint32
	OpticalNumAudioTracks() proxy.PropUint32
	OpticalNumDataTracks() proxy.PropUint32
	OpticalNumSessions() proxy.PropUint32
	RotationRate() proxy.PropInt32
	ConnectionBus() proxy.PropString
	Seat() proxy.PropString
	Removable() proxy.PropBool
	Ejectable() proxy.PropBool
	SortKey() proxy.PropString
	CanPowerOff() proxy.PropBool
	SiblingId() proxy.PropString
}

type interfaceDrive struct{}

func (v *interfaceDrive) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDrive) GetInterfaceName_() string {
	return "org.freedesktop.UDisks2.Drive"
}

// method Eject

func (v *interfaceDrive) GoEject(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Eject", flags, ch, options)
}

func (v *interfaceDrive) Eject(flags dbus.Flags, options map[string]dbus.Variant) error {
	return (<-v.GoEject(flags, make(chan *dbus.Call, 1), options).Done).Err
}

// method SetConfiguration

func (v *interfaceDrive) GoSetConfiguration(flags dbus.Flags, ch chan *dbus.Call, value map[string]dbus.Variant, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetConfiguration", flags, ch, value, options)
}

func (v *interfaceDrive) SetConfiguration(flags dbus.Flags, value map[string]dbus.Variant, options map[string]dbus.Variant) error {
	return (<-v.GoSetConfiguration(flags, make(chan *dbus.Call, 1), value, options).Done).Err
}

// method PowerOff

func (v *interfaceDrive) GoPowerOff(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".PowerOff", flags, ch, options)
}

func (v *interfaceDrive) PowerOff(flags dbus.Flags, options map[string]dbus.Variant) error {
	return (<-v.GoPowerOff(flags, make(chan *dbus.Call, 1), options).Done).Err
}

// property Vendor s

func (v *interfaceDrive) Vendor() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Vendor",
	}
}

// property Model s

func (v *interfaceDrive) Model() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Model",
	}
}

// property Revision s

func (v *interfaceDrive) Revision() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Revision",
	}
}

// property Serial s

func (v *interfaceDrive) Serial() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Serial",
	}
}

// property WWN s

func (v *interfaceDrive) WWN() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "WWN",
	}
}

// property Id s

func (v *interfaceDrive) Id() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Id",
	}
}

type PropDriveConfiguration interface {
	Get(flags dbus.Flags) (value map[string]dbus.Variant, err error)
	Set(flags dbus.Flags, value map[string]dbus.Variant) error
	ConnectChanged(cb func(hasValue bool, value map[string]dbus.Variant)) error
}

type implPropDriveConfiguration struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropDriveConfiguration) Get(flags dbus.Flags) (value map[string]dbus.Variant, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropDriveConfiguration) Set(flags dbus.Flags, value map[string]dbus.Variant) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropDriveConfiguration) ConnectChanged(cb func(hasValue bool, value map[string]dbus.Variant)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v map[string]dbus.Variant
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property Configuration a{sv}

func (v *interfaceDrive) Configuration() PropDriveConfiguration {
	return &implPropDriveConfiguration{
		Impl: v,
		Name: "Configuration",
	}
}

// property Media s

func (v *interfaceDrive) Media() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Media",
	}
}

// property MediaCompatibility as

func (v *interfaceDrive) MediaCompatibility() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "MediaCompatibility",
	}
}

// property MediaRemovable b

func (v *interfaceDrive) MediaRemovable() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "MediaRemovable",
	}
}

// property MediaAvailable b

func (v *interfaceDrive) MediaAvailable() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "MediaAvailable",
	}
}

// property MediaChangeDetected b

func (v *interfaceDrive) MediaChangeDetected() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "MediaChangeDetected",
	}
}

// property Size t

func (v *interfaceDrive) Size() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "Size",
	}
}

// property TimeDetected t

func (v *interfaceDrive) TimeDetected() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "TimeDetected",
	}
}

// property TimeMediaDetected t

func (v *interfaceDrive) TimeMediaDetected() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "TimeMediaDetected",
	}
}

// property Optical b

func (v *interfaceDrive) Optical() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Optical",
	}
}

// property OpticalBlank b

func (v *interfaceDrive) OpticalBlank() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "OpticalBlank",
	}
}

// property OpticalNumTracks u

func (v *interfaceDrive) OpticalNumTracks() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "OpticalNumTracks",
	}
}

// property OpticalNumAudioTracks u

func (v *interfaceDrive) OpticalNumAudioTracks() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "OpticalNumAudioTracks",
	}
}

// property OpticalNumDataTracks u

func (v *interfaceDrive) OpticalNumDataTracks() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "OpticalNumDataTracks",
	}
}

// property OpticalNumSessions u

func (v *interfaceDrive) OpticalNumSessions() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "OpticalNumSessions",
	}
}

// property RotationRate i

func (v *interfaceDrive) RotationRate() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "RotationRate",
	}
}

// property ConnectionBus s

func (v *interfaceDrive) ConnectionBus() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "ConnectionBus",
	}
}

// property Seat s

func (v *interfaceDrive) Seat() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Seat",
	}
}

// property Removable b

func (v *interfaceDrive) Removable() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Removable",
	}
}

// property Ejectable b

func (v *interfaceDrive) Ejectable() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Ejectable",
	}
}

// property SortKey s

func (v *interfaceDrive) SortKey() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SortKey",
	}
}

// property CanPowerOff b

func (v *interfaceDrive) CanPowerOff() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "CanPowerOff",
	}
}

// property SiblingId s

func (v *interfaceDrive) SiblingId() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SiblingId",
	}
}

func (obj *objectDrive) DriveAta() driveAta {
	return &obj.interfaceDriveAta
}

type driveAta interface {
	GoSmartUpdate(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	SmartUpdate(flags dbus.Flags, options map[string]dbus.Variant) error
	GoSmartGetAttributes(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	SmartGetAttributes(flags dbus.Flags, options map[string]dbus.Variant) ([]Attribute, error)
	GoSmartSelftestStart(flags dbus.Flags, ch chan *dbus.Call, type0 string, options map[string]dbus.Variant) *dbus.Call
	SmartSelftestStart(flags dbus.Flags, type0 string, options map[string]dbus.Variant) error
	GoSmartSelftestAbort(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	SmartSelftestAbort(flags dbus.Flags, options map[string]dbus.Variant) error
	GoSmartSetEnabled(flags dbus.Flags, ch chan *dbus.Call, value bool, options map[string]dbus.Variant) *dbus.Call
	SmartSetEnabled(flags dbus.Flags, value bool, options map[string]dbus.Variant) error
	GoPmGetState(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	PmGetState(flags dbus.Flags, options map[string]dbus.Variant) (uint8, error)
	GoPmStandby(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	PmStandby(flags dbus.Flags, options map[string]dbus.Variant) error
	GoPmWakeup(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	PmWakeup(flags dbus.Flags, options map[string]dbus.Variant) error
	GoSecurityEraseUnit(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	SecurityEraseUnit(flags dbus.Flags, options map[string]dbus.Variant) error
	SmartSupported() proxy.PropBool
	SmartEnabled() proxy.PropBool
	SmartUpdated() proxy.PropUint64
	SmartFailing() proxy.PropBool
	SmartPowerOnSeconds() proxy.PropUint64
	SmartTemperature() proxy.PropDouble
	SmartNumAttributesFailing() proxy.PropInt32
	SmartNumAttributesFailedInThePast() proxy.PropInt32
	SmartNumBadSectors() proxy.PropInt64
	SmartSelftestStatus() proxy.PropString
	SmartSelftestPercentRemaining() proxy.PropInt32
	PmSupported() proxy.PropBool
	PmEnabled() proxy.PropBool
	ApmSupported() proxy.PropBool
	ApmEnabled() proxy.PropBool
	AamSupported() proxy.PropBool
	AamEnabled() proxy.PropBool
	AamVendorRecommendedValue() proxy.PropInt32
	WriteCacheSupported() proxy.PropBool
	WriteCacheEnabled() proxy.PropBool
	ReadLookaheadSupported() proxy.PropBool
	ReadLookaheadEnabled() proxy.PropBool
	SecurityEraseUnitMinutes() proxy.PropInt32
	SecurityEnhancedEraseUnitMinutes() proxy.PropInt32
	SecurityFrozen() proxy.PropBool
}

type interfaceDriveAta struct{}

func (v *interfaceDriveAta) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDriveAta) GetInterfaceName_() string {
	return "org.freedesktop.UDisks2.Drive.Ata"
}

// method SmartUpdate

func (v *interfaceDriveAta) GoSmartUpdate(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SmartUpdate", flags, ch, options)
}

func (v *interfaceDriveAta) SmartUpdate(flags dbus.Flags, options map[string]dbus.Variant) error {
	return (<-v.GoSmartUpdate(flags, make(chan *dbus.Call, 1), options).Done).Err
}

// method SmartGetAttributes

func (v *interfaceDriveAta) GoSmartGetAttributes(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SmartGetAttributes", flags, ch, options)
}

func (*interfaceDriveAta) StoreSmartGetAttributes(call *dbus.Call) (attributes []Attribute, err error) {
	err = call.Store(&attributes)
	return
}

func (v *interfaceDriveAta) SmartGetAttributes(flags dbus.Flags, options map[string]dbus.Variant) ([]Attribute, error) {
	return v.StoreSmartGetAttributes(
		<-v.GoSmartGetAttributes(flags, make(chan *dbus.Call, 1), options).Done)
}

// method SmartSelftestStart

func (v *interfaceDriveAta) GoSmartSelftestStart(flags dbus.Flags, ch chan *dbus.Call, type0 string, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SmartSelftestStart", flags, ch, type0, options)
}

func (v *interfaceDriveAta) SmartSelftestStart(flags dbus.Flags, type0 string, options map[string]dbus.Variant) error {
	return (<-v.GoSmartSelftestStart(flags, make(chan *dbus.Call, 1), type0, options).Done).Err
}

// method SmartSelftestAbort

func (v *interfaceDriveAta) GoSmartSelftestAbort(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SmartSelftestAbort", flags, ch, options)
}

func (v *interfaceDriveAta) SmartSelftestAbort(flags dbus.Flags, options map[string]dbus.Variant) error {
	return (<-v.GoSmartSelftestAbort(flags, make(chan *dbus.Call, 1), options).Done).Err
}

// method SmartSetEnabled

func (v *interfaceDriveAta) GoSmartSetEnabled(flags dbus.Flags, ch chan *dbus.Call, value bool, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SmartSetEnabled", flags, ch, value, options)
}

func (v *interfaceDriveAta) SmartSetEnabled(flags dbus.Flags, value bool, options map[string]dbus.Variant) error {
	return (<-v.GoSmartSetEnabled(flags, make(chan *dbus.Call, 1), value, options).Done).Err
}

// method PmGetState

func (v *interfaceDriveAta) GoPmGetState(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".PmGetState", flags, ch, options)
}

func (*interfaceDriveAta) StorePmGetState(call *dbus.Call) (state uint8, err error) {
	err = call.Store(&state)
	return
}

func (v *interfaceDriveAta) PmGetState(flags dbus.Flags, options map[string]dbus.Variant) (uint8, error) {
	return v.StorePmGetState(
		<-v.GoPmGetState(flags, make(chan *dbus.Call, 1), options).Done)
}

// method PmStandby

func (v *interfaceDriveAta) GoPmStandby(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".PmStandby", flags, ch, options)
}

func (v *interfaceDriveAta) PmStandby(flags dbus.Flags, options map[string]dbus.Variant) error {
	return (<-v.GoPmStandby(flags, make(chan *dbus.Call, 1), options).Done).Err
}

// method PmWakeup

func (v *interfaceDriveAta) GoPmWakeup(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".PmWakeup", flags, ch, options)
}

func (v *interfaceDriveAta) PmWakeup(flags dbus.Flags, options map[string]dbus.Variant) error {
	return (<-v.GoPmWakeup(flags, make(chan *dbus.Call, 1), options).Done).Err
}

// method SecurityEraseUnit

func (v *interfaceDriveAta) GoSecurityEraseUnit(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SecurityEraseUnit", flags, ch, options)
}

func (v *interfaceDriveAta) SecurityEraseUnit(flags dbus.Flags, options map[string]dbus.Variant) error {
	return (<-v.GoSecurityEraseUnit(flags, make(chan *dbus.Call, 1), options).Done).Err
}

// property SmartSupported b

func (v *interfaceDriveAta) SmartSupported() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "SmartSupported",
	}
}

// property SmartEnabled b

func (v *interfaceDriveAta) SmartEnabled() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "SmartEnabled",
	}
}

// property SmartUpdated t

func (v *interfaceDriveAta) SmartUpdated() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "SmartUpdated",
	}
}

// property SmartFailing b

func (v *interfaceDriveAta) SmartFailing() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "SmartFailing",
	}
}

// property SmartPowerOnSeconds t

func (v *interfaceDriveAta) SmartPowerOnSeconds() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "SmartPowerOnSeconds",
	}
}

// property SmartTemperature d

func (v *interfaceDriveAta) SmartTemperature() proxy.PropDouble {
	return &proxy.ImplPropDouble{
		Impl: v,
		Name: "SmartTemperature",
	}
}

// property SmartNumAttributesFailing i

func (v *interfaceDriveAta) SmartNumAttributesFailing() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "SmartNumAttributesFailing",
	}
}

// property SmartNumAttributesFailedInThePast i

func (v *interfaceDriveAta) SmartNumAttributesFailedInThePast() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "SmartNumAttributesFailedInThePast",
	}
}

// property SmartNumBadSectors x

func (v *interfaceDriveAta) SmartNumBadSectors() proxy.PropInt64 {
	return &proxy.ImplPropInt64{
		Impl: v,
		Name: "SmartNumBadSectors",
	}
}

// property SmartSelftestStatus s

func (v *interfaceDriveAta) SmartSelftestStatus() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "SmartSelftestStatus",
	}
}

// property SmartSelftestPercentRemaining i

func (v *interfaceDriveAta) SmartSelftestPercentRemaining() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "SmartSelftestPercentRemaining",
	}
}

// property PmSupported b

func (v *interfaceDriveAta) PmSupported() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "PmSupported",
	}
}

// property PmEnabled b

func (v *interfaceDriveAta) PmEnabled() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "PmEnabled",
	}
}

// property ApmSupported b

func (v *interfaceDriveAta) ApmSupported() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "ApmSupported",
	}
}

// property ApmEnabled b

func (v *interfaceDriveAta) ApmEnabled() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "ApmEnabled",
	}
}

// property AamSupported b

func (v *interfaceDriveAta) AamSupported() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "AamSupported",
	}
}

// property AamEnabled b

func (v *interfaceDriveAta) AamEnabled() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "AamEnabled",
	}
}

// property AamVendorRecommendedValue i

func (v *interfaceDriveAta) AamVendorRecommendedValue() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "AamVendorRecommendedValue",
	}
}

// property WriteCacheSupported b

func (v *interfaceDriveAta) WriteCacheSupported() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "WriteCacheSupported",
	}
}

// property WriteCacheEnabled b

func (v *interfaceDriveAta) WriteCacheEnabled() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "WriteCacheEnabled",
	}
}

// property ReadLookaheadSupported b

func (v *interfaceDriveAta) ReadLookaheadSupported() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "ReadLookaheadSupported",
	}
}

// property ReadLookaheadEnabled b

func (v *interfaceDriveAta) ReadLookaheadEnabled() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "ReadLookaheadEnabled",
	}
}

// property SecurityEraseUnitMinutes i

func (v *interfaceDriveAta) SecurityEraseUnitMinutes() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "SecurityEraseUnitMinutes",
	}
}

// property SecurityEnhancedEraseUnitMinutes i

func (v *interfaceDriveAta) SecurityEnhancedEraseUnitMinutes() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "SecurityEnhancedEraseUnitMinutes",
	}
}

// property SecurityFrozen b

func (v *interfaceDriveAta) SecurityFrozen() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "SecurityFrozen",
	}
}

type Block interface {
	Block() block                   // interface org.freedesktop.UDisks2.Block
	PartitionTable() partitionTable // interface org.freedesktop.UDisks2.PartitionTable
	Partition() partition           // interface org.freedesktop.UDisks2.Partition
	Filesystem() filesystem         // interface org.freedesktop.UDisks2.Filesystem
	proxy.Object
}

type objectBlock struct {
	interfaceBlock          // interface org.freedesktop.UDisks2.Block
	interfacePartitionTable // interface org.freedesktop.UDisks2.PartitionTable
	interfacePartition      // interface org.freedesktop.UDisks2.Partition
	interfaceFilesystem     // interface org.freedesktop.UDisks2.Filesystem
	proxy.ImplObject
}

func NewBlock(conn *dbus.Conn, path dbus.ObjectPath) (Block, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectBlock)
	obj.ImplObject.Init_(conn, "org.freedesktop.UDisks2", path)
	return obj, nil
}

func (obj *objectBlock) Block() block {
	return &obj.interfaceBlock
}

type block interface {
	GoAddConfigurationItem(flags dbus.Flags, ch chan *dbus.Call, item ConfigurationItem, options map[string]dbus.Variant) *dbus.Call
	AddConfigurationItem(flags dbus.Flags, item ConfigurationItem, options map[string]dbus.Variant) error
	GoRemoveConfigurationItem(flags dbus.Flags, ch chan *dbus.Call, item ConfigurationItem, options map[string]dbus.Variant) *dbus.Call
	RemoveConfigurationItem(flags dbus.Flags, item ConfigurationItem, options map[string]dbus.Variant) error
	GoUpdateConfigurationItem(flags dbus.Flags, ch chan *dbus.Call, old_item ConfigurationItem, new_item ConfigurationItem, options map[string]dbus.Variant) *dbus.Call
	UpdateConfigurationItem(flags dbus.Flags, old_item ConfigurationItem, new_item ConfigurationItem, options map[string]dbus.Variant) error
	GoGetSecretConfiguration(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	GetSecretConfiguration(flags dbus.Flags, options map[string]dbus.Variant) ([]ConfigurationItem, error)
	GoFormat(flags dbus.Flags, ch chan *dbus.Call, type0 string, options map[string]dbus.Variant) *dbus.Call
	Format(flags dbus.Flags, type0 string, options map[string]dbus.Variant) error
	GoOpenForBackup(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	OpenForBackup(flags dbus.Flags, options map[string]dbus.Variant) (dbus.UnixFD, error)
	GoOpenForRestore(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	OpenForRestore(flags dbus.Flags, options map[string]dbus.Variant) (dbus.UnixFD, error)
	GoOpenForBenchmark(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	OpenForBenchmark(flags dbus.Flags, options map[string]dbus.Variant) (dbus.UnixFD, error)
	GoRescan(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	Rescan(flags dbus.Flags, options map[string]dbus.Variant) error
	Device() proxy.PropByteArray
	PreferredDevice() proxy.PropByteArray
	Symlinks() PropByteSliceSlice
	DeviceNumber() proxy.PropUint64
	Id() proxy.PropString
	Size() proxy.PropUint64
	ReadOnly() proxy.PropBool
	Drive() proxy.PropObjectPath
	MDRaid() proxy.PropObjectPath
	MDRaidMember() proxy.PropObjectPath
	IdUsage() proxy.PropString
	IdType() proxy.PropString
	IdVersion() proxy.PropString
	IdLabel() proxy.PropString
	IdUUID() proxy.PropString
	Configuration() PropBlockConfiguration
	CryptoBackingDevice() proxy.PropObjectPath
	HintPartitionable() proxy.PropBool
	HintSystem() proxy.PropBool
	HintIgnore() proxy.PropBool
	HintAuto() proxy.PropBool
	HintName() proxy.PropString
	HintIconName() proxy.PropString
	HintSymbolicIconName() proxy.PropString
}

type interfaceBlock struct{}

func (v *interfaceBlock) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceBlock) GetInterfaceName_() string {
	return "org.freedesktop.UDisks2.Block"
}

// method AddConfigurationItem

func (v *interfaceBlock) GoAddConfigurationItem(flags dbus.Flags, ch chan *dbus.Call, item ConfigurationItem, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AddConfigurationItem", flags, ch, item, options)
}

func (v *interfaceBlock) AddConfigurationItem(flags dbus.Flags, item ConfigurationItem, options map[string]dbus.Variant) error {
	return (<-v.GoAddConfigurationItem(flags, make(chan *dbus.Call, 1), item, options).Done).Err
}

// method RemoveConfigurationItem

func (v *interfaceBlock) GoRemoveConfigurationItem(flags dbus.Flags, ch chan *dbus.Call, item ConfigurationItem, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RemoveConfigurationItem", flags, ch, item, options)
}

func (v *interfaceBlock) RemoveConfigurationItem(flags dbus.Flags, item ConfigurationItem, options map[string]dbus.Variant) error {
	return (<-v.GoRemoveConfigurationItem(flags, make(chan *dbus.Call, 1), item, options).Done).Err
}

// method UpdateConfigurationItem

func (v *interfaceBlock) GoUpdateConfigurationItem(flags dbus.Flags, ch chan *dbus.Call, old_item ConfigurationItem, new_item ConfigurationItem, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UpdateConfigurationItem", flags, ch, old_item, new_item, options)
}

func (v *interfaceBlock) UpdateConfigurationItem(flags dbus.Flags, old_item ConfigurationItem, new_item ConfigurationItem, options map[string]dbus.Variant) error {
	return (<-v.GoUpdateConfigurationItem(flags, make(chan *dbus.Call, 1), old_item, new_item, options).Done).Err
}

// method GetSecretConfiguration

func (v *interfaceBlock) GoGetSecretConfiguration(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetSecretConfiguration", flags, ch, options)
}

func (*interfaceBlock) StoreGetSecretConfiguration(call *dbus.Call) (configuration []ConfigurationItem, err error) {
	err = call.Store(&configuration)
	return
}

func (v *interfaceBlock) GetSecretConfiguration(flags dbus.Flags, options map[string]dbus.Variant) ([]ConfigurationItem, error) {
	return v.StoreGetSecretConfiguration(
		<-v.GoGetSecretConfiguration(flags, make(chan *dbus.Call, 1), options).Done)
}

// method Format

func (v *interfaceBlock) GoFormat(flags dbus.Flags, ch chan *dbus.Call, type0 string, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Format", flags, ch, type0, options)
}

func (v *interfaceBlock) Format(flags dbus.Flags, type0 string, options map[string]dbus.Variant) error {
	return (<-v.GoFormat(flags, make(chan *dbus.Call, 1), type0, options).Done).Err
}

// method OpenForBackup

func (v *interfaceBlock) GoOpenForBackup(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".OpenForBackup", flags, ch, options)
}

func (*interfaceBlock) StoreOpenForBackup(call *dbus.Call) (fd dbus.UnixFD, err error) {
	err = call.Store(&fd)
	return
}

func (v *interfaceBlock) OpenForBackup(flags dbus.Flags, options map[string]dbus.Variant) (dbus.UnixFD, error) {
	return v.StoreOpenForBackup(
		<-v.GoOpenForBackup(flags, make(chan *dbus.Call, 1), options).Done)
}

// method OpenForRestore

func (v *interfaceBlock) GoOpenForRestore(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".OpenForRestore", flags, ch, options)
}

func (*interfaceBlock) StoreOpenForRestore(call *dbus.Call) (fd dbus.UnixFD, err error) {
	err = call.Store(&fd)
	return
}

func (v *interfaceBlock) OpenForRestore(flags dbus.Flags, options map[string]dbus.Variant) (dbus.UnixFD, error) {
	return v.StoreOpenForRestore(
		<-v.GoOpenForRestore(flags, make(chan *dbus.Call, 1), options).Done)
}

// method OpenForBenchmark

func (v *interfaceBlock) GoOpenForBenchmark(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".OpenForBenchmark", flags, ch, options)
}

func (*interfaceBlock) StoreOpenForBenchmark(call *dbus.Call) (fd dbus.UnixFD, err error) {
	err = call.Store(&fd)
	return
}

func (v *interfaceBlock) OpenForBenchmark(flags dbus.Flags, options map[string]dbus.Variant) (dbus.UnixFD, error) {
	return v.StoreOpenForBenchmark(
		<-v.GoOpenForBenchmark(flags, make(chan *dbus.Call, 1), options).Done)
}

// method Rescan

func (v *interfaceBlock) GoRescan(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Rescan", flags, ch, options)
}

func (v *interfaceBlock) Rescan(flags dbus.Flags, options map[string]dbus.Variant) error {
	return (<-v.GoRescan(flags, make(chan *dbus.Call, 1), options).Done).Err
}

// property Device ay

func (v *interfaceBlock) Device() proxy.PropByteArray {
	return &proxy.ImplPropByteArray{
		Impl: v,
		Name: "Device",
	}
}

// property PreferredDevice ay

func (v *interfaceBlock) PreferredDevice() proxy.PropByteArray {
	return &proxy.ImplPropByteArray{
		Impl: v,
		Name: "PreferredDevice",
	}
}

// property Symlinks aay

func (v *interfaceBlock) Symlinks() PropByteSliceSlice {
	return &implPropByteSliceSlice{
		Impl: v,
		Name: "Symlinks",
	}
}

// property DeviceNumber t

func (v *interfaceBlock) DeviceNumber() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "DeviceNumber",
	}
}

// property Id s

func (v *interfaceBlock) Id() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Id",
	}
}

// property Size t

func (v *interfaceBlock) Size() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "Size",
	}
}

// property ReadOnly b

func (v *interfaceBlock) ReadOnly() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "ReadOnly",
	}
}

// property Drive o

func (v *interfaceBlock) Drive() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Drive",
	}
}

// property MDRaid o

func (v *interfaceBlock) MDRaid() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "MDRaid",
	}
}

// property MDRaidMember o

func (v *interfaceBlock) MDRaidMember() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "MDRaidMember",
	}
}

// property IdUsage s

func (v *interfaceBlock) IdUsage() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "IdUsage",
	}
}

// property IdType s

func (v *interfaceBlock) IdType() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "IdType",
	}
}

// property IdVersion s

func (v *interfaceBlock) IdVersion() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "IdVersion",
	}
}

// property IdLabel s

func (v *interfaceBlock) IdLabel() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "IdLabel",
	}
}

// property IdUUID s

func (v *interfaceBlock) IdUUID() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "IdUUID",
	}
}

type PropBlockConfiguration interface {
	Get(flags dbus.Flags) (value []ConfigurationItem, err error)
	Set(flags dbus.Flags, value []ConfigurationItem) error
	ConnectChanged(cb func(hasValue bool, value []ConfigurationItem)) error
}

type implPropBlockConfiguration struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropBlockConfiguration) Get(flags dbus.Flags) (value []ConfigurationItem, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropBlockConfiguration) Set(flags dbus.Flags, value []ConfigurationItem) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropBlockConfiguration) ConnectChanged(cb func(hasValue bool, value []ConfigurationItem)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []ConfigurationItem
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property Configuration a(sa{sv})

func (v *interfaceBlock) Configuration() PropBlockConfiguration {
	return &implPropBlockConfiguration{
		Impl: v,
		Name: "Configuration",
	}
}

// property CryptoBackingDevice o

func (v *interfaceBlock) CryptoBackingDevice() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "CryptoBackingDevice",
	}
}

// property HintPartitionable b

func (v *interfaceBlock) HintPartitionable() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "HintPartitionable",
	}
}

// property HintSystem b

func (v *interfaceBlock) HintSystem() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "HintSystem",
	}
}

// property HintIgnore b

func (v *interfaceBlock) HintIgnore() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "HintIgnore",
	}
}

// property HintAuto b

func (v *interfaceBlock) HintAuto() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "HintAuto",
	}
}

// property HintName s

func (v *interfaceBlock) HintName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HintName",
	}
}

// property HintIconName s

func (v *interfaceBlock) HintIconName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HintIconName",
	}
}

// property HintSymbolicIconName s

func (v *interfaceBlock) HintSymbolicIconName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HintSymbolicIconName",
	}
}

func (obj *objectBlock) PartitionTable() partitionTable {
	return &obj.interfacePartitionTable
}

type partitionTable interface {
	GoCreatePartition(flags dbus.Flags, ch chan *dbus.Call, offset uint64, size uint64, type0 string, name string, options map[string]dbus.Variant) *dbus.Call
	CreatePartition(flags dbus.Flags, offset uint64, size uint64, type0 string, name string, options map[string]dbus.Variant) (dbus.ObjectPath, error)
	Type() proxy.PropString
}

type interfacePartitionTable struct{}

func (v *interfacePartitionTable) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfacePartitionTable) GetInterfaceName_() string {
	return "org.freedesktop.UDisks2.PartitionTable"
}

// method CreatePartition

func (v *interfacePartitionTable) GoCreatePartition(flags dbus.Flags, ch chan *dbus.Call, offset uint64, size uint64, type0 string, name string, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CreatePartition", flags, ch, offset, size, type0, name, options)
}

func (*interfacePartitionTable) StoreCreatePartition(call *dbus.Call) (created_partition dbus.ObjectPath, err error) {
	err = call.Store(&created_partition)
	return
}

func (v *interfacePartitionTable) CreatePartition(flags dbus.Flags, offset uint64, size uint64, type0 string, name string, options map[string]dbus.Variant) (dbus.ObjectPath, error) {
	return v.StoreCreatePartition(
		<-v.GoCreatePartition(flags, make(chan *dbus.Call, 1), offset, size, type0, name, options).Done)
}

// property Type s

func (v *interfacePartitionTable) Type() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Type",
	}
}

func (obj *objectBlock) Partition() partition {
	return &obj.interfacePartition
}

type partition interface {
	GoSetType(flags dbus.Flags, ch chan *dbus.Call, type0 string, options map[string]dbus.Variant) *dbus.Call
	SetType(flags dbus.Flags, type0 string, options map[string]dbus.Variant) error
	GoSetName(flags dbus.Flags, ch chan *dbus.Call, name string, options map[string]dbus.Variant) *dbus.Call
	SetName(flags dbus.Flags, name string, options map[string]dbus.Variant) error
	GoSetFlags(flags dbus.Flags, ch chan *dbus.Call, flags0 uint64, options map[string]dbus.Variant) *dbus.Call
	SetFlags(flags dbus.Flags, flags0 uint64, options map[string]dbus.Variant) error
	GoDelete(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	Delete(flags dbus.Flags, options map[string]dbus.Variant) error
	Number() proxy.PropUint32
	Type() proxy.PropString
	Flags() proxy.PropUint64
	Offset() proxy.PropUint64
	Size() proxy.PropUint64
	Name() proxy.PropString
	UUID() proxy.PropString
	Table() proxy.PropObjectPath
	IsContainer() proxy.PropBool
	IsContained() proxy.PropBool
}

type interfacePartition struct{}

func (v *interfacePartition) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfacePartition) GetInterfaceName_() string {
	return "org.freedesktop.UDisks2.Partition"
}

// method SetType

func (v *interfacePartition) GoSetType(flags dbus.Flags, ch chan *dbus.Call, type0 string, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetType", flags, ch, type0, options)
}

func (v *interfacePartition) SetType(flags dbus.Flags, type0 string, options map[string]dbus.Variant) error {
	return (<-v.GoSetType(flags, make(chan *dbus.Call, 1), type0, options).Done).Err
}

// method SetName

func (v *interfacePartition) GoSetName(flags dbus.Flags, ch chan *dbus.Call, name string, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetName", flags, ch, name, options)
}

func (v *interfacePartition) SetName(flags dbus.Flags, name string, options map[string]dbus.Variant) error {
	return (<-v.GoSetName(flags, make(chan *dbus.Call, 1), name, options).Done).Err
}

// method SetFlags

func (v *interfacePartition) GoSetFlags(flags dbus.Flags, ch chan *dbus.Call, flags0 uint64, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetFlags", flags, ch, flags0, options)
}

func (v *interfacePartition) SetFlags(flags dbus.Flags, flags0 uint64, options map[string]dbus.Variant) error {
	return (<-v.GoSetFlags(flags, make(chan *dbus.Call, 1), flags0, options).Done).Err
}

// method Delete

func (v *interfacePartition) GoDelete(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Delete", flags, ch, options)
}

func (v *interfacePartition) Delete(flags dbus.Flags, options map[string]dbus.Variant) error {
	return (<-v.GoDelete(flags, make(chan *dbus.Call, 1), options).Done).Err
}

// property Number u

func (v *interfacePartition) Number() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Number",
	}
}

// property Type s

func (v *interfacePartition) Type() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Type",
	}
}

// property Flags t

func (v *interfacePartition) Flags() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "Flags",
	}
}

// property Offset t

func (v *interfacePartition) Offset() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "Offset",
	}
}

// property Size t

func (v *interfacePartition) Size() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "Size",
	}
}

// property Name s

func (v *interfacePartition) Name() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Name",
	}
}

// property UUID s

func (v *interfacePartition) UUID() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "UUID",
	}
}

// property Table o

func (v *interfacePartition) Table() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Table",
	}
}

// property IsContainer b

func (v *interfacePartition) IsContainer() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "IsContainer",
	}
}

// property IsContained b

func (v *interfacePartition) IsContained() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "IsContained",
	}
}

func (obj *objectBlock) Filesystem() filesystem {
	return &obj.interfaceFilesystem
}

type filesystem interface {
	GoSetLabel(flags dbus.Flags, ch chan *dbus.Call, label string, options map[string]dbus.Variant) *dbus.Call
	SetLabel(flags dbus.Flags, label string, options map[string]dbus.Variant) error
	GoMount(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	Mount(flags dbus.Flags, options map[string]dbus.Variant) (string, error)
	GoUnmount(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call
	Unmount(flags dbus.Flags, options map[string]dbus.Variant) error
	MountPoints() PropByteSliceSlice
}

type interfaceFilesystem struct{}

func (v *interfaceFilesystem) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceFilesystem) GetInterfaceName_() string {
	return "org.freedesktop.UDisks2.Filesystem"
}

// method SetLabel

func (v *interfaceFilesystem) GoSetLabel(flags dbus.Flags, ch chan *dbus.Call, label string, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetLabel", flags, ch, label, options)
}

func (v *interfaceFilesystem) SetLabel(flags dbus.Flags, label string, options map[string]dbus.Variant) error {
	return (<-v.GoSetLabel(flags, make(chan *dbus.Call, 1), label, options).Done).Err
}

// method Mount

func (v *interfaceFilesystem) GoMount(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Mount", flags, ch, options)
}

func (*interfaceFilesystem) StoreMount(call *dbus.Call) (mount_path string, err error) {
	err = call.Store(&mount_path)
	return
}

func (v *interfaceFilesystem) Mount(flags dbus.Flags, options map[string]dbus.Variant) (string, error) {
	return v.StoreMount(
		<-v.GoMount(flags, make(chan *dbus.Call, 1), options).Done)
}

// method Unmount

func (v *interfaceFilesystem) GoUnmount(flags dbus.Flags, ch chan *dbus.Call, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Unmount", flags, ch, options)
}

func (v *interfaceFilesystem) Unmount(flags dbus.Flags, options map[string]dbus.Variant) error {
	return (<-v.GoUnmount(flags, make(chan *dbus.Call, 1), options).Done).Err
}

// property MountPoints aay

func (v *interfaceFilesystem) MountPoints() PropByteSliceSlice {
	return &implPropByteSliceSlice{
		Impl: v,
		Name: "MountPoints",
	}
}

type PropByteSliceSlice interface {
	Get(flags dbus.Flags) (value [][]byte, err error)
	Set(flags dbus.Flags, value [][]byte) error
	ConnectChanged(cb func(hasValue bool, value [][]byte)) error
}

type implPropByteSliceSlice struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropByteSliceSlice) Get(flags dbus.Flags) (value [][]byte, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropByteSliceSlice) Set(flags dbus.Flags, value [][]byte) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropByteSliceSlice) ConnectChanged(cb func(hasValue bool, value [][]byte)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v [][]byte
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}
