#
# new.py - DITrack 'new' command
#
# Copyright (c) 2006-2007 The DITrack Project, www.ditrack.org.
#
# $Id: new.py 1696 2007-07-10 22:45:31Z vss $
# $HeadURL: https://svn.xiolabs.com/ditrack/src/tags/0.8/DITrack/Command/new.py $
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

import sys

# DITrack modules
import DITrack.Command.generic

class Handler(DITrack.Command.generic.Handler):
    canonical_name = "new"
    description = """Add new issue to a database.
usage: %s""" % canonical_name

    def run(self, opts, globals):
        self.check_options(opts)

        globals.get_editor()

        db = DITrack.Util.common.open_db(globals, opts, "w")

        # Choose one of categories
        categories = filter(
            lambda x: db.cfg.category[x].enabled,
            db.cfg.category.keys()
            )

        categories.sort()

        m_category = DITrack.UI.EnumMenu("Choose the issue category",
            categories, abort_option=True)

        category = m_category.run()

        if not category: return

        assert(category in db.cfg.category)

        # Now ask for a version the issue is reported against
        m_version = DITrack.UI.EnumMenu(
            "Choose the version the issue is reported against",
            db.cfg.category[category].versions.current,
            abort_option=True)

        version = m_version.run()

        if not version: return

        # Ask for a title
        ti_title = DITrack.UI.TextInput("Enter the issue title")

        title = ti_title.run()

        if not title: return

        # Now edit the issue description text
        descr = DITrack.Edit.edit_text(globals,
            """DITrack: Enter the issue description here. The line below is your issue title.

%s
""" % title)

        # Now ask for a version the issue is due
        m_version = DITrack.UI.EnumMenu(
            "Choose the version the issue is due",
            db.cfg.category[category].versions.future,
            abort_option=True)

        due_version = m_version.run()

        if not due_version: return

        local_id, issue = db.new_issue(
            title=title,
            opened_by=globals.username,
            opened_on=globals.fmt_timestamp(),
            owned_by=None,
            category=category,
            version_reported=version,
            version_due=due_version,
            description=descr)

        # Check if we should commit the new issue
        if opts.var["no_commits"]:
            sys.stdout.write("New local issue #%s added\n" % local_id)
        else:
            id = db.commit_issue(local_id)
            sys.stdout.write(
                "New local issue #%s committed as i#%s\n" % (local_id, id)
            )
