/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.Optional;

@StatelessCheck
public class MissingJavadocPackageCheck
extends AbstractCheck {
    public static final String MSG_PKG_JAVADOC_MISSING = "package.javadoc.missing";

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{16};
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (CheckUtil.isPackageInfo(this.getFilePath()) && !MissingJavadocPackageCheck.hasJavadoc(ast)) {
            this.log(ast, MSG_PKG_JAVADOC_MISSING, new Object[0]);
        }
    }

    private static boolean hasJavadoc(DetailAST ast) {
        boolean hasJavadocBefore = ast.getPreviousSibling() != null && MissingJavadocPackageCheck.isJavadoc(ast.getPreviousSibling());
        return hasJavadocBefore || MissingJavadocPackageCheck.hasJavadocAboveAnnotation(ast);
    }

    private static boolean hasJavadocAboveAnnotation(DetailAST ast) {
        Optional<DetailAST> firstAnnotationChild = Optional.of(ast.getFirstChild()).map(DetailAST::getFirstChild).map(DetailAST::getFirstChild);
        boolean result = false;
        if (firstAnnotationChild.isPresent()) {
            for (DetailAST child = firstAnnotationChild.get(); child != null; child = child.getNextSibling()) {
                if (!MissingJavadocPackageCheck.isJavadoc(child)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static boolean isJavadoc(DetailAST ast) {
        return ast.getType() == 145 && JavadocUtil.isJavadocComment(ast);
    }
}

