// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef COLORDEFINE_H
#define COLORDEFINE_H

#include "common/common.h"

namespace EditorColor {
enum_def(Table, QColor)
{
    enum_exp AliceBlue = QRgb(0xF0F8FF);
    enum_exp AntiqueWhite = QRgb(0xFAEBD7);
    enum_exp Aqua = QRgb(0x00FFFF);
    enum_exp Aquamarine = QRgb(0x7FFFD4);
    enum_exp Azure = QRgb(0xF0FFFF);
    enum_exp Beige = QRgb(0xF5F5DC);
    enum_exp Bisque = QRgb(0xFFE4C4);
    enum_exp Black = QRgb(0x000000);
    enum_exp BlanchedAlmond = QRgb(0xFFEBCD);
    enum_exp Blue = QRgb(0x0000FF);
    enum_exp BlueViolet = QRgb(0x8A2BE2);
    enum_exp Brown = QRgb(0xA52A2A);
    enum_exp BurlyWood = QRgb(0xDEB887);
    enum_exp CadetBlue = QRgb(0x5F9EA0);
    enum_exp Chartreuse = QRgb(0x7FFF00);
    enum_exp Chocolate = QRgb(0xD2691E);
    enum_exp Coral = QRgb(0xFF7F50);
    enum_exp CornflowerBlue = QRgb(0x6495ED);
    enum_exp Cornsilk = QRgb(0xFFF8DC);
    enum_exp Crimson = QRgb(0xDC143C);
    enum_exp Cyan = QRgb(0x00FFFF);
    enum_exp DarkBlue = QRgb(0x00008B);
    enum_exp DarkCyan = QRgb(0x008B8B);
    enum_exp DarkGoldenRod = QRgb(0xB8860B);
    enum_exp DarkGray = QRgb(0xA9A9A9);
    enum_exp DarkGreen = QRgb(0x006400);
    enum_exp DarkKhaki = QRgb(0xBDB76B);
    enum_exp DarkMagenta = QRgb(0x8B008B);
    enum_exp DarkOliveGreen = QRgb(0x556B2F);
    enum_exp Darkorange = QRgb(0xFF8C00);
    enum_exp DarkOrchid = QRgb(0x9932CC);
    enum_exp DarkRed = QRgb(0x8B0000);
    enum_exp DarkSalmon = QRgb(0xE9967A);
    enum_exp DarkSeaGreen = QRgb(0x8FBC8F);
    enum_exp DarkSlateBlue = QRgb(0x483D8B);
    enum_exp DarkSlateGray = QRgb(0x2F4F4F);
    enum_exp DarkTurquoise = QRgb(0x00CED1);
    enum_exp DarkViolet = QRgb(0x9400D3);
    enum_exp DeepPink = QRgb(0xFF1493);
    enum_exp DeepSkyBlue = QRgb(0x00BFFF);
    enum_exp DimGray = QRgb(0x696969);
    enum_exp DodgerBlue = QRgb(0x1E90FF);
    enum_exp Feldspar = QRgb(0xD19275);
    enum_exp FireBrick = QRgb(0xB22222);
    enum_exp FloralWhite = QRgb(0xFFFAF0);
    enum_exp ForestGreen = QRgb(0x228B22);
    enum_exp Fuchsia = QRgb(0xFF00FF);
    enum_exp Gainsboro = QRgb(0xDCDCDC);
    enum_exp GhostWhite = QRgb(0xF8F8FF);
    enum_exp Gold = QRgb(0xFFD700);
    enum_exp GoldenRod = QRgb(0xDAA520);
    enum_exp Gray = QRgb(0x808080);
    enum_exp Green = QRgb(0x008000);
    enum_exp GreenYellow = QRgb(0xADFF2F);
    enum_exp HoneyDew = QRgb(0xF0FFF0);
    enum_exp HotPink = QRgb(0xFF69B4);
    enum_exp IndianRed = QRgb(0xCD5C5C);
    enum_exp Indigo = QRgb(0x4B0082);
    enum_exp Ivory = QRgb(0xFFFFF0);
    enum_exp Khaki = QRgb(0xF0E68C);
    enum_exp Lavender = QRgb(0xE6E6FA);
    enum_exp LavenderBlush = QRgb(0xFFF0F5);
    enum_exp LawnGreen = QRgb(0x7CFC00);
    enum_exp LemonChiffon = QRgb(0xFFFACD);
    enum_exp LightBlue = QRgb(0xADD8E6);
    enum_exp LightCoral = QRgb(0xF08080);
    enum_exp LightCyan = QRgb(0xE0FFFF);
    enum_exp LightGoldenRodYellow = QRgb(0xFAFAD2);
    enum_exp LightGrey = QRgb(0xD3D3D3);
    enum_exp LightGreen = QRgb(0x90EE90);
    enum_exp LightPink = QRgb(0xFFB6C1);
    enum_exp LightSalmon = QRgb(0xFFA07A);
    enum_exp LightSeaGreen = QRgb(0x20B2AA);
    enum_exp LightSkyBlue = QRgb(0x87CEFA);
    enum_exp LightSlateBlue = QRgb(0x8470FF);
    enum_exp LightSlateGray = QRgb(0x778899);
    enum_exp LightSteelBlue = QRgb(0xB0C4DE);
    enum_exp LightYellow = QRgb(0xFFFFE0);
    enum_exp Lime = QRgb(0x00FF00);
    enum_exp LimeGreen = QRgb(0x32CD32);
    enum_exp Linen = QRgb(0xFAF0E6);
    enum_exp Magenta = QRgb(0xFF00FF);
    enum_exp Maroon = QRgb(0x800000);
    enum_exp MediumAquaMarine = QRgb(0x66CDAA);
    enum_exp MediumBlue = QRgb(0x0000CD);
    enum_exp MediumOrchid = QRgb(0xBA55D3);
    enum_exp MediumPurple = QRgb(0x9370D8);
    enum_exp MediumSeaGreen = QRgb(0x3CB371);
    enum_exp MediumSlateBlue = QRgb(0x7B68EE);
    enum_exp MediumSpringGreen = QRgb(0x00FA9A);
    enum_exp MediumTurquoise = QRgb(0x48D1CC);
    enum_exp MediumVioletRed = QRgb(0xC71585);
    enum_exp MidnightBlue = QRgb(0x191970);
    enum_exp MintCream = QRgb(0xF5FFFA);
    enum_exp MistyRose = QRgb(0xFFE4E1);
    enum_exp Moccasin = QRgb(0xFFE4B5);
    enum_exp NavajoWhite = QRgb(0xFFDEAD);
    enum_exp Navy = QRgb(0x000080);
    enum_exp OldLace = QRgb(0xFDF5E6);
    enum_exp Olive = QRgb(0x808000);
    enum_exp OliveDrab = QRgb(0x6B8E23);
    enum_exp Orange = QRgb(0xFFA500);
    enum_exp OrangeRed = QRgb(0xFF4500);
    enum_exp Orchid = QRgb(0xDA70D6);
    enum_exp PaleGoldenRod = QRgb(0xEEE8AA);
    enum_exp PaleGreen = QRgb(0x98FB98);
    enum_exp PaleTurquoise = QRgb(0xAFEEEE);
    enum_exp PaleVioletRed = QRgb(0xD87093);
    enum_exp PapayaWhip = QRgb(0xFFEFD5);
    enum_exp PeachPuff = QRgb(0xFFDAB9);
    enum_exp Peru = QRgb(0xCD853F);
    enum_exp Pink = QRgb(0xFFC0CB);
    enum_exp Plum = QRgb(0xDDA0DD);
    enum_exp PowderBlue = QRgb(0xB0E0E6);
    enum_exp Purple = QRgb(0x800080);
    enum_exp Red = QRgb(0xFF0000);
    enum_exp RosyBrown = QRgb(0xBC8F8F);
    enum_exp RoyalBlue = QRgb(0x4169E1);
    enum_exp SaddleBrown = QRgb(0x8B4513);
    enum_exp Salmon = QRgb(0xFA8072);
    enum_exp SandyBrown = QRgb(0xF4A460);
    enum_exp SeaGreen = QRgb(0x2E8B57);
    enum_exp SeaShell = QRgb(0xFFF5EE);
    enum_exp Sienna = QRgb(0xA0522D);
    enum_exp Silver = QRgb(0xC0C0C0);
    enum_exp SkyBlue = QRgb(0x87CEEB);
    enum_exp SlateBlue = QRgb(0x6A5ACD);
    enum_exp SlateGray = QRgb(0x708090);
    enum_exp Snow = QRgb(0xFFFAFA);
    enum_exp SpringGreen = QRgb(0x00FF7F);
    enum_exp SteelBlue = QRgb(0x4682B4);
    enum_exp Tan = QRgb(0xD2B48C);
    enum_exp Teal = QRgb(0x008080);
    enum_exp Thistle = QRgb(0xD8BFD8);
    enum_exp Tomato = QRgb(0xFF6347);
    enum_exp Turquoise = QRgb(0x40E0D0);
    enum_exp Violet = QRgb(0xEE82EE);
    enum_exp VioletRed = QRgb(0xD02090);
    enum_exp Wheat = QRgb(0xF5DEB3);
    enum_exp White = QRgb(0xFFFFFF);
    enum_exp WhiteSmoke = QRgb(0xF5F5F5);
    enum_exp Yellow = QRgb(0xFFFF00);
    enum_exp YellowGreen = QRgb(0x9ACD32);
};
}

#endif   // COLORDEFINE_H
