/*
 * Copyright (c) 1993 Branko Lankester <branko@hacktic.nl>
 * Copyright (c) 1993, 1994, 1995 Rick Sladkey <jrs@world.std.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
[  0] = { 2,	TM,		SEN(io_setup),			"io_setup"		},
[  1] = { 1,	TM,		SEN(io_destroy),		"io_destroy"		},
[  2] = { 3,	0,		SEN(io_submit),			"io_submit"		},
[  3] = { 3,	0,		SEN(io_cancel),			"io_cancel"		},
[  4] = { 5,	0,		SEN(io_getevents),		"io_getevents"		},
[  5] = { 5,	TF,		SEN(setxattr),			"setxattr"		},
[  6] = { 5,	TF,		SEN(setxattr),			"lsetxattr"		},
[  7] = { 5,	TD,		SEN(fsetxattr),			"fsetxattr"		},
[  8] = { 4,	TF,		SEN(getxattr),			"getxattr"		},
[  9] = { 4,	TF,		SEN(getxattr),			"lgetxattr"		},
[ 10] = { 4,	TD,		SEN(fgetxattr),			"fgetxattr"		},
[ 11] = { 3,	TF,		SEN(listxattr),			"listxattr"		},
[ 12] = { 3,	TF,		SEN(listxattr),			"llistxattr"		},
[ 13] = { 3,	TD,		SEN(flistxattr),		"flistxattr"		},
[ 14] = { 2,	TF,		SEN(removexattr),		"removexattr"		},
[ 15] = { 2,	TF,		SEN(removexattr),		"lremovexattr"		},
[ 16] = { 2,	TD,		SEN(fremovexattr),		"fremovexattr"		},
[ 17] = { 2,	TF,		SEN(getcwd),			"getcwd"		},
[ 18] = { 3,	0,		SEN(lookup_dcookie),		"lookup_dcookie"	},
[ 19] = { 2,	TD,		SEN(eventfd2),			"eventfd2"		},
[ 20] = { 1,	TD,		SEN(epoll_create1),		"epoll_create1"		},
[ 21] = { 4,	TD,		SEN(epoll_ctl),			"epoll_ctl"		},
[ 22] = { 6,	TD,		SEN(epoll_pwait),		"epoll_pwait"		},
[ 23] = { 1,	TD,		SEN(dup),			"dup"			},
[ 24] = { 3,	TD,		SEN(dup3),			"dup3"			},
[ 25] = { 3,	TD,		SEN(fcntl),			"fcntl"			},
[ 26] = { 1,	TD,		SEN(inotify_init1),		"inotify_init1"		},
[ 27] = { 3,	TD,		SEN(inotify_add_watch),		"inotify_add_watch"	},
[ 28] = { 2,	TD,		SEN(inotify_rm_watch),		"inotify_rm_watch"	},
[ 29] = { 3,	TD,		SEN(ioctl),			"ioctl"			},
[ 30] = { 3,	0,		SEN(ioprio_set),		"ioprio_set"		},
[ 31] = { 2,	0,		SEN(ioprio_get),		"ioprio_get"		},
[ 32] = { 2,	TD,		SEN(flock),			"flock"			},
[ 33] = { 4,	TD|TF,		SEN(mknodat),			"mknodat"		},
[ 34] = { 3,	TD|TF,		SEN(mkdirat),			"mkdirat"		},
[ 35] = { 3,	TD|TF,		SEN(unlinkat),			"unlinkat"		},
[ 36] = { 3,	TD|TF,		SEN(symlinkat),			"symlinkat"		},
[ 37] = { 5,	TD|TF,		SEN(linkat),			"linkat"		},
[ 38] = { 4,	TD|TF,		SEN(renameat),			"renameat"		},
[ 39] = { 2,	TF,		SEN(umount2),			"umount2"		},
[ 40] = { 5,	TF,		SEN(mount),			"mount"			},
[ 41] = { 2,	TF,		SEN(pivotroot),			"pivot_root"		},
[ 42] = { 3,	0,		SEN(nfsservctl),		"nfsservctl"		},
[ 43] = { 2,	TF,		SEN(statfs),			"statfs"		},
[ 44] = { 2,	TD,		SEN(fstatfs),			"fstatfs"		},
[ 45] = { 2,	TF,		SEN(truncate),			"truncate"		},
[ 46] = { 2,	TD,		SEN(ftruncate),			"ftruncate"		},
[ 47] = { 4,	TD,		SEN(fallocate),			"fallocate"		},
[ 48] = { 3,	TD|TF,		SEN(faccessat),			"faccessat"		},
[ 49] = { 1,	TF,		SEN(chdir),			"chdir"			},
[ 50] = { 1,	TD,		SEN(fchdir),			"fchdir"		},
[ 51] = { 1,	TF,		SEN(chroot),			"chroot"		},
[ 52] = { 2,	TD,		SEN(fchmod),			"fchmod"		},
[ 53] = { 3,	TD|TF,		SEN(fchmodat),			"fchmodat"		},
[ 54] = { 5,	TD|TF,		SEN(fchownat),			"fchownat"		},
[ 55] = { 3,	TD,		SEN(fchown),			"fchown"		},
[ 56] = { 4,	TD|TF,		SEN(openat),			"openat"		},
[ 57] = { 1,	TD,		SEN(close),			"close"			},
[ 58] = { 0,	0,		SEN(vhangup),			"vhangup"		},
[ 59] = { 2,	TD,		SEN(pipe2),			"pipe2"			},
[ 60] = { 4,	TF,		SEN(quotactl),			"quotactl"		},
[ 61] = { 3,	TD,		SEN(getdents64),		"getdents64"		},
[ 62] = { 3,	TD,		SEN(lseek),			"lseek"			},
[ 63] = { 3,	TD,		SEN(read),			"read"			},
[ 64] = { 3,	TD,		SEN(write),			"write"			},
[ 65] = { 3,	TD,		SEN(readv),			"readv"			},
[ 66] = { 3,	TD,		SEN(writev),			"writev"		},
[ 67] = { 4,	TD,		SEN(pread),			"pread64"		},
[ 68] = { 4,	TD,		SEN(pwrite),			"pwrite64"		},
[ 69] = { 4,	TD,		SEN(preadv),			"preadv"		},
[ 70] = { 4,	TD,		SEN(pwritev),			"pwritev"		},
[ 71] = { 4,	TD|TN,		SEN(sendfile64),		"sendfile"		},
[ 72] = { 6,	TD,		SEN(pselect6),			"pselect6"		},
[ 73] = { 5,	TD,		SEN(ppoll),			"ppoll"			},
[ 74] = { 4,	TD|TS,		SEN(signalfd4),			"signalfd4"		},
[ 75] = { 4,	TD,		SEN(vmsplice),			"vmsplice"		},
[ 76] = { 6,	TD,		SEN(splice),			"splice"		},
[ 77] = { 4,	TD,		SEN(tee),			"tee"			},
[ 78] = { 4,	TD|TF,		SEN(readlinkat),		"readlinkat"		},
[ 79] = { 4,	TD|TF,		SEN(newfstatat),		"newfstatat"		},
[ 80] = { 2,	TD,		SEN(fstat),			"fstat"			},
[ 81] = { 0,	0,		SEN(sync),			"sync"			},
[ 82] = { 1,	TD,		SEN(fsync),			"fsync"			},
[ 83] = { 1,	TD,		SEN(fdatasync),			"fdatasync"		},
[ 84] = { 4,	TD,		SEN(sync_file_range),		"sync_file_range"	},
[ 85] = { 2,	TD,		SEN(timerfd_create),		"timerfd_create"	},
[ 86] = { 4,	TD,		SEN(timerfd_settime),		"timerfd_settime"	},
[ 87] = { 2,	TD,		SEN(timerfd_gettime),		"timerfd_gettime"	},
[ 88] = { 4,	TD|TF,		SEN(utimensat),			"utimensat"		},
[ 89] = { 1,	TF,		SEN(acct),			"acct"			},
[ 90] = { 2,	0,		SEN(capget),			"capget"		},
[ 91] = { 2,	0,		SEN(capset),			"capset"		},
[ 92] = { 1,	NF,		SEN(personality),		"personality"		},
[ 93] = { 1,	TP|SE,		SEN(exit),			"exit"			},
[ 94] = { 1,	TP|SE,		SEN(exit),			"exit_group"		},
[ 95] = { 5,	TP,		SEN(waitid),			"waitid"		},
[ 96] = { 1,	0,		SEN(set_tid_address),		"set_tid_address"	},
[ 97] = { 1,	TP,		SEN(unshare),			"unshare"		},
[ 98] = { 6,	0,		SEN(futex),			"futex"			},
[ 99] = { 2,	0,		SEN(set_robust_list),		"set_robust_list"	},
[100] = { 3,	0,		SEN(get_robust_list),		"get_robust_list"	},
[101] = { 2,	0,		SEN(nanosleep),			"nanosleep"		},
[102] = { 2,	0,		SEN(getitimer),			"getitimer"		},
[103] = { 3,	0,		SEN(setitimer),			"setitimer"		},
[104] = { 4,	0,		SEN(kexec_load),		"kexec_load"		},
[105] = { 3,	0,		SEN(init_module),		"init_module"		},
[106] = { 2,	0,		SEN(delete_module),		"delete_module"		},
[107] = { 3,	0,		SEN(timer_create),		"timer_create"		},
[108] = { 2,	0,		SEN(timer_gettime),		"timer_gettime"		},
[109] = { 1,	0,		SEN(timer_getoverrun),		"timer_getoverrun"	},
[110] = { 4,	0,		SEN(timer_settime),		"timer_settime"		},
[111] = { 1,	0,		SEN(timer_delete),		"timer_delete"		},
[112] = { 2,	0,		SEN(clock_settime),		"clock_settime"		},
[113] = { 2,	0,		SEN(clock_gettime),		"clock_gettime"		},
[114] = { 2,	0,		SEN(clock_getres),		"clock_getres"		},
[115] = { 4,	0,		SEN(clock_nanosleep),		"clock_nanosleep"	},
[116] = { 3,	0,		SEN(syslog),			"syslog"		},
[117] = { 4,	0,		SEN(ptrace),			"ptrace"		},
[118] = { 2,	0,		SEN(sched_setparam),		"sched_setparam"	},
[119] = { 3,	0,		SEN(sched_setscheduler),	"sched_setscheduler"	},
[120] = { 1,	0,		SEN(sched_getscheduler),	"sched_getscheduler"	},
[121] = { 2,	0,		SEN(sched_getparam),		"sched_getparam"	},
[122] = { 3,	0,		SEN(sched_setaffinity),		"sched_setaffinity"	},
[123] = { 3,	0,		SEN(sched_getaffinity),		"sched_getaffinity"	},
[124] = { 0,	0,		SEN(sched_yield),		"sched_yield"		},
[125] = { 1,	0,		SEN(sched_get_priority_max),	"sched_get_priority_max"},
[126] = { 1,	0,		SEN(sched_get_priority_min),	"sched_get_priority_min"},
[127] = { 2,	0,		SEN(sched_rr_get_interval),	"sched_rr_get_interval"	},
[128] = { 0,	0,		SEN(restart_syscall),		"restart_syscall"	},
[129] = { 2,	TS,		SEN(kill),			"kill"			},
[130] = { 2,	TS,		SEN(kill),			"tkill"			},
[131] = { 3,	TS,		SEN(tgkill),			"tgkill"		},
[132] = { 2,	TS,		SEN(sigaltstack),		"sigaltstack"		},
[133] = { 2,	TS,		SEN(rt_sigsuspend),		"rt_sigsuspend"		},
[134] = { 4,	TS,		SEN(rt_sigaction),		"rt_sigaction"		},
[135] = { 4,	TS,		SEN(rt_sigprocmask),		"rt_sigprocmask"	},
[136] = { 2,	TS,		SEN(rt_sigpending),		"rt_sigpending"		},
[137] = { 4,	TS,		SEN(rt_sigtimedwait),		"rt_sigtimedwait"	},
[138] = { 3,	TS,		SEN(rt_sigqueueinfo),		"rt_sigqueueinfo"	},
[139] = { 0,	TS,		SEN(sigreturn),			"rt_sigreturn"		},
[140] = { 3,	0,		SEN(setpriority),		"setpriority"		},
[141] = { 2,	0,		SEN(getpriority),		"getpriority"		},
[142] = { 4,	0,		SEN(reboot),			"reboot"		},
[143] = { 2,	0,		SEN(setregid),			"setregid"		},
[144] = { 1,	0,		SEN(setgid),			"setgid"		},
[145] = { 2,	0,		SEN(setreuid),			"setreuid"		},
[146] = { 1,	0,		SEN(setuid),			"setuid"		},
[147] = { 3,	0,		SEN(setresuid),			"setresuid"		},
[148] = { 3,	0,		SEN(getresuid),			"getresuid"		},
[149] = { 3,	0,		SEN(setresgid),			"setresgid"		},
[150] = { 3,	0,		SEN(getresgid),			"getresgid"		},
[151] = { 1,	NF,		SEN(setfsuid),			"setfsuid"		},
[152] = { 1,	NF,		SEN(setfsgid),			"setfsgid"		},
[153] = { 1,	0,		SEN(times),			"times"			},
[154] = { 2,	0,		SEN(setpgid),			"setpgid"		},
[155] = { 1,	0,		SEN(getpgid),			"getpgid"		},
[156] = { 1,	0,		SEN(getsid),			"getsid"		},
[157] = { 0,	0,		SEN(setsid),			"setsid"		},
[158] = { 2,	0,		SEN(getgroups),			"getgroups"		},
[159] = { 2,	0,		SEN(setgroups),			"setgroups"		},
[160] = { 1,	0,		SEN(uname),			"uname"			},
[161] = { 2,	0,		SEN(sethostname),		"sethostname"		},
[162] = { 2,	0,		SEN(setdomainname),		"setdomainname"		},
[163] = { 2,	0,		SEN(getrlimit),			"getrlimit"		},
[164] = { 2,	0,		SEN(setrlimit),			"setrlimit"		},
[165] = { 2,	0,		SEN(getrusage),			"getrusage"		},
[166] = { 1,	NF,		SEN(umask),			"umask"			},
[167] = { 5,	0,		SEN(prctl),			"prctl"			},
[168] = { 3,	0,		SEN(getcpu),			"getcpu"		},
[169] = { 2,	0,		SEN(gettimeofday),		"gettimeofday"		},
[170] = { 2,	0,		SEN(settimeofday),		"settimeofday"		},
[171] = { 1,	0,		SEN(adjtimex),			"adjtimex"		},
[172] = { 0,	NF,		SEN(getpid),			"getpid"		},
[173] = { 0,	NF,		SEN(getppid),			"getppid"		},
[174] = { 0,	NF,		SEN(getuid),			"getuid"		},
[175] = { 0,	NF,		SEN(geteuid),			"geteuid"		},
[176] = { 0,	NF,		SEN(getgid),			"getgid"		},
[177] = { 0,	NF,		SEN(getegid),			"getegid"		},
[178] = { 0,	NF,		SEN(gettid),			"gettid"		},
[179] = { 1,	0,		SEN(sysinfo),			"sysinfo"		},
[180] = { 4,	0,		SEN(mq_open),			"mq_open"		},
[181] = { 1,	0,		SEN(mq_unlink),			"mq_unlink"		},
[182] = { 5,	0,		SEN(mq_timedsend),		"mq_timedsend"		},
[183] = { 5,	0,		SEN(mq_timedreceive),		"mq_timedreceive"	},
[184] = { 2,	0,		SEN(mq_notify),			"mq_notify"		},
[185] = { 3,	0,		SEN(mq_getsetattr),		"mq_getsetattr"		},
[186] = { 2,	TI,		SEN(msgget),			"msgget"		},
[187] = { 3,	TI,		SEN(msgctl),			"msgctl"		},
[188] = { 5,	TI,		SEN(msgrcv),			"msgrcv"		},
[189] = { 4,	TI,		SEN(msgsnd),			"msgsnd"		},
[190] = { 3,	TI,		SEN(semget),			"semget"		},
[191] = { 4,	TI,		SEN(semctl),			"semctl"		},
[192] = { 4,	TI,		SEN(semtimedop),		"semtimedop"		},
[193] = { 3,	TI,		SEN(semop),			"semop"			},
[194] = { 3,	TI,		SEN(shmget),			"shmget"		},
[195] = { 3,	TI,		SEN(shmctl),			"shmctl"		},
[196] = { 3,	TI|TM|SI,	SEN(shmat),			"shmat"			},
[197] = { 1,	TI|TM|SI,	SEN(shmdt),			"shmdt"			},
[198] = { 3,	TN,		SEN(socket),			"socket"		},
[199] = { 4,	TN,		SEN(socketpair),		"socketpair"		},
[200] = { 3,	TN,		SEN(bind),			"bind"			},
[201] = { 2,	TN,		SEN(listen),			"listen"		},
[202] = { 3,	TN,		SEN(accept),			"accept"		},
[203] = { 3,	TN,		SEN(connect),			"connect"		},
[204] = { 3,	TN,		SEN(getsockname),		"getsockname"		},
[205] = { 3,	TN,		SEN(getpeername),		"getpeername"		},
[206] = { 6,	TN,		SEN(sendto),			"sendto"		},
[207] = { 6,	TN,		SEN(recvfrom),			"recvfrom"		},
[208] = { 5,	TN,		SEN(setsockopt),		"setsockopt"		},
[209] = { 5,	TN,		SEN(getsockopt),		"getsockopt"		},
[210] = { 2,	TN,		SEN(shutdown),			"shutdown"		},
[211] = { 3,	TN,		SEN(sendmsg),			"sendmsg"		},
[212] = { 3,	TN,		SEN(recvmsg),			"recvmsg"		},
[213] = { 3,	TD,		SEN(readahead),			"readahead"		},
[214] = { 1,	TM|SI,		SEN(brk),			"brk"			},
[215] = { 2,	TM|SI,		SEN(munmap),			"munmap"		},
[216] = { 5,	TM|SI,		SEN(mremap),			"mremap"		},
[217] = { 5,	0,		SEN(add_key),			"add_key"		},
[218] = { 4,	0,		SEN(request_key),		"request_key"		},
[219] = { 5,	0,		SEN(keyctl),			"keyctl"		},
[220] = { 5,	TP,		SEN(clone),			"clone"			},
[221] = { 3,	TF|TP|SE|SI,	SEN(execve),			"execve"		},
[222] = { 6,	TD|TM|SI,	SEN(mmap),			"mmap"			},
[223] = { 4,	TD,		SEN(fadvise64),			"fadvise64"		},
[224] = { 2,	TF,		SEN(swapon),			"swapon"		},
[225] = { 1,	TF,		SEN(swapoff),			"swapoff"		},
[226] = { 3,	TM|SI,		SEN(mprotect),			"mprotect"		},
[227] = { 3,	TM,		SEN(msync),			"msync"			},
[228] = { 2,	TM,		SEN(mlock),			"mlock"			},
[229] = { 2,	TM,		SEN(munlock),			"munlock"		},
[230] = { 1,	TM,		SEN(mlockall),			"mlockall"		},
[231] = { 0,	TM,		SEN(munlockall),		"munlockall"		},
[232] = { 3,	TM,		SEN(mincore),			"mincore"		},
[233] = { 3,	TM,		SEN(madvise),			"madvise"		},
[234] = { 5,	TM|SI,		SEN(remap_file_pages),		"remap_file_pages"	},
[235] = { 6,	TM,		SEN(mbind),			"mbind"			},
[236] = { 5,	TM,		SEN(get_mempolicy),		"get_mempolicy"		},
[237] = { 3,	TM,		SEN(set_mempolicy),		"set_mempolicy"		},
[238] = { 4,	TM,		SEN(migrate_pages),		"migrate_pages"		},
[239] = { 6,	TM,		SEN(move_pages),		"move_pages"		},
[240] = { 4,	TP|TS,		SEN(rt_tgsigqueueinfo),		"rt_tgsigqueueinfo"	},
[241] = { 5,	TD,		SEN(perf_event_open),		"perf_event_open"	},
[242] = { 4,	TN,		SEN(accept4),			"accept4"		},
[243] = { 5,	TN,		SEN(recvmmsg),			"recvmmsg"		},
/* 244,259 Arch-specific block, not used on AArch64 */
[244] = {0, 0, 0, NULL},
[245] = {0, 0, 0, NULL},
[246] = {0, 0, 0, NULL},
[247] = {0, 0, 0, NULL},
[248] = {0, 0, 0, NULL},
[249] = {0, 0, 0, NULL},
[250] = {0, 0, 0, NULL},
[251] = {0, 0, 0, NULL},
[252] = {0, 0, 0, NULL},
[253] = {0, 0, 0, NULL},
[254] = {0, 0, 0, NULL},
[255] = {0, 0, 0, NULL},
[256] = {0, 0, 0, NULL},
[257] = {0, 0, 0, NULL},
[258] = {0, 0, 0, NULL},
[259] = {0, 0, 0, NULL},
[260] = { 4,	TP,		SEN(wait4),			"wait4"			},
[261] = { 4,	0,		SEN(prlimit64),			"prlimit64"		},
[262] = { 2,	TD,		SEN(fanotify_init),		"fanotify_init"		},
[263] = { 5,	TD|TF,		SEN(fanotify_mark),		"fanotify_mark"		},
[264] = { 5,	TD|TF,		SEN(name_to_handle_at),		"name_to_handle_at"	},
[265] = { 3,	TD,		SEN(open_by_handle_at),		"open_by_handle_at"	},
[266] = { 2,	0,		SEN(clock_adjtime),		"clock_adjtime"		},
[267] = { 1,	TD,		SEN(syncfs),			"syncfs"		},
[268] = { 2,	TD,		SEN(setns),			"setns"			},
[269] = { 4,	TN,		SEN(sendmmsg),			"sendmmsg"		},
[270] = { 6,	0,		SEN(process_vm_readv),		"process_vm_readv"	},
[271] = { 6,	0,		SEN(process_vm_writev),		"process_vm_writev"	},
[272] = { 5,	0,		SEN(kcmp),			"kcmp"			},
[273] = { 3,	TD,		SEN(finit_module),		"finit_module"		},
[274] = { 3,	0,		SEN(sched_setattr),		"sched_setattr"		},
[275] = { 4,	0,		SEN(sched_getattr),		"sched_getattr"		},
[276] = { 5,	TD|TF,		SEN(renameat2),			"renameat2"		},
[277] = { 3,	0,		SEN(seccomp),			"seccomp",		},
[278] = { 3,	0,		SEN(getrandom),			"getrandom",		},
[279] = { 2,	TD,		SEN(memfd_create),		"memfd_create",		},
[280] = { 3,	TD,		SEN(bpf),			"bpf",			},
[281] = { 5,	TD|TF|TP|SE|SI,	SEN(execveat),			"execveat",		},
[282] = { 1,	TD,		SEN(userfaultfd),		"userfaultfd",		},
[283] = { 2,	0,		SEN(membarrier),		"membarrier",		},
[284] = { 3,	TM,		SEN(mlock2),			"mlock2"		},
[285] = { 6,	TD,		SEN(copy_file_range),		"copy_file_range"	},
[286] = { 6,	TD,		SEN(preadv2),			"preadv2"		},
[287] = { 6,	TD,		SEN(pwritev2),			"pwritev2"		},
[288] = { 4,	TM|SI,		SEN(pkey_mprotect),		"pkey_mprotect"		},
[289] = { 2,	0,		SEN(pkey_alloc),		"pkey_alloc"		},
[290] = { 1,	0,		SEN(pkey_free),			"pkey_free"		},
[291] = {0, 0, 0, NULL},
[292] = {0, 0, 0, NULL},
[293] = {0, 0, 0, NULL},
[294] = {0, 0, 0, NULL},
[295] = {0, 0, 0, NULL},
[296] = {0, 0, 0, NULL},
[297] = {0, 0, 0, NULL},
[298] = {0, 0, 0, NULL},
[299] = {0, 0, 0, NULL},
[300] = {0, 0, 0, NULL},
[301] = {0, 0, 0, NULL},
[302] = {0, 0, 0, NULL},
[303] = {0, 0, 0, NULL},
[304] = {0, 0, 0, NULL},
[305] = {0, 0, 0, NULL},
[306] = {0, 0, 0, NULL},
[307] = {0, 0, 0, NULL},
[308] = {0, 0, 0, NULL},
[309] = {0, 0, 0, NULL},
[310] = {0, 0, 0, NULL},
[311] = {0, 0, 0, NULL},
[312] = {0, 0, 0, NULL},
[313] = {0, 0, 0, NULL},
[314] = {0, 0, 0, NULL},
[315] = {0, 0, 0, NULL},
[316] = {0, 0, 0, NULL},
[317] = {0, 0, 0, NULL},
[318] = {0, 0, 0, NULL},
[319] = {0, 0, 0, NULL},
[320] = {0, 0, 0, NULL},
[321] = {0, 0, 0, NULL},
[322] = {0, 0, 0, NULL},
[323] = {0, 0, 0, NULL},
[324] = {0, 0, 0, NULL},
[325] = {0, 0, 0, NULL},
[326] = {0, 0, 0, NULL},
[327] = {0, 0, 0, NULL},
[328] = {0, 0, 0, NULL},
[329] = {0, 0, 0, NULL},
[330] = {0, 0, 0, NULL},
[331] = {0, 0, 0, NULL},
[332] = {0, 0, 0, NULL},
[333] = {0, 0, 0, NULL},
[334] = {0, 0, 0, NULL},
[335] = {0, 0, 0, NULL},
[336] = {0, 0, 0, NULL},
[337] = {0, 0, 0, NULL},
[338] = {0, 0, 0, NULL},
[339] = {0, 0, 0, NULL},
[340] = {0, 0, 0, NULL},
[341] = {0, 0, 0, NULL},
[342] = {0, 0, 0, NULL},
[343] = {0, 0, 0, NULL},
[344] = {0, 0, 0, NULL},
[345] = {0, 0, 0, NULL},
[346] = {0, 0, 0, NULL},
[347] = {0, 0, 0, NULL},
[348] = {0, 0, 0, NULL},
[349] = {0, 0, 0, NULL},
[350] = {0, 0, 0, NULL},
[351] = {0, 0, 0, NULL},
[352] = {0, 0, 0, NULL},
[353] = {0, 0, 0, NULL},
[354] = {0, 0, 0, NULL},
[355] = {0, 0, 0, NULL},
[356] = {0, 0, 0, NULL},
[357] = {0, 0, 0, NULL},
[358] = {0, 0, 0, NULL},
[359] = {0, 0, 0, NULL},
[360] = {0, 0, 0, NULL},
[361] = {0, 0, 0, NULL},
[362] = {0, 0, 0, NULL},
[363] = {0, 0, 0, NULL},
[364] = {0, 0, 0, NULL},
[365] = {0, 0, 0, NULL},
[366] = {0, 0, 0, NULL},
[367] = {0, 0, 0, NULL},
[368] = {0, 0, 0, NULL},
[369] = {0, 0, 0, NULL},
[370] = {0, 0, 0, NULL},
[371] = {0, 0, 0, NULL},
[372] = {0, 0, 0, NULL},
[373] = {0, 0, 0, NULL},
[374] = {0, 0, 0, NULL},
[375] = {0, 0, 0, NULL},
[376] = {0, 0, 0, NULL},
[377] = {0, 0, 0, NULL},
[378] = {0, 0, 0, NULL},
[379] = {0, 0, 0, NULL},
[380] = {0, 0, 0, NULL},
[381] = {0, 0, 0, NULL},
[382] = {0, 0, 0, NULL},
[383] = {0, 0, 0, NULL},
[384] = {0, 0, 0, NULL},
[385] = {0, 0, 0, NULL},
[386] = {0, 0, 0, NULL},
[387] = {0, 0, 0, NULL},
[388] = {0, 0, 0, NULL},
[389] = {0, 0, 0, NULL},
[390] = {0, 0, 0, NULL},
[391] = {0, 0, 0, NULL},
[392] = {0, 0, 0, NULL},
[393] = {0, 0, 0, NULL},
[394] = {0, 0, 0, NULL},
[395] = {0, 0, 0, NULL},
[396] = {0, 0, 0, NULL},
[397] = {0, 0, 0, NULL},
[398] = {0, 0, 0, NULL},
[399] = {0, 0, 0, NULL},
[400] = {0, 0, 0, NULL},
[401] = {0, 0, 0, NULL},
[402] = {0, 0, 0, NULL},
[403] = {0, 0, 0, NULL},
[404] = {0, 0, 0, NULL},
[405] = {0, 0, 0, NULL},
[406] = {0, 0, 0, NULL},
[407] = {0, 0, 0, NULL},
[408] = {0, 0, 0, NULL},
[409] = {0, 0, 0, NULL},
[410] = {0, 0, 0, NULL},
[411] = {0, 0, 0, NULL},
[412] = {0, 0, 0, NULL},
[413] = {0, 0, 0, NULL},
[414] = {0, 0, 0, NULL},
[415] = {0, 0, 0, NULL},
[416] = {0, 0, 0, NULL},
[417] = {0, 0, 0, NULL},
[418] = {0, 0, 0, NULL},
[419] = {0, 0, 0, NULL},
[420] = {0, 0, 0, NULL},
[421] = {0, 0, 0, NULL},
[422] = {0, 0, 0, NULL},
[423] = {0, 0, 0, NULL},
[424] = {0, 0, 0, NULL},
[425] = {0, 0, 0, NULL},
[426] = {0, 0, 0, NULL},
[427] = {0, 0, 0, NULL},
[428] = {0, 0, 0, NULL},
[429] = {0, 0, 0, NULL},
[430] = {0, 0, 0, NULL},
[431] = {0, 0, 0, NULL},
[432] = {0, 0, 0, NULL},
[433] = {0, 0, 0, NULL},
[434] = {0, 0, 0, NULL},
[435] = {0, 0, 0, NULL},
[436] = {0, 0, 0, NULL},
[437] = {0, 0, 0, NULL},
[438] = {0, 0, 0, NULL},
[439] = {0, 0, 0, NULL},
[440] = {0, 0, 0, NULL},
[441] = {0, 0, 0, NULL},
[442] = {0, 0, 0, NULL},
[443] = {0, 0, 0, NULL},
[444] = {0, 0, 0, NULL},
[445] = {0, 0, 0, NULL},
[446] = {0, 0, 0, NULL},
[447] = {0, 0, 0, NULL},
[448] = {0, 0, 0, NULL},
[449] = {0, 0, 0, NULL},
[450] = {0, 0, 0, NULL},
[451] = {0, 0, 0, NULL},
[452] = {0, 0, 0, NULL},
[453] = {0, 0, 0, NULL},
[454] = {0, 0, 0, NULL},
[455] = {0, 0, 0, NULL},
[456] = {0, 0, 0, NULL},
[457] = {0, 0, 0, NULL},
[458] = {0, 0, 0, NULL},
[459] = {0, 0, 0, NULL},
[460] = {0, 0, 0, NULL},
[461] = {0, 0, 0, NULL},
[462] = {0, 0, 0, NULL},
[463] = {0, 0, 0, NULL},
[464] = {0, 0, 0, NULL},
[465] = {0, 0, 0, NULL},
[466] = {0, 0, 0, NULL},
[467] = {0, 0, 0, NULL},
[468] = {0, 0, 0, NULL},
[469] = {0, 0, 0, NULL},
[470] = {0, 0, 0, NULL},
[471] = {0, 0, 0, NULL},
[472] = {0, 0, 0, NULL},
[473] = {0, 0, 0, NULL},
[474] = {0, 0, 0, NULL},
[475] = {0, 0, 0, NULL},
[476] = {0, 0, 0, NULL},
[477] = {0, 0, 0, NULL},
[478] = {0, 0, 0, NULL},
[479] = {0, 0, 0, NULL},
[480] = {0, 0, 0, NULL},
[481] = {0, 0, 0, NULL},
[482] = {0, 0, 0, NULL},
[483] = {0, 0, 0, NULL},
[484] = {0, 0, 0, NULL},
[485] = {0, 0, 0, NULL},
[486] = {0, 0, 0, NULL},
[487] = {0, 0, 0, NULL},
[488] = {0, 0, 0, NULL},
[489] = {0, 0, 0, NULL},
[490] = {0, 0, 0, NULL},
[491] = {0, 0, 0, NULL},
[492] = {0, 0, 0, NULL},
[493] = {0, 0, 0, NULL},
[494] = {0, 0, 0, NULL},
[495] = {0, 0, 0, NULL},
[496] = {0, 0, 0, NULL},
[497] = {0, 0, 0, NULL},
[498] = {0, 0, 0, NULL},
[499] = {0, 0, 0, NULL},
[500] = {0, 0, 0, NULL},
[501] = {0, 0, 0, NULL},
[502] = {0, 0, 0, NULL},
[503] = {0, 0, 0, NULL},
[504] = {0, 0, 0, NULL},
[505] = {0, 0, 0, NULL},
[506] = {0, 0, 0, NULL},
[507] = {0, 0, 0, NULL},
[508] = {0, 0, 0, NULL},
[509] = {0, 0, 0, NULL},
[510] = {0, 0, 0, NULL},
[511] = {0, 0, 0, NULL},
[512] = {0, 0, 0, NULL},
[513] = {0, 0, 0, NULL},
[514] = {0, 0, 0, NULL},
[515] = {0, 0, 0, NULL},
[516] = {0, 0, 0, NULL},
[517] = {0, 0, 0, NULL},
[518] = {0, 0, 0, NULL},
[519] = {0, 0, 0, NULL},
[520] = {0, 0, 0, NULL},
[521] = {0, 0, 0, NULL},
[522] = {0, 0, 0, NULL},
[523] = {0, 0, 0, NULL},
[524] = {0, 0, 0, NULL},
[525] = {0, 0, 0, NULL},
[526] = {0, 0, 0, NULL},
[527] = {0, 0, 0, NULL},
[528] = {0, 0, 0, NULL},
[529] = {0, 0, 0, NULL},
[530] = {0, 0, 0, NULL},
[531] = {0, 0, 0, NULL},
[532] = {0, 0, 0, NULL},
[533] = {0, 0, 0, NULL},
[534] = {0, 0, 0, NULL},
[535] = {0, 0, 0, NULL},
[536] = {0, 0, 0, NULL},
[537] = {0, 0, 0, NULL},
[538] = {0, 0, 0, NULL},
[539] = {0, 0, 0, NULL},
[540] = {0, 0, 0, NULL},
[541] = {0, 0, 0, NULL},
[542] = {0, 0, 0, NULL},
[543] = {0, 0, 0, NULL},
[544] = {0, 0, 0, NULL},
[545] = {0, 0, 0, NULL},
[546] = {0, 0, 0, NULL},
[547] = {0, 0, 0, NULL},
[548] = {0, 0, 0, NULL},
[549] = {0, 0, 0, NULL},
[550] = {0, 0, 0, NULL},
[551] = {0, 0, 0, NULL},
[552] = {0, 0, 0, NULL},
[553] = {0, 0, 0, NULL},
[554] = {0, 0, 0, NULL},
[555] = {0, 0, 0, NULL},
[556] = {0, 0, 0, NULL},
[557] = {0, 0, 0, NULL},
[558] = {0, 0, 0, NULL},
[559] = {0, 0, 0, NULL},
[560] = {0, 0, 0, NULL},
[561] = {0, 0, 0, NULL},
[562] = {0, 0, 0, NULL},
[563] = {0, 0, 0, NULL},
[564] = {0, 0, 0, NULL},
[565] = {0, 0, 0, NULL},
[566] = {0, 0, 0, NULL},
[567] = {0, 0, 0, NULL},
[568] = {0, 0, 0, NULL},
[569] = {0, 0, 0, NULL},
[570] = {0, 0, 0, NULL},
[571] = {0, 0, 0, NULL},
[572] = {0, 0, 0, NULL},
[573] = {0, 0, 0, NULL},
[574] = {0, 0, 0, NULL},
[575] = {0, 0, 0, NULL},
[576] = {0, 0, 0, NULL},
[577] = {0, 0, 0, NULL},
[578] = {0, 0, 0, NULL},
[579] = {0, 0, 0, NULL},
[580] = {0, 0, 0, NULL},
[581] = {0, 0, 0, NULL},
[582] = {0, 0, 0, NULL},
[583] = {0, 0, 0, NULL},
[584] = {0, 0, 0, NULL},
[585] = {0, 0, 0, NULL},
[586] = {0, 0, 0, NULL},
[587] = {0, 0, 0, NULL},
[588] = {0, 0, 0, NULL},
[589] = {0, 0, 0, NULL},
[590] = {0, 0, 0, NULL},
[591] = {0, 0, 0, NULL},
[592] = {0, 0, 0, NULL},
[593] = {0, 0, 0, NULL},
[594] = {0, 0, 0, NULL},
[595] = {0, 0, 0, NULL},
[596] = {0, 0, 0, NULL},
[597] = {0, 0, 0, NULL},
[598] = {0, 0, 0, NULL},
[599] = {0, 0, 0, NULL},
[600] = {0, 0, 0, NULL},
[601] = {0, 0, 0, NULL},
[602] = {0, 0, 0, NULL},
[603] = {0, 0, 0, NULL},
[604] = {0, 0, 0, NULL},
[605] = {0, 0, 0, NULL},
[606] = {0, 0, 0, NULL},
[607] = {0, 0, 0, NULL},
[608] = {0, 0, 0, NULL},
[609] = {0, 0, 0, NULL},
[610] = {0, 0, 0, NULL},
[611] = {0, 0, 0, NULL},
[612] = {0, 0, 0, NULL},
[613] = {0, 0, 0, NULL},
[614] = {0, 0, 0, NULL},
[615] = {0, 0, 0, NULL},
[616] = {0, 0, 0, NULL},
[617] = {0, 0, 0, NULL},
[618] = {0, 0, 0, NULL},
[619] = {0, 0, 0, NULL},
[620] = {0, 0, 0, NULL},
[621] = {0, 0, 0, NULL},
[622] = {0, 0, 0, NULL},
[623] = {0, 0, 0, NULL},
[624] = {0, 0, 0, NULL},
[625] = {0, 0, 0, NULL},
[626] = {0, 0, 0, NULL},
[627] = {0, 0, 0, NULL},
[628] = {0, 0, 0, NULL},
[629] = {0, 0, 0, NULL},
[630] = {0, 0, 0, NULL},
[631] = {0, 0, 0, NULL},
[632] = {0, 0, 0, NULL},
[633] = {0, 0, 0, NULL},
[634] = {0, 0, 0, NULL},
[635] = {0, 0, 0, NULL},
[636] = {0, 0, 0, NULL},
[637] = {0, 0, 0, NULL},
[638] = {0, 0, 0, NULL},
[639] = {0, 0, 0, NULL},
[640] = {0, 0, 0, NULL},
[641] = {0, 0, 0, NULL},
[642] = {0, 0, 0, NULL},
[643] = {0, 0, 0, NULL},
[644] = {0, 0, 0, NULL},
[645] = {0, 0, 0, NULL},
[646] = {0, 0, 0, NULL},
[647] = {0, 0, 0, NULL},
[648] = {0, 0, 0, NULL},
[649] = {0, 0, 0, NULL},
[650] = {0, 0, 0, NULL},
[651] = {0, 0, 0, NULL},
[652] = {0, 0, 0, NULL},
[653] = {0, 0, 0, NULL},
[654] = {0, 0, 0, NULL},
[655] = {0, 0, 0, NULL},
[656] = {0, 0, 0, NULL},
[657] = {0, 0, 0, NULL},
[658] = {0, 0, 0, NULL},
[659] = {0, 0, 0, NULL},
[660] = {0, 0, 0, NULL},
[661] = {0, 0, 0, NULL},
[662] = {0, 0, 0, NULL},
[663] = {0, 0, 0, NULL},
[664] = {0, 0, 0, NULL},
[665] = {0, 0, 0, NULL},
[666] = {0, 0, 0, NULL},
[667] = {0, 0, 0, NULL},
[668] = {0, 0, 0, NULL},
[669] = {0, 0, 0, NULL},
[670] = {0, 0, 0, NULL},
[671] = {0, 0, 0, NULL},
[672] = {0, 0, 0, NULL},
[673] = {0, 0, 0, NULL},
[674] = {0, 0, 0, NULL},
[675] = {0, 0, 0, NULL},
[676] = {0, 0, 0, NULL},
[677] = {0, 0, 0, NULL},
[678] = {0, 0, 0, NULL},
[679] = {0, 0, 0, NULL},
[680] = {0, 0, 0, NULL},
[681] = {0, 0, 0, NULL},
[682] = {0, 0, 0, NULL},
[683] = {0, 0, 0, NULL},
[684] = {0, 0, 0, NULL},
[685] = {0, 0, 0, NULL},
[686] = {0, 0, 0, NULL},
[687] = {0, 0, 0, NULL},
[688] = {0, 0, 0, NULL},
[689] = {0, 0, 0, NULL},
[690] = {0, 0, 0, NULL},
[691] = {0, 0, 0, NULL},
[692] = {0, 0, 0, NULL},
[693] = {0, 0, 0, NULL},
[694] = {0, 0, 0, NULL},
[695] = {0, 0, 0, NULL},
[696] = {0, 0, 0, NULL},
[697] = {0, 0, 0, NULL},
[698] = {0, 0, 0, NULL},
[699] = {0, 0, 0, NULL},
[700] = {0, 0, 0, NULL},
[701] = {0, 0, 0, NULL},
[702] = {0, 0, 0, NULL},
[703] = {0, 0, 0, NULL},
[704] = {0, 0, 0, NULL},
[705] = {0, 0, 0, NULL},
[706] = {0, 0, 0, NULL},
[707] = {0, 0, 0, NULL},
[708] = {0, 0, 0, NULL},
[709] = {0, 0, 0, NULL},
[710] = {0, 0, 0, NULL},
[711] = {0, 0, 0, NULL},
[712] = {0, 0, 0, NULL},
[713] = {0, 0, 0, NULL},
[714] = {0, 0, 0, NULL},
[715] = {0, 0, 0, NULL},
[716] = {0, 0, 0, NULL},
[717] = {0, 0, 0, NULL},
[718] = {0, 0, 0, NULL},
[719] = {0, 0, 0, NULL},
[720] = {0, 0, 0, NULL},
[721] = {0, 0, 0, NULL},
[722] = {0, 0, 0, NULL},
[723] = {0, 0, 0, NULL},
[724] = {0, 0, 0, NULL},
[725] = {0, 0, 0, NULL},
[726] = {0, 0, 0, NULL},
[727] = {0, 0, 0, NULL},
[728] = {0, 0, 0, NULL},
[729] = {0, 0, 0, NULL},
[730] = {0, 0, 0, NULL},
[731] = {0, 0, 0, NULL},
[732] = {0, 0, 0, NULL},
[733] = {0, 0, 0, NULL},
[734] = {0, 0, 0, NULL},
[735] = {0, 0, 0, NULL},
[736] = {0, 0, 0, NULL},
[737] = {0, 0, 0, NULL},
[738] = {0, 0, 0, NULL},
[739] = {0, 0, 0, NULL},
[740] = {0, 0, 0, NULL},
[741] = {0, 0, 0, NULL},
[742] = {0, 0, 0, NULL},
[743] = {0, 0, 0, NULL},
[744] = {0, 0, 0, NULL},
[745] = {0, 0, 0, NULL},
[746] = {0, 0, 0, NULL},
[747] = {0, 0, 0, NULL},
[748] = {0, 0, 0, NULL},
[749] = {0, 0, 0, NULL},
[750] = {0, 0, 0, NULL},
[751] = {0, 0, 0, NULL},
[752] = {0, 0, 0, NULL},
[753] = {0, 0, 0, NULL},
[754] = {0, 0, 0, NULL},
[755] = {0, 0, 0, NULL},
[756] = {0, 0, 0, NULL},
[757] = {0, 0, 0, NULL},
[758] = {0, 0, 0, NULL},
[759] = {0, 0, 0, NULL},
[760] = {0, 0, 0, NULL},
[761] = {0, 0, 0, NULL},
[762] = {0, 0, 0, NULL},
[763] = {0, 0, 0, NULL},
[764] = {0, 0, 0, NULL},
[765] = {0, 0, 0, NULL},
[766] = {0, 0, 0, NULL},
[767] = {0, 0, 0, NULL},
[768] = {0, 0, 0, NULL},
[769] = {0, 0, 0, NULL},
[770] = {0, 0, 0, NULL},
[771] = {0, 0, 0, NULL},
[772] = {0, 0, 0, NULL},
[773] = {0, 0, 0, NULL},
[774] = {0, 0, 0, NULL},
[775] = {0, 0, 0, NULL},
[776] = {0, 0, 0, NULL},
[777] = {0, 0, 0, NULL},
[778] = {0, 0, 0, NULL},
[779] = {0, 0, 0, NULL},
[780] = {0, 0, 0, NULL},
[781] = {0, 0, 0, NULL},
[782] = {0, 0, 0, NULL},
[783] = {0, 0, 0, NULL},
[784] = {0, 0, 0, NULL},
[785] = {0, 0, 0, NULL},
[786] = {0, 0, 0, NULL},
[787] = {0, 0, 0, NULL},
[788] = {0, 0, 0, NULL},
[789] = {0, 0, 0, NULL},
[790] = {0, 0, 0, NULL},
[791] = {0, 0, 0, NULL},
[792] = {0, 0, 0, NULL},
[793] = {0, 0, 0, NULL},
[794] = {0, 0, 0, NULL},
[795] = {0, 0, 0, NULL},
[796] = {0, 0, 0, NULL},
[797] = {0, 0, 0, NULL},
[798] = {0, 0, 0, NULL},
[799] = {0, 0, 0, NULL},
[800] = {0, 0, 0, NULL},
[801] = {0, 0, 0, NULL},
[802] = {0, 0, 0, NULL},
[803] = {0, 0, 0, NULL},
[804] = {0, 0, 0, NULL},
[805] = {0, 0, 0, NULL},
[806] = {0, 0, 0, NULL},
[807] = {0, 0, 0, NULL},
[808] = {0, 0, 0, NULL},
[809] = {0, 0, 0, NULL},
[810] = {0, 0, 0, NULL},
[811] = {0, 0, 0, NULL},
[812] = {0, 0, 0, NULL},
[813] = {0, 0, 0, NULL},
[814] = {0, 0, 0, NULL},
[815] = {0, 0, 0, NULL},
[816] = {0, 0, 0, NULL},
[817] = {0, 0, 0, NULL},
[818] = {0, 0, 0, NULL},
[819] = {0, 0, 0, NULL},
[820] = {0, 0, 0, NULL},
[821] = {0, 0, 0, NULL},
[822] = {0, 0, 0, NULL},
[823] = {0, 0, 0, NULL},
[824] = {0, 0, 0, NULL},
[825] = {0, 0, 0, NULL},
[826] = {0, 0, 0, NULL},
[827] = {0, 0, 0, NULL},
[828] = {0, 0, 0, NULL},
[829] = {0, 0, 0, NULL},
[830] = {0, 0, 0, NULL},
[831] = {0, 0, 0, NULL},
[832] = {0, 0, 0, NULL},
[833] = {0, 0, 0, NULL},
[834] = {0, 0, 0, NULL},
[835] = {0, 0, 0, NULL},
[836] = {0, 0, 0, NULL},
[837] = {0, 0, 0, NULL},
[838] = {0, 0, 0, NULL},
[839] = {0, 0, 0, NULL},
[840] = {0, 0, 0, NULL},
[841] = {0, 0, 0, NULL},
[842] = {0, 0, 0, NULL},
[843] = {0, 0, 0, NULL},
[844] = {0, 0, 0, NULL},
[845] = {0, 0, 0, NULL},
[846] = {0, 0, 0, NULL},
[847] = {0, 0, 0, NULL},
[848] = {0, 0, 0, NULL},
[849] = {0, 0, 0, NULL},
[850] = {0, 0, 0, NULL},
[851] = {0, 0, 0, NULL},
[852] = {0, 0, 0, NULL},
[853] = {0, 0, 0, NULL},
[854] = {0, 0, 0, NULL},
[855] = {0, 0, 0, NULL},
[856] = {0, 0, 0, NULL},
[857] = {0, 0, 0, NULL},
[858] = {0, 0, 0, NULL},
[859] = {0, 0, 0, NULL},
[860] = {0, 0, 0, NULL},
[861] = {0, 0, 0, NULL},
[862] = {0, 0, 0, NULL},
[863] = {0, 0, 0, NULL},
[864] = {0, 0, 0, NULL},
[865] = {0, 0, 0, NULL},
[866] = {0, 0, 0, NULL},
[867] = {0, 0, 0, NULL},
[868] = {0, 0, 0, NULL},
[869] = {0, 0, 0, NULL},
[870] = {0, 0, 0, NULL},
[871] = {0, 0, 0, NULL},
[872] = {0, 0, 0, NULL},
[873] = {0, 0, 0, NULL},
[874] = {0, 0, 0, NULL},
[875] = {0, 0, 0, NULL},
[876] = {0, 0, 0, NULL},
[877] = {0, 0, 0, NULL},
[878] = {0, 0, 0, NULL},
[879] = {0, 0, 0, NULL},
[880] = {0, 0, 0, NULL},
[881] = {0, 0, 0, NULL},
[882] = {0, 0, 0, NULL},
[883] = {0, 0, 0, NULL},
[884] = {0, 0, 0, NULL},
[885] = {0, 0, 0, NULL},
[886] = {0, 0, 0, NULL},
[887] = {0, 0, 0, NULL},
[888] = {0, 0, 0, NULL},
[889] = {0, 0, 0, NULL},
[890] = {0, 0, 0, NULL},
[891] = {0, 0, 0, NULL},
[892] = {0, 0, 0, NULL},
[893] = {0, 0, 0, NULL},
[894] = {0, 0, 0, NULL},
[895] = {0, 0, 0, NULL},
[896] = {0, 0, 0, NULL},
[897] = {0, 0, 0, NULL},
[898] = {0, 0, 0, NULL},
[899] = {0, 0, 0, NULL},
[900] = {0, 0, 0, NULL},
[901] = {0, 0, 0, NULL},
[902] = {0, 0, 0, NULL},
[903] = {0, 0, 0, NULL},
[904] = {0, 0, 0, NULL},
[905] = {0, 0, 0, NULL},
[906] = {0, 0, 0, NULL},
[907] = {0, 0, 0, NULL},
[908] = {0, 0, 0, NULL},
[909] = {0, 0, 0, NULL},
[910] = {0, 0, 0, NULL},
[911] = {0, 0, 0, NULL},
[912] = {0, 0, 0, NULL},
[913] = {0, 0, 0, NULL},
[914] = {0, 0, 0, NULL},
[915] = {0, 0, 0, NULL},
[916] = {0, 0, 0, NULL},
[917] = {0, 0, 0, NULL},
[918] = {0, 0, 0, NULL},
[919] = {0, 0, 0, NULL},
[920] = {0, 0, 0, NULL},
[921] = {0, 0, 0, NULL},
[922] = {0, 0, 0, NULL},
[923] = {0, 0, 0, NULL},
[924] = {0, 0, 0, NULL},
[925] = {0, 0, 0, NULL},
[926] = {0, 0, 0, NULL},
[927] = {0, 0, 0, NULL},
[928] = {0, 0, 0, NULL},
[929] = {0, 0, 0, NULL},
[930] = {0, 0, 0, NULL},
[931] = {0, 0, 0, NULL},
[932] = {0, 0, 0, NULL},
[933] = {0, 0, 0, NULL},
[934] = {0, 0, 0, NULL},
[935] = {0, 0, 0, NULL},
[936] = {0, 0, 0, NULL},
[937] = {0, 0, 0, NULL},
[938] = {0, 0, 0, NULL},
[939] = {0, 0, 0, NULL},
[940] = {0, 0, 0, NULL},
[941] = {0, 0, 0, NULL},
[942] = {0, 0, 0, NULL},
[943] = {0, 0, 0, NULL},
[944] = {0, 0, 0, NULL},
[945] = {0, 0, 0, NULL},
[946] = {0, 0, 0, NULL},
[947] = {0, 0, 0, NULL},
[948] = {0, 0, 0, NULL},
[949] = {0, 0, 0, NULL},
[950] = {0, 0, 0, NULL},
[951] = {0, 0, 0, NULL},
[952] = {0, 0, 0, NULL},
[953] = {0, 0, 0, NULL},
[954] = {0, 0, 0, NULL},
[955] = {0, 0, 0, NULL},
[956] = {0, 0, 0, NULL},
[957] = {0, 0, 0, NULL},
[958] = {0, 0, 0, NULL},
[959] = {0, 0, 0, NULL},
[960] = {0, 0, 0, NULL},
[961] = {0, 0, 0, NULL},
[962] = {0, 0, 0, NULL},
[963] = {0, 0, 0, NULL},
[964] = {0, 0, 0, NULL},
[965] = {0, 0, 0, NULL},
[966] = {0, 0, 0, NULL},
[967] = {0, 0, 0, NULL},
[968] = {0, 0, 0, NULL},
[969] = {0, 0, 0, NULL},
[970] = {0, 0, 0, NULL},
[971] = {0, 0, 0, NULL},
[972] = {0, 0, 0, NULL},
[973] = {0, 0, 0, NULL},
[974] = {0, 0, 0, NULL},
[975] = {0, 0, 0, NULL},
[976] = {0, 0, 0, NULL},
[977] = {0, 0, 0, NULL},
[978] = {0, 0, 0, NULL},
[979] = {0, 0, 0, NULL},
[980] = {0, 0, 0, NULL},
[981] = {0, 0, 0, NULL},
[982] = {0, 0, 0, NULL},
[983] = {0, 0, 0, NULL},
[984] = {0, 0, 0, NULL},
[985] = {0, 0, 0, NULL},
[986] = {0, 0, 0, NULL},
[987] = {0, 0, 0, NULL},
[988] = {0, 0, 0, NULL},
[989] = {0, 0, 0, NULL},
[990] = {0, 0, 0, NULL},
[991] = {0, 0, 0, NULL},
[992] = {0, 0, 0, NULL},
[993] = {0, 0, 0, NULL},
[994] = {0, 0, 0, NULL},
[995] = {0, 0, 0, NULL},
[996] = {0, 0, 0, NULL},
[997] = {0, 0, 0, NULL},
[998] = {0, 0, 0, NULL},
[999] = {0, 0, 0, NULL},
[1000] = {0, 0, 0, NULL},
[1001] = {0, 0, 0, NULL},
[1002] = {0, 0, 0, NULL},
[1003] = {0, 0, 0, NULL},
[1004] = {0, 0, 0, NULL},
[1005] = {0, 0, 0, NULL},
[1006] = {0, 0, 0, NULL},
[1007] = {0, 0, 0, NULL},
[1008] = {0, 0, 0, NULL},
[1009] = {0, 0, 0, NULL},
[1010] = {0, 0, 0, NULL},
[1011] = {0, 0, 0, NULL},
[1012] = {0, 0, 0, NULL},
[1013] = {0, 0, 0, NULL},
[1014] = {0, 0, 0, NULL},
[1015] = {0, 0, 0, NULL},
[1016] = {0, 0, 0, NULL},
[1017] = {0, 0, 0, NULL},
[1018] = {0, 0, 0, NULL},
[1019] = {0, 0, 0, NULL},
[1020] = {0, 0, 0, NULL},
[1021] = {0, 0, 0, NULL},
[1022] = {0, 0, 0, NULL},
[1023] = {0, 0, 0, NULL},
[1024] = { 3,	TD|TF,		SEN(open),		"open"		},
[1025] = { 2,	TF,		SEN(link),		"link"		},
[1026] = { 1,	TF,		SEN(unlink),		"unlink"	},
[1027] = { 3,	TF,		SEN(mknod),		"mknod"		},
[1028] = { 2,	TF,		SEN(chmod),		"chmod"		},
[1029] = { 3,	TF,		SEN(chown),		"chown"		},
[1030] = { 2,	TF,		SEN(mkdir),		"mkdir"		},
[1031] = { 1,	TF,		SEN(rmdir),		"rmdir"		},
[1032] = { 3,	TF,		SEN(chown),		"lchown"	},
[1033] = { 2,	TF,		SEN(access),		"access"	},
[1034] = { 2,	TF,		SEN(rename),		"rename"	},
[1035] = { 3,	TF,		SEN(readlink),		"readlink"	},
[1036] = { 2,	TF,		SEN(symlink),		"symlink"	},
[1037] = { 2,	TF,		SEN(utimes),		"utimes"	},
[1038] = { 2,	TF,		SEN(stat),		"stat"		},
[1039] = { 2,	TF,		SEN(lstat),		"lstat"		},
[1040] = { 1,	TD,		SEN(pipe),		"pipe"		},
[1041] = { 2,	TD,		SEN(dup2),		"dup2"		},
[1042] = { 1,	TD,		SEN(epoll_create),	"epoll_create"	},
[1043] = { 0,	TD,		SEN(inotify_init),	"inotify_init"	},
[1044] = { 1,	TD,		SEN(eventfd),		"eventfd"	},
[1045] = { 3,	TD|TS,		SEN(signalfd),		"signalfd"	},
[1046] = { 4,	TD|TN,		SEN(sendfile64),	"sendfile"	},
[1047] = { 2,	TD,		SEN(ftruncate),		"ftruncate"	},
[1048] = { 2,	TF,		SEN(truncate),		"truncate"	},
[1049] = { 2,	TF,		SEN(stat),		"stat"		},
[1050] = { 2,	TF,		SEN(lstat),		"lstat"		},
[1051] = { 2,	TD,		SEN(fstat),		"fstat"		},
[1052] = { 3,	TD,		SEN(fcntl),		"fcntl"		},
[1053] = { 4,	TD,		SEN(fadvise64),		"fadvise64"	},
[1054] = { 4,	TD|TF,		SEN(newfstatat),	"newfstatat"	},
[1055] = { 2,	TD,		SEN(fstatfs),		"fstatfs"	},
[1056] = { 2,	TF,		SEN(statfs),		"statfs"	},
[1057] = { 3,	TD,		SEN(lseek),		"lseek"		},
[1058] = { 6,	TD|TM|SI,	SEN(mmap),		"mmap"		},
[1059] = { 1,	0,		SEN(alarm),		"alarm"		},
[1060] = { 0,	0,		SEN(getpgrp),		"getpgrp"	},
[1061] = { 0,	TS,		SEN(pause),		"pause"		},
[1062] = { 1,	0,		SEN(time),		"time"		},
[1063] = { 2,	TF,		SEN(utime),		"utime"		},
[1064] = { 2,	TD|TF,		SEN(creat),		"creat"		},
[1065] = { 3,	TD,		SEN(getdents),		"getdents"	},
[1066] = { 3,	TD|TF,		SEN(futimesat),		"futimesat"	},
[1067] = { 5,	TD,		SEN(select),		"select"	},
[1068] = { 3,	TD,		SEN(poll),		"poll"		},
[1069] = { 4,	TD,		SEN(epoll_wait),	"epoll_wait"	},
[1070] = { 2,	0,		SEN(ustat),		"ustat"		},
[1071] = { 0,	TP,		SEN(vfork),		"vfork"		},
[1072] = { 4,	TP,		SEN(wait4),		"wait4"		},
[1073] = { 4,	TN,		SEN(recv),		"recv"		},
[1074] = { 4,	TN,		SEN(send),		"send"		},
[1075] = { 2,	0,		SEN(bdflush),		"bdflush"	},
[1076] = { 1,	TF,		SEN(umount),		"umount"	},
[1077] = { 1,	TF,		SEN(uselib),		"uselib"	},
[1078] = { 1,	0,		SEN(sysctl),		"sysctl"	},
[1079] = { 0,	TP,		SEN(fork),		"fork"		},
