/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.XPathComparable;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.CodepointIterator;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UniStringConsumer;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.z.IntIterator;

public class StringValue
extends AtomicValue {
    protected UnicodeString content;
    public static final StringValue EMPTY_STRING = new StringValue(EmptyUnicodeString.getInstance());
    public static final StringValue SINGLE_SPACE = new StringValue(StringConstants.SINGLE_SPACE);
    public static final StringValue TRUE = new StringValue(StringConstants.TRUE);
    public static final StringValue FALSE = new StringValue(StringConstants.FALSE);
    public static final StringValue ZERO_LENGTH_UNTYPED = StringValue.makeUntypedAtomic(EmptyUnicodeString.getInstance());

    protected StringValue() {
        this.content = EmptyUnicodeString.getInstance();
        this.typeLabel = BuiltInAtomicType.STRING;
    }

    public StringValue(UnicodeString content) {
        this(content, (AtomicType)BuiltInAtomicType.STRING);
    }

    public StringValue(UnicodeString content, AtomicType type) {
        this.content = content;
        this.typeLabel = type;
    }

    public StringValue(String value) {
        this(value, (AtomicType)BuiltInAtomicType.STRING);
    }

    public StringValue(String value, AtomicType typeLabel) {
        this.content = StringView.of(value).tidy();
        this.typeLabel = typeLabel;
    }

    public static StringValue makeUntypedAtomic(UnicodeString value) {
        return new StringValue(value, (AtomicType)BuiltInAtomicType.UNTYPED_ATOMIC);
    }

    @Override
    public StringValue copyAsSubType(AtomicType typeLabel) {
        if (typeLabel == this.typeLabel) {
            return this;
        }
        StringValue v = new StringValue();
        v.typeLabel = typeLabel;
        v.content = this.content;
        return v;
    }

    public static StringValue bmp(String content) {
        return new StringValue(BMPString.of(content));
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return this.typeLabel == BuiltInAtomicType.UNTYPED_ATOMIC ? BuiltInAtomicType.UNTYPED_ATOMIC : BuiltInAtomicType.STRING;
    }

    public static StringValue makeStringValue(CharSequence value) {
        if (value == null || value.length() == 0) {
            return EMPTY_STRING;
        }
        return new StringValue(value.toString());
    }

    public static StringValue makeUStringValue(UnicodeString value) {
        if (value == null || value.isEmpty()) {
            return EMPTY_STRING;
        }
        return new StringValue(value);
    }

    @Override
    public UnicodeString getPrimitiveStringValue() {
        return this.content;
    }

    public UnicodeString getContent() {
        return this.content;
    }

    public long length() {
        return this.content.length();
    }

    public int length32() {
        return this.content.length32();
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public synchronized AtomicIterator iterateCharacters() {
        return new CodepointIterator(this.codePoints());
    }

    @Override
    public AtomicMatchKey getXPathMatchKey(StringCollator collator, int implicitTimezone) {
        return collator.getCollationKey(this.getUnicodeStringValue());
    }

    public Base64BinaryValue getCodepointCollationKey() {
        int len = this.getContent().length32();
        byte[] result = new byte[len * 3];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int c = this.getContent().codePointAt(i);
            result[j++] = (byte)(c >> 16);
            result[j++] = (byte)(c >> 8);
            result[j++] = (byte)c;
        }
        return new Base64BinaryValue(result);
    }

    public IntIterator codePoints() {
        return this.content.codePoints();
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int count = 0;
        IntIterator iter = this.codePoints();
        while (iter.hasNext()) {
            h2 = 31 * h2 + iter.next();
            if (++count < 100) continue;
            break;
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof StringValue) {
            return this.content.equals(((StringValue)o).content);
        }
        return false;
    }

    @Override
    public boolean effectiveBooleanValue() {
        return !this.isEmpty();
    }

    @Override
    public String toString() {
        return this.getContent().toString();
    }

    @Override
    public UnicodeString getUnicodeStringValue() {
        return this.content;
    }

    @Override
    public String toShortString() {
        String s2 = this.content.toString();
        if (s2.length() > 40) {
            s2 = s2.substring(0, 20) + " ... " + s2.substring(s2.length() - 20);
        }
        s2 = "\"" + s2 + '\"';
        if (this.typeLabel == BuiltInAtomicType.UNTYPED_ATOMIC) {
            s2 = "u" + s2;
        }
        return s2;
    }

    @Override
    public XPathComparable getXPathComparable(final StringCollator collator, int implicitTimezone) throws NoDynamicContextException {
        return new XPathComparable(){

            @Override
            public int compareTo(XPathComparable o) {
                if (o instanceof StringValue) {
                    return collator.compareStrings(StringValue.this.getContent(), ((StringValue)((Object)o)).content);
                }
                throw new ClassCastException("Cannot compare xs:string to " + o.toString());
            }
        };
    }

    @Override
    public boolean isIdentical(AtomicValue v) {
        return v instanceof StringValue && this instanceof AnyURIValue == v instanceof AnyURIValue && this.isUntypedAtomic() == v.isUntypedAtomic() && this.equals(v);
    }

    public static final class Builder
    implements UniStringConsumer {
        UnicodeBuilder buffer = new UnicodeBuilder();

        @Override
        public UniStringConsumer accept(UnicodeString chars) {
            this.buffer.accept(chars);
            return this;
        }

        public UnicodeString getStringValue() {
            return this.buffer.toUnicodeString();
        }
    }

    public static final class CharacterIterator
    implements AtomicIterator {
        int inpos = 0;
        private final CharSequence value;

        public CharacterIterator(CharSequence value) {
            this.value = value;
        }

        @Override
        public Int64Value next() {
            if (this.inpos < this.value.length()) {
                int current;
                int c;
                if ((c = this.value.charAt(this.inpos++)) >= 55296 && c <= 56319) {
                    try {
                        current = (c - 55296) * 1024 + (this.value.charAt(this.inpos++) - 56320) + 65536;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new AssertionError((Object)("Invalid surrogate at end of string: " + StringTool.diagnosticDisplay(this.value.toString())));
                    }
                } else {
                    current = c;
                }
                return new Int64Value(current);
            }
            return null;
        }
    }
}

