# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

* [`java_ks::config`](#java_ks--config): java_ks configuration

### Resource types

* [`java_ks`](#java_ks): Manages the entries in a java keystore, and uses composite namevars to accomplish the same alias spread across multiple target keystores.

## Classes

### <a name="java_ks--config"></a>`java_ks::config`

java_ks configuration

#### Parameters

The following parameters are available in the `java_ks::config` class:

* [`params`](#-java_ks--config--params)

##### <a name="-java_ks--config--params"></a>`params`

Data type: `Hash`

A hash containing the parameters required for the java config.

Default value: `{}`

## Resource types

### <a name="java_ks"></a>`java_ks`

Manages the entries in a java keystore, and uses composite namevars to
accomplish the same alias spread across multiple target keystores.

#### Properties

The following properties are available in the `java_ks` type.

##### `ensure`

Valid values: `present`, `absent`, `latest`

Has three states: present, absent, and latest.  Latest
will compare the on disk SHA1 fingerprint of the certificate to that
in keytool to determine if insync? returns true or false.  We redefine
insync? for this parameter to accomplish this.

Default value: `present`

##### `password`

The password used to protect the keystore.  If private keys are
subsequently also protected this password will be used to attempt
unlocking. Must be six or more characters in length. Cannot be used
together with :password_file, but you must pass at least one of these parameters.

#### Parameters

The following parameters are available in the `java_ks` type.

* [`certificate`](#-java_ks--certificate)
* [`certificate_content`](#-java_ks--certificate_content)
* [`chain`](#-java_ks--chain)
* [`destkeypass`](#-java_ks--destkeypass)
* [`keytool_timeout`](#-java_ks--keytool_timeout)
* [`name`](#-java_ks--name)
* [`password_fail_reset`](#-java_ks--password_fail_reset)
* [`password_file`](#-java_ks--password_file)
* [`path`](#-java_ks--path)
* [`private_key`](#-java_ks--private_key)
* [`private_key_content`](#-java_ks--private_key_content)
* [`private_key_type`](#-java_ks--private_key_type)
* [`provider`](#-java_ks--provider)
* [`source_alias`](#-java_ks--source_alias)
* [`source_password`](#-java_ks--source_password)
* [`storetype`](#-java_ks--storetype)
* [`target`](#-java_ks--target)
* [`trustcacerts`](#-java_ks--trustcacerts)

##### <a name="-java_ks--certificate"></a>`certificate`

A file containing a server certificate, followed by zero or more intermediate certificate authorities.
All certificates will be placed in the keystore. This will autorequire the specified file.

##### <a name="-java_ks--certificate_content"></a>`certificate_content`

A string containing a server certificate, followed by zero or more intermediate certificate authorities.
All certificates will be placed in the keystore.

##### <a name="-java_ks--chain"></a>`chain`

The intermediate certificate authorities, if they are to be taken
from a file separate from the server certificate. This will autorequire the specified file.

##### <a name="-java_ks--destkeypass"></a>`destkeypass`

The password used to protect the key in keystore.

##### <a name="-java_ks--keytool_timeout"></a>`keytool_timeout`

Timeout for the keytool command in seconds.

Default value: `120`

##### <a name="-java_ks--name"></a>`name`

namevar

The alias that is used to identify the entry in the keystore. This will be
converted to lowercase.

##### <a name="-java_ks--password_fail_reset"></a>`password_fail_reset`

Valid values: `true`, `false`

If the supplied password does not succeed in unlocking the
keystore file, then delete the keystore file and create a new one.
Default: false.

Default value: `false`

##### <a name="-java_ks--password_file"></a>`password_file`

The path to a file containing the password used to protect the
keystore. This cannot be used together with :password, but you must pass at least one of these parameters.

##### <a name="-java_ks--path"></a>`path`

The search path used for command (keytool, openssl) execution.
Paths can be specified as an array or as a '

##### <a name="-java_ks--private_key"></a>`private_key`

If you want an application to be a server and encrypt traffic,
you will need a private key.  Private key entries in a keystore must be
accompanied by a signed certificate for the keytool provider. This parameter
allows you to specify the file name containing the private key. This will autorequire
the specified file.

##### <a name="-java_ks--private_key_content"></a>`private_key_content`

If you want an application to be a server and encrypt traffic,
you will need a private key.  Private key entries in a keystore must be
accompanied by a signed certificate for the keytool provider. This parameter allows you to specify the content
of the private key.

##### <a name="-java_ks--private_key_type"></a>`private_key_type`

Valid values: `rsa`, `dsa`, `ec`

The type of the private key. Usually the private key is of type RSA
key but it can also be an Elliptic Curve key (EC) or DSA.
Valid options: <rsa>, <dsa>, <ec>. Defaults to <rsa>

Default value: `rsa`

##### <a name="-java_ks--provider"></a>`provider`

The specific backend to use for this `java_ks` resource. You will seldom need to specify this --- Puppet will usually
discover the appropriate provider for your platform.

##### <a name="-java_ks--source_alias"></a>`source_alias`

The source certificate alias

##### <a name="-java_ks--source_password"></a>`source_password`

The source keystore password

##### <a name="-java_ks--storetype"></a>`storetype`

Valid values: `jceks`, `pkcs12`, `jks`

Optional storetype
Valid options: <jceks>, <pkcs12>, <jks>

##### <a name="-java_ks--target"></a>`target`

namevar

Destination file for the keystore.  This will autorequire the parent directory of the file.

##### <a name="-java_ks--trustcacerts"></a>`trustcacerts`

Valid values: `true`, `false`

Certificate authorities aren't by default trusted so if you are adding a CA you need to set this to true.
Defaults to :false.

Default value: `false`

