package charactermanaj.model;

import java.util.EventListener;
import java.util.EventObject;

/**
 * リストの変更通知イベントのリスナ
 *
 * @param <E>
 */
public interface ListChangeListener<E> extends EventListener {

	/**
	 * イベントのタイプ
	 */
	public enum ChangeType {
		ADD, MODIFIY, REMOVE
	}

	/**
	 * リストの変更通知イベント
	 *
	 * @param <E>
	 */
	public class Change<E> extends EventObject {
		private static final long serialVersionUID = 3685161122703901464L;

		/**
		 * イベントのタイプ
		 */
		private ChangeType type;

		/**
		 * 行インデックス
		 */
		private int index;

		/**
		 * 変更前の値
		 * addの場合はnull
		 */
		private E oldValue;

		/**
		 * 変更後の値
		 * removeの場合はnull
		 */
		private E newValue;

		/**
		 * 変更イベントを構築する
		 * @param source イベント元
		 * @param type イベントの種類
		 * @param index リストのインデックス
		 * @param oldValue 前の値
		 * @param newValue 現在の値
		 */
		public Change(ObservableList<E> source, ChangeType type, int index, E oldValue, E newValue) {
			super(source);
			this.type = type;
			this.index = index;
			this.oldValue = oldValue;
			this.newValue = newValue;
		}

		/**
		 * Gets the event type
		 * @return either ADD, REMOVE, or MODIFY
		 */
		public ChangeType getType() {
			return type;
		}

		public int getIndex() {
			return index;
		}

		public E getOldValue() {
			return oldValue;
		}

		public E getNewValue() {
			return newValue;
		}

		@SuppressWarnings("unchecked")
		public ObservableList<E> getList() {
			return (ObservableList<E>) getSource();
		}

		@Override
		public String toString() {
			return "Change [type=" + type + ", index=" + index + ", oldValue=" + oldValue + ", newValue=" + newValue
					+ "]";
		}
	}

	/**
	 * リストに変更があったことを通知される
	 * @param c 変更イベント
	 */
	void onChanged(Change<? extends E> c);
}