#!/bin/sh -f
#
# Copyright (c) 2001-2003 The Trustees of Indiana University.  
#                         All rights reserved.
# Copyright (c) 1998-2001 University of Notre Dame. 
#                         All rights reserved.
# Copyright (c) 1994-1998 The Ohio State University.  
#                         All rights reserved.
# 
# This file is part of the XMPI software package.  For license
# information, see the LICENSE file in the top level directory of the
# XMPI source distribution.
#

# any temporary files needed by the rpm build process are 
# kept in this directory:
mytmpdir="/tmp/xmpirpm$$"
mkdir $mytmpdir || exit 1
# this is the directory where "make rpm" was invoked from
rpmbuilddir="`pwd`"

# if we fail somewhere along the line, we want to clean out all
# the cruft we've left along the way...

# Get the version of LAM that we're installing

VERSIONFILE=xmpi.h
LIBVERSIONFILE=libxmpi/lam_libxmpi.h

if test -d /usr/src/RPM; then
    rpmtopdir="/usr/src/RPM"
else
    rpmtopdir="/usr/src/redhat"
fi

cat $VERSIONFILE | grep XMPI_VERSION | cut -d\" -f2 > ver.$$
ver="`cat ver.$$`"
rm -f ver.$$

cat $LIBVERSIONFILE | grep LAM_LIBXMPI_VERSION | cut -d\" -f2 > ver.$$
libver="`cat ver.$$`"
rm -f ver.$$


# rpm names don't like extra dashes
shortlibver=`echo $libver | sed -e 's/-//g'`
rev=$shortlibver


# make sure the tarball is out there
if test ! -f xmpi-$ver-$shortlibver.tar.gz; then
    make dist
fi

# make sure we have write access to the directories we need
if test ! -w $rpmtopdir/SOURCES -o ! -w /usr/local; then
    echo "Problem creating rpms: You do not have a $rpmtopdir directory"
    echo "tree, you do not have write access to the $rpmtopdir directory"
    echo "tree, or you do not have write access to /usr/local directory to"
    echo "create the xmpi-$ver tree. Please remedy and try again."
    exit 1
fi

# move the tarball and spec file to the rpm directory,
# replace the version string, and insert the copyright dealy...

cp xmpi-$ver-$shortlibver.tar.gz $rpmtopdir/SOURCES/.

sed -e 's/\$COPYRIGHT\$//g' config/xmpi.spec > $mytmpdir/xmpi-copyright.spec
sed -e 's/XMPIVERSION/'$ver'/g' $mytmpdir/xmpi-copyright.spec > $mytmpdir/xmpi-$ver.spec.tmp$$
sed -e 's/SHORTLIBVERSION/'$shortlibver'/g' $mytmpdir/xmpi-$ver.spec.tmp$$ > $mytmpdir/xmpi-$ver.spec.tmp
sed -e 's/XMPIREVISION/'$rev'/g' $mytmpdir/xmpi-$ver.spec.tmp > $mytmpdir/xmpi-$ver-$rev.spec.tmp
sed -e 's/LIBVERSION/'$libver'/g' $mytmpdir/xmpi-$ver-$rev.spec.tmp > $rpmtopdir/SPECS/xmpi-$ver.spec

cp xmpi-$ver-$shortlibver.tar.gz $rpmtopdir/SOURCES

cd $rpmtopdir/SPECS

rpm -ba xmpi-$ver.spec

FILE=$rpmtopdir/RPMS/i386/xmpi-$ver-$rev.i386.rpm
mv $FILE $rpmbuilddir
cat <<EOF
******************************************************************************
Completed $FILE

Moved xmpi-$ver-$rev.i386.rpm to $rpmbuilddir
******************************************************************************
EOF

FILE=$rpmtopdir/SRPMS/xmpi-$ver-$rev.src.rpm

	mv $FILE $rpmbuilddir/xmpi-$ver-$rev.src.rpm
cat <<EOF
******************************************************************************
Completed $FILE

Moved xmpi-$ver-$rev.src.rpm to $rpmbuilddir
******************************************************************************
EOF

rm -rf $mytmpdir

cat <<EOF

ALL DONE

Files should be in $rpmbuilddir

But if not...
The completed rpms are located in: $rpmtopdir/RPMS/i386/
The sources rpms are locate in $rpmtopdir/SRPMS/

EOF






