% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snap_to_grid.R
\name{st_snap_to_grid}
\alias{st_snap_to_grid}
\title{Snap geometries to a grid}
\usage{
st_snap_to_grid(x, size, origin)
}
\arguments{
\item{x}{object with geometries to be snapped}

\item{size}{numeric or (length) units object; grid cell size in x-, y- (and possibly z- and m-) directions}

\item{origin}{numeric; origin of the grid}
}
\value{
object of the same class as \code{x}
}
\description{
Snap geometries to a grid
}
\examples{
# obtain data
library(sf)
x = st_read(system.file("gpkg/nc.gpkg", package="sf"), quiet = TRUE)[1, ] \%>\%
    st_geometry \%>\%
    st_transform(3395)

# snap to a grid of 5000 m
y = st_snap_to_grid(x, 5000)

# plot data for visual comparison
par(mfrow = c(1, 2))
plot(x, main = "orginal data")
plot(y, main = "snapped to 5000 m")
}
