# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BMSRPQueryObject(Model):
    """Filters to list backup copies.

    :param start_date: Backup copies created after this time.
    :type start_date: datetime
    :param end_date: Backup copies created before this time.
    :type end_date: datetime
    :param restore_point_query_type: RestorePoint type. Possible values
     include: 'Invalid', 'Full', 'Log', 'Differential', 'FullAndDifferential',
     'All'
    :type restore_point_query_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RestorePointQueryType
    :param extended_info: In Get Recovery Point, it tells whether extended
     information about recovery point is asked.
    :type extended_info: bool
    """

    _attribute_map = {
        'start_date': {'key': 'startDate', 'type': 'iso-8601'},
        'end_date': {'key': 'endDate', 'type': 'iso-8601'},
        'restore_point_query_type': {'key': 'restorePointQueryType', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(BMSRPQueryObject, self).__init__(**kwargs)
        self.start_date = kwargs.get('start_date', None)
        self.end_date = kwargs.get('end_date', None)
        self.restore_point_query_type = kwargs.get('restore_point_query_type', None)
        self.extended_info = kwargs.get('extended_info', None)
